/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import com.google.common.collect.Range;

public class PluginParameter {
    private final String guiName;
    private final String guiUnits;
    private final String cmdLineName;
    private final String cmdLineLongName;
    private final String description;
    private final Class type;
    private final Range range;
    private final Object value;

    private PluginParameter(String guiName, String guiUnits, String cmdLineName, String cmdLineLongName, String description, Class type, Range range, Object value) {
        this.guiName = guiName;
        this.guiUnits = guiUnits;
        this.cmdLineName = cmdLineName;
        this.cmdLineLongName = cmdLineLongName;
        this.description = description;
        this.type = type;
        this.range = range;
        this.value = value;
    }

    public PluginParameter(PluginParameter oldParameter, Object newValue) {
        this.guiName = oldParameter.guiName;
        this.guiUnits = oldParameter.guiUnits;
        this.cmdLineName = oldParameter.cmdLineName;
        this.cmdLineLongName = oldParameter.cmdLineLongName;
        this.description = oldParameter.description;
        this.type = oldParameter.type;
        this.range = oldParameter.range;
        this.value = newValue;
    }

    public String guiName() {
        return this.guiName;
    }

    public String guiUnits() {
        return this.guiUnits;
    }

    public String cmdLineName() {
        return this.cmdLineName;
    }

    public String cmdLineLongName() {
        return this.cmdLineLongName;
    }

    public String description() {
        return this.description;
    }

    public Class type() {
        return this.type;
    }

    public Range range() {
        return this.range;
    }

    public Object value() {
        return this.value;
    }

    public static class Builder {
        private String guiName;
        private String guiUnits = "";
        private String cmdLineName;
        private String cmdLineLongName = "";
        private String description = "";
        private Class type;
        private Range range = null;
        private Object value;

        public Builder(String guiName, String cmdLineName, Class type, Object value) {
            this.guiName = guiName;
            this.cmdLineName = cmdLineName;
            this.type = type;
            this.value = value;
        }

        public Builder guiUnits(String guiUnits) {
            this.guiUnits = guiUnits;
            return this;
        }

        public Builder cmdLineLongName(String cmdLineLongName) {
            this.cmdLineLongName = cmdLineLongName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public PluginParameter build() {
            if (this.cmdLineLongName.isEmpty()) {
                this.cmdLineLongName = this.cmdLineName;
            }
            if (this.description.isEmpty()) {
                this.description = this.guiName;
            }
            return new PluginParameter(this.guiName, this.guiUnits, this.cmdLineName, this.cmdLineLongName, this.description, this.type, this.range, this.value);
        }
    }
}

