/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JPanel;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import org.apache.log4j.Logger;

public abstract class AbstractPlugin
implements Plugin {
    private static final Logger myLogger = Logger.getLogger(AbstractPlugin.class);
    private final List<PluginListener> myListeners = new ArrayList<PluginListener>();
    private final List<Plugin> myInputs = new ArrayList<Plugin>();
    private final Frame myParentFrame;
    private final boolean myIsInteractive;
    private boolean myTrace = false;
    private boolean myThreaded = false;

    public AbstractPlugin() {
        this(null, true);
    }

    public AbstractPlugin(Frame parentFrame, boolean isInteractive) {
        this.myParentFrame = parentFrame;
        this.myIsInteractive = isInteractive;
    }

    @Override
    public JMenu getMenu() {
        return null;
    }

    @Override
    public void receiveInput(Plugin input) {
        if (input == null) {
            throw new IllegalArgumentException("AbstractPlugin: receiveInput: input can not be null.");
        }
        if (!this.myInputs.contains(input)) {
            this.myInputs.add(input);
        }
        input.addListener(this);
    }

    @Override
    public JPanel getPanel() {
        return null;
    }

    @Override
    public boolean isInteractive() {
        return this.myIsInteractive;
    }

    @Override
    public Frame getParentFrame() {
        return this.myParentFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PluginListener listener) {
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            if (listener != null && !this.myListeners.contains(listener)) {
                this.myListeners.add(listener);
            }
        }
    }

    protected List<PluginListener> getListeners() {
        return this.myListeners;
    }

    public List<Plugin> getInputs() {
        return this.myInputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataSetReturned(PluginEvent event) {
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            Iterator<PluginListener> itr = this.myListeners.iterator();
            while (itr.hasNext()) {
                try {
                    PluginListener current;
                    if (this.myThreaded) {
                        current = itr.next();
                        ThreadedPluginListener thread = new ThreadedPluginListener(current, event);
                        thread.start();
                        continue;
                    }
                    current = itr.next();
                    current.dataSetReturned(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void fireDataSetReturned(DataSet data) {
        this.fireDataSetReturned(new PluginEvent(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgress(PluginEvent event) {
        Datum datum;
        Integer percent;
        List<Datum> percentage;
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            for (PluginListener current : this.myListeners) {
                current.progress(event);
            }
        }
        DataSet ds = (DataSet)event.getSource();
        if (ds != null && (percentage = ds.getDataOfType(Integer.class)).size() > 0 && (percent = (Integer)(datum = percentage.get(0)).getData()) == 100) {
            myLogger.info((Object)(this.getClass().getName() + "  Citation: " + this.getCitation()));
        }
    }

    protected void fireProgress(Integer percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("AbstractPlugin: fireProgress: percent must be between 0 and 100 inclusive.  arg: " + percent);
        }
        Datum percentage = new Datum("Percent", percent, null);
        this.fireProgress(new PluginEvent(new DataSet(percentage, (Plugin)this)));
    }

    @Override
    public String getCitation() {
        return "Bradbury PJ, Zhang Z, Kroon DE, Casstevens TM, Ramdoss Y, Buckler ES. (2007) TASSEL: Software for association mapping of complex traits in diverse samples. Bioinformatics 23:2633-2635.";
    }

    @Override
    public void dataSetReturned(PluginEvent event) {
        DataSet input = (DataSet)event.getSource();
        this.performFunction(input);
    }

    @Override
    public void progress(PluginEvent event) {
    }

    public void reverseTrace(int indent) {
        if (this.myTrace) {
            return;
        }
        this.indent(indent);
        System.out.println(this.getClass().getName());
        Iterator<Plugin> itr = this.myInputs.iterator();
        while (itr.hasNext()) {
            try {
                AbstractPlugin current = (AbstractPlugin)itr.next();
                current.reverseTrace(indent + 3);
            }
            catch (Exception exception) {}
        }
        this.myTrace = true;
    }

    public void trace(int indent) {
        if (this.myTrace) {
            return;
        }
        this.indent(indent);
        System.out.println(this.getClass().getName());
        Iterator<PluginListener> itr = this.myListeners.iterator();
        while (itr.hasNext()) {
            try {
                AbstractPlugin current = (AbstractPlugin)itr.next();
                current.trace(indent + 3);
            }
            catch (Exception exception) {}
        }
        this.myTrace = true;
    }

    private void indent(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
    }

    @Override
    public void setThreaded(boolean threaded) {
        this.myThreaded = threaded;
    }

    @Override
    public boolean cancel() {
        return false;
    }

    @Override
    public void run() {
        this.performFunction(null);
    }

    @Override
    public void progress(int percent, Object meta) {
        this.fireProgress(percent);
    }

    @Override
    public void setParameters(String[] args) {
        throw new UnsupportedOperationException();
    }
}

