/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Pattern;
import net.maizegenetics.phenotype.Phenotype;

public class ImportPhenotypeUtils {
    private static final Pattern sep = Pattern.compile("\\s+");
    private static final Pattern equal = Pattern.compile("=");
    private static final Pattern brack = Pattern.compile("[<>]");

    public static Phenotype importPhenotypeFile(String filename) throws IOException {
        String[] parsedline;
        String[] traitnames = null;
        LinkedList headerList = new LinkedList();
        String[] use = null;
        boolean alldata = false;
        boolean allfactor = false;
        boolean allcovar = false;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        int numberOfDataLines = 0;
        String inputline = br.readLine().trim();
        while (inputline != null) {
            if ((inputline = inputline.trim()).startsWith("<")) {
                int c;
                int n;
                int close = inputline.indexOf(62);
                String tag = inputline.substring(1, close);
                if (tag.toUpperCase().startsWith("TRAIT")) {
                    parsedline = sep.split(inputline);
                    n = parsedline.length - 1;
                    traitnames = new String[n];
                    for (c = 0; c < n; ++c) {
                        traitnames[c] = parsedline[c + 1];
                    }
                } else if (tag.toUpperCase().startsWith("HEADER")) {
                    parsedline = sep.split(inputline);
                    n = parsedline.length - 1;
                    String[] head = new String[n];
                    for (int c2 = 0; c2 < n; ++c2) {
                        head[c2] = parsedline[c2 + 1];
                    }
                    int equalpos = head[0].indexOf(61);
                    close = head[0].indexOf(62);
                    head[0] = head[0].substring(equalpos + 1, close);
                } else if (tag.toUpperCase().startsWith("USE")) {
                    parsedline = sep.split(inputline);
                    n = parsedline.length - 1;
                    use = new String[n];
                    for (c = 0; c < n; ++c) {
                        use[c] = parsedline[c + 1];
                    }
                } else if (tag.toUpperCase().startsWith("DATA")) {
                    alldata = true;
                } else if (tag.toUpperCase().startsWith("COVAR")) {
                    allcovar = true;
                } else if (tag.toUpperCase().startsWith("FACTOR")) {
                    allfactor = true;
                }
            } else if (!inputline.startsWith("#")) {
                ++numberOfDataLines;
            }
            inputline = br.readLine().trim();
        }
        br.close();
        br = new BufferedReader(new FileReader(filename));
        while ((inputline = br.readLine()) != null) {
            if ((inputline = inputline.trim()).length() <= 0 || inputline.startsWith("#") || inputline.startsWith("<")) continue;
            parsedline = sep.split(inputline);
        }
        br.close();
        return null;
    }
}

