/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.EJMLDoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.EigenDecomposition;
import org.ejml.ops.EigenOps;

public class EJMLEigenvalueDecomposition
implements EigenvalueDecomposition {
    final EigenDecomposition<DenseMatrix64F> myDecomposition;
    boolean successful;

    public EJMLEigenvalueDecomposition(DoubleMatrix dm) {
        EJMLDoubleMatrix ejmldm = (EJMLDoubleMatrix)dm;
        this.myDecomposition = DecompositionFactory.eig((int)dm.numberOfRows(), (boolean)true);
        this.successful = this.myDecomposition.decompose((Matrix64F)ejmldm.myMatrix);
    }

    public EJMLEigenvalueDecomposition(DenseMatrix64F matrix) {
        this.myDecomposition = DecompositionFactory.eig((int)matrix.numRows, (boolean)true);
        this.successful = this.myDecomposition.decompose((Matrix64F)matrix);
    }

    public EJMLEigenvalueDecomposition(EigenDecomposition<DenseMatrix64F> decomp) {
        this.myDecomposition = decomp;
    }

    @Override
    public double getEigenvalue(int i) {
        return this.myDecomposition.getEigenvalue(i).getReal();
    }

    @Override
    public DoubleMatrix getEigenvalueMatrix() {
        return new EJMLDoubleMatrix(EigenOps.createMatrixD(this.myDecomposition));
    }

    @Override
    public double[] getEigenvalues() {
        int n = this.myDecomposition.getNumberOfEigenvalues();
        double[] values = new double[n];
        for (int i = 0; i < n; ++i) {
            values[i] = this.myDecomposition.getEigenvalue(i).getReal();
        }
        return values;
    }

    @Override
    public DoubleMatrix getEigenvectors() {
        return new EJMLDoubleMatrix(EigenOps.createMatrixV(this.myDecomposition));
    }

    public boolean wasSuccessful() {
        return this.successful;
    }
}

