/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import java.util.TreeMap;
import net.maizegenetics.dna.tag.AbstractTagsByTaxa;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TaxaGroups;

public class TagsByTaxaByteHDF5TagGroups
extends AbstractTagsByTaxa {
    static int chunkSize = 65536;
    int tagCount = 0;
    IHDF5Writer h5 = null;
    TreeMap<String, Integer> taxaNameIndexTreeMap;
    private int bufferedTagIndex = Integer.MIN_VALUE;
    private byte[] bufferedTagDist = null;
    private boolean bufferChanged = false;

    public TagsByTaxaByteHDF5TagGroups(Tags inTags, String newHDF5file) {
        this.tagLengthInLong = inTags.getTagSizeInLong();
        this.tagCount = inTags.getTagCount();
        this.taxaNum = 0;
        this.tags = new long[this.tagLengthInLong][this.tagCount];
        this.tagLength = new byte[this.tagCount];
        for (int i = 0; i < this.tagCount; ++i) {
            long[] ct = inTags.getTag(i);
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                this.tags[j][i] = ct[j];
            }
            this.tagLength[i] = (byte)inTags.getTagLength(i);
        }
        IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(newHDF5file));
        System.out.println("Creating HDF5 file: " + newHDF5file);
        config.overwrite();
        config.dontUseExtendableDataTypes();
        config.useUTF8CharacterEncoding();
        this.h5 = config.writer();
        this.h5.setIntAttribute("/", "tagCount", inTags.getTagCount());
        this.h5.setIntAttribute("/", "chunkSize", chunkSize);
        this.h5.setIntAttribute("/", "tagLengthInLong", this.tagLengthInLong);
        this.h5.setIntAttribute("/", "taxaNum", this.taxaNum);
        this.h5.createLongMatrix("tags", (long)inTags.getTagSizeInLong(), (long)this.tagCount, inTags.getTagSizeInLong(), this.tagCount);
        this.h5.writeLongMatrix("tags", this.tags);
        this.h5.createByteArray("tagLength", this.tagCount);
        this.h5.writeByteArray("tagLength", this.tagLength);
        this.h5.createGroup("tbttg");
        int tagChunks = inTags.getTagCount() >> 16;
        if (inTags.getTagCount() % chunkSize > 0) {
            ++tagChunks;
        }
        System.out.println(chunkSize);
        System.out.printf("tagChunks %d Div %g %n", tagChunks, (double)inTags.getTagCount() / (double)chunkSize);
        this.h5.setIntAttribute("tbttg/", "tagCount", inTags.getTagCount());
        this.h5.setIntAttribute("tbttg/", "tagChunks", tagChunks);
        for (int tc = 0; tc < tagChunks; ++tc) {
            this.h5.createGroup("tbttg/c" + tc);
        }
        if (inTags instanceof TagsByTaxa) {
            TagsByTaxa inTBT = (TagsByTaxa)inTags;
            this.taxaNum = inTBT.getTaxaCount();
            this.h5.setIntAttribute("/", "taxaNum", this.taxaNum);
            this.h5.setIntAttribute("/", "tagCount", this.tagCount);
            this.h5.createStringVariableLengthArray("tbttg/taxaNames", this.taxaNum);
            this.h5.writeStringVariableLengthArray("tbttg/taxaNames", inTBT.getTaxaNames());
            if (inTBT instanceof TagsByTaxaByteHDF5TaxaGroups) {
                this.populateTBTMatrixTranspose((TagsByTaxaByteHDF5TaxaGroups)inTBT);
            } else {
                this.populateTBTMatrix(inTBT);
            }
            this.createFastTaxaMap();
        }
    }

    public void writeDistFile(String newHDF5file, int[] tagIndex) {
        int newTagCount = tagIndex.length;
        long[][] newTags = new long[this.tagLengthInLong][newTagCount];
        byte[] newTagLength = new byte[newTagCount];
        for (int i = 0; i < newTagCount; ++i) {
            long[] ct = this.getTag(tagIndex[i]);
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                newTags[j][i] = ct[j];
            }
            newTagLength[i] = (byte)this.getTagLength(tagIndex[i]);
        }
        IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(newHDF5file));
        System.out.println("Creating HDF5 file: " + newHDF5file);
        config.overwrite();
        config.dontUseExtendableDataTypes();
        config.useUTF8CharacterEncoding();
        IHDF5Writer nH5 = config.writer();
        nH5.setIntAttribute("/", "tagCount", newTagCount);
        nH5.setIntAttribute("/", "chunkSize", chunkSize);
        nH5.setIntAttribute("/", "tagLengthInLong", this.tagLengthInLong);
        nH5.setIntAttribute("/", "taxaNum", this.taxaNum);
        nH5.createLongMatrix("tags", (long)this.getTagSizeInLong(), (long)newTagCount, this.getTagSizeInLong(), newTagCount);
        nH5.writeLongMatrix("tags", newTags);
        nH5.createByteArray("tagLength", newTagCount);
        nH5.writeByteArray("tagLength", newTagLength);
        nH5.createGroup("tbttg");
        int tagChunks = newTagCount >> 16;
        if (newTagCount % chunkSize > 0) {
            ++tagChunks;
        }
        System.out.println(chunkSize);
        System.out.printf("tagChunks %d Div %g %n", tagChunks, (double)newTagCount / (double)chunkSize);
        nH5.setIntAttribute("tbttg/", "tagCount", newTagCount);
        nH5.setIntAttribute("tbttg/", "tagChunks", tagChunks);
        for (int tc = 0; tc < tagChunks; ++tc) {
            nH5.createGroup("tbttg/c" + tc);
        }
        nH5.createStringVariableLengthArray("tbttg/taxaNames", this.taxaNum);
        nH5.writeStringVariableLengthArray("tbttg/taxaNames", this.getTaxaNames());
        for (int i = 0; i < newTagCount; ++i) {
            byte[] td = new byte[this.taxaNum];
            for (int j = 0; j < this.taxaNum; ++j) {
                td[j] = (byte)this.getReadCountForTagTaxon(tagIndex[i], j);
            }
            int chunk = i >> 16;
            String d = "tbttg/c" + chunk + "/" + i;
            byte[] deftc = TagsByTaxaByteHDF5TagGroups.encodeBySign(td);
            nH5.createByteArray(d, deftc.length);
            nH5.writeByteArray(d, deftc);
        }
        this.createFastTaxaMap();
    }

    private void populateTBTMatrix(TagsByTaxa inTBT) {
        for (int tg = 0; tg < this.tagCount; ++tg) {
            byte[] td = new byte[this.taxaNum];
            for (int tx = 0; tx < this.taxaNum; ++tx) {
                td[tx] = (byte)inTBT.getReadCountForTagTaxon(tg, tx);
            }
            int chunk = tg >> 16;
            String d = "tbttg/c" + chunk + "/" + tg;
            byte[] deftc = TagsByTaxaByteHDF5TagGroups.encodeBySign(td);
            this.h5.createByteArray(d, deftc.length);
            this.h5.writeByteArray(d, deftc);
        }
    }

    private void populateTBTMatrixTranspose(TagsByTaxaByteHDF5TaxaGroups inTBT) {
        for (int tgC = 0; tgC < this.tagCount; tgC += chunkSize) {
            System.out.println("TagChunk:" + tgC);
            byte[][] td = new byte[chunkSize][this.taxaNum];
            int top = tgC + chunkSize > this.tagCount ? this.tagCount : tgC + chunkSize;
            for (int tx = 0; tx < this.taxaNum; ++tx) {
                for (int tg = tgC; tg < top; ++tg) {
                    td[tg - tgC][tx] = (byte)inTBT.getReadCountForTagTaxon(tg, tx);
                }
            }
            for (int tg = tgC; tg < top; ++tg) {
                int chunk = tgC >> 16;
                String d = "tbttg/c" + chunk + "/" + tg;
                byte[] deftc = TagsByTaxaByteHDF5TagGroups.encodeBySign(td[tg - tgC]);
                this.h5.createByteArray(d, deftc.length);
                this.h5.writeByteArray(d, deftc);
            }
        }
    }

    public TagsByTaxaByteHDF5TagGroups(String infile) {
        IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(infile));
        config.dontUseExtendableDataTypes();
        this.h5 = config.writer();
        this.tagCount = this.h5.getIntAttribute("/", "tagCount");
        chunkSize = this.h5.getIntAttribute("/", "chunkSize");
        this.tagLengthInLong = this.h5.getIntAttribute("/", "tagLengthInLong");
        this.taxaNum = this.h5.getIntAttribute("/", "taxaNum");
        this.tags = this.h5.readLongMatrix("tags");
        this.tagLength = this.h5.readByteArray("tagLength");
        this.createFastTaxaMap();
    }

    private void createFastTaxaMap() {
        this.taxaNames = this.h5.readStringArray("tbttg/taxaNames");
        this.taxaNameIndexTreeMap = new TreeMap();
        for (int i = 0; i < this.taxaNames.length; ++i) {
            this.taxaNameIndexTreeMap.put(this.taxaNames[i], i);
        }
    }

    public static byte[] createRandomDistribution(int arraySize, double proportionToFill, int maxValue) {
        byte[] result = new byte[arraySize];
        int fillNum = (int)((double)result.length * proportionToFill);
        Random r = new Random();
        for (int i = 0; i < fillNum; ++i) {
            byte cnt;
            result[r.nextInt((int)arraySize)] = cnt = (byte)r.nextInt(maxValue);
        }
        return result;
    }

    public static byte[][] encodeBySign(byte[] source, int chunkSize) {
        int chunks = source.length / chunkSize;
        if (source.length % chunkSize != 0) {
            ++chunks;
        }
        byte[][] result = new byte[chunks][];
        for (int i = 0; i < chunks; ++i) {
            int s = i * chunkSize;
            int e = s + chunkSize;
            if (e > source.length) {
                e = source.length;
            }
            result[i] = TagsByTaxaByteHDF5TagGroups.encodeBySign(Arrays.copyOfRange(source, s, e));
        }
        return result;
    }

    public static byte[] encodeBySign(byte[] source) {
        ByteBuffer dest = ByteBuffer.allocate(source.length + 4);
        dest.putInt(source.length);
        byte runLength = 0;
        for (int i = 0; i < source.length; ++i) {
            if (source[i] > 0) {
                if (runLength < 0) {
                    dest.put(runLength);
                }
                dest.put(source[i]);
                runLength = 0;
                continue;
            }
            if ((runLength = (byte)(runLength - 1)) != -128) continue;
            dest.put(runLength);
            runLength = 0;
        }
        if (runLength < 0) {
            dest.put(runLength);
        }
        return Arrays.copyOf(dest.array(), dest.position());
    }

    public static byte[] decodeBySign(byte[][] srcCompChunk) {
        byte[][] resInChunk = new byte[srcCompChunk.length][];
        int totalLength = 0;
        for (int i = 0; i < srcCompChunk.length; ++i) {
            resInChunk[i] = TagsByTaxaByteHDF5TagGroups.decodeBySign(srcCompChunk[i]);
            totalLength += resInChunk[i].length;
        }
        ByteBuffer result = ByteBuffer.allocate(totalLength);
        for (int i = 0; i < srcCompChunk.length; ++i) {
            result.put(resInChunk[i]);
        }
        return result.array();
    }

    public static byte[] decodeBySign(byte[] source) {
        ByteBuffer srcB = ByteBuffer.wrap(source);
        int length = srcB.getInt();
        ByteBuffer dest = ByteBuffer.allocate(length);
        for (int i = 4; i < source.length; ++i) {
            if (source[i] > 0) {
                dest.put(source[i]);
                continue;
            }
            dest.position(-source[i] + dest.position());
        }
        return dest.array();
    }

    public TagsByTaxaByte convertToTBTByte() {
        byte[][] tagDist = new byte[this.taxaNum][this.tagCount];
        for (int tag = 0; tag < this.tagCount; ++tag) {
            for (int taxon = 0; taxon < this.taxaNum; ++taxon) {
                tagDist[taxon][tag] = (byte)this.getReadCountForTagTaxon(tag, taxon);
            }
        }
        return new TagsByTaxaByte(this.tags, this.tagLength, tagDist, this.getTaxaNames());
    }

    public static void main(String[] args) {
        String inTBTFile = "/Users/edbuckler/SolexaAnal/GBS/build20120110/tbt/434GFAAXX_s_3.tbt.byte";
        String path = "/Users/edbuckler/SolexaAnal/GBS/test/";
        String file = "testToGZ.h5";
        TagsByTaxaByte inTBT = new TagsByTaxaByte(inTBTFile, TagsByTaxa.FilePacking.Byte);
        long time = System.currentTimeMillis();
        TagsByTaxaByteHDF5TagGroups tHDF5 = new TagsByTaxaByteHDF5TagGroups(inTBT, path + file);
        tHDF5.getFileReadyForClosing();
        TagsByTaxaByteHDF5TagGroups rHDF5 = new TagsByTaxaByteHDF5TagGroups(path + file);
        int same = 0;
        int diff = 0;
        int count = 0;
        time = System.currentTimeMillis();
        int tags = 9;
        for (int i = 0; i < 10000; i += 11) {
            int taxon = i % inTBT.getTaxaCount();
            if (i % 550 == 0) {
                tags = i % inTBT.getTagCount();
            }
            int newTaxonIndex = rHDF5.getIndexOfTaxaName(inTBT.getTaxaName(taxon));
            if (inTBT.getReadCountForTagTaxon(tags, taxon) == rHDF5.getReadCountForTagTaxon(tags, newTaxonIndex)) {
                ++same;
            } else {
                ++diff;
            }
            ++count;
        }
        System.out.printf("Same %d Diff %d %n", same, diff);
        long duration = System.currentTimeMillis() - time;
        double rate = (double)duration / (double)count;
        System.out.printf("Rate %g %n", rate);
    }

    @Override
    public int getIndexOfTaxaName(String taxon) {
        Integer index = this.taxaNameIndexTreeMap.get(taxon);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public int getReadCountForTagTaxon(int tagIndex, int taxaIndex) {
        if (this.bufferedTagIndex != tagIndex) {
            this.bufferTagDist(tagIndex);
        }
        return this.bufferedTagDist[taxaIndex];
    }

    private synchronized void bufferTagDist(int tagIndex) {
        String g;
        int chunk;
        if (this.bufferChanged) {
            chunk = this.bufferedTagIndex >> 16;
            g = "tbttg/c" + chunk + "/" + this.bufferedTagIndex;
            this.h5.writeByteArray(g, this.bufferedTagDist);
        }
        chunk = tagIndex >> 16;
        g = "tbttg/c" + chunk + "/" + tagIndex;
        this.bufferedTagDist = TagsByTaxaByteHDF5TagGroups.decodeBySign(this.h5.readByteArray(g));
        this.bufferedTagIndex = tagIndex;
        this.bufferChanged = false;
    }

    @Override
    public void setMethodByRows(boolean rowSetMethod) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setReadCountForTagTaxon(int tagIndex, int taxaIndex, int value) {
        if (this.bufferedTagIndex != taxaIndex) {
            this.bufferTagDist(taxaIndex);
        }
        this.bufferChanged = true;
        this.bufferedTagDist[taxaIndex] = value > 127 ? 127 : (value < 0 ? 0 : (int)value);
    }

    @Override
    public void initMatrices(int taxaNum, int tagNum) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addTaxa(String[] addTaxaNames) {
        throw new UnsupportedOperationException("Is not supported, use other HDF5 class");
    }

    @Override
    public void getFileReadyForClosing() {
        this.bufferTagDist(0);
        this.h5.close();
    }
}

