/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NavigableSet;
import net.maizegenetics.dna.map.DonorHaplotypes;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;

public class ProjectionGenotypeCallTable
extends AbstractGenotypeCallTable {
    private final GenotypeTable myBaseGenoTable;
    private ImmutableList<NavigableSet<DonorHaplotypes>> allBreakPoints;
    private BaseMode currMode = BaseMode.Taxa;
    private ArrayList<RangeMap<Integer, DonorSiteHaps>> breakMaps;
    private DonorSiteHaps[] currentDSH;
    private byte[] donorForCachedSite;
    private byte[] projForCachedTaxon;
    private int cachedSite = -1;
    private int cachedTaxon = -1;
    int[] primDSH;

    public ProjectionGenotypeCallTable(GenotypeTable hdAlign, ImmutableList<NavigableSet<DonorHaplotypes>> allBreakPoints) {
        super(allBreakPoints.size(), hdAlign.numberOfSites(), false, NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES);
        this.myBaseGenoTable = hdAlign;
        this.allBreakPoints = allBreakPoints;
        this.breakMaps = new ArrayList(this.numberOfTaxa());
        for (NavigableSet allBreakPoint : allBreakPoints) {
            TreeRangeMap tRM = TreeRangeMap.create();
            for (DonorHaplotypes dh : allBreakPoint) {
                int[] siteRange = this.siteRangeForDonor(dh);
                DonorSiteHaps dsh = new DonorSiteHaps(siteRange[0], siteRange[1], dh.getParent1index(), dh.getParent2index());
                tRM.put(Range.closed((Comparable)Integer.valueOf(siteRange[0]), (Comparable)Integer.valueOf(siteRange[1])), (Object)dsh);
            }
            this.breakMaps.add((RangeMap<Integer, DonorSiteHaps>)tRM);
        }
        this.currentDSH = new DonorSiteHaps[this.numberOfTaxa()];
        this.primDSH = new int[this.myTaxaCount * 4];
        Arrays.fill(this.primDSH, Integer.MIN_VALUE);
    }

    public NavigableSet<DonorHaplotypes> getDonorHaplotypes(int taxon) {
        return (NavigableSet)this.allBreakPoints.get(taxon);
    }

    private int[] siteRangeForDonor(DonorHaplotypes dh) {
        int end;
        int start = this.myBaseGenoTable.siteOfPhysicalPosition(dh.getStartPosition(), dh.getChromosome());
        if (start < 0) {
            start = -(start + 1);
        }
        if ((end = this.myBaseGenoTable.siteOfPhysicalPosition(dh.getEndPosition(), dh.getChromosome())) < 0) {
            end = -(end + 1);
        }
        return new int[]{start, end};
    }

    @Override
    public byte genotype(int taxon, int site) {
        if (this.currMode == BaseMode.Site) {
            return this.getBaseSite(taxon, site);
        }
        return this.getBaseGeneral(taxon, site);
    }

    public GenotypeTable getBaseGenotypeTable() {
        return this.myBaseGenoTable;
    }

    private byte getBaseGeneral(int taxon, int site) {
        if (this.currentDSH[taxon] == null || !this.currentDSH[taxon].containsSite(site)) {
            this.currentDSH[taxon] = (DonorSiteHaps)this.breakMaps.get(taxon).get((Comparable)Integer.valueOf(site));
            if (this.currentDSH[taxon] == null) {
                return -1;
            }
        }
        byte p1 = this.myBaseGenoTable.genotype(this.currentDSH[taxon].getParent1index(), site);
        byte p2 = this.myBaseGenoTable.genotype(this.currentDSH[taxon].getParent2index(), site);
        return GenotypeTableUtils.getUnphasedDiploidValueNoHets(p1, p2);
    }

    private byte getBaseTaxon(int taxon, int site) {
        byte result;
        if (taxon != this.cachedTaxon) {
            this.projForCachedTaxon = new byte[this.mySiteCount];
            Arrays.fill(this.projForCachedTaxon, (byte)-18);
            this.cachedTaxon = taxon;
        }
        if ((result = this.projForCachedTaxon[site]) == -18) {
            DonorSiteHaps currentDSH = (DonorSiteHaps)this.breakMaps.get(taxon).get((Comparable)Integer.valueOf(site));
            byte[] r = this.myBaseGenoTable.genotypeRange(currentDSH.getParent1index(), currentDSH.getStartSite(), currentDSH.getEndSite() + 1);
            System.arraycopy(r, 0, this.projForCachedTaxon, currentDSH.getStartSite(), r.length);
            result = this.projForCachedTaxon[site];
        }
        return result;
    }

    private byte getBaseSite(int taxon, int site) {
        if (site != this.cachedSite) {
            this.donorForCachedSite = this.myBaseGenoTable.genotypeMatrix().genotypeForAllTaxa(site);
            this.cachedSite = site;
        }
        int primPos = taxon << 2;
        if (site < this.primDSH[primPos++] || site > this.primDSH[primPos++]) {
            DonorSiteHaps currentDSH = (DonorSiteHaps)this.breakMaps.get(taxon).get((Comparable)Integer.valueOf(site));
            primPos = taxon << 2;
            this.primDSH[primPos++] = currentDSH.getStartSite();
            this.primDSH[primPos++] = currentDSH.getEndSite();
            this.primDSH[primPos++] = currentDSH.getParent1index();
            this.primDSH[primPos] = currentDSH.getParent2index();
            primPos = (taxon << 2) + 2;
        }
        return GenotypeTableUtils.getUnphasedDiploidValueNoHets(this.donorForCachedSite[this.primDSH[primPos]], this.donorForCachedSite[this.primDSH[primPos + 1]]);
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(this.genotype(taxon, site));
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(value);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        this.myBaseGenoTable.genotypeMatrix().transposeData(siteInnerLoop);
        this.currMode = siteInnerLoop ? BaseMode.Site : BaseMode.General;
    }

    private class DonorSiteHaps {
        private final int startSite;
        private final int endSite;
        private final int parent1index;
        private final int parent2index;

        private DonorSiteHaps(int startSite, int endSite, int parent1index, int parent2index) {
            this.startSite = startSite;
            this.endSite = endSite;
            this.parent1index = parent1index;
            this.parent2index = parent2index;
        }

        private int getStartSite() {
            return this.startSite;
        }

        private int getEndSite() {
            return this.endSite;
        }

        private int getParent1index() {
            return this.parent1index;
        }

        private int getParent2index() {
            return this.parent2index;
        }

        private boolean containsSite(int site) {
            return site >= this.startSite && site <= this.endSite;
        }
    }

    private static enum BaseMode {
        General,
        Site,
        Taxa;

    }
}

