/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.util.TableReport;

@Deprecated
public class GeneticMap
implements TableReport,
Serializable {
    private static final long serialVersionUID = -5197800047652332969L;
    protected HashMap<String, Integer> markerIndex = new HashMap();
    int[] mapIndex;
    ArrayList<mapFeature> featureList = new ArrayList();
    boolean hasPhysicalPositions = false;
    ArrayList<mapFeature> physicalFeatureList = new ArrayList();
    String name;

    public GeneticMap(String name, String[] markerID, String[] chromosome, double[] geneticPosition, int[] physicalPosition) {
        this.name = name;
        int n = markerID.length;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(geneticPosition[i])) continue;
            int pos = -1;
            if (physicalPosition != null) {
                pos = physicalPosition[i];
                this.hasPhysicalPositions = true;
            }
            mapFeature feature = new mapFeature(markerID[i], chromosome[i], pos, geneticPosition[i]);
            this.featureList.add(feature);
            if (Double.isNaN(geneticPosition[i]) || pos <= -1) continue;
            this.physicalFeatureList.add(feature);
        }
        Collections.sort(this.featureList);
        int nFeatures = this.featureList.size();
        for (int i = 0; i < nFeatures; ++i) {
            this.markerIndex.put(this.featureList.get((int)i).id, i);
        }
    }

    public GeneticMap(String name, String[] markerID, String[] chromosome, double[] geneticPosition) {
        this(name, markerID, chromosome, geneticPosition, null);
    }

    public GeneticMap(String name) {
        this.name = name;
    }

    public void addMarker(String id, String chromosome, double geneticPosition, int physPosition) {
        mapFeature feature = new mapFeature(id, chromosome, physPosition, geneticPosition);
        this.featureList.add(feature);
        if (physPosition > -1) {
            if (!Double.isNaN(geneticPosition)) {
                this.physicalFeatureList.add(feature);
            }
            this.hasPhysicalPositions = true;
        }
        this.markerIndex.put(id, this.featureList.size() - 1);
    }

    public void addMarker(String id, String chromosome, double geneticPosition) {
        this.featureList.add(new mapFeature(id, chromosome, geneticPosition));
    }

    public boolean addMarker(String[] mapInfo) {
        int infoLength = mapInfo.length;
        if (infoLength > 2) {
            int physpos;
            double genpos;
            String id = mapInfo[0];
            String chr = mapInfo[1];
            try {
                genpos = Double.parseDouble(mapInfo[2]);
            }
            catch (Exception e) {
                genpos = Double.NaN;
            }
            if (infoLength > 3) {
                try {
                    physpos = Integer.parseInt(mapInfo[3]);
                }
                catch (Exception e) {
                    physpos = -1;
                }
            } else {
                physpos = -1;
            }
            this.addMarker(id, chr, genpos, physpos);
            return true;
        }
        return false;
    }

    public int getMarkerIndex(String marker) {
        return this.markerIndex.get(marker);
    }

    public String getMarkerID(int index) {
        return this.featureList.get((int)index).id;
    }

    public int getNumberOfMarkers() {
        return this.featureList.size();
    }

    public String getChromosome(int index) {
        return this.featureList.get((int)index).chromosome;
    }

    public double getGeneticPosition(int index) {
        return this.featureList.get((int)index).geneticPos;
    }

    public int getPhysicalPosition(int index) {
        return this.featureList.get((int)index).physicalPos;
    }

    public double getGeneticPositionFromPhysical(Chromosome locus, int position) {
        return this.getGeneticPositionFromPhysical(locus.getName(), position);
    }

    public double getGeneticPositionFromPhysical(String chromosome, int position) {
        mapFeature thisFeature = new mapFeature("none", chromosome, position, -1.0);
        int index = Collections.binarySearch(this.physicalFeatureList, thisFeature, new Comparator<mapFeature>(){

            @Override
            public int compare(mapFeature pos1, mapFeature pos2) {
                int comp = pos1.chromosome.compareTo(pos2.chromosome);
                if (comp != 0) {
                    return comp;
                }
                if (pos1.physicalPos < pos2.physicalPos) {
                    return -1;
                }
                if (pos1.physicalPos > pos2.physicalPos) {
                    return 1;
                }
                return 0;
            }
        });
        if (index > -1) {
            return this.physicalFeatureList.get((int)index).geneticPos;
        }
        int n = this.physicalFeatureList.size();
        if (index == -1) {
            mapFeature left = this.physicalFeatureList.get(0);
            mapFeature right = this.physicalFeatureList.get(1);
            double ratio = (right.geneticPos - left.geneticPos) / (double)(right.physicalPos - left.physicalPos);
            return left.geneticPos - ratio * (double)(left.physicalPos - position);
        }
        if (index == -1 - n) {
            mapFeature left = this.physicalFeatureList.get(n - 2);
            mapFeature right = this.physicalFeatureList.get(n - 1);
            double ratio = (right.geneticPos - left.geneticPos) / (double)(right.physicalPos - left.physicalPos);
            return right.geneticPos + ratio * (double)(position - right.physicalPos);
        }
        int insertionPoint = -1 - index;
        mapFeature left = this.physicalFeatureList.get(insertionPoint - 1);
        mapFeature right = this.physicalFeatureList.get(insertionPoint);
        double ratio = (right.geneticPos - left.geneticPos) / (double)(right.physicalPos - left.physicalPos);
        return left.geneticPos + ratio * (double)(position - left.physicalPos);
    }

    public int getPhysicalPositionFromGenetic(Chromosome locus, double position) {
        return this.getPhysicalPositionFromGenetic(locus.getName(), position);
    }

    public int getPhysicalPositionFromGenetic(String chromosome, double position) {
        mapFeature thisFeature = new mapFeature("none", chromosome, -1, position);
        int index = Collections.binarySearch(this.physicalFeatureList, thisFeature, new Comparator<mapFeature>(){

            @Override
            public int compare(mapFeature pos1, mapFeature pos2) {
                int comp = pos1.chromosome.compareTo(pos2.chromosome);
                if (comp != 0) {
                    return comp;
                }
                if (pos1.geneticPos < pos2.geneticPos) {
                    return -1;
                }
                if (pos1.geneticPos > pos2.geneticPos) {
                    return 1;
                }
                return 0;
            }
        });
        if (index > -1) {
            return this.physicalFeatureList.get((int)index).physicalPos;
        }
        int n = this.physicalFeatureList.size();
        if (index == -1) {
            mapFeature left = this.physicalFeatureList.get(0);
            mapFeature right = this.physicalFeatureList.get(1);
            double ratio = (double)(right.physicalPos - left.physicalPos) / (right.geneticPos - left.geneticPos);
            return left.physicalPos - (int)(ratio * (left.geneticPos - position));
        }
        if (index == -1 - n) {
            mapFeature left = this.physicalFeatureList.get(n - 2);
            mapFeature right = this.physicalFeatureList.get(n - 1);
            double ratio = (double)(right.physicalPos - left.physicalPos) / (right.geneticPos - left.geneticPos);
            return right.physicalPos + (int)(ratio * (position - right.geneticPos));
        }
        int insertionPoint = -1 - index;
        mapFeature left = this.physicalFeatureList.get(insertionPoint - 1);
        mapFeature right = this.physicalFeatureList.get(insertionPoint);
        double ratio = (double)(right.physicalPos - left.physicalPos) / (right.geneticPos - left.geneticPos);
        return left.physicalPos + (int)(ratio * (position - left.geneticPos));
    }

    public boolean hasPhysicalPositions() {
        return this.hasPhysicalPositions;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getColumnCount() {
        if (this.hasPhysicalPositions) {
            return 4;
        }
        return 3;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Marker";
            }
            case 1: {
                return "Chromosome";
            }
            case 2: {
                return "Genetic Position";
            }
            case 3: {
                return "Phys Position";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.featureList.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.featureList.get((int)row).id;
            }
            case 1: {
                return this.featureList.get((int)row).chromosome;
            }
            case 2: {
                return this.featureList.get((int)row).geneticPos;
            }
            case 3: {
                return this.featureList.get((int)row).physicalPos;
            }
        }
        return "";
    }

    @Override
    public int getElementCount() {
        return this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(int row) {
        int ncol = this.getColumnCount();
        Object[] thisRow = new Object[ncol];
        for (int i = 0; i < ncol; ++i) {
            thisRow[i] = this.getValueAt(row, i);
        }
        return thisRow;
    }

    @Override
    public Object[] getTableColumnNames() {
        int ncol = this.getColumnCount();
        Object[] names = new Object[ncol];
        for (int i = 0; i < ncol; ++i) {
            names[i] = this.getColumnName(i);
        }
        return names;
    }

    @Override
    public Object[][] getTableData() {
        int ncols = this.getColumnCount();
        int nrows = this.getRowCount();
        Object[][] data = new Object[nrows][ncols];
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                data[r][c] = this.getValueAt(r, c);
            }
        }
        return null;
    }

    @Override
    public Object[][] getTableData(int start, int end) {
        int ncols = this.getColumnCount();
        int nrows = end - start + 1;
        Object[][] data = new Object[nrows][ncols];
        for (int r = start; r <= end; ++r) {
            for (int c = 0; c < ncols; ++c) {
                data[r][c] = this.getValueAt(r, c);
            }
        }
        return null;
    }

    @Override
    public String getTableTitle() {
        return this.name;
    }

    class mapFeature
    implements Comparable<mapFeature>,
    Serializable {
        private static final long serialVersionUID = -5197800047652332969L;
        String id;
        String chromosome;
        int physicalPos;
        double geneticPos;

        public mapFeature(String id, String chromosome, int physical, double genetic) {
            this.id = id;
            this.chromosome = chromosome;
            this.physicalPos = physical;
            this.geneticPos = genetic;
        }

        public mapFeature(String id, String chromosome, double genetic) {
            this.id = id;
            this.chromosome = chromosome;
            this.physicalPos = -1;
            this.geneticPos = genetic;
        }

        public boolean equals(Object obj) {
            if (obj instanceof mapFeature) {
                mapFeature feature = (mapFeature)obj;
                if (!this.chromosome.equals(feature.chromosome)) {
                    return false;
                }
                if (!Double.isNaN(this.physicalPos) && !Double.isNaN(feature.physicalPos) && this.physicalPos != feature.physicalPos) {
                    return false;
                }
                return this.geneticPos == feature.geneticPos;
            }
            return false;
        }

        @Override
        public int compareTo(mapFeature feature) {
            int comp = this.chromosome.compareTo(feature.chromosome);
            if (comp != 0) {
                return comp;
            }
            if (this.physicalPos == -1 || feature.physicalPos == -1) {
                if (this.geneticPos > feature.geneticPos) {
                    return 1;
                }
                if (this.geneticPos < feature.geneticPos) {
                    return -1;
                }
                if (this.physicalPos > -1) {
                    return -1;
                }
                if (feature.physicalPos > -1) {
                    return 1;
                }
                return 0;
            }
            if (this.geneticPos > feature.geneticPos && this.physicalPos > feature.physicalPos) {
                return 1;
            }
            if (this.geneticPos < feature.geneticPos && this.physicalPos < feature.physicalPos) {
                return -1;
            }
            if (this.geneticPos == feature.geneticPos && this.physicalPos > feature.physicalPos) {
                return 1;
            }
            if (this.geneticPos == feature.geneticPos && this.physicalPos < feature.physicalPos) {
                return -1;
            }
            if (this.geneticPos == feature.geneticPos && this.physicalPos == feature.physicalPos) {
                return 0;
            }
            StringBuilder msg = new StringBuilder("The genetic and physical map positions are inconsistent for marker ");
            msg.append(this.id).append(" on chr ").append(this.chromosome).append(" at ");
            msg.append(this.geneticPos).append(", ").append(this.physicalPos);
            msg.append(" and marker ");
            msg.append(feature.id).append(" on chr ").append(feature.chromosome).append(" at ");
            msg.append(feature.geneticPos).append(", ").append(feature.physicalPos);
            throw new IllegalArgumentException("The genetic and physical map positions are inconsistent.");
        }
    }
}

