/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.bit.BitStorage;
import net.maizegenetics.dna.snp.bit.DynamicBitStorage;
import net.maizegenetics.dna.snp.depth.AlleleDepth;
import net.maizegenetics.dna.snp.depth.FilterAlleleDepth;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import org.apache.log4j.Logger;

public class FilterGenotypeTable
implements GenotypeTable {
    private static final long serialVersionUID = -5197800047652332969L;
    private static final Logger myLogger = Logger.getLogger(FilterGenotypeTable.class);
    private final boolean myIsTaxaFilter;
    private final boolean myIsSiteFilter;
    private final boolean myIsSiteFilterByRange;
    private final GenotypeTable myBaseAlignment;
    private final TaxaList myTaxaList;
    private final int[] myTaxaRedirect;
    private final int[] mySiteRedirect;
    private final int myRangeStart;
    private final int myRangeEnd;
    private Chromosome[] myChromosomes;
    private int[] myChromosomeOffsets;
    private PositionList myPositionList;
    private AlleleDepth myAlleleDepth = null;
    private final GenotypeCallTable myGenotype;
    private final Map<GenotypeTable.WHICH_ALLELE, BitStorage> myBitStorage = new HashMap<GenotypeTable.WHICH_ALLELE, BitStorage>();

    private FilterGenotypeTable(GenotypeTable a, TaxaList subList, int[] taxaRedirect, FilterGenotypeTable original) {
        this.myTaxaList = subList;
        if (this.myTaxaList.numberOfTaxa() != taxaRedirect.length) {
            throw new IllegalArgumentException("FilterGenotypeTable: init: subList should be same size as taxaRedirect.");
        }
        this.myIsTaxaFilter = true;
        this.myBaseAlignment = a;
        this.myTaxaRedirect = taxaRedirect;
        if (original == null) {
            this.myIsSiteFilter = false;
            this.myIsSiteFilterByRange = false;
            this.mySiteRedirect = null;
            this.myRangeStart = -1;
            this.myRangeEnd = -1;
            this.myChromosomes = this.myBaseAlignment.chromosomes();
            this.myChromosomeOffsets = this.myBaseAlignment.chromosomesOffsets();
        } else {
            this.myIsSiteFilter = original.isSiteFilter();
            this.myIsSiteFilterByRange = original.isSiteFilterByRange();
            this.mySiteRedirect = original.getSiteRedirect();
            this.myRangeStart = original.getRangeStart();
            this.myRangeEnd = original.getRangeEnd();
            this.myChromosomes = original.chromosomes();
            this.myChromosomeOffsets = original.chromosomesOffsets();
        }
        this.myGenotype = this.myIsSiteFilter ? GenotypeCallTableBuilder.getFilteredInstance(this.myBaseAlignment.genotypeMatrix(), this.numberOfTaxa(), this.myTaxaRedirect, this.numberOfSites(), this.mySiteRedirect) : GenotypeCallTableBuilder.getFilteredInstance(this.myBaseAlignment.genotypeMatrix(), this.numberOfTaxa(), this.myTaxaRedirect, this.numberOfSites(), this.myRangeStart, this.myRangeEnd);
    }

    public static GenotypeTable getInstance(GenotypeTable a, TaxaList subTaxaList) {
        return FilterGenotypeTable.getInstance(a, subTaxaList, true);
    }

    public static GenotypeTable getInstance(GenotypeTable a, TaxaList subTaxaList, boolean retainUnknownTaxa) {
        GenotypeTable baseAlignment = a;
        FilterGenotypeTable original = null;
        if (baseAlignment instanceof FilterGenotypeTable) {
            original = (FilterGenotypeTable)a;
            baseAlignment = ((FilterGenotypeTable)a).getBaseAlignment();
        }
        ArrayList<Integer> taxaRedirectList = new ArrayList<Integer>();
        ArrayList<Taxon> idList = new ArrayList<Taxon>();
        boolean noNeedToFilter = true;
        if (subTaxaList.numberOfTaxa() != a.numberOfTaxa()) {
            noNeedToFilter = false;
        }
        int n = subTaxaList.numberOfTaxa();
        for (int i = 0; i < n; ++i) {
            int ion = a.taxa().indexOf((Taxon)subTaxaList.get(i));
            if (ion != i) {
                noNeedToFilter = false;
            }
            if (ion == -1) {
                if (!retainUnknownTaxa) continue;
                taxaRedirectList.add(-1);
                idList.add((Taxon)subTaxaList.get(i));
                continue;
            }
            if (a instanceof FilterGenotypeTable) {
                taxaRedirectList.add(((FilterGenotypeTable)a).translateTaxon(ion));
            } else {
                taxaRedirectList.add(ion);
            }
            idList.add((Taxon)a.taxa().get(ion));
        }
        if (noNeedToFilter) {
            return a;
        }
        int[] taxaRedirect = new int[taxaRedirectList.size()];
        int n2 = taxaRedirectList.size();
        for (int j = 0; j < n2; ++j) {
            taxaRedirect[j] = (Integer)taxaRedirectList.get(j);
        }
        TaxaList resultTaxaList = new TaxaListBuilder().addAll(idList).build();
        return new FilterGenotypeTable(baseAlignment, resultTaxaList, taxaRedirect, original);
    }

    public static GenotypeTable getInstanceRemoveIDs(GenotypeTable a, TaxaList subTaxaList) {
        TaxaListBuilder result = new TaxaListBuilder();
        TaxaList current = a.taxa();
        int n = current.numberOfTaxa();
        for (int i = 0; i < n; ++i) {
            if (subTaxaList.indexOf((Taxon)current.get(i)) >= 0) continue;
            result.add((Taxon)current.get(i));
        }
        return FilterGenotypeTable.getInstance(a, result.build());
    }

    private FilterGenotypeTable(GenotypeTable a, int startSite, int endSite, FilterGenotypeTable original) {
        TaxaList taxaList = this.myTaxaList = original == null ? a.taxa() : original.taxa();
        if (startSite > endSite) {
            throw new IllegalArgumentException("FilterGenotypeTable: init: start site: " + startSite + " is larger than end site: " + endSite);
        }
        if (startSite < 0 || startSite > a.numberOfSites() - 1) {
            throw new IllegalArgumentException("FilterGenotypeTable: init: start site: " + startSite + " is out of range.");
        }
        if (endSite < 0 || endSite > a.numberOfSites() - 1) {
            throw new IllegalArgumentException("FilterGenotypeTable: init: end site: " + endSite + " is out of range.");
        }
        this.myBaseAlignment = a;
        this.myIsSiteFilterByRange = true;
        this.myIsSiteFilter = false;
        this.myRangeStart = startSite;
        this.myRangeEnd = endSite;
        this.mySiteRedirect = null;
        this.getLociFromBase();
        if (original == null) {
            this.myIsTaxaFilter = false;
            this.myTaxaRedirect = null;
        } else {
            this.myIsTaxaFilter = original.isTaxaFilter();
            this.myTaxaRedirect = original.getTaxaRedirect();
        }
        this.myGenotype = this.myIsSiteFilter ? GenotypeCallTableBuilder.getFilteredInstance(this.myBaseAlignment.genotypeMatrix(), this.numberOfTaxa(), this.myTaxaRedirect, this.numberOfSites(), this.mySiteRedirect) : GenotypeCallTableBuilder.getFilteredInstance(this.myBaseAlignment.genotypeMatrix(), this.numberOfTaxa(), this.myTaxaRedirect, this.numberOfSites(), this.myRangeStart, this.myRangeEnd);
    }

    private FilterGenotypeTable(GenotypeTable a, int[] subSites, FilterGenotypeTable original) {
        this.myTaxaList = original == null ? a.taxa() : original.taxa();
        this.myBaseAlignment = a;
        this.myIsSiteFilter = true;
        this.myIsSiteFilterByRange = false;
        if (subSites == null || subSites.length == 0) {
            this.mySiteRedirect = new int[0];
        } else {
            this.mySiteRedirect = new int[subSites.length];
            Arrays.sort(subSites);
            System.arraycopy(subSites, 0, this.mySiteRedirect, 0, subSites.length);
        }
        this.myRangeStart = -1;
        this.myRangeEnd = -1;
        this.getLociFromBase();
        if (original == null) {
            this.myIsTaxaFilter = false;
            this.myTaxaRedirect = null;
        } else {
            this.myIsTaxaFilter = original.isTaxaFilter();
            this.myTaxaRedirect = original.getTaxaRedirect();
        }
        this.myGenotype = this.myIsSiteFilter ? GenotypeCallTableBuilder.getFilteredInstance(this.myBaseAlignment.genotypeMatrix(), this.numberOfTaxa(), this.myTaxaRedirect, this.numberOfSites(), this.mySiteRedirect) : GenotypeCallTableBuilder.getFilteredInstance(this.myBaseAlignment.genotypeMatrix(), this.numberOfTaxa(), this.myTaxaRedirect, this.numberOfSites(), this.myRangeStart, this.myRangeEnd);
    }

    public static FilterGenotypeTable getInstance(GenotypeTable a, int[] subSites) {
        if (a instanceof FilterGenotypeTable) {
            FilterGenotypeTable original = (FilterGenotypeTable)a;
            GenotypeTable baseAlignment = ((FilterGenotypeTable)a).getBaseAlignment();
            if (original.isSiteFilter()) {
                int[] newSubSites = new int[subSites.length];
                for (int i = 0; i < subSites.length; ++i) {
                    newSubSites[i] = original.translateSite(subSites[i]);
                }
                return new FilterGenotypeTable(baseAlignment, newSubSites, original);
            }
            if (original.isSiteFilterByRange()) {
                int[] newSubSites = new int[subSites.length];
                for (int i = 0; i < subSites.length; ++i) {
                    newSubSites[i] = original.translateSite(subSites[i]);
                }
                return new FilterGenotypeTable(baseAlignment, newSubSites, original);
            }
            if (original.isTaxaFilter()) {
                return new FilterGenotypeTable(baseAlignment, subSites, original);
            }
            throw new IllegalStateException("FilterGenotypeTable: getInstance: original not in known state.");
        }
        return new FilterGenotypeTable(a, subSites, null);
    }

    public static FilterGenotypeTable getInstance(GenotypeTable a, List<String> siteNamesToKeep) {
        return FilterGenotypeTable.getInstance(a, siteNamesToKeep.toArray(new String[siteNamesToKeep.size()]));
    }

    public static FilterGenotypeTable getInstance(GenotypeTable a, String[] siteNamesToKeep) {
        Arrays.sort(siteNamesToKeep);
        int[] temp = new int[siteNamesToKeep.length];
        int count = 0;
        int n = a.numberOfSites();
        for (int i = 0; i < n; ++i) {
            if (Arrays.binarySearch(siteNamesToKeep, a.siteName(i)) < 0) continue;
            temp[count++] = i;
            if (count == siteNamesToKeep.length) break;
        }
        int[] result = null;
        if (count == siteNamesToKeep.length) {
            result = temp;
        } else {
            result = new int[count];
            System.arraycopy(temp, 0, result, 0, count);
        }
        return FilterGenotypeTable.getInstance(a, result);
    }

    public static FilterGenotypeTable getInstanceRemoveSiteNames(GenotypeTable a, List<String> siteNamesToRemove) {
        return FilterGenotypeTable.getInstance(a, siteNamesToRemove.toArray(new String[siteNamesToRemove.size()]));
    }

    public static FilterGenotypeTable getInstanceRemoveSiteNames(GenotypeTable a, String[] siteNamesToRemove) {
        Arrays.sort(siteNamesToRemove);
        int[] temp = new int[a.numberOfSites()];
        int count = 0;
        int n = a.numberOfSites();
        for (int i = 0; i < n; ++i) {
            if (Arrays.binarySearch(siteNamesToRemove, a.siteName(i)) >= 0) continue;
            temp[count++] = i;
        }
        int[] result = null;
        if (count == temp.length) {
            result = temp;
        } else {
            result = new int[count];
            System.arraycopy(temp, 0, result, 0, count);
        }
        return FilterGenotypeTable.getInstance(a, result);
    }

    public static FilterGenotypeTable getInstance(GenotypeTable a, PositionList subPositionList) {
        int[] temp = new int[subPositionList.size()];
        int count = 0;
        PositionList positionList = a.positions();
        for (Position position : subPositionList) {
            int index = positionList.indexOf(position);
            if (index < 0) continue;
            temp[count++] = index;
        }
        int[] result = null;
        if (count == subPositionList.size()) {
            result = temp;
        } else {
            result = new int[count];
            System.arraycopy(temp, 0, result, 0, count);
        }
        return FilterGenotypeTable.getInstance(a, result);
    }

    public static FilterGenotypeTable getInstance(GenotypeTable a, String chromosome, int startPhysicalPos, int endPhysicalPos) {
        return FilterGenotypeTable.getInstance(a, a.chromosome(chromosome), startPhysicalPos, endPhysicalPos);
    }

    public static FilterGenotypeTable getInstance(GenotypeTable a, Chromosome chromosome, int startPhysicalPos, int endPhysicalPos) {
        int endSite;
        int startSite = a.siteOfPhysicalPosition(startPhysicalPos, chromosome);
        if (startSite < 0) {
            startSite = -(startSite + 1);
        }
        if ((endSite = a.siteOfPhysicalPosition(endPhysicalPos, chromosome)) < 0) {
            endSite = -(endSite + 2);
        }
        if (startSite > endSite) {
            myLogger.warn((Object)("getInstance: start site: " + startSite + " from physical pos: " + startPhysicalPos + " is larger than end site: " + endSite + " from physical pos: " + endPhysicalPos));
            return null;
        }
        return FilterGenotypeTable.getInstance(a, startSite, endSite);
    }

    public static FilterGenotypeTable getInstance(GenotypeTable a, Chromosome chromosome) {
        int[] endStart = a.firstLastSiteOfChromosome(chromosome);
        return FilterGenotypeTable.getInstance(a, endStart[0], endStart[1]);
    }

    public static FilterGenotypeTable getInstance(GenotypeTable a, int startSite, int endSite) {
        if (a instanceof FilterGenotypeTable) {
            FilterGenotypeTable original = (FilterGenotypeTable)a;
            GenotypeTable baseAlignment = ((FilterGenotypeTable)a).getBaseAlignment();
            if (original.isSiteFilter()) {
                int[] subSites = new int[endSite - startSite + 1];
                int[] originalSites = original.getSiteRedirect();
                for (int i = startSite; i <= endSite; ++i) {
                    subSites[i - startSite] = originalSites[i];
                }
                return new FilterGenotypeTable(baseAlignment, subSites, original);
            }
            if (original.isSiteFilterByRange()) {
                return new FilterGenotypeTable(baseAlignment, original.translateSite(startSite), original.translateSite(endSite), original);
            }
            if (original.isTaxaFilter()) {
                return new FilterGenotypeTable(baseAlignment, startSite, endSite, original);
            }
            throw new IllegalStateException("FilterGenotypeTable: getInstance: original not in known state.");
        }
        return new FilterGenotypeTable(a, startSite, endSite, null);
    }

    @Override
    public byte genotype(int taxon, int site) {
        return this.myGenotype.genotype(taxon, site);
    }

    @Override
    public byte[] genotypeRange(int taxon, int startSite, int endSite) {
        return this.myGenotype.genotypeRange(taxon, startSite, endSite);
    }

    @Override
    public byte genotype(int taxon, Chromosome chromosome, int physicalPosition) {
        return this.myGenotype.genotype(taxon, this.myPositionList.siteOfPhysicalPosition(physicalPosition, chromosome));
    }

    public int translateSite(int site) {
        if (this.myIsSiteFilterByRange) {
            return site + this.myRangeStart;
        }
        if (this.myIsSiteFilter) {
            return this.mySiteRedirect[site];
        }
        return site;
    }

    public int reverseTranslateSite(int site) {
        if (this.myIsSiteFilterByRange) {
            return site - this.myRangeStart;
        }
        if (this.myIsSiteFilter) {
            return Arrays.binarySearch(this.mySiteRedirect, site);
        }
        return site;
    }

    public int[] getBaseSitesShown() {
        int numSites = this.numberOfSites();
        int[] result = new int[numSites];
        for (int i = 0; i < numSites; ++i) {
            result[i] = this.translateSite(i);
        }
        return result;
    }

    public int translateTaxon(int taxon) {
        if (this.myIsTaxaFilter) {
            return this.myTaxaRedirect[taxon];
        }
        return taxon;
    }

    private void getLociFromBase() {
        int i;
        if (!this.myIsSiteFilter && !this.myIsSiteFilterByRange) {
            this.myChromosomes = this.myBaseAlignment.chromosomes();
            this.myChromosomeOffsets = this.myBaseAlignment.chromosomesOffsets();
            return;
        }
        int numSites = this.numberOfSites();
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (i = 0; i < numSites; ++i) {
            Chromosome current = this.chromosome(i);
            if (chromosomes.contains(current)) continue;
            chromosomes.add(current);
            offsets.add(i);
        }
        this.myChromosomes = new Chromosome[chromosomes.size()];
        chromosomes.toArray(this.myChromosomes);
        this.myChromosomeOffsets = new int[offsets.size()];
        for (i = 0; i < offsets.size(); ++i) {
            this.myChromosomeOffsets[i] = (Integer)offsets.get(i);
        }
    }

    @Override
    public int indelSize(int site) {
        return this.myBaseAlignment.indelSize(this.translateSite(site));
    }

    @Override
    public Chromosome chromosome(int site) {
        return this.myBaseAlignment.chromosome(this.translateSite(site));
    }

    @Override
    public int chromosomalPosition(int site) {
        return this.myBaseAlignment.chromosomalPosition(this.translateSite(site));
    }

    @Override
    public String chromosomeName(int site) {
        return this.myBaseAlignment.chromosomeName(this.translateSite(site));
    }

    @Override
    public Chromosome chromosome(String name) {
        return this.myBaseAlignment.chromosome(name);
    }

    @Override
    public Chromosome[] chromosomes() {
        return this.myChromosomes;
    }

    @Override
    public int numChromosomes() {
        return this.myChromosomes.length;
    }

    @Override
    public int[] chromosomesOffsets() {
        return this.myChromosomeOffsets;
    }

    @Override
    public int[] firstLastSiteOfChromosome(Chromosome chromosome) {
        for (int i = 0; i < this.numChromosomes(); ++i) {
            if (!chromosome.equals(this.myChromosomes[i])) continue;
            int end = 0;
            end = i == this.numChromosomes() - 1 ? this.numberOfSites() - 1 : this.myChromosomeOffsets[i + 1] - 1;
            return new int[]{this.myChromosomeOffsets[i], end};
        }
        throw new IllegalArgumentException("FilterGenotypeTable: getStartAndEndOfLocus: this locus not defined: " + chromosome.getName());
    }

    @Override
    public float[][] siteScores() {
        if (!this.myBaseAlignment.hasSiteScores()) {
            return null;
        }
        int numSites = this.numberOfSites();
        int numSeqs = this.numberOfTaxa();
        float[][] result = new float[numSeqs][numSites];
        for (int i = 0; i < numSites; ++i) {
            for (int j = 0; j < numSeqs; ++j) {
                int taxaIndex = this.translateTaxon(j);
                result[j][i] = taxaIndex == -1 ? -9.0f : this.myBaseAlignment.siteScore(taxaIndex, this.translateSite(i));
            }
        }
        return result;
    }

    @Override
    public byte referenceAllele(int site) {
        return this.myBaseAlignment.referenceAllele(this.translateSite(site));
    }

    @Override
    public int numberOfSites() {
        if (this.myIsSiteFilterByRange) {
            return this.myRangeEnd - this.myRangeStart + 1;
        }
        if (this.myIsSiteFilter) {
            return this.mySiteRedirect.length;
        }
        return this.myBaseAlignment.numberOfSites();
    }

    @Override
    public String siteName(int site) {
        return this.myBaseAlignment.siteName(this.translateSite(site));
    }

    @Override
    public boolean hasReference() {
        return this.myBaseAlignment.hasReference();
    }

    @Override
    public boolean isIndel(int site) {
        return this.myBaseAlignment.isIndel(this.translateSite(site));
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome) {
        int temp = this.myBaseAlignment.siteOfPhysicalPosition(physicalPosition, chromosome);
        if (temp < 0) {
            temp = -(temp + 1);
            return -(this.reverseTranslateSite(temp) + 1);
        }
        return this.reverseTranslateSite(temp);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome, String snpName) {
        int temp = this.myBaseAlignment.siteOfPhysicalPosition(physicalPosition, chromosome, snpName);
        if (temp < 0) {
            temp = -(temp + 1);
            return -(this.reverseTranslateSite(temp) + 1);
        }
        return this.reverseTranslateSite(temp);
    }

    public GenotypeTable getBaseAlignment() {
        return this.myBaseAlignment;
    }

    public boolean isTaxaFilter() {
        return this.myIsTaxaFilter;
    }

    public boolean isSiteFilter() {
        return this.myIsSiteFilter;
    }

    public boolean isSiteFilterByRange() {
        return this.myIsSiteFilterByRange;
    }

    protected int[] getTaxaRedirect() {
        return this.myTaxaRedirect;
    }

    protected int[] getSiteRedirect() {
        return this.mySiteRedirect;
    }

    protected int getRangeStart() {
        return this.myRangeStart;
    }

    protected int getRangeEnd() {
        return this.myRangeEnd;
    }

    @Override
    public byte[] genotypeArray(int taxon, int site) {
        return this.myGenotype.genotypeArray(taxon, site);
    }

    @Override
    public byte[] genotypeAllTaxa(int site) {
        return this.myGenotype.genotypeForAllTaxa(site);
    }

    @Override
    public byte[] genotypeAllSites(int taxon) {
        return this.myGenotype.genotypeAllSites(taxon);
    }

    @Override
    public BitSet allelePresenceForAllSites(int taxon, GenotypeTable.WHICH_ALLELE allele) {
        return this.bitStorage(allele).allelePresenceForAllSites(taxon);
    }

    @Override
    public long[] allelePresenceForSitesBlock(int taxon, GenotypeTable.WHICH_ALLELE allele, int startBlock, int endBlock) {
        return this.bitStorage(allele).allelePresenceForSitesBlock(taxon, startBlock, endBlock);
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return this.myGenotype.genotypeAsString(taxon, site);
    }

    @Override
    public String[] genotypeAsStringArray(int taxon, int site) {
        return this.myGenotype.genotypeAsStringArray(taxon, site);
    }

    @Override
    public byte[] referenceAlleleForAllSites() {
        if (this.myIsSiteFilterByRange || this.myIsSiteFilter) {
            byte[] result = new byte[this.numberOfSites()];
            int n = this.numberOfSites();
            for (int i = 0; i < n; ++i) {
                result[i] = this.referenceAllele(i);
            }
            return result;
        }
        return this.myBaseAlignment.referenceAlleleForAllSites();
    }

    @Override
    public boolean isHeterozygous(int taxon, int site) {
        return this.myGenotype.isHeterozygous(taxon, site);
    }

    @Override
    public int[] physicalPositions() {
        if (this.myIsSiteFilterByRange || this.myIsSiteFilter) {
            int numSites = this.numberOfSites();
            int[] result = new int[numSites];
            for (int i = 0; i < numSites; ++i) {
                result[i] = this.chromosomalPosition(i);
            }
            return result;
        }
        return this.myBaseAlignment.physicalPositions();
    }

    @Override
    public TaxaList taxa() {
        return this.myTaxaList;
    }

    @Override
    public int numberOfTaxa() {
        return this.myTaxaList.numberOfTaxa();
    }

    @Override
    public float siteScore(int taxon, int site) {
        int taxaIndex = this.translateTaxon(taxon);
        if (taxaIndex == -1) {
            return Float.NaN;
        }
        return this.myBaseAlignment.siteScore(taxaIndex, this.translateSite(site));
    }

    @Override
    public boolean hasSiteScores() {
        return this.myBaseAlignment.hasSiteScores();
    }

    @Override
    public GenotypeTable.SITE_SCORE_TYPE siteScoreType() {
        return this.myBaseAlignment.siteScoreType();
    }

    @Override
    public String genomeVersion() {
        return this.myBaseAlignment.genomeVersion();
    }

    @Override
    public boolean isPositiveStrand(int site) {
        return this.myBaseAlignment.isPositiveStrand(this.translateSite(site));
    }

    @Override
    public boolean isPhased() {
        return this.myGenotype.isPhased();
    }

    @Override
    public boolean retainsRareAlleles() {
        return this.myGenotype.retainsRareAlleles();
    }

    @Override
    public String[][] alleleDefinitions() {
        return this.alleleDefinitions();
    }

    @Override
    public String[] alleleDefinitions(int site) {
        return this.alleleDefinitions(site);
    }

    @Override
    public String genotypeAsString(int site, byte value) {
        return this.myGenotype.genotypeAsString(site, value);
    }

    @Override
    public int maxNumAlleles() {
        return this.myGenotype.maxNumAlleles();
    }

    @Override
    public byte[] alleles(int site) {
        return this.myGenotype.alleles(site);
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        return this.myGenotype.allelesSortedByFrequency(site);
    }

    @Override
    public double majorAlleleFrequency(int site) {
        return this.myGenotype.majorAlleleFrequency(site);
    }

    @Override
    public int heterozygousCount(int site) {
        return this.myGenotype.heterozygousCount(site);
    }

    @Override
    public boolean isPolymorphic(int site) {
        return this.myGenotype.isPolymorphic(site);
    }

    @Override
    public int totalGametesNonMissingForSite(int site) {
        return this.myGenotype.totalGametesNonMissingForSite(site);
    }

    @Override
    public int totalNonMissingForSite(int site) {
        return this.myGenotype.totalNonMissingForSite(site);
    }

    @Override
    public int minorAlleleCount(int site) {
        return this.myGenotype.minorAlleleCount(site);
    }

    @Override
    public double minorAlleleFrequency(int site) {
        return this.myGenotype.minorAlleleFrequency(site);
    }

    @Override
    public int majorAlleleCount(int site) {
        return this.myGenotype.majorAlleleCount(site);
    }

    @Override
    public byte majorAllele(int site) {
        return this.myGenotype.majorAllele(site);
    }

    @Override
    public byte minorAllele(int site) {
        return this.myGenotype.minorAllele(site);
    }

    @Override
    public Object[][] genosSortedByFrequency(int site) {
        return this.myGenotype.genosSortedByFrequency(site);
    }

    @Override
    public int totalGametesNonMissingForTaxon(int taxon) {
        return this.myGenotype.totalGametesNonMissingForTaxon(taxon);
    }

    @Override
    public int totalNonMissingForTaxon(int taxon) {
        return this.myGenotype.totalNonMissingForTaxon(taxon);
    }

    @Override
    public int heterozygousCountForTaxon(int taxon) {
        return this.myGenotype.heterozygousCountForTaxon(taxon);
    }

    @Override
    public boolean hasDepth() {
        return this.myBaseAlignment.hasDepth();
    }

    @Override
    public AlleleDepth depth() {
        if (this.myAlleleDepth == null) {
            this.myAlleleDepth = new FilterAlleleDepth(this.myBaseAlignment.depth(), this);
        }
        return this.myAlleleDepth;
    }

    @Override
    public int[] depthForAlleles(int taxon, int site) {
        int taxaIndex = this.translateTaxon(taxon);
        if (taxaIndex == -1) {
            return null;
        }
        return this.myBaseAlignment.depthForAlleles(taxaIndex, this.translateSite(site));
    }

    @Override
    public byte[] allelesBySortType(GenotypeTable.ALLELE_SORT_TYPE scope, int site) {
        if (scope == GenotypeTable.ALLELE_SORT_TYPE.Frequency) {
            return this.alleles(site);
        }
        return this.myBaseAlignment.allelesBySortType(scope, this.translateSite(site));
    }

    @Override
    public BitSet allelePresenceForAllTaxa(int site, GenotypeTable.WHICH_ALLELE allele) {
        return this.bitStorage(allele).allelePresenceForAllTaxa(site);
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllSites(int taxon, boolean firstParent, GenotypeTable.WHICH_ALLELE allele) {
        return this.bitStorage(allele).haplotypeAllelePresenceForAllSites(taxon, firstParent);
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllTaxa(int site, boolean firstParent, GenotypeTable.WHICH_ALLELE allele) {
        return this.bitStorage(allele).haplotypeAllelePresenceForAllTaxa(site, firstParent);
    }

    @Override
    public long[] haplotypeAllelePresenceForSitesBlock(int taxon, boolean firstParent, GenotypeTable.WHICH_ALLELE allele, int startBlock, int endBlock) {
        return this.bitStorage(allele).haplotypeAllelePresenceForSitesBlock(taxon, firstParent, startBlock, endBlock);
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        return this.myGenotype.genotypeAsStringRange(taxon, startSite, endSite);
    }

    @Override
    public String genotypeAsStringRow(int taxon) {
        return this.myGenotype.genotypeAsStringRow(taxon);
    }

    @Override
    public byte[] referenceAlleles(int startSite, int endSite) {
        if (!this.hasReference()) {
            return null;
        }
        byte[] result = new byte[endSite - startSite];
        for (int i = startSite; i < endSite; ++i) {
            result[i] = this.referenceAllele(i);
        }
        return result;
    }

    @Override
    public int chromosomeSiteCount(Chromosome chromosome) {
        int[] startEnd = this.firstLastSiteOfChromosome(chromosome);
        return startEnd[1] - startEnd[0] + 1;
    }

    @Override
    public boolean isAllPolymorphic() {
        return this.myGenotype.isAllPolymorphic();
    }

    @Override
    public String majorAlleleAsString(int site) {
        return this.myGenotype.majorAlleleAsString(site);
    }

    @Override
    public String minorAlleleAsString(int site) {
        return this.myGenotype.minorAlleleAsString(site);
    }

    @Override
    public byte[] minorAlleles(int site) {
        return this.myGenotype.minorAlleles(site);
    }

    @Override
    public String taxaName(int index) {
        return this.myTaxaList.taxaName(index);
    }

    @Override
    public GenotypeTable[] compositeAlignments() {
        return new GenotypeTable[]{this};
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return this.myGenotype.diploidAsString(site, value);
    }

    @Override
    public Object[][] genoCounts() {
        return this.myGenotype.genoCounts();
    }

    @Override
    public Object[][] majorMinorCounts() {
        return this.myGenotype.majorMinorCounts();
    }

    @Override
    public BitStorage bitStorage(GenotypeTable.WHICH_ALLELE allele) {
        BitStorage result = this.myBitStorage.get((Object)allele);
        if (result != null) {
            return result;
        }
        switch (allele) {
            case Major: {
                result = new DynamicBitStorage(this.myGenotype, allele, this.myGenotype.majorAlleleForAllSites());
                break;
            }
            case Minor: {
                result = new DynamicBitStorage(this.myGenotype, allele, this.myGenotype.minorAlleleForAllSites());
                break;
            }
            default: {
                myLogger.warn((Object)("bitStorage: Unsupported allele: " + (Object)((Object)allele)));
                return null;
            }
        }
        this.myBitStorage.put(allele, result);
        return result;
    }

    @Override
    public PositionList positions() {
        if (this.myPositionList == null) {
            PositionListBuilder pLB = new PositionListBuilder();
            PositionList basePL = this.getBaseAlignment().positions();
            for (int i = 0; i < this.numberOfSites(); ++i) {
                pLB.add((Position)basePL.get(this.translateSite(i)));
            }
            this.myPositionList = pLB.build();
        }
        return this.myPositionList;
    }

    @Override
    public GenotypeCallTable genotypeMatrix() {
        return this.myGenotype;
    }
}

