/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.AbstractTagsOnPhysicalMap;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.TableReport;

public class TOPMTableReport
implements TableReport {
    private static final String[] DEFAULT_COLUMN_HEADINGS = new String[]{"Tag", "Tag Length", "Multi Maps", "Chromosome", "Strand", "Start Pos", "End Pos", "Divergence"};
    private final TOPMInterface myTOPM;
    private final String[] myColumnHeadings;

    public TOPMTableReport(TOPMInterface topm) {
        this.myTOPM = topm;
        int numVariants = this.myTOPM.getMaxNumVariants();
        int totalHeadings = DEFAULT_COLUMN_HEADINGS.length + numVariants * 2;
        this.myColumnHeadings = new String[totalHeadings];
        for (int i = 0; i < DEFAULT_COLUMN_HEADINGS.length; ++i) {
            this.myColumnHeadings[i] = DEFAULT_COLUMN_HEADINGS[i];
        }
        for (int j = DEFAULT_COLUMN_HEADINGS.length; j < totalHeadings; j += 2) {
            this.myColumnHeadings[j] = "Offset";
            this.myColumnHeadings[j + 1] = "Variant";
        }
    }

    @Override
    public Object[] getTableColumnNames() {
        return this.myColumnHeadings;
    }

    @Override
    public Object[][] getTableData() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String getTableTitle() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getColumnCount() {
        return this.myColumnHeadings.length;
    }

    @Override
    public int getRowCount() {
        return this.myTOPM.getSize();
    }

    @Override
    public int getElementCount() {
        return this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(int row) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Object[][] getTableData(int start, int end) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return BaseEncoder.getSequenceFromLong(this.myTOPM.getTag(row));
            }
            case 1: {
                return this.myTOPM.getTagLength(row);
            }
            case 2: {
                return AbstractTagsOnPhysicalMap.printWithMissing(this.myTOPM.getMultiMaps(col));
            }
            case 3: {
                return AbstractTagsOnPhysicalMap.printWithMissing(this.myTOPM.getChromosome(row));
            }
            case 4: {
                return AbstractTagsOnPhysicalMap.printWithMissing(this.myTOPM.getStrand(row));
            }
            case 5: {
                return AbstractTagsOnPhysicalMap.printWithMissing(this.myTOPM.getStartPosition(row));
            }
            case 6: {
                return AbstractTagsOnPhysicalMap.printWithMissing(this.myTOPM.getEndPosition(row));
            }
            case 7: {
                return AbstractTagsOnPhysicalMap.printWithMissing(this.myTOPM.getDivergence(row));
            }
        }
        int varIndex = col - 8;
        if (varIndex % 2 == 0) {
            return AbstractTagsOnPhysicalMap.printWithMissing(this.myTOPM.getVariantPosOff(row, varIndex / 2));
        }
        byte vd = this.myTOPM.getVariantDef(row, varIndex / 2);
        if (vd == -128) {
            return AbstractTagsOnPhysicalMap.printWithMissing(vd);
        }
        return NucleotideAlignmentConstants.getHaplotypeNucleotide(vd);
    }
}

