/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionArrayList;
import net.maizegenetics.dna.map.PositionHDF5List;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Tassel5HDF5Constants;
import org.apache.log4j.Logger;

public class PositionListBuilder {
    private static final Logger myLogger = Logger.getLogger(PositionListBuilder.class);
    private ArrayList<Position> myPositions = new ArrayList();
    private boolean isHDF5 = false;
    private String genomeVersion = null;
    private IHDF5Reader reader;

    public PositionListBuilder() {
    }

    public PositionListBuilder(int numberOfPositions) {
        for (int i = 0; i < numberOfPositions; ++i) {
            this.myPositions.add(new GeneralPosition.Builder(Chromosome.UNKNOWN, i).build());
        }
    }

    public PositionListBuilder add(Position element) {
        if (this.isHDF5) {
            throw new UnsupportedOperationException("Positions cannot be added to existing HDF5 alignments");
        }
        Preconditions.checkNotNull((Object)element, (Object)"element cannot be null");
        this.myPositions.add(element);
        return this;
    }

    public PositionListBuilder addAll(Iterable<? extends Position> elements) {
        if (this.isHDF5) {
            throw new UnsupportedOperationException("Positions cannot be added to existing HDF5 alignments");
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            this.myPositions.ensureCapacity(this.myPositions.size() + collection.size());
        }
        for (Position position : elements) {
            Preconditions.checkNotNull((Object)position, (Object)"elements contains a null");
            this.myPositions.add(position);
        }
        return this;
    }

    public PositionListBuilder set(int index, Position element) {
        if (this.isHDF5) {
            throw new UnsupportedOperationException("Positions cannot be edited to existing HDF5 alignments");
        }
        this.myPositions.set(index, element);
        return this;
    }

    public PositionListBuilder genomeVersion(String genomeVersion) {
        this.genomeVersion = genomeVersion;
        return this;
    }

    public boolean validateOrdering() {
        boolean result = true;
        Position startAP = this.myPositions.get(0);
        for (Position ap : this.myPositions) {
            if (ap.compareTo(startAP) < 0) {
                myLogger.error((Object)("validateOrdering: " + ap.toString() + " and " + startAP.toString() + " out of order."));
                return false;
            }
            startAP = ap;
        }
        return result;
    }

    public int size() {
        return this.myPositions.size();
    }

    public static PositionList getInstance(String hdf5Filename) {
        return new PositionHDF5List(HDF5Factory.openForReading((String)hdf5Filename));
    }

    public static PositionList getInstance(IHDF5Reader reader) {
        return new PositionHDF5List(reader);
    }

    public static PositionList getInstance(int numSites) {
        PositionListBuilder builder = new PositionListBuilder();
        for (int i = 0; i < numSites; ++i) {
            builder.add(new GeneralPosition.Builder(Chromosome.UNKNOWN, i).build());
        }
        return builder.build();
    }

    public static PositionList getInstance(ArrayList<Position> positions) {
        PositionListBuilder builder = new PositionListBuilder();
        builder.addAll(positions);
        return builder.build();
    }

    public PositionListBuilder(IHDF5Writer h5w, PositionList a) {
        HDF5Utils.createHDF5PositionModule(h5w);
        h5w.setIntAttribute("Positions/", "numSites", a.size());
        if (a.hasReference()) {
            h5w.setStringAttribute("Positions/", "genomeVersion", a.genomeVersion());
            h5w.setBooleanAttribute("Positions/", "hasReferenceAlleles", true);
        }
        String[] lociNames = new String[a.numChromosomes()];
        HashMap<Chromosome, Integer> locusToIndex = new HashMap<Chromosome, Integer>(10);
        Chromosome[] loci = a.chromosomes();
        for (int i = 0; i < a.numChromosomes(); ++i) {
            lociNames[i] = loci[i].getName();
            locusToIndex.put(loci[i], i);
        }
        h5w.createStringVariableLengthArray("Positions/Chromosomes", a.numChromosomes());
        h5w.writeStringVariableLengthArray("Positions/Chromosomes", lociNames);
        int blockSize = 65536;
        h5w.createStringArray("Positions/SnpIds", 15, (long)a.numberOfSites(), blockSize, Tassel5HDF5Constants.genDeflation);
        h5w.createIntArray("Positions/ChromosomeIndices", a.numberOfSites(), Tassel5HDF5Constants.intDeflation);
        h5w.createIntArray("Positions/Positions", a.numberOfSites(), Tassel5HDF5Constants.intDeflation);
        h5w.createIntArray("Positions/ReferenceAlleles", a.numberOfSites(), Tassel5HDF5Constants.intDeflation);
        int blocks = (a.numberOfSites() - 1) / blockSize + 1;
        for (int block = 0; block < blocks; ++block) {
            int startPos = block * blockSize;
            int length = a.numberOfSites() - startPos > blockSize ? blockSize : a.numberOfSites() - startPos;
            String[] snpIDs = new String[length];
            int[] locusIndicesArray = new int[length];
            int[] positions = new int[length];
            byte[] refAlleles = new byte[length];
            for (int i = 0; i < length; ++i) {
                Position gp = (Position)a.get(i + startPos);
                snpIDs[i] = gp.getSNPID();
                locusIndicesArray[i] = (Integer)locusToIndex.get(gp.getChromosome());
                positions[i] = gp.getPosition();
                refAlleles[i] = gp.getAllele(Position.Allele.REF);
            }
            HDF5Utils.writeHDF5Block("Positions/SnpIds", h5w, blockSize, block, snpIDs);
            HDF5Utils.writeHDF5Block("Positions/ChromosomeIndices", h5w, blockSize, block, locusIndicesArray);
            HDF5Utils.writeHDF5Block("Positions/Positions", h5w, blockSize, block, positions);
            HDF5Utils.writeHDF5Block("Positions/ReferenceAlleles", h5w, blockSize, block, refAlleles);
        }
        this.reader = h5w;
        this.isHDF5 = true;
    }

    public PositionList build() {
        if (this.isHDF5) {
            return new PositionHDF5List(this.reader);
        }
        Collections.sort(this.myPositions);
        return new PositionArrayList(this.myPositions, this.genomeVersion);
    }

    public PositionList build(GenotypeCallTableBuilder genotypes) {
        this.sortPositions(genotypes);
        return new PositionArrayList(this.myPositions, this.genomeVersion);
    }

    public PositionListBuilder sortPositions(GenotypeCallTableBuilder genotypes) {
        int numPositions = this.myPositions.size();
        if (numPositions != genotypes.getSiteCount()) {
            throw new IllegalArgumentException("PositionListBuilder: sortPositions: position list size: " + numPositions + " doesn't match genotypes num position: " + genotypes.getSiteCount());
        }
        genotypes.reorderPositions(this.sort());
        return this;
    }

    public PositionListBuilder sortPositions() {
        this.sort();
        return this;
    }

    private int[] sort() {
        int numPositions = this.myPositions.size();
        final int[] indicesOfSortByPosition = new int[numPositions];
        for (int i = 0; i < indicesOfSortByPosition.length; ++i) {
            indicesOfSortByPosition[i] = i;
        }
        Swapper swapPosition = new Swapper(){

            public void swap(int a, int b) {
                int temp = indicesOfSortByPosition[a];
                indicesOfSortByPosition[a] = indicesOfSortByPosition[b];
                indicesOfSortByPosition[b] = temp;
            }
        };
        IntComparator compPosition = new IntComparator(){

            public int compare(int a, int b) {
                return ((Position)PositionListBuilder.this.myPositions.get(indicesOfSortByPosition[a])).compareTo(PositionListBuilder.this.myPositions.get(indicesOfSortByPosition[b]));
            }
        };
        GenericSorting.quickSort((int)0, (int)indicesOfSortByPosition.length, (IntComparator)compPosition, (Swapper)swapPosition);
        ArrayList<Position> temp = new ArrayList<Position>(numPositions);
        for (int t = 0; t < numPositions; ++t) {
            temp.add(this.myPositions.get(indicesOfSortByPosition[t]));
        }
        this.myPositions = temp;
        return indicesOfSortByPosition;
    }
}

