/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.tree;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix;
import net.maizegenetics.analysis.tree.CreateTreeDialog;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.tree.NeighborJoiningTree;
import net.maizegenetics.taxa.tree.UPGMATree;

public class CreateTreePlugin
extends AbstractPlugin {
    private boolean isNeighborJoining = true;
    private boolean isReturnDistanceMatrix = true;

    public CreateTreePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() < 1) {
                String message = "Invalid selection.  Please select sequence or marker alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    System.out.println(message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            if (this.isInteractive()) {
                CreateTreeDialog myDialog = new CreateTreeDialog();
                myDialog.setLocationRelativeTo(this.getParentFrame());
                myDialog.setVisible(true);
                if (myDialog.isCancel()) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                this.isNeighborJoining = myDialog.isNeighborJoiningTree();
                this.isReturnDistanceMatrix = myDialog.isSaveMatrix();
                myDialog.dispose();
            }
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            for (Datum current : alignInList) {
                DataSet tds = this.processDatum(current, this.isNeighborJoining, this.isReturnDistanceMatrix);
                result.add(tds);
                if (tds == null) continue;
                this.fireDataSetReturned(new PluginEvent(tds, CreateTreePlugin.class));
            }
            DataSet dataSet = DataSet.getDataSet(result, this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public DataSet processDatum(Datum input, boolean isNJ, boolean isSaveMatrix) {
        GenotypeTable aa = (GenotypeTable)input.getData();
        IBSDistanceMatrix adm = new IBSDistanceMatrix(aa, this);
        ArrayList<Datum> results = new ArrayList<Datum>();
        if (isNJ) {
            NeighborJoiningTree theTree = new NeighborJoiningTree(adm);
            results.add(new Datum("Tree:" + input.getName(), theTree, "NJ Tree"));
        } else {
            UPGMATree theTree = new UPGMATree(adm);
            results.add(new Datum("Tree:" + input.getName(), theTree, "UPGMA Tree"));
        }
        if (isSaveMatrix) {
            results.add(new Datum("Matrix:" + input.getName(), adm, "Distance Matrix"));
        }
        DataSet tds = new DataSet(results, (Plugin)this);
        return tds;
    }

    public boolean isNeighborJoining() {
        return this.isNeighborJoining;
    }

    public void setNeighborJoining(boolean neighborJoining) {
        this.isNeighborJoining = neighborJoining;
    }

    public boolean isReturnDistanceMatrix() {
        return this.isReturnDistanceMatrix;
    }

    public void setReturnDistanceMatrix(boolean returnDistanceMatrix) {
        this.isReturnDistanceMatrix = returnDistanceMatrix;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = CreateTreePlugin.class.getResource("/net/maizegenetics/analysis/images/Tree.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Cladogram";
    }

    @Override
    public String getToolTipText() {
        return "Create a cladogram";
    }
}

