/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.io.Serializable;
import java.util.Vector;
import net.maizegenetics.analysis.popgen.PolymorphismDistributionResults;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.util.AbstractTableReport;
import net.maizegenetics.util.TableReport;

public class PolymorphismDistribution
extends AbstractTableReport
implements TableReport,
Serializable {
    Vector polyDistResultsVector = new Vector();
    int maxSeqCount = -1;

    public void addDistribution(String label, GenotypeTable theSP, boolean poolMinor) {
        this.maxSeqCount = theSP.numberOfTaxa() * 2;
        int[] pdist = new int[this.maxSeqCount];
        for (int i = 0; i < theSP.numberOfSites(); ++i) {
            if (theSP.isPolymorphic(i)) {
                int[][] alleleCounts = theSP.allelesSortedByFrequency(i);
                int numAlleles = alleleCounts[0].length;
                if (!poolMinor || numAlleles == 2) {
                    int n = alleleCounts[1][1];
                    pdist[n] = pdist[n] + 1;
                    continue;
                }
                int sum = 0;
                for (int a = 1; a < numAlleles; ++a) {
                    sum += alleleCounts[1][a];
                }
                int n = sum;
                pdist[n] = pdist[n] + 1;
                continue;
            }
            pdist[0] = pdist[0] + 1;
        }
        PolymorphismDistributionResults pdr = new PolymorphismDistributionResults(label, pdist, poolMinor);
        this.polyDistResultsVector.add(pdr);
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] basicLabels = new String[1 + this.polyDistResultsVector.size()];
        basicLabels[0] = "Site_Freq";
        for (int i = 0; i < this.polyDistResultsVector.size(); ++i) {
            PolymorphismDistributionResults pdr = (PolymorphismDistributionResults)this.polyDistResultsVector.get(i);
            basicLabels[i + 1] = pdr.label;
        }
        return basicLabels;
    }

    @Override
    public Object[][] getTableData() {
        int i;
        int basicCols = 1;
        Object[][] data = new String[this.maxSeqCount + 1][basicCols + this.polyDistResultsVector.size()];
        data[0][0] = "N";
        for (i = 0; i < this.maxSeqCount; ++i) {
            data[i + 1][0] = "" + i;
        }
        for (i = 0; i < this.polyDistResultsVector.size(); ++i) {
            PolymorphismDistributionResults pdr = (PolymorphismDistributionResults)this.polyDistResultsVector.get(i);
            data[0][i + 1] = "" + pdr.polyDist.length;
            for (int j = 0; j < pdr.polyDist.length; ++j) {
                data[j + 1][i + 1] = "" + pdr.polyDist[j];
            }
        }
        return data;
    }

    @Override
    public Object[] getRow(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTableTitle() {
        return "Polymorphism Distribution";
    }

    public String toString() {
        if (this.polyDistResultsVector.size() == 0) {
            return "Needs to be run";
        }
        StringBuffer cs = new StringBuffer();
        Object[] header = this.getTableColumnNames();
        for (int i = 0; i < header.length; ++i) {
            cs.append(header[i]);
        }
        cs.append("\n");
        Object[][] data = this.getTableData();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                cs.append(data[i][j]);
            }
            cs.append("\n");
        }
        return cs.toString();
    }

    @Override
    public int getRowCount() {
        return this.maxSeqCount + 1;
    }

    @Override
    public int getElementCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getColumnCount() {
        throw new UnsupportedOperationException();
    }
}

