/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.maizegenetics.analysis.modelfitter.StepwiseOLSModelFitter;
import net.maizegenetics.analysis.modelfitter.StepwiseOLSModelFitterPlugin;

public class StepwiseOLSModelFitterDialog
extends JDialog
implements ActionListener {
    JCheckBox chkNested = null;
    JList<String> listMainEffects = null;
    JButton btnLimits = new JButton("Enter limits by trait");
    JButton btnOk = new JButton("OK");
    JButton btnCancel = new JButton("Cancel");
    JLabel lblWhich = new JLabel("Which factor?");
    JTextField txtEnter;
    JTextField txtExit;
    JTextField txtMax;
    JTextField txtPerm;
    JTextField txtAlpha;
    String enterlim = "1e-5";
    String exitlim = "2e-5";
    String[] mainEffects = null;
    int indexOfSelectedEffect = 0;
    boolean wasCancelled = true;
    int numberOfMainEffects = 0;
    ButtonGroup modelSelectionButtonGroup = new ButtonGroup();
    JRadioButton PvalueRadioButton = new JRadioButton("Use P-value thresholds");
    JRadioButton mBICRadioButton = new JRadioButton("mBIC model selection");
    JRadioButton BICRadioButton = new JRadioButton("BIC model selection");
    JRadioButton AICRadioButton = new JRadioButton("AIC model selection");

    public StepwiseOLSModelFitterDialog(String[] mainEffects, Frame parentFrame) {
        this.mainEffects = mainEffects;
        if (mainEffects != null) {
            this.numberOfMainEffects = mainEffects.length;
        }
        this.setTitle("Specify Model Parameters");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(1);
        this.setUndecorated(false);
        this.getRootPane().setWindowDecorationStyle(0);
        Container contentPane = this.getContentPane();
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new BoxLayout(myPanel, 1));
        myPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.add(myPanel);
        this.modelSelectionButtonGroup.add(this.PvalueRadioButton);
        this.modelSelectionButtonGroup.add(this.mBICRadioButton);
        this.modelSelectionButtonGroup.add(this.BICRadioButton);
        this.modelSelectionButtonGroup.add(this.AICRadioButton);
        this.PvalueRadioButton.setSelected(true);
        if (this.numberOfMainEffects > 1) {
            this.chkNested = new JCheckBox("Nest markers within a factor", null, false);
            myPanel.add(this.chkNested);
            this.chkNested.setAlignmentX(0.5f);
            this.chkNested.addActionListener(this);
            this.chkNested.setActionCommand("nest");
            this.lblWhich.setAlignmentX(0.5f);
            this.lblWhich.setEnabled(false);
            myPanel.add(Box.createVerticalStrut(30));
            myPanel.add(this.lblWhich);
            this.listMainEffects = new JList<String>(mainEffects);
            this.listMainEffects.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            myPanel.add(Box.createVerticalStrut(10));
            myPanel.add(this.listMainEffects);
            this.listMainEffects.setAlignmentX(0.5f);
            this.listMainEffects.setEnabled(false);
        } else if (this.numberOfMainEffects == 1) {
            this.chkNested = new JCheckBox("Nest markers within " + mainEffects[0], null, false);
            myPanel.add(this.chkNested);
            this.chkNested.setAlignmentX(0.5f);
            this.chkNested.addActionListener(this);
            this.chkNested.setActionCommand("nest");
        }
        if (this.numberOfMainEffects > 0) {
            myPanel.add(Box.createVerticalStrut(20));
            JLabel sep1 = new JLabel("-----------------------");
            sep1.setAlignmentX(0.5f);
            myPanel.add(sep1);
        }
        myPanel.add(Box.createVerticalStrut(20));
        Box enterBox = Box.createHorizontalBox();
        enterBox.add(new JLabel("enter limit"));
        this.txtEnter = new JTextField(this.enterlim, 15);
        enterBox.add(this.txtEnter);
        myPanel.add(enterBox);
        myPanel.add(Box.createVerticalStrut(10));
        Box exitBox = Box.createHorizontalBox();
        exitBox.add(new JLabel("exit limit"));
        this.txtExit = new JTextField(this.exitlim, 15);
        exitBox.add(this.txtExit);
        myPanel.add(exitBox);
        myPanel.add(Box.createVerticalStrut(10));
        myPanel.add(this.btnLimits);
        this.btnLimits.setActionCommand("limits");
        this.btnLimits.setAlignmentX(0.5f);
        myPanel.add(Box.createVerticalStrut(20));
        JLabel sep2 = new JLabel("-----------------------");
        myPanel.add(sep2);
        sep2.setAlignmentX(0.5f);
        myPanel.add(Box.createVerticalStrut(20));
        Box maxBox = Box.createHorizontalBox();
        maxBox.add(new JLabel("Maximum number of markers"));
        this.txtMax = new JTextField("30", 6);
        maxBox.add(this.txtMax);
        myPanel.add(maxBox);
        myPanel.add(Box.createVerticalStrut(20));
        JLabel sep3 = new JLabel("-----------------------");
        myPanel.add(sep3);
        sep3.setAlignmentX(0.5f);
        myPanel.add(Box.createVerticalStrut(20));
        Box permBox = Box.createHorizontalBox();
        permBox.add(new JLabel("Number of Permutations (only for P-value model selection)"));
        this.txtPerm = new JTextField("0", 6);
        permBox.add(this.txtPerm);
        myPanel.add(permBox);
        myPanel.add(Box.createVerticalStrut(20));
        myPanel.add(Box.createVerticalStrut(20));
        JLabel sep4 = new JLabel("------");
        myPanel.add(sep4);
        sep4.setAlignmentX(0.5f);
        myPanel.add(Box.createVerticalStrut(20));
        Box alphaBox = Box.createHorizontalBox();
        alphaBox.add(new JLabel("Type I Error Rate for Permutations"));
        this.txtAlpha = new JTextField("0.05", 6);
        alphaBox.add(this.txtAlpha);
        myPanel.add(alphaBox);
        myPanel.add(Box.createVerticalStrut(20));
        myPanel.add(Box.createVerticalStrut(20));
        JLabel sep5 = new JLabel("-----------------------");
        myPanel.add(sep5);
        sep5.setAlignmentX(0.5f);
        myPanel.add(this.PvalueRadioButton);
        myPanel.add(this.mBICRadioButton);
        myPanel.add(this.BICRadioButton);
        myPanel.add(this.AICRadioButton);
        this.PvalueRadioButton.setAlignmentX(0.5f);
        this.mBICRadioButton.setAlignmentX(0.5f);
        this.BICRadioButton.setAlignmentX(0.5f);
        this.AICRadioButton.setAlignmentX(0.5f);
        myPanel.add(Box.createVerticalStrut(20));
        JLabel sep6 = new JLabel("-----------------------");
        myPanel.add(sep6);
        sep6.setAlignmentX(0.5f);
        myPanel.add(Box.createVerticalStrut(20));
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(this.btnOk);
        this.btnOk.setAlignmentX(0.5f);
        this.btnOk.addActionListener(this);
        this.btnOk.setActionCommand("ok");
        buttonBox.add(this.btnCancel);
        this.btnCancel.setAlignmentX(0.5f);
        this.btnCancel.addActionListener(this);
        this.btnCancel.setActionCommand("cancel");
        myPanel.add(buttonBox);
        buttonBox.setAlignmentX(0.5f);
        myPanel.add(Box.createVerticalStrut(20));
        JLabel sep7 = new JLabel("------Developed by Peter Bradbury and Alex Lipka, 2013-----------------");
        myPanel.add(sep7);
        sep7.setAlignmentX(0.5f);
        JLabel note1 = new JLabel("Note: Because the Stepwise method does not allow missing marker data,");
        JLabel note2 = new JLabel("the marker value N will be treated as a marker class, not missing data.");
        note1.setAlignmentX(0.5f);
        note2.setAlignmentX(0.5f);
        myPanel.add(note1);
        myPanel.add(note2);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Action Command: " + e.getActionCommand());
        if (e.getActionCommand().equals("nest") && this.numberOfMainEffects > 1) {
            if (this.chkNested.isSelected()) {
                this.listMainEffects.setEnabled(true);
                this.lblWhich.setEnabled(true);
            } else {
                this.listMainEffects.setEnabled(false);
                this.lblWhich.setEnabled(false);
            }
        } else if (e.getActionCommand().equals("ok")) {
            this.wasCancelled = false;
            this.setVisible(false);
        } else if (e.getActionCommand().equals("cancel")) {
            this.wasCancelled = true;
            this.setVisible(false);
        }
    }

    public boolean isNested() {
        if (this.chkNested == null) {
            return false;
        }
        return this.chkNested.isSelected();
    }

    public String getNestedEffect() {
        if (this.mainEffects == null || this.mainEffects.length == 0) {
            return null;
        }
        if (this.mainEffects.length == 1) {
            return this.mainEffects[0];
        }
        return this.listMainEffects.getSelectedValue();
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public double[] getEnterLimits() {
        return StepwiseOLSModelFitterPlugin.parseDoubles(this.txtEnter.getText(), ",");
    }

    public double[] getExitLimits() {
        return StepwiseOLSModelFitterPlugin.parseDoubles(this.txtExit.getText(), ",");
    }

    public int getNumberOfPermutations() {
        return Integer.parseInt(this.txtPerm.getText());
    }

    public double getAlpha() {
        return Double.parseDouble(this.txtAlpha.getText());
    }

    public int getMaxNumberOfMarkers() {
        return Integer.parseInt(this.txtMax.getText());
    }

    public StepwiseOLSModelFitter.MODEL_TYPE getModelType() {
        if (this.PvalueRadioButton.isSelected()) {
            return StepwiseOLSModelFitter.MODEL_TYPE.pvalue;
        }
        if (this.mBICRadioButton.isSelected()) {
            return StepwiseOLSModelFitter.MODEL_TYPE.mbic;
        }
        if (this.BICRadioButton.isSelected()) {
            return StepwiseOLSModelFitter.MODEL_TYPE.bic;
        }
        if (this.AICRadioButton.isSelected()) {
            return StepwiseOLSModelFitter.MODEL_TYPE.aic;
        }
        return StepwiseOLSModelFitter.MODEL_TYPE.pvalue;
    }
}

