/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import net.maizegenetics.analysis.gbs.SmithWaterman;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.Tags;

public class TagMatchFinder {
    Tags refTags;
    private static int[][] lookups;
    public static final int wordLength = 16;
    public static final int maxDivergence = 15;
    private SmithWaterman pa;
    Swapper swapper = new Swapper(){

        public void swap(int a, int b) {
            int t1 = lookups[0][a];
            lookups[0][a] = lookups[0][b];
            lookups[0][b] = t1;
            int t2 = lookups[1][a];
            lookups[1][a] = lookups[1][b];
            lookups[1][b] = t2;
        }
    };
    IntComparator comp = new IntComparator(){

        public int compare(int a, int b) {
            if (lookups[0][a] == lookups[0][b]) {
                return lookups[1][a] == lookups[1][b] ? 0 : (lookups[1][a] < lookups[1][b] ? -1 : 1);
            }
            return lookups[0][a] < lookups[0][b] ? -1 : 1;
        }
    };

    public int[][] getTagLookTable() {
        return lookups;
    }

    public TagMatchFinder(Tags theTags) {
        this.refTags = theTags;
        this.init();
        this.pa = new SmithWaterman(64, 32);
        long[] query = this.refTags.getTag(10);
        TreeMap<Integer, Integer> al = this.findMatchesWithIntLengthWords(query, 10, false);
        System.out.println(al.toString());
    }

    public static void main(String[] args) {
    }

    private void init() {
        lookups = new int[2][2 * this.refTags.getTagCount() * this.refTags.getTagSizeInLong()];
        int count = 0;
        System.out.println("Beginning to create index");
        for (int i = 0; i < this.refTags.getTagCount(); ++i) {
            long[] cTag = this.refTags.getTag(i);
            for (int j = 0; j < this.refTags.getTagSizeInLong(); ++j) {
                int[] word = BaseEncoder.getIntFromLong(cTag[j]);
                TagMatchFinder.lookups[0][count] = word[0];
                TagMatchFinder.lookups[1][count] = i;
                TagMatchFinder.lookups[0][++count] = word[1];
                TagMatchFinder.lookups[1][count] = i;
                ++count;
            }
        }
        System.out.println("Sorting index");
        GenericSorting.quickSort((int)0, (int)lookups[0].length, (IntComparator)this.comp, (Swapper)this.swapper);
        System.out.println("Beginning to reduce duplicates");
        this.reduceDuplicates();
        System.out.println("Duplicates removed");
        this.pa = new SmithWaterman(32, 32);
    }

    private void reduceDuplicates() {
        int start = 0;
        int end = -1;
        int currHap = lookups[0][0];
        int duplicated = 0;
        System.out.println(BaseEncoder.getSequenceFromInt(currHap) + " " + currHap);
        for (int i = 0; i < lookups[0].length; ++i) {
            if (lookups[0][i] == currHap) {
                end = i;
                continue;
            }
            if (end - start > 1000) {
                for (int j = start; j <= end; ++j) {
                    TagMatchFinder.lookups[0][j] = Integer.MAX_VALUE;
                    ++duplicated;
                }
            }
            currHap = lookups[0][i];
            start = end = i;
        }
        GenericSorting.quickSort((int)0, (int)lookups[0].length, (IntComparator)this.comp, (Swapper)this.swapper);
        int[][] newlookups = new int[2][lookups[0].length - duplicated];
        System.arraycopy(lookups[0], 0, newlookups[0], 0, lookups[0].length - duplicated);
        System.arraycopy(lookups[1], 0, newlookups[1], 0, lookups[1].length - duplicated);
        System.out.println("Old Lookup Size:" + lookups[0].length + "  new size:" + newlookups[0].length);
        lookups = newlookups;
    }

    public TreeMap<Integer, Integer> findMatchesWithIntLengthWords(long[] query, int maxDiv, boolean keepOnlyBest) {
        TreeMap<Integer, Integer> hitsAndDiv = new TreeMap<Integer, Integer>();
        int bestDiv = maxDiv;
        for (int i = 0; i < query.length; ++i) {
            int[] words;
            for (int word : words = BaseEncoder.getIntFromLong(query[i])) {
                int hit = Arrays.binarySearch(lookups[0], word);
                if (hit < 0) continue;
                while (hit > 0 && word == lookups[0][hit - 1]) {
                    --hit;
                }
                while (hit < lookups[0].length && lookups[0][hit] == word) {
                    int indexPossHapHit = lookups[1][hit];
                    if (!hitsAndDiv.containsKey(indexPossHapHit)) {
                        int div = BaseEncoder.seqDifferences(this.refTags.getTag(indexPossHapHit)[0], query[0], maxDiv) + BaseEncoder.seqDifferences(this.refTags.getTag(indexPossHapHit)[1], query[1], maxDiv);
                        if (div <= maxDiv) {
                            hitsAndDiv.put(indexPossHapHit, div);
                        }
                        if (div < bestDiv) {
                            bestDiv = div;
                        }
                    }
                    ++hit;
                }
            }
        }
        if (keepOnlyBest && hitsAndDiv.size() > 1) {
            TreeMap<Integer, Integer> bestHitsAndDiv = new TreeMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> e : hitsAndDiv.entrySet()) {
                if (e.getValue() != bestDiv) continue;
                bestHitsAndDiv.put(e.getKey(), e.getValue());
            }
            return bestHitsAndDiv;
        }
        return hitsAndDiv;
    }
}

