/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.list.IntArrayList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.analysis.gbs.TagMatchFinder;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TOPMUtils;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.depth.AlleleDepthUtil;
import net.maizegenetics.dna.snp.genotypecall.BasicGenotypeMergeRule;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class ProductionSNPCallerPlugin
extends AbstractPlugin {
    private final Logger myLogger = Logger.getLogger(ProductionSNPCallerPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String[] myRawSeqFileNames = null;
    private String myKeyFile = null;
    private String myEnzyme = null;
    private String myOutputDir = null;
    private String myTargetHDF5file = null;
    private TOPMInterface topm = null;
    private int maxDivergence = 0;
    private int[] chromosomes = null;
    private boolean fastq = true;
    private Map<String, Integer> keyFileColumns = new HashMap<String, Integer>();
    private Set<String> flowcellLanesInKey = new TreeSet<String>();
    private Map<String, String> seqFileNameToFlowcellLane = new HashMap<String, String>();
    private Set<String> seqFilesInKeyAndDir = new TreeSet<String>();
    private Map<String, String> fullNameToHDF5Name = new TreeMap<String, String>();
    private Multimap<String, String> flowCellLaneToLibPrepIDs = TreeMultimap.create();
    private Map<String, String> libraryPrepIDToSampleName = new TreeMap<String, String>();
    private GenotypeTableBuilder genos = null;
    private TaxaList taxaList = null;
    private PositionList myPositionList = null;
    private IntArrayList[] obsTagsForEachTaxon = null;
    private Table<Integer, Integer, Integer> positionToSite = null;
    private Map<String, Integer> rawReadCountsForFullSampleName = new TreeMap<String, Integer>();
    private Map<String, Integer> matchedReadCountsForFullSampleName = new TreeMap<String, Integer>();
    private boolean stacksL = false;
    private boolean keepOpen = false;
    private double errorRate = 0.01;
    private BasicGenotypeMergeRule genoMergeRule = null;
    private boolean noDepthOutput = false;
    private String rawSeqFileNameRegex = "(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$|.*_qseq\\.txt$|.*_qseq\\.txt\\.gz$";
    private String rawSeqFileNameReplaceRegex = "(?i)\\.fq$|\\.fq\\.gz$|\\.fastq$|_fastq\\.txt$|_fastq\\.gz$|_fastq\\.txt\\.gz$|_sequence\\.txt$|_sequence\\.txt\\.gz$|_qseq\\.txt$|_qseq\\.txt\\.gz$";
    private String noMatchingRawSeqFileNamesMessage = "Couldn't find any files that end with \".fq\", \".fq.gz\", \".fastq\", \"_fastq.txt\", \"_fastq.gz\", \"_fastq.txt.gz\", \"_sequence.txt\", \"_sequence.txt.gz\", \"_qseq.txt\", or \"_qseq.txt.gz\" in the supplied directory: ";

    public ProductionSNPCallerPlugin() {
        super(null, false);
    }

    public ProductionSNPCallerPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.myLogger.info((Object)("\n\n\nThe options for the TASSEL ProductionSNPCallerPlugin are as follows:\n  -i   Input directory containing fastq AND/OR qseq files\n  -k   Barcode key file\n  -e   Enzyme used to create the GBS library\n  -m   Physical map file containing tags and corresponding variants (production TOPM)\n  -o   Output (target) HDF5 genotypes file to add new genotypes to (new file created if it doesn't exist)\n  -eR  Average sequencing error rate per base (used to decide between heterozygous and homozygous calls) (default: " + this.errorRate + ")\n" + "  -ko  Keep hdf5 genotypes open for future runs that add more taxa or more depth\n (default: finalize hdf5 file)\n" + "\n\n"));
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-directory", true);
            this.myArgsEngine.add("-k", "--key-file", true);
            this.myArgsEngine.add("-e", "--enzyme", true);
            this.myArgsEngine.add("-m", "--physical-map", true);
            this.myArgsEngine.add("-o", "--target-HDF5", true);
            this.myArgsEngine.add("-eR", "--seqErrRate", true);
            this.myArgsEngine.add("-ko", "--keep-open", false);
            this.myArgsEngine.add("-sL", "--STACKS-likelihood", false);
            this.myArgsEngine.add("-d", "--divergence", true);
            this.myArgsEngine.add("-ndo", "--no-depth-output", false);
        }
        this.myArgsEngine.parse(args);
        String tempDirectory = this.myArgsEngine.getString("-i");
        if (tempDirectory != null) {
            File rawSeqDirectory = new File(tempDirectory);
            if (!rawSeqDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("setParameters: The input name you supplied is not a directory: " + tempDirectory);
            }
            this.myRawSeqFileNames = DirectoryCrawler.listFileNames(this.rawSeqFileNameRegex, rawSeqDirectory.getAbsolutePath());
            if (this.myRawSeqFileNames.length == 0 || this.myRawSeqFileNames == null) {
                this.printUsage();
                throw new IllegalArgumentException(this.noMatchingRawSeqFileNamesMessage + tempDirectory);
            }
            Arrays.sort(this.myRawSeqFileNames);
            this.myLogger.info((Object)"ProductionSNPCallerPlugin:\n\nThe following GBS raw sequence data files were found in the input folder (and sub-folders):");
            for (String filename : this.myRawSeqFileNames) {
                System.out.println("   " + filename);
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an input directory containing fastq (or qseq) files (option -i).");
        }
        System.out.println("\n");
        if (!this.myArgsEngine.getBoolean("-k")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a key file (option -k).");
        }
        this.myKeyFile = this.myArgsEngine.getString("-k");
        if (!this.myArgsEngine.getBoolean("-e")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the enzyme used to create the GBS library.");
        }
        this.myEnzyme = this.myArgsEngine.getString("-e");
        if (this.myArgsEngine.getBoolean("-m")) {
            this.topm = TOPMUtils.readTOPM(this.myArgsEngine.getString("-m"));
            if (this.topm.getSize() == 0) {
                throw new IllegalStateException("TagsOnPhysicalMap file not available or is empty");
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a TagsOnPhysicalMap file (-m)");
        }
        if (this.myArgsEngine.getBoolean("-eR")) {
            this.errorRate = Double.parseDouble(this.myArgsEngine.getString("-eR"));
        }
        if (this.myArgsEngine.getBoolean("-o")) {
            this.myTargetHDF5file = this.myArgsEngine.getString("-o");
            this.myOutputDir = this.myTargetHDF5file.substring(0, this.myTargetHDF5file.lastIndexOf(File.separator));
            File outDir = new File(this.myOutputDir);
            if (!outDir.isDirectory()) {
                throw new IllegalArgumentException("The directory containing (or to contain) the target HDF5 genotypes file (option -t) does not exist");
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a target HDF5 genotypes file (option -t)");
        }
        if (this.myArgsEngine.getBoolean("-sL")) {
            this.stacksL = true;
        }
        if (this.myArgsEngine.getBoolean("-ko")) {
            this.keepOpen = true;
        }
        if (this.myArgsEngine.getBoolean("-ndo")) {
            this.noDepthOutput = true;
        }
        if (this.myArgsEngine.getBoolean("-d")) {
            this.maxDivergence = Integer.parseInt(this.myArgsEngine.getString("-d"));
        }
    }

    @Override
    public DataSet performFunction(DataSet input) {
        long previous = System.nanoTime();
        this.readKeyFile();
        long current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: performFunction: readKeyFile: " + (double)(current - previous) / 1.0E9 + " sec");
        previous = System.nanoTime();
        this.matchKeyFileToAvailableRawSeqFiles();
        current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: performFunction: matchKeyFileToAvailableRawSeqFiles: " + (double)(current - previous) / 1.0E9 + " sec");
        previous = System.nanoTime();
        this.myPositionList = this.getUniquePositions();
        current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: performFunction: getUniquePositions: " + (double)(current - previous) / 1.0E9 + " sec");
        previous = System.nanoTime();
        this.generateFastSiteLookup(this.myPositionList);
        current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: performFunction: generateFastSiteLookup: " + (double)(current - previous) / 1.0E9 + " sec");
        previous = System.nanoTime();
        this.setUpGenotypeTableBuilder();
        current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: performFunction: setUpGenotypeTableBuilder: " + (double)(current - previous) / 1.0E9 + " sec");
        int nFilesProcessed = 0;
        for (int fileNum = 0; fileNum < this.myRawSeqFileNames.length; ++fileNum) {
            if (!this.seqFilesInKeyAndDir.contains(this.myRawSeqFileNames[fileNum])) continue;
            int[] counters = new int[]{0, 0, 0, 0, 0, 0};
            System.out.println("\nLooking for known SNPs in sequence reads from file:");
            System.out.println("  " + this.myRawSeqFileNames[fileNum] + "\n");
            previous = System.nanoTime();
            this.readRawSequencesAndRecordDepth(fileNum, counters);
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: readRawSequencesAndRecordDepth: " + this.myRawSeqFileNames[fileNum] + ": " + (double)(current - previous) / 1.0E9 + " sec");
            previous = System.nanoTime();
            this.callGenotypes();
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: callGenotypes: " + this.myRawSeqFileNames[fileNum] + ": " + (double)(current - previous) / 1.0E9 + " sec");
            previous = System.nanoTime();
            this.reportTotals(fileNum, counters, ++nFilesProcessed);
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: reportTotals: " + this.myRawSeqFileNames[fileNum] + ": " + (double)(current - previous) / 1.0E9 + " sec");
        }
        if (this.keepOpen) {
            previous = System.nanoTime();
            this.genos.closeUnfinished();
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: genos.closeUnfinished(): " + (double)(current - previous) / 1.0E9 + " sec");
        } else {
            previous = System.nanoTime();
            this.genos.build();
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: genos.build(): " + (double)(current - previous) / 1.0E9 + " sec");
        }
        previous = System.nanoTime();
        this.writeReadsPerSampleReports();
        current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: performFunction: writeReadsPerSampleReports: " + (double)(current - previous) / 1.0E9 + " sec");
        return null;
    }

    private void readRawSequencesAndRecordDepth(int fileNum, int[] counters) {
        long previous = System.nanoTime();
        ParseBarcodeRead thePBR = this.setUpBarcodes(fileNum);
        long current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: readRawSequencesAndRecordDepth: setUpBarcodes: " + (double)(current - previous) / 1.0E9 + " sec");
        previous = System.nanoTime();
        if (thePBR == null || thePBR.getBarCodeCount() == 0) {
            System.out.println("No barcodes found. Skipping this raw sequence file.");
            return;
        }
        current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: readRawSequencesAndRecordDepth: getBarCodeCount: " + (double)(current - previous) / 1.0E9 + " sec");
        previous = System.nanoTime();
        this.taxaList = new TaxaListBuilder().addAll(this.getHDF5Taxa(fileNum)).sortTaxaAlphabetically().build();
        current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: readRawSequencesAndRecordDepth: new TaxaListBuilder(): " + (double)(current - previous) / 1.0E9 + " sec");
        previous = System.nanoTime();
        this.obsTagsForEachTaxon = new IntArrayList[this.taxaList.numberOfTaxa()];
        for (int t = 0; t < this.obsTagsForEachTaxon.length; ++t) {
            this.obsTagsForEachTaxon[t] = new IntArrayList(750000);
        }
        current = System.nanoTime();
        System.out.println("ProductionSNPCallerPlugin: readRawSequencesAndRecordDepth: IntArrayList: " + (double)(current - previous) / 1.0E9 + " sec");
        String temp = "Nothing has been read from the raw sequence file yet";
        BufferedReader br = this.getBufferedReaderForRawSeqFile(fileNum);
        try {
            long readSeqReadTime = 0L;
            long ifRRNotNullTime = 0L;
            while ((temp = br.readLine()) != null) {
                if (counters[0] % 1000000 == 0) {
                    this.reportProgress(counters, readSeqReadTime, ifRRNotNullTime);
                }
                previous = System.nanoTime();
                ReadBarcodeResult rr = this.readSequenceRead(br, temp, thePBR, counters);
                current = System.nanoTime();
                readSeqReadTime += current - previous;
                previous = System.nanoTime();
                if (rr != null) {
                    counters[1] = counters[1] + 1;
                    this.rawReadCountsForFullSampleName.put(rr.getTaxonName(), this.rawReadCountsForFullSampleName.get(rr.getTaxonName()) + 1);
                    int tagIndex = this.topm.getTagIndex(rr.getRead());
                    if (tagIndex >= 0) {
                        counters[3] = counters[3] + 1;
                    }
                    if (tagIndex < 0 && this.maxDivergence > 0) {
                        tagIndex = this.findBestImperfectMatch(rr.getRead(), counters);
                    }
                    if (tagIndex < 0) continue;
                    counters[2] = counters[2] + 1;
                    this.matchedReadCountsForFullSampleName.put(rr.getTaxonName(), this.matchedReadCountsForFullSampleName.get(rr.getTaxonName()) + 1);
                    int taxonIndex = this.taxaList.indexOf(this.fullNameToHDF5Name.get(rr.getTaxonName()));
                    this.obsTagsForEachTaxon[taxonIndex].add(tagIndex);
                }
                current = System.nanoTime();
                ifRRNotNullTime += current - previous;
            }
            System.out.println("ProductionSNPCallerPlugin: readRawSequencesAndRecordDepth: readSequenceTime: " + (double)readSeqReadTime / 1.0E9 + " sec");
            System.out.println("ProductionSNPCallerPlugin: readRawSequencesAndRecordDepth: processSequenceTime: " + (double)ifRRNotNullTime / 1.0E9 + " sec");
            br.close();
        }
        catch (Exception e) {
            System.out.println("Catch in readRawSequencesAndRecordDepth() at nReads=" + counters[0] + " e=" + e);
            System.out.println("Last line read: " + temp);
            e.printStackTrace();
        }
    }

    private void reportProgress(int[] counters, long readSeqReadTime, long ifRRNotNullTime) {
        System.out.println("totalReads:" + counters[0] + "  goodBarcodedReads:" + counters[1] + "  goodMatchedToTOPM:" + counters[2] + "  cumulReadSequenceTime: " + (double)readSeqReadTime / 1.0E9 + " sec" + "  cumulProcessSequenceTime: " + (double)ifRRNotNullTime / 1.0E9 + " sec");
    }

    private void reportTotals(int fileNum, int[] counters, int nFilesProcessed) {
        System.out.println("Total number of reads in lane=" + counters[0]);
        System.out.println("Total number of good, barcoded reads=" + counters[1]);
        System.out.println("Total number of good, barcoded reads matched to the TOPM=" + counters[2]);
        System.out.println("Finished reading " + nFilesProcessed + " of " + this.seqFilesInKeyAndDir.size() + " sequence files: " + this.myRawSeqFileNames[fileNum] + "\n");
    }

    private void readKeyFile() {
        this.flowcellLanesInKey.clear();
        this.seqFileNameToFlowcellLane.clear();
        this.seqFilesInKeyAndDir.clear();
        this.fullNameToHDF5Name.clear();
        this.flowCellLaneToLibPrepIDs.clear();
        this.libraryPrepIDToSampleName.clear();
        String inputLine = "Nothing has been read from the keyfile yet";
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.myKeyFile), 65536);
            int currLine = 0;
            while ((inputLine = br.readLine()) != null) {
                if (currLine == 0) {
                    this.parseKeyFileHeader(inputLine);
                } else {
                    this.populateKeyFileFields(inputLine);
                }
                ++currLine;
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't read key file: " + e);
            System.out.println("Last line read from key file: " + inputLine);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void parseKeyFileHeader(String headerLine) {
        headerLine.trim();
        String[] header = headerLine.split("\\t");
        this.keyFileColumns.clear();
        for (int col = 0; col < header.length; ++col) {
            if (header[col].equalsIgnoreCase("Flowcell")) {
                this.keyFileColumns.put("Flowcell", col);
                continue;
            }
            if (header[col].equalsIgnoreCase("Lane")) {
                this.keyFileColumns.put("Lane", col);
                continue;
            }
            if (header[col].equalsIgnoreCase("Barcode")) {
                this.keyFileColumns.put("Barcode", col);
                continue;
            }
            if (header[col].equalsIgnoreCase("DNASample") || header[col].equalsIgnoreCase("Sample")) {
                this.keyFileColumns.put("Sample", col);
                continue;
            }
            if (!header[col].equalsIgnoreCase("LibraryPrepID")) continue;
            this.keyFileColumns.put("LibPrepID", col);
        }
        if (!this.confirmKeyFileHeader()) {
            this.throwBadKeyFileError();
        }
    }

    private boolean confirmKeyFileHeader() {
        if (!this.keyFileColumns.containsKey("Flowcell")) {
            return false;
        }
        if (!this.keyFileColumns.containsKey("Lane")) {
            return false;
        }
        if (!this.keyFileColumns.containsKey("Barcode")) {
            return false;
        }
        if (!this.keyFileColumns.containsKey("Sample")) {
            return false;
        }
        if (!this.keyFileColumns.containsKey("LibPrepID")) {
            return false;
        }
        if (!this.keyFileColumns.get("Flowcell").equals(0)) {
            return false;
        }
        if (!this.keyFileColumns.get("Lane").equals(1)) {
            return false;
        }
        if (!this.keyFileColumns.get("Barcode").equals(2)) {
            return false;
        }
        if (!this.keyFileColumns.get("Sample").equals(3)) {
            return false;
        }
        return this.keyFileColumns.get("LibPrepID").equals(7);
    }

    private void throwBadKeyFileError() {
        String badKeyFileMessage = "\n\nThe keyfile does not conform to expections.\nIt must contain columns with the following (exact) headers, and\nin the indicated columns:\n   \"Flowcell\"                 (column A)\n   \"Lane\"                     (column B)\n   \"Barcode\"                  (column C)\n   \"DNASample\" or \"Sample\"    (column D)\n   \"LibraryPrepID\"            (column H)\n\n\n";
        try {
            throw new IllegalStateException(badKeyFileMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void populateKeyFileFields(String keyFileLine) {
        keyFileLine.trim();
        String[] cells = keyFileLine.split("\\t");
        String sample = cells[this.keyFileColumns.get("Sample")];
        String libPrepID = cells[this.keyFileColumns.get("LibPrepID")];
        String fullName = sample + ":" + cells[this.keyFileColumns.get("Flowcell")] + ":" + cells[this.keyFileColumns.get("Lane")] + ":" + libPrepID;
        this.rawReadCountsForFullSampleName.put(fullName, 0);
        this.matchedReadCountsForFullSampleName.put(fullName, 0);
        this.fullNameToHDF5Name.put(fullName, sample + ":" + libPrepID);
        String flowCell_Lane = cells[this.keyFileColumns.get("Flowcell")] + "_" + cells[this.keyFileColumns.get("Lane")];
        this.flowcellLanesInKey.add(flowCell_Lane);
        this.flowCellLaneToLibPrepIDs.put((Object)flowCell_Lane, (Object)libPrepID);
        String prevSample = this.libraryPrepIDToSampleName.get(libPrepID);
        if (prevSample == null) {
            this.libraryPrepIDToSampleName.put(libPrepID, sample);
        } else if (!prevSample.contentEquals(sample)) {
            try {
                throw new IllegalStateException("\nThe key file contains different Sample names (\"" + prevSample + "\" and \"" + sample + "\") for the sample LibraryPrepID (" + libPrepID + ")\n\n");
            }
            catch (Exception e) {
                System.out.println("Error in key file: " + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void matchKeyFileToAvailableRawSeqFiles() {
        System.out.println("\nThe following raw sequence files in the input directory conform to one of our file naming conventions and have corresponding samples in the barcode key file:");
        for (int fileNum = 0; fileNum < this.myRawSeqFileNames.length; ++fileNum) {
            String[] flowcellLane = this.parseRawSeqFileName(this.myRawSeqFileNames[fileNum]);
            if (flowcellLane == null || !this.flowcellLanesInKey.contains(flowcellLane[0] + "_" + flowcellLane[1])) continue;
            this.seqFileNameToFlowcellLane.put(this.myRawSeqFileNames[fileNum], flowcellLane[0] + "_" + flowcellLane[1]);
            this.seqFilesInKeyAndDir.add(this.myRawSeqFileNames[fileNum]);
            System.out.println("  " + this.myRawSeqFileNames[fileNum]);
        }
        System.out.println("\n");
    }

    private ParseBarcodeRead setUpBarcodes(int fileNum) {
        System.gc();
        System.out.println("\nWorking on GBS raw sequence file: " + this.myRawSeqFileNames[fileNum]);
        this.fastq = true;
        if (this.myRawSeqFileNames[fileNum].substring(this.myRawSeqFileNames[fileNum].lastIndexOf(File.separator)).contains("qseq")) {
            this.fastq = false;
        }
        if (this.fastq) {
            System.out.println("\tThis file is assumed to be in fastq format");
        } else {
            System.out.println("\tThis file contains 'qseq' in its name so is assumed to be in qseq format");
        }
        String[] flowcellLane = this.parseRawSeqFileName(this.myRawSeqFileNames[fileNum]);
        if (flowcellLane == null) {
            return null;
        }
        ParseBarcodeRead thePBR = new ParseBarcodeRead(this.myKeyFile, this.myEnzyme, flowcellLane[0], flowcellLane[1]);
        System.out.println("Total barcodes found in key file for this lane:" + thePBR.getBarCodeCount());
        return thePBR;
    }

    private String[] parseRawSeqFileName(String rawSeqFileName) {
        File rawSeqFile = new File(rawSeqFileName);
        String[] FileNameParts = rawSeqFile.getName().split("_");
        if (FileNameParts.length == 3) {
            return new String[]{FileNameParts[0], FileNameParts[1]};
        }
        if (FileNameParts.length == 4) {
            return new String[]{FileNameParts[0], FileNameParts[2]};
        }
        if (FileNameParts.length == 5) {
            return new String[]{FileNameParts[1], FileNameParts[3]};
        }
        this.printFileNameConventions(rawSeqFileName);
        return null;
    }

    private void setUpGenotypeTableBuilder() {
        this.genoMergeRule = new BasicGenotypeMergeRule(this.errorRate);
        File hdf5File = new File(this.myTargetHDF5file);
        if (hdf5File.exists()) {
            System.out.println("Genotypes will be added to existing HDF5 file:\n  " + this.myTargetHDF5file + "\n");
            this.genos = GenotypeTableBuilder.mergeTaxaIncremental(this.myTargetHDF5file, this.genoMergeRule);
        } else {
            System.out.println("\nThe target HDF5 file:\n  " + this.myTargetHDF5file);
            System.out.println("does not exist. A new HDF5 file of that name will be created \nto hold the genotypes from this run.");
            this.genos = GenotypeTableBuilder.getTaxaIncrementalWithMerging(this.myTargetHDF5file, this.myPositionList, this.genoMergeRule);
        }
    }

    private ArrayList<Taxon> getHDF5Taxa(int fileNum) {
        ArrayList<Taxon> taxaAL = new ArrayList<Taxon>();
        String currFlowcellLane = this.seqFileNameToFlowcellLane.get(this.myRawSeqFileNames[fileNum]);
        for (String libPrepID : this.flowCellLaneToLibPrepIDs.get((Object)currFlowcellLane)) {
            String hdf5Name = this.libraryPrepIDToSampleName.get(libPrepID) + ":" + libPrepID;
            Taxon gbsTaxon = new Taxon.Builder(hdf5Name).addAnno("Flowcell_Lane", currFlowcellLane).build();
            taxaAL.add(gbsTaxon);
        }
        return taxaAL;
    }

    private PositionList getUniquePositions() {
        this.myLogger.info((Object)"\nCounting sites in TOPM file");
        PositionListBuilder plb = new PositionListBuilder();
        int[] arr$ = this.chromosomes = this.topm.getChromosomes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer chrNum = arr$[i$];
            Chromosome chr = new Chromosome(chrNum.toString());
            for (int pos : this.topm.getUniquePositions(this.topm.getChromosomeIndex(chrNum))) {
                GeneralPosition p = new GeneralPosition.Builder(chr, pos).build();
                plb.add(p);
            }
        }
        PositionList pl = plb.sortPositions().build();
        System.out.println("In total, the TOPM contains " + this.chromosomes.length + " chromosomes and " + pl.numberOfSites() + " sites.");
        return pl;
    }

    private void generateFastSiteLookup(PositionList pl) {
        ImmutableTable.Builder ptsB = new ImmutableTable.Builder();
        for (int i = 0; i < pl.numberOfSites(); ++i) {
            Position position = (Position)pl.get(i);
            ptsB.put((Object)position.getChromosome().getChromosomeNumber(), (Object)position.getPosition(), (Object)i);
        }
        this.positionToSite = ptsB.build();
    }

    private BufferedReader getBufferedReaderForRawSeqFile(int fileNum) {
        BufferedReader br = null;
        try {
            br = this.myRawSeqFileNames[fileNum].endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(this.myRawSeqFileNames[fileNum])))) : new BufferedReader(new FileReader(this.myRawSeqFileNames[fileNum]), 65536);
        }
        catch (Exception e) {
            System.out.println("Catch in getBufferedReader(): e=" + e);
            e.printStackTrace();
        }
        return br;
    }

    private ReadBarcodeResult readSequenceRead(BufferedReader br, String temp, ParseBarcodeRead thePBR, int[] counters) {
        ReadBarcodeResult rr = null;
        String sl = "";
        try {
            if (this.fastq) {
                sl = br.readLine();
                temp = br.readLine();
                temp = br.readLine();
                rr = thePBR.parseReadIntoTagAndTaxa(sl, null, true, 0);
            } else {
                String[] jj = temp.split("\\s");
                sl = jj[8];
                rr = thePBR.parseReadIntoTagAndTaxa(sl, null, false, 0);
            }
        }
        catch (Exception e) {
            System.out.println("Catch in readSequenceRead() at nReads=" + counters[0] + " e=" + e);
            System.out.println(temp);
            e.printStackTrace();
        }
        counters[0] = counters[0] + 1;
        return rr;
    }

    private int findBestImperfectMatch(long[] read, int[] counters) {
        int tagIndex = -1;
        TagMatchFinder tmf = new TagMatchFinder(this.topm);
        TreeMap<Integer, Integer> bestHitsAndDiv = tmf.findMatchesWithIntLengthWords(read, this.maxDivergence, true);
        if (bestHitsAndDiv.size() > 0) {
            counters[4] = counters[4] + 1;
            if (bestHitsAndDiv.size() == 1) {
                counters[5] = counters[5] + 1;
            }
            tagIndex = bestHitsAndDiv.firstKey();
        }
        return tagIndex;
    }

    private void incrementDepthForTagVariants(int tagIndex, int[][] alleleDepths, int increment) {
        int chromosome = this.topm.getChromosome(tagIndex);
        if (chromosome == Integer.MIN_VALUE) {
            return;
        }
        int startPos = this.topm.getStartPosition(tagIndex);
        for (int variant = 0; variant < this.topm.getMaxNumVariants(); ++variant) {
            byte newBase = this.topm.getVariantDef(tagIndex, variant);
            if (newBase == -128 || newBase == 15) continue;
            byte offset = this.topm.getVariantPosOff(tagIndex, variant);
            int pos = startPos + offset;
            int currSite = (Integer)this.positionToSite.get((Object)chromosome, (Object)pos);
            if (currSite < 0) continue;
            int[] nArray = alleleDepths[newBase];
            int n = currSite;
            nArray[n] = nArray[n] + increment;
        }
    }

    private void callGenotypes() {
        System.out.println("\nCalling genotypes...");
        for (int currTaxonIndex = 0; currTaxonIndex < this.obsTagsForEachTaxon.length; ++currTaxonIndex) {
            IntArrayList currTagList = this.obsTagsForEachTaxon[currTaxonIndex];
            currTagList.sort();
            int[][] alleleDepths = new int[6][this.myPositionList.numberOfSites()];
            int prevTag = currTagList.getQuick(0);
            int currInc = 0;
            for (int t = 0; t < currTagList.size(); ++t) {
                int tag = currTagList.getQuick(t);
                if (tag == prevTag) {
                    ++currInc;
                    continue;
                }
                this.incrementDepthForTagVariants(prevTag, alleleDepths, currInc);
                prevTag = tag;
                currInc = 1;
            }
            this.incrementDepthForTagVariants(prevTag, alleleDepths, currInc);
            byte[][] byteDepths = AlleleDepthUtil.depthIntToByte(alleleDepths);
            byte[] taxonGenos = this.resolveGenosForTaxon(byteDepths);
            if (this.noDepthOutput) {
                this.genos.addTaxon((Taxon)this.taxaList.get(currTaxonIndex), taxonGenos, (byte[][])null);
            } else {
                this.genos.addTaxon((Taxon)this.taxaList.get(currTaxonIndex), taxonGenos, byteDepths);
            }
            System.out.println("  finished calling genotypes for " + ((Taxon)this.taxaList.get(currTaxonIndex)).getName());
        }
        System.out.println("Finished calling genotypes for " + this.obsTagsForEachTaxon.length + " taxa\n");
    }

    private byte[] resolveGenosForTaxon(byte[][] depthsForTaxon) {
        int nAlleles = depthsForTaxon.length;
        byte[] depthsAtSite = new byte[nAlleles];
        int nSites = depthsForTaxon[0].length;
        byte[] genos = new byte[nSites];
        for (int site = 0; site < nSites; ++site) {
            for (int allele = 0; allele < nAlleles; ++allele) {
                depthsAtSite[allele] = depthsForTaxon[allele][site];
            }
            genos[site] = this.genoMergeRule.callBasedOnDepth(depthsAtSite);
        }
        return genos;
    }

    private void writeReadsPerSampleReports() {
        System.out.print("\nWriting ReadsPerSample log file...");
        String outFileS = this.myOutputDir + this.myKeyFile.substring(this.myKeyFile.lastIndexOf(File.separator));
        outFileS = outFileS.replaceAll(".txt", "_ReadsPerSample.log");
        outFileS = outFileS.replaceAll("_key", "");
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(outFileS))), 65536);
            bw.write("FullSampleName\tgoodBarcodedReads\tgoodReadsMatchedToTOPM\n");
            for (String fullSampleName : this.rawReadCountsForFullSampleName.keySet()) {
                bw.write(fullSampleName + "\t" + this.rawReadCountsForFullSampleName.get(fullSampleName) + "\t" + this.matchedReadCountsForFullSampleName.get(fullSampleName) + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            System.out.println("Couldn't write to ReadsPerSample log file: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        System.out.print("   ...done\n");
    }

    private void printFileNameConventions(String actualFileName) {
        System.out.println("Error in parsing file name:");
        System.out.println("   The raw sequence filename does not contain either 3, 4, or 5 underscore-delimited values.");
        System.out.println("   Acceptable file naming conventions include the following (where FLOWCELL indicates the flowcell name and LANE is an integer):");
        System.out.println("       FLOWCELL_LANE_fastq.gz");
        System.out.println("       FLOWCELL_s_LANE_fastq.gz");
        System.out.println("       code_FLOWCELL_s_LANE_fastq.gz");
        System.out.println("       FLOWCELL_LANE_fastq.txt.gz");
        System.out.println("       FLOWCELL_s_LANE_fastq.txt.gz");
        System.out.println("       code_FLOWCELL_s_LANE_fastq.txt.gz");
        System.out.println("       FLOWCELL_LANE_qseq.txt.gz");
        System.out.println("       FLOWCELL_s_LANE_qseq.txt.gz");
        System.out.println("       code_FLOWCELL_s_LANE_qseq.txt.gz");
        System.out.println("");
        System.out.println("   Actual Filename: " + actualFileName);
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

