/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import net.maizegenetics.analysis.gbs.ProductionSNPCallerPlugin;
import net.maizegenetics.analysis.imputation.FILLINImputationPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.CheckSum;
import net.maizegenetics.util.SMTPClient;
import net.maizegenetics.util.Utils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ProductionPipeline {
    private static final Logger myLogger = Logger.getLogger(ProductionPipeline.class);
    private static final String EMAIL_ADDRESS_DELIMITER = ";";
    private static final SimpleDateFormat LOGGING_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    private static final String RUN_FILE_SUFFIX = ".run";
    private String myApplicationHost = "unknown";
    private String myEmailHost = "appsmtp.mail.cornell.edu";
    private String[] myRecipientEmailAddresses = null;
    private String myArchiveDirectory = "/SSD/prop_pipeline/arcvtmp/";
    private String myHaplotypeDirectory = "/SSD/haplos/";
    private String myInputFolder = null;
    private String myEnzyme = null;
    private String myTopmFile = null;
    private String myOutputFolder = null;
    private String myKeyFile = null;
    private final boolean myRunImputation = true;
    private String myPropertiesFileContents = null;
    private final Map<String, String> myEmailSubjects = new HashMap<String, String>();
    private static final String EXAMPLE_RUN_FILE = "emailHost=appsmtp.mail.cornell.edu\nemailAddress=dek29@cornell.edu\narchiveDirectory=/SSD/prop_pipeline/arcvtmp/\nhaplosDirectory=/SSD/haplos/\ninputFolder=/workdir/tassel/tassel4-src/20130716test/raw_seq\nenzyme=ApeKI\ntopmFile=/workdir/tassel/tassel4-src/20130716test/topm/AllZeaGBSv2.6ProdTOPM_20130605.topm.h5\noutputFolder=/workdir/tassel/tassel4-src/20130716test/hap_maps\nkeyFile=/workdir/tassel/tassel4-src/20130716test/keyfile/MGP1_low_vol_2smallReps_key.txt";

    public ProductionPipeline(File runFile) {
        Properties props = new Properties();
        props.setProperty("log4j.logger.net.maizegenetics", "INFO, stdout");
        props.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)props);
        try {
            this.myApplicationHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.executeRunFile(runFile);
    }

    private String getEmailSubjectRun(String runFile) {
        String result = this.myEmailSubjects.get(runFile);
        if (result != null) {
            return result;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Discussion: ");
        builder.append(ProductionPipeline.getTimeStamp());
        builder.append("Run File: ").append(runFile).append(" ");
        result = builder.toString();
        this.myEmailSubjects.put(runFile, result);
        return result;
    }

    private String getEmailSubjectApp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Discussion: ");
        builder.append(ProductionPipeline.getTimeStamp());
        builder.append("Tassel GBS Production Pipeline on Host: ").append(this.myApplicationHost);
        return builder.toString();
    }

    private void executeRunFile(File runFile) {
        String currentRunFile = runFile.getAbsolutePath();
        String msgBody = "Starting to run " + currentRunFile + " on server " + this.myApplicationHost;
        this.sendAlertNotification(this.getEmailSubjectRun(currentRunFile), msgBody);
        String runFileContents = this.loadRunConfiguration(runFile);
        String todayDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String fileName = FilenameUtils.removeExtension((String)runFile.getName());
        String fileNameBase = todayDate + "_" + fileName;
        String logFileName = fileNameBase + ".log";
        File logFile = new File(this.myOutputFolder + "/" + logFileName);
        try {
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            BufferedWriter bw = Utils.getBufferedWriter(logFile);
            bw.write("Contents of the .properties file:\n" + this.myPropertiesFileContents);
            bw.write(ProductionPipeline.getTimeStamp() + "Contents of the .run file: " + "\n" + runFileContents);
            bw.write(this.getCurrentRunContext());
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        PrintStream ps = null;
        try {
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile, true)));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        System.setOut(ps);
        System.setErr(ps);
        System.out.println(ProductionPipeline.getTimeStamp() + "Initializing ProductionSNPCallerPlugin \n");
        long start = System.nanoTime();
        String[] pluginArgs = this.getPipelinePluginArgs();
        StringBuilder builder = new StringBuilder();
        for (String s : pluginArgs) {
            builder.append(s + "\n");
        }
        System.out.println("Arguments passed to ProductionSNPCallerPlugin:\n" + builder.toString());
        ProductionSNPCallerPlugin pscp = new ProductionSNPCallerPlugin();
        System.out.println(ProductionPipeline.getTimeStamp() + "Initialized ProductionSNPCallerPlugin \n");
        pscp.setParameters(pluginArgs);
        System.out.println(ProductionPipeline.getTimeStamp() + "Done with ProductionSNPCallerPlugin.setParameters() \n");
        pscp.performFunction(null);
        System.out.println(ProductionPipeline.getTimeStamp() + "Done with ProductionSNPCallerPlugin.performFunction() \n");
        double elapsedSeconds = (double)(System.nanoTime() - start) / 1.0E9;
        System.out.println(ProductionPipeline.getTimeStamp() + "Time to run ProductionSNPCallerPlugin: " + elapsedSeconds + " sec.");
        start = System.nanoTime();
        String[] name = runFile.getName().split("\\.");
        String h5File = this.myOutputFolder + "/" + name[0] + ".hmp.h5";
        String haploDir = this.myHaplotypeDirectory + "/" + "AllZeaGBSv27.gX.hmp.txt.gz";
        String targetFile = this.myOutputFolder + "/" + name[0] + ".globalimp.hmp.h5";
        this.runImputation(h5File, haploDir, targetFile);
        elapsedSeconds = (double)(System.nanoTime() - start) / 1.0E9;
        System.out.println(ProductionPipeline.getTimeStamp() + "Time to run Imputation: " + elapsedSeconds + " sec.");
        String email = "Ran:\n " + this.myInputFolder + "\n\n  Tassel Pipeline Execution Time: " + elapsedSeconds + " seconds" + "\n\n Attachment:\n " + logFile.getAbsolutePath() + "\nRun on server: " + this.myApplicationHost;
        StringBuilder emailMsg = new StringBuilder(email);
        File toFile = new File(this.myArchiveDirectory + "/" + runFile.getName());
        boolean movedFile = false;
        try {
            Files.move((File)runFile, (File)toFile);
            movedFile = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (movedFile) {
            System.out.println("Moved file " + runFile.getAbsolutePath() + " to " + toFile.getAbsolutePath());
        } else {
            String msg = "******* COULD NOT MOVE FILE " + runFile.getAbsolutePath() + " TO " + toFile.getAbsolutePath() + " on server: " + this.myApplicationHost;
            System.out.println(msg);
            this.sendAlertNotification(this.getEmailSubjectRun(currentRunFile), msg);
        }
        SMTPClient sc = new SMTPClient(this.myEmailHost, this.myRecipientEmailAddresses);
        try {
            sc.sendMessageWithAttachment(this.getEmailSubjectRun(currentRunFile), emailMsg.toString(), logFile.getAbsolutePath());
        }
        catch (MessagingException me) {
            // empty catch block
        }
    }

    private String[] getPipelinePluginArgs() {
        String[] args = new String[]{"-i", this.myInputFolder, "-k", this.myKeyFile, "-e", this.myEnzyme, "-o", this.myOutputFolder, "-m", this.myTopmFile};
        return args;
    }

    private String getPipelinePluginArgsString() {
        StringBuilder builder = new StringBuilder();
        builder.append("-i ").append(this.myInputFolder);
        builder.append(" -k ").append(this.myKeyFile);
        builder.append(" -e ").append(this.myEnzyme);
        builder.append(" -o ").append(this.myOutputFolder);
        builder.append(" -m ").append(this.myTopmFile);
        return builder.toString();
    }

    private String loadRunConfiguration(File aFileIn) {
        Properties props = new Properties();
        try {
            System.out.println(aFileIn.getAbsoluteFile());
            props.load(new FileInputStream(aFileIn));
        }
        catch (IOException ioe) {
            System.out.println("Problem loading run file configuration file:" + aFileIn);
            System.out.println("************** Example .properties file: ");
            System.out.println(EXAMPLE_RUN_FILE);
            ioe.printStackTrace();
            this.sendAlertNotification(this.getEmailSubjectApp(), "Properties file could not be loaded: " + aFileIn + " on server " + this.myApplicationHost);
            System.exit(1);
        }
        String configurationElement = "emailHost";
        this.myEmailHost = props.getProperty(configurationElement, this.myEmailHost);
        configurationElement = "emailAddress";
        String address = props.getProperty(configurationElement);
        if (address != null) {
            Iterable results = Splitter.on((String)EMAIL_ADDRESS_DELIMITER).split((CharSequence)address);
            this.myRecipientEmailAddresses = (String[])Iterables.toArray((Iterable)results, String.class);
        }
        configurationElement = "archiveDirectory";
        this.myArchiveDirectory = props.getProperty(configurationElement);
        String response = this.testInputDirectory(aFileIn, this.myArchiveDirectory, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "haplosDirectory";
        this.myHaplotypeDirectory = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn, this.myHaplotypeDirectory, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "inputFolder";
        this.myInputFolder = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn, this.myInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "enzyme";
        this.myEnzyme = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn, this.myInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "topmFile";
        this.myTopmFile = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn, this.myInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "outputFolder";
        this.myOutputFolder = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn, this.myInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "keyFile";
        this.myKeyFile = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn, this.myInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new FileReader(aFileIn));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sb.toString();
    }

    private String testInputDirectory(File filename, String input, String configurationElement) {
        String response = null;
        if (input == null) {
            response = filename.getAbsolutePath() + " is missing a run configuration element:  " + configurationElement;
        } else {
            File aFileOrDir = new File(input);
            if (!aFileOrDir.exists()) {
                response = filename.getAbsolutePath() + "'s configuration element " + configurationElement + " does not exist.  Please confirm path and filename.";
            }
        }
        return response;
    }

    private String getCurrentRunContext() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProductionPipeline.getTimeStamp()).append("\n");
        String user = System.getProperty("user.name");
        sb.append("User Account Name: ").append(user).append("\n");
        sb.append("Name of Machine on which JVM is Running: ").append(this.myApplicationHost).append("\n");
        sb.append(ProductionPipeline.getTimeStamp()).append("MD5: ").append(this.myKeyFile).append(": ").append(CheckSum.getMD5Checksum(this.myKeyFile)).append("\n");
        File inFldr = new File(this.myInputFolder);
        if (inFldr.isDirectory()) {
            File[] files;
            for (File f : files = inFldr.listFiles()) {
                sb.append(ProductionPipeline.getTimeStamp()).append("MD5: ").append(f.getPath()).append(": ").append(CheckSum.getMD5Checksum(f.getPath())).append("\n");
            }
        } else {
            sb.append(ProductionPipeline.getTimeStamp()).append(CheckSum.getMD5Checksum(this.myInputFolder)).append("\n");
        }
        return sb.toString();
    }

    private void runImputation(String unImpTargetFile, String donorFile, String impTargetFile) {
        String[] args2 = new String[]{"-hmp", unImpTargetFile, "-d", donorFile, "-o", impTargetFile, "-minMnCnt", "20", "-mxInbErr", "0.02", "-mxHybErr", "0.005", "-mnTestSite", "50", "-mxDonH", "10"};
        StringBuilder builder = new StringBuilder();
        for (String s : args2) {
            builder.append(s).append("\n");
        }
        System.out.println("Arguments passed to MinorWindowViterbiImputationPlugin:\n" + builder.toString());
        TasselPrefs.putAlignmentRetainRareAlleles(false);
        FILLINImputationPlugin plugin = new FILLINImputationPlugin();
        plugin.setParameters(args2);
        plugin.performFunction(null);
    }

    public static String compareOriginalAgainstImputed(String originalFile, String imputedFile) {
        StringBuilder sb = new StringBuilder();
        GenotypeTable origAlignment = ImportUtils.readGuessFormat(originalFile);
        GenotypeTable impAlignment = ImportUtils.readGuessFormat(imputedFile);
        int siteCount = origAlignment.numberOfSites();
        int taxaCount = origAlignment.numberOfTaxa();
        int totalSiteCount = siteCount * taxaCount;
        int siteDelta = Math.abs(origAlignment.numberOfSites() - impAlignment.numberOfSites());
        int taxaDelta = Math.abs(origAlignment.numberOfTaxa() - impAlignment.numberOfTaxa());
        int origTotalSitesNotMissing = 0;
        int impTotalSitesNotMissing = 0;
        int totalSitesNotMissingDelta = 0;
        double origProportionNotMissing = 0.0;
        double impProportionNotMissing = 0.0;
        double proportionNotMissingDelta = 0.0;
        int origHetCount = 0;
        int impHetCount = 0;
        int hetCountDelta = 0;
        double origHetProportion = 0.0;
        double impHetProportion = 0.0;
        double hetProportionDelta = 0.0;
        int flipCount = 0;
        int allelicChangeCount = 0;
        if (siteDelta == 0) {
            for (int i = 0; i < siteCount; ++i) {
                double diff;
                byte impMajorAllele;
                hetCountDelta = (impHetCount += impAlignment.heterozygousCount(i)) - (origHetCount += origAlignment.heterozygousCount(i));
                origTotalSitesNotMissing += origAlignment.totalNonMissingForSite(i);
                impTotalSitesNotMissing += impAlignment.totalNonMissingForSite(i);
                byte origMajorAllele = origAlignment.majorAllele(i);
                if (origMajorAllele != (impMajorAllele = impAlignment.majorAllele(i))) {
                    ++flipCount;
                    diff = Math.abs(origAlignment.majorAlleleFrequency(i) - impAlignment.minorAlleleFrequency(i));
                    allelicChangeCount += (int)diff * taxaCount;
                    continue;
                }
                diff = Math.abs(origAlignment.majorAlleleFrequency(i) - impAlignment.majorAlleleFrequency(i));
                allelicChangeCount += (int)diff * taxaCount;
            }
            totalSitesNotMissingDelta = impTotalSitesNotMissing - origTotalSitesNotMissing;
            origProportionNotMissing = (double)origTotalSitesNotMissing / (double)totalSiteCount;
            impProportionNotMissing = (double)impTotalSitesNotMissing / (double)totalSiteCount;
            proportionNotMissingDelta = impProportionNotMissing - origProportionNotMissing;
            hetCountDelta = impHetCount - origHetCount;
            origHetProportion = (double)origHetCount / (double)totalSiteCount;
            impHetProportion = (double)impHetCount / (double)totalSiteCount;
            hetProportionDelta = impHetProportion - origHetProportion;
        }
        sb.append("\nSites: " + siteCount + "\tSite Delta: " + siteDelta);
        sb.append("\nTaxa: " + taxaCount + "\tTaxa Delta: " + taxaDelta);
        sb.append("\nTotal Sites: " + totalSiteCount);
        sb.append("\nSites Not Missing Original: " + origTotalSitesNotMissing + "\tSites Not Missing Imputed: " + impTotalSitesNotMissing + "\tSites Not Missing Delta: " + totalSitesNotMissingDelta);
        sb.append("\nProportion Not Missing Original: " + origProportionNotMissing + "\tProportion Not Missing Imputed: " + impProportionNotMissing + "\tProportion Not Missing Delta: " + proportionNotMissingDelta);
        sb.append("\nChange in Heterozygous Sites: " + hetCountDelta);
        sb.append("\nHeterozygous Sites Original: " + origHetCount + "\tHeterozygous Sites Imputed: " + impHetCount + "\tHet Delta: " + hetCountDelta);
        sb.append("\nHeterozygous Proportion Original: " + origHetProportion + "\tHeterozygous Proportion Imputed: " + impHetProportion + "\tHet Proportion Delta: " + hetProportionDelta);
        sb.append("\nTotal Alleles Changed: " + allelicChangeCount + "\tProportion of Alleles Changed: " + (double)allelicChangeCount / (double)totalSiteCount);
        sb.append("\nNumber of Sites Changing Major Allele: " + flipCount + "\tMajor <-> Minor Proportion: " + (double)flipCount / (double)totalSiteCount);
        return sb.toString();
    }

    private static String getTimeStamp() {
        return "Timestamp: " + LOGGING_DATE_FORMAT.format(new Date()) + ": ";
    }

    private void sendAlertNotification(String subject, String message) {
        System.out.println("myEmailHost: " + this.myEmailHost);
        System.out.println("myRecipientEmailAddresses: " + this.myRecipientEmailAddresses);
        SMTPClient sc = new SMTPClient(this.myEmailHost, this.myRecipientEmailAddresses);
        try {
            sc.sendMessage(subject, message);
        }
        catch (MessagingException me) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        File inputDirectory;
        File[] runFiles;
        if (args.length != 1) {
            System.out.println("Usage: ProductionPipeline <run directory>");
            System.exit(1);
        }
        if ((runFiles = (inputDirectory = new File(args[0])).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ProductionPipeline.RUN_FILE_SUFFIX);
            }
        })) == null || runFiles.length == 0) {
            System.out.println("ProductionPipeline: Could not find a valid .run files in directory: " + args[0]);
            System.out.println("ProductionPipeline: Example .run file: ");
            System.out.println(EXAMPLE_RUN_FILE);
        }
        for (File current : runFiles) {
            System.out.println("ProductionPipeline: current run file: " + current.getAbsolutePath());
            new ProductionPipeline(current);
        }
    }
}

