/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TOPMUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import org.apache.log4j.Logger;

public class MergeMultipleTOPMPlugin
extends AbstractPlugin {
    private final Logger myLogger = Logger.getLogger(MergeMultipleTOPMPlugin.class);
    private static String TOPM_FILENAME_REGEX = "(?i).*\\.topm$|.*\\.topm\\.bin";
    private ArgsEngine myArgsEngine = null;
    private String[] myTOPMFileNames = null;
    private String myOutputFilename = null;
    private String myOrigFilename = null;
    private TOPMInterface myOrigTOPM = null;
    private int myOrigTagCount = 0;
    private byte[][] myOrigVariantOff = null;
    private byte[][] myOrigVariantDef = null;
    private boolean[] myChangedRows = null;
    private int[] myChromosomeChangedCounts = new int[20];

    public MergeMultipleTOPMPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        this.myOrigTOPM = TOPMUtils.readTOPM(this.myOrigFilename);
        this.myOrigTagCount = this.myOrigTOPM.getTagCount();
        this.myLogger.info((Object)("performFunction: Number of Original Tags: " + this.myOrigTagCount));
        this.myOrigVariantOff = this.myOrigTOPM.getVariantOff();
        this.myOrigVariantDef = this.myOrigTOPM.getVariantDef();
        this.myChangedRows = new boolean[this.myOrigTagCount];
        Arrays.fill(this.myChangedRows, false);
        for (int i = 0; i < this.myTOPMFileNames.length; ++i) {
            if (this.myTOPMFileNames[i].equals(this.myOrigFilename)) continue;
            this.processTOPM(this.myTOPMFileNames[i]);
        }
        for (int x = 0; x < this.myChromosomeChangedCounts.length; ++x) {
            if (this.myChromosomeChangedCounts[x] == 0) continue;
            this.myLogger.info((Object)("performFunction: chromosome: " + x + " changed: " + this.myChromosomeChangedCounts[x]));
        }
        TOPMUtils.writeTOPM(this.myOrigTOPM, this.myOutputFilename);
        return null;
    }

    private void printUsage() {
        this.myLogger.info((Object)"\nThe options for the MergeMultipleTOPMPlugin:\n-input  Input directory containing TOPM files\n-orig Original TOPM-result  TOPM Output Filename\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-input", "-input", true);
            this.myArgsEngine.add("-orig", "-orig", true);
            this.myArgsEngine.add("-result", "-result", true);
        }
        this.myArgsEngine.parse(args);
        String tempDirectory = this.myArgsEngine.getString("-input");
        if (tempDirectory != null && tempDirectory.length() != 0) {
            File topmDirectory = new File(tempDirectory);
            if (!topmDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("MergeMultipleTOPMPlugin: setParameters: The input name you supplied is not a directory: " + tempDirectory);
            }
            this.myTOPMFileNames = DirectoryCrawler.listFileNames(TOPM_FILENAME_REGEX, topmDirectory.getAbsolutePath());
            if (this.myTOPMFileNames.length == 0 || this.myTOPMFileNames == null) {
                this.printUsage();
                throw new IllegalArgumentException("MergeMultipleTOPMPlugin: setParameters: No TOPM files in: " + tempDirectory);
            }
            this.myLogger.info((Object)"setParameters: Using these TOPM files:");
            for (String filename : this.myTOPMFileNames) {
                this.myLogger.info((Object)filename);
            }
        }
        this.myOrigFilename = this.myArgsEngine.getString("-orig");
        if (this.myOrigFilename == null || this.myOrigFilename.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("MergeMultipleTOPMPlugin: setParameters: Must define original file");
        }
        File origFile = new File(this.myOrigFilename);
        if (!origFile.exists()) {
            this.printUsage();
            throw new IllegalArgumentException("MergeMultipleTOPMPlugin: setParameters: The original file doesn't exist: " + this.myOrigFilename);
        }
        this.myOutputFilename = this.myArgsEngine.getString("-result");
        if (this.myOutputFilename == null || this.myOutputFilename.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("MergeMultipleTOPMPlugin: setParameters: Must define result file");
        }
        File outputFile = new File(this.myOutputFilename);
        if (outputFile.exists()) {
            this.printUsage();
            throw new IllegalArgumentException("MergeMultipleTOPMPlugin: setParameters: The output file already exists: " + this.myOutputFilename);
        }
    }

    private void processTOPM(String filename) {
        this.myLogger.info((Object)("processTOPM: " + filename));
        FilterInputStream dis = null;
        int tagsInput = 0;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filename), 65536));
            int tagNum = ((DataInputStream)dis).readInt();
            int tagLengthInLong = ((DataInputStream)dis).readInt();
            int maxVariants = ((DataInputStream)dis).readInt();
            for (int row = 0; row < tagNum; ++row) {
                ++tagsInput;
                this.processTag((DataInputStream)dis, row, tagLengthInLong, maxVariants);
                if (row % 1000000 != 0) continue;
                this.myLogger.info((Object)("processTOPM: Tags Read: " + row));
            }
            this.myLogger.info((Object)("processTOPM: Number of Tags: " + tagsInput));
        }
        catch (Exception e) {
            this.myLogger.error((Object)("processTOPM: Error Reading Tag: " + tagsInput));
            e.printStackTrace();
            throw new IllegalStateException("MergeMultipleTOPMPlugin: processTOPM: Problem processing: " + filename);
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception e) {}
        }
    }

    private void processTag(DataInputStream dis, int row, int tagLengthInLong, int maxVariants) throws IOException {
        int i;
        long[] tags = new long[tagLengthInLong];
        for (int j = 0; j < tagLengthInLong; ++j) {
            tags[j] = dis.readLong();
        }
        byte tagLength = dis.readByte();
        byte multimaps = dis.readByte();
        int chromosome = dis.readInt();
        byte strand = dis.readByte();
        int startPosition = dis.readInt();
        int endPosition = dis.readInt();
        byte divergence = dis.readByte();
        byte[] variantPosOff = new byte[maxVariants];
        byte[] variantDef = new byte[maxVariants];
        for (int j = 0; j < maxVariants; ++j) {
            variantPosOff[j] = dis.readByte();
            variantDef[j] = dis.readByte();
        }
        byte dcoP = dis.readByte();
        byte mapP = dis.readByte();
        if (this.myOrigTOPM.getTagLength(row) != tagLength) {
            this.myLogger.error((Object)("processTag: " + row + " Tag Length: " + tagLength + " doesn't match Original: " + this.myOrigTOPM.getTagLength(row)));
        }
        if (this.myOrigTOPM.getMultiMaps(row) != multimaps) {
            this.myLogger.error((Object)("processTag: " + row + " Multi Maps: " + multimaps + " doesn't match Original: " + this.myOrigTOPM.getMultiMaps(row)));
        }
        if (this.myOrigTOPM.getChromosome(row) != chromosome) {
            this.myLogger.error((Object)("processTag: " + row + " Chromosome: " + chromosome + " doesn't match Original: " + this.myOrigTOPM.getChromosome(row)));
        }
        if (this.myOrigTOPM.getStrand(row) != strand) {
            this.myLogger.error((Object)("processTag: " + row + " Strand: " + strand + " doesn't match Original: " + this.myOrigTOPM.getStrand(row)));
        }
        if (this.myOrigTOPM.getStartPosition(row) != startPosition) {
            this.myLogger.error((Object)("processTag: " + row + " Start Position: " + startPosition + " doesn't match Original: " + this.myOrigTOPM.getStartPosition(row)));
        }
        if (this.myOrigTOPM.getEndPosition(row) != endPosition) {
            this.myLogger.error((Object)("processTag: " + row + " End Position: " + endPosition + " doesn't match Original: " + this.myOrigTOPM.getEndPosition(row)));
        }
        if (this.myOrigTOPM.getDivergence(row) != divergence) {
            this.myLogger.error((Object)("processTag: " + row + " Divergence: " + divergence + " doesn't match Original: " + this.myOrigTOPM.getDivergence(row)));
        }
        if (this.myOrigTOPM.getDcoP(row) != dcoP) {
            this.myLogger.error((Object)("processTag: " + row + " DcoP: " + dcoP + " doesn't match Original: " + this.myOrigTOPM.getDcoP(row)));
        }
        if (this.myOrigTOPM.getMapP(row) != mapP) {
            this.myLogger.error((Object)("processTag: " + row + " MapP: " + mapP + " doesn't match Original: " + this.myOrigTOPM.getMapP(row)));
        }
        boolean variantsEqual = true;
        for (i = 0; i < maxVariants; ++i) {
            if (this.myOrigVariantDef[row][i] != variantDef[i]) {
                variantsEqual = false;
                break;
            }
            if (this.myOrigVariantOff[row][i] == variantPosOff[i]) continue;
            variantsEqual = false;
            break;
        }
        if (!variantsEqual) {
            if (this.myChangedRows[row]) {
                throw new IllegalStateException("MergeMultipleTOPMPlugin: processTag: " + row + " has already been merged.");
            }
            this.myChangedRows[row] = true;
            if (chromosome < this.myChromosomeChangedCounts.length) {
                int n = chromosome;
                this.myChromosomeChangedCounts[n] = this.myChromosomeChangedCounts[n] + 1;
            }
            for (i = 0; i < maxVariants; ++i) {
                this.myOrigTOPM.setVariantDef(row, i, variantDef[i]);
                this.myOrigTOPM.setVariantPosOff(row, i, variantPosOff[i]);
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

