/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.tag.TagCountMutable;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class FastqToTagCountPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FastqToTagCountPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String myInputDirName = null;
    private String myKeyfile = null;
    private String myEnzyme = null;
    private int myMaxGoodReads = 300000000;
    private int myMinCount = 1;
    private String myOutputDir = null;

    public FastqToTagCountPlugin() {
        super(null, false);
    }

    public FastqToTagCountPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        myLogger.info((Object)"\n\nUsage is as follows:\n -i  Input directory containing FASTQ files in text or gzipped text.\n     NOTE: Directory will be searched recursively and should\n     be written WITHOUT a slash after its name.\n\n -k  Key file listing barcodes distinguishing the samples\n -e  Enzyme used to create the GBS library, if it differs from the one listed in the key file.\n -s  Max good reads per lane. (Optional. Default is 300,000,000).\n -c  Minimum tag count (default is 1).\n -o  Output directory to contain .cnt files (one per FASTQ file, defaults to input directory).\n\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        File fastqDirectory = new File(this.myInputDirName);
        if (!fastqDirectory.isDirectory()) {
            this.printUsage();
            throw new IllegalStateException("The input name you supplied is not a directory: " + this.myInputDirName);
        }
        FastqToTagCountPlugin.countTags(this.myKeyfile, this.myEnzyme, this.myInputDirName, this.myOutputDir, this.myMaxGoodReads, this.myMinCount);
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-directory", true);
            this.myArgsEngine.add("-k", "--key-file", true);
            this.myArgsEngine.add("-e", "--enzyme", true);
            this.myArgsEngine.add("-s", "--max-reads", true);
            this.myArgsEngine.add("-c", "--min-count", true);
            this.myArgsEngine.add("-o", "--output-file", true);
            this.myArgsEngine.parse(args);
        }
        if (!this.myArgsEngine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the location of your FASTQ files.");
        }
        this.myInputDirName = this.myArgsEngine.getString("-i");
        if (!this.myArgsEngine.getBoolean("-k")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a barcode key file.");
        }
        this.myKeyfile = this.myArgsEngine.getString("-k");
        if (this.myArgsEngine.getBoolean("-e")) {
            this.myEnzyme = this.myArgsEngine.getString("-e");
        } else {
            myLogger.warn((Object)"No enzyme specified.  Using enzyme listed in key file.");
        }
        if (this.myArgsEngine.getBoolean("-s")) {
            this.myMaxGoodReads = Integer.parseInt(this.myArgsEngine.getString("-s"));
        }
        if (this.myArgsEngine.getBoolean("-c")) {
            this.myMinCount = Integer.parseInt(this.myArgsEngine.getString("-c"));
        }
        this.myOutputDir = this.myArgsEngine.getBoolean("-o") ? this.myArgsEngine.getString("-o") : this.myInputDirName;
    }

    public static void countTags(String keyFileS, String enzyme, String fastqDirectory, String outputDir, int maxGoodReads, int minCount) {
        String[] countFileNames = null;
        File inputDirectory = new File(fastqDirectory);
        File[] fastqFiles = DirectoryCrawler.listFiles("(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$", inputDirectory.getAbsolutePath());
        if (fastqFiles.length == 0 || fastqFiles == null) {
            myLogger.warn((Object)"Couldn't find any files that end with \".fq\", \".fq.gz\", \".fastq\", \"_fastq.txt\", \"_fastq.gz\", \"_fastq.txt.gz\", \"_sequence.txt\", or \"_sequence.txt.gz\" in the supplied directory.");
            return;
        }
        myLogger.info((Object)"Using the following FASTQ files:");
        countFileNames = new String[fastqFiles.length];
        for (int i = 0; i < fastqFiles.length; ++i) {
            countFileNames[i] = fastqFiles[i].getName().replaceAll("(?i)\\.fq$|\\.fq\\.gz$|\\.fastq$|_fastq\\.txt$|_fastq\\.gz$|_fastq\\.txt\\.gz$|_sequence\\.txt$|_sequence\\.txt\\.gz$", ".cnt");
            myLogger.info((Object)fastqFiles[i].getAbsolutePath());
        }
        for (int laneNum = 0; laneNum < fastqFiles.length; ++laneNum) {
            ParseBarcodeRead thePBR;
            File outputFile = new File(outputDir + File.separator + countFileNames[laneNum]);
            if (outputFile.isFile()) {
                myLogger.warn((Object)("An output file " + countFileNames[laneNum] + "\n" + " already exists in the output directory for file " + fastqFiles[laneNum] + ".  Skipping."));
                continue;
            }
            myLogger.info((Object)("Reading FASTQ file: " + fastqFiles[laneNum]));
            String[] filenameField = fastqFiles[laneNum].getName().split("_");
            if (filenameField.length == 3) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[0], filenameField[1]);
            } else if (filenameField.length == 4) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[0], filenameField[2]);
            } else if (filenameField.length == 5) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[1], filenameField[3]);
            } else {
                myLogger.error((Object)("Error in parsing file name: " + fastqFiles[laneNum]));
                myLogger.error((Object)"   The filename does not contain either 3, 4, or 5 underscore-delimited values.");
                myLogger.error((Object)"   Expect: flowcell_lane_fastq.txt.gz OR flowcell_s_lane_fastq.txt.gz OR code_flowcell_s_lane_fastq.txt.gz");
                continue;
            }
            myLogger.info((Object)("Total barcodes found in lane:" + thePBR.getBarCodeCount()));
            if (thePBR.getBarCodeCount() == 0) {
                myLogger.warn((Object)"No barcodes found.  Skipping this flowcell lane.");
                continue;
            }
            String[] taxaNames = new String[thePBR.getBarCodeCount()];
            for (int i = 0; i < taxaNames.length; ++i) {
                taxaNames[i] = thePBR.getTheBarcodes(i).getTaxaName();
            }
            int goodBarcodedReads = 0;
            try {
                BufferedReader br = Utils.getBufferedReader(fastqFiles[laneNum], 65536);
                TagCountMutable theTC = null;
                try {
                    theTC = new TagCountMutable(2, maxGoodReads);
                }
                catch (OutOfMemoryError e) {
                    myLogger.error((Object)"Your system doesn't have enough memory to store the number of sequencesyou specified.  Try using a smaller value for the minimum number of reads.");
                    System.exit(1);
                }
                int currLine = 0;
                int allReads = 0;
                goodBarcodedReads = 0;
                String sequence = "";
                String qualityScore = "";
                String temp = br.readLine();
                while (temp != null && goodBarcodedReads < maxGoodReads) {
                    ++currLine;
                    try {
                        if ((currLine + 2) % 4 == 0) {
                            sequence = temp;
                        } else if (currLine % 4 == 0) {
                            qualityScore = temp;
                            ++allReads;
                            ReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(sequence, qualityScore, true, 0);
                            if (rr != null) {
                                ++goodBarcodedReads;
                                theTC.addReadCount(rr.getRead(), rr.getLength(), 1);
                            }
                            if (allReads % 1000000 == 0) {
                                myLogger.info((Object)("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads));
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        myLogger.error((Object)("Unable to correctly parse the sequence and: " + sequence + " and quality score: " + qualityScore + " from fastq file.  Your fastq file may have been corrupted."));
                        System.exit(1);
                    }
                    temp = br.readLine();
                }
                myLogger.info((Object)("Total number of reads in lane=" + allReads));
                myLogger.info((Object)("Total number of good barcoded reads=" + goodBarcodedReads));
                myLogger.info((Object)"Timing process (sorting, collapsing, and writing TagCount to file).");
                long timePoint1 = System.currentTimeMillis();
                theTC.collapseCounts();
                theTC.writeTagCountFile(outputDir + File.separator + countFileNames[laneNum], TagsByTaxa.FilePacking.Byte, minCount);
                myLogger.info((Object)("Process took " + (System.currentTimeMillis() - timePoint1) + " milliseconds."));
                br.close();
            }
            catch (Exception e) {
                myLogger.error((Object)("Good Barcodes Read: " + goodBarcodedReads));
                e.printStackTrace();
            }
            myLogger.info((Object)("Finished reading " + (laneNum + 1) + " of " + fastqFiles.length + " sequence files."));
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

