/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class BinaryToTextPlugin
extends AbstractPlugin {
    private Logger myLogger = Logger.getLogger(BinaryToTextPlugin.class);
    private ArgsEngine myEngine = null;
    private String myInput;
    private String myOutput;
    private FILE_TYPES myType;

    public BinaryToTextPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        switch (this.getType()) {
            case TOPM: {
                TagsOnPhysicalMap topm = new TagsOnPhysicalMap(this.myInput, true);
                topm.writeTextFile(new File(this.myOutput));
                break;
            }
            case TagCounts: {
                TagCounts tc = new TagCounts(this.myInput, TagsByTaxa.FilePacking.Byte);
                tc.writeTagCountFile(this.myOutput, TagsByTaxa.FilePacking.Text, 0);
                break;
            }
            case TBTByte: {
                TagsByTaxaByte tbtbyte = new TagsByTaxaByte(this.myInput, TagsByTaxa.FilePacking.Byte);
                tbtbyte.writeDistFile(new File(this.myOutput), TagsByTaxa.FilePacking.Text, 0);
            }
        }
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args == null || args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myEngine == null) {
            this.myEngine = new ArgsEngine();
            this.myEngine.add("-i", "--input-file", true);
            this.myEngine.add("-o", "--output-file", true);
            this.myEngine.add("-t", "--file-type", true);
        }
        this.myEngine.parse(args);
        if (!this.myEngine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the input file name.");
        }
        this.myInput = this.myEngine.getString("-i");
        if (!this.myEngine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the output file name.");
        }
        this.myOutput = this.myEngine.getString("-o");
        if (this.myEngine.getBoolean("-t")) {
            String temp = this.myEngine.getString("-t");
            if (temp.equalsIgnoreCase(FILE_TYPES.TOPM.toString())) {
                this.setType(FILE_TYPES.TOPM);
            } else if (temp.equalsIgnoreCase(FILE_TYPES.TagCounts.toString())) {
                this.setType(FILE_TYPES.TagCounts);
            } else if (temp.equalsIgnoreCase(FILE_TYPES.TBTBit.toString())) {
                this.setType(FILE_TYPES.TBTBit);
            } else if (temp.equalsIgnoreCase(FILE_TYPES.TBTByte.toString())) {
                this.setType(FILE_TYPES.TBTByte);
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the file type.");
        }
    }

    private void printUsage() {
        this.myLogger.info((Object)"\nUsage:\nBinaryToTextPlugin <options>\n -i  Input File Name\n -o  Output File Name\n -t  File Type (TOPM, TagCounts, TBTBit, TBTByte)\n");
    }

    public void setInput(String filename) {
        this.myInput = filename;
    }

    public String getInput() {
        return this.myInput;
    }

    public void setOutput(String filename) {
        this.myOutput = filename;
    }

    public String getOutput() {
        return this.myOutput;
    }

    public void setType(FILE_TYPES type) {
        this.myType = type;
    }

    public FILE_TYPES getType() {
        return this.myType;
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum FILE_TYPES {
        TOPM,
        TagCounts,
        TBTBit,
        TBTByte;

    }
}

