/*
 * Decompiled with CFR 0.152.
 */
package gbs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import net.maizegenetics.analysis.gbs.SAMConverterPlugin;
import net.maizegenetics.analysis.gbs.TagCountToFastqPlugin;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.PETagsOnPhysicalMap;
import net.maizegenetics.dna.map.TagsOnGeneticMap;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.map.TagsOnPhysicalMapV3;
import net.maizegenetics.dna.tag.PETagCounts;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.util.MultiMemberGZIPInputStream;

public class V3Utils {
    public void mergeBlastResult(String inputDirS, String outputFileS) {
        File[] files = new File(inputDirS).listFiles();
    }

    public void splitFastaFileS(String inputFileS, String outputDir, int fileNum) {
        try {
            int i;
            String temp;
            BufferedReader br = inputFileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(inputFileS))))) : new BufferedReader(new FileReader(new File(inputFileS)), 65536);
            int tagNum = 0;
            while ((temp = br.readLine()) != null) {
                ++tagNum;
            }
            br.close();
            int[] size = new int[fileNum];
            int left = (tagNum /= 2) % fileNum;
            if (left == 0) {
                for (i = 0; i < size.length; ++i) {
                    size[i] = tagNum / fileNum;
                }
            } else {
                int i2;
                int base = tagNum / fileNum;
                for (i2 = 0; i2 < left; ++i2) {
                    size[i2] = base + 1;
                }
                for (i2 = left; i2 < fileNum; ++i2) {
                    size[i2] = base;
                }
            }
            br = inputFileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(inputFileS))))) : new BufferedReader(new FileReader(new File(inputFileS)), 65536);
            for (i = 0; i < fileNum; ++i) {
                String fileName = outputDir + "tag" + this.get5DigitNumber(i) + ".fasta";
                BufferedWriter bw = new BufferedWriter(new FileWriter(fileName), 65536);
                for (int j = 0; j < size[i]; ++j) {
                    bw.write(br.readLine());
                    bw.newLine();
                    bw.write(br.readLine());
                    bw.newLine();
                }
                bw.flush();
                bw.close();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String get5DigitNumber(int j) {
        String numS = String.valueOf(j);
        int repeat = 5 - numS.length();
        for (int i = 0; i < repeat; ++i) {
            numS = "0" + numS;
        }
        return numS;
    }

    public void convertSAM2TOPM(String infileS, String outfileS) {
        SAMConverterPlugin scp = new SAMConverterPlugin();
        String arguments = "-i " + infileS + " -t -o " + outfileS;
        String[] args = arguments.split(" ");
        scp.setParameters(args);
        scp.performFunction(null);
    }

    public void convertTagCount2Fastq(String inputFileS, String outputFileS) {
        TagCountToFastqPlugin umithm = new TagCountToFastqPlugin();
        String arguments = "-i " + inputFileS + " -o " + outputFileS;
        String[] args = arguments.split(" ");
        umithm.setParameters(args);
        umithm.performFunction(null);
    }

    public void convertTOPM2Fastq(String topmFileS, String outputFileS) {
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(topmFileS);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileS), 65536);
            for (int i = 0; i < topm.getTagCount(); ++i) {
                bw.write("@length=" + topm.getTagLength(i) + "count=" + 1);
                bw.newLine();
                long[] tag = topm.getTag(i);
                bw.write(BaseEncoder.getSequenceFromLong(tag).substring(0, topm.getTagLength(i)));
                bw.newLine();
                bw.write("+");
                bw.newLine();
                for (int j = 0; j < topm.getTagLength(i); ++j) {
                    bw.write("f");
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mkSmallPETagCountsFile(String inputFileS, String outputFileS, int startIndex, int size) {
        PETagCounts ptc = new PETagCounts(inputFileS, TagsByTaxa.FilePacking.Byte);
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFileS), 65536));
            dos.writeInt(ptc.getTagSizeInLong());
            dos.writeInt(size);
            for (int i = startIndex; i < startIndex + size; ++i) {
                int j;
                for (j = 0; j < ptc.getTagSizeInLong(); ++j) {
                    dos.writeLong(ptc.getTagF(i)[j]);
                }
                dos.writeShort(ptc.getTagFLength(i));
                for (j = 0; j < ptc.getTagSizeInLong(); ++j) {
                    dos.writeLong(ptc.getTagB(i)[j]);
                }
                dos.writeShort(ptc.getTagBLength(i));
                dos.writeByte(ptc.getContigLengthInLong(i));
                for (j = 0; j < ptc.getContigLengthInLong(i); ++j) {
                    dos.writeLong(ptc.getContig(i)[j]);
                }
                dos.writeShort(ptc.getContigLength(i));
                dos.writeInt(ptc.getReadCount(i));
            }
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void mkSmallTagCountsFile(String inputFileS, String outputFileS, int startIndex, int tagNum) {
        TagCounts tc = new TagCounts(inputFileS, TagsByTaxa.FilePacking.Byte);
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFileS), 65536));
            fw.writeInt(tagNum);
            fw.writeInt(tc.getTagSizeInLong());
            for (int i = startIndex; i < startIndex + tagNum; ++i) {
                for (int j = 0; j < tc.getTagSizeInLong(); ++j) {
                    fw.writeLong(tc.getTag(i)[j]);
                }
                fw.writeByte(tc.getTagLength(i));
                fw.writeInt(tc.getReadCount(i));
            }
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextDistFile writing output file e=" + e);
            e.printStackTrace();
        }
    }

    public void mkAlignmentCompareTable(String TOGMFileS, String topmFileS, String ptopmFileS, String outfileS) {
        int tagLimit = 30000;
        TagsOnGeneticMap togm = new TagsOnGeneticMap(TOGMFileS, TagsByTaxa.FilePacking.Text);
        TagsOnPhysicalMap topm = new TagsOnPhysicalMap(topmFileS, true);
        PETagsOnPhysicalMap ptopm = new PETagsOnPhysicalMap(ptopmFileS, TagsByTaxa.FilePacking.Text);
        int cnt = 0;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write("Tag\tGChr\tGPOs\tPEChr\tPEPos\tTChr\tTPos");
            bw.newLine();
            for (int i = 0; i < ptopm.getTagCount(); ++i) {
                int index2;
                long[] PEtag = ptopm.getTagF(i);
                long[] tag = new long[togm.getTagSizeInLong()];
                for (int j = 0; j < tag.length; ++j) {
                    tag[j] = PEtag[j];
                }
                int index1 = togm.getTagIndex(tag);
                if (index1 < 0 || (index2 = topm.getTagIndex(tag)) < 0) continue;
                bw.write(BaseEncoder.getSequenceFromLong(togm.getTag(i)) + "\t");
                bw.write(String.valueOf(togm.getGChr(index1)) + "\t" + String.valueOf(togm.getGPos(index1)) + "\t");
                bw.write(String.valueOf(ptopm.getChrF(i)) + "\t" + String.valueOf(ptopm.getPosStartF(i)) + "\t");
                bw.write(String.valueOf(topm.getChromosome(index2)) + "\t" + String.valueOf(topm.getPositionArray(index2)[2]));
                bw.newLine();
                if (++cnt > tagLimit) break;
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

