/*
 * Decompiled with CFR 0.152.
 */
package gbs;

import gbs.V3Utils;
import java.util.Arrays;
import net.maizegenetics.analysis.data.MigrateHDF5FromT4T5;
import net.maizegenetics.analysis.gbs.AnnotateTOPM;
import net.maizegenetics.analysis.gbs.ContigPETagCountPlugin;
import net.maizegenetics.analysis.gbs.FastqToPETagCountPlugin;
import net.maizegenetics.analysis.gbs.MergePETagCountPlugin;
import net.maizegenetics.analysis.gbs.QseqToPETagCountPlugin;
import net.maizegenetics.analysis.gbs.SimpleGenotypeSBit;
import net.maizegenetics.analysis.gbs.TagAgainstAnchor;
import net.maizegenetics.analysis.gbs.TagAgainstAnchorHypothesis;
import net.maizegenetics.analysis.gbs.TagAgainstAnchorPlugin;
import net.maizegenetics.analysis.gbs.TagBlockPosition;
import net.maizegenetics.dna.map.PETagsOnPhysicalMapV3;
import net.maizegenetics.dna.map.TagGWASMap;
import net.maizegenetics.dna.map.TagMappingInfoV3;
import net.maizegenetics.dna.map.TagsOnPhysicalMapV3;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.tag.PETagCounts;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;

public class PipelineTest {
    public PipelineTest() {
        this.geneticMappingPipeline();
    }

    public void V3TestPipeline() {
    }

    public void callSNPDiscovery() {
        String topmFileS = "M:/pipelineTest/GBSV3test/topm/ini.topm.h5";
        String pedigreeFileS = "M:/pipelineTest/GBSV3test/keyfile/AllZeaPedigree2012oct01C.txt";
        String tbtFileS = "M:/pipelineTest/GBSV3test/tbt/small4096TBTHDF5_mergedtaxa_pivot_20120921.h5";
        String referenceFileS = "M:/Database/maizeReference/chr10.fasta";
        String hapmapFileS = "M:/pipelineTest/GBSV3test/hapmap/myGBSGenos.chr+.hmp.txt";
        String arguments = "-i " + tbtFileS + " -m " + topmFileS + " -o " + hapmapFileS + " -p " + pedigreeFileS + " -ref " + referenceFileS;
        arguments = arguments + " -mxSites 10000 -mnF 0.8 -mnMAF 0.001 -mnMAC 10 -mnLCov 0.1 -cF -sC 10 -eC 10";
        String[] args = arguments.split(" ");
    }

    public void importPrediction() {
        String topmFileS = "M:/pipelineTest/GBSV3test/topm/ini.topm.h5";
        String predictDirS = "M:/pipelineTest/GBSV3test/wekaPrediction/output/";
        String indexDirS = "M:/pipelineTest/GBSV3test/wekaPrediction/index/";
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(topmFileS);
        AnnotateTOPM anno = new AnnotateTOPM(topm);
        TagMappingInfoV3.Aligner priorityAligner = TagMappingInfoV3.Aligner.Bowtie2;
        anno.annotateBestMappingImport(indexDirS, predictDirS, priorityAligner);
    }

    public void predictHypothesis() {
        String topmFileS = "M:/pipelineTest/GBSV3test/topm/ini.topm.h5";
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(topmFileS);
        String modelFileS = "E:/Research/gbsv3/modelDevelop/262144Tags_RandomForest.model";
        String tagCountFileS = "M:/pipelineTest/GBSV3test/tagCount/small.cnt";
        String inputDirS = "M:/pipelineTest/GBSV3test/wekaPrediction//input/";
        String indexDirS = "M:/pipelineTest/GBSV3test/wekaPrediction/index/";
        String outputDirS = "M:/pipelineTest/GBSV3test/wekaPrediction/output/";
        AnnotateTOPM anno = new AnnotateTOPM(topm);
        anno.annotateBestMappingPredict(modelFileS, tagCountFileS, inputDirS, indexDirS, outputDirS);
    }

    public void annotateTOPMHDF5WithGMGW() {
        String inputFileS = "M:/pipelineTest/GBSV3test/topm/ini.topm.h5";
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(inputFileS);
        AnnotateTOPM anno = new AnnotateTOPM(topm);
        String TOGMFileS = "M:/pav/PhyGenMapping/v1.togm.txt";
        anno.annotateWithGMGW(TOGMFileS, 1);
    }

    public void hypothesisGeneticMapping() {
        String topmFileS = "M:/pipelineTest/GBSV3test/topm/ini.topm.h5";
        String hapMapHDF5 = "M:/pipelineTest/GBSV3test/anchor/GBS27.small1024.sBit.h5";
        String tbtHDF5 = "M:/pipelineTest/GBSV3test/tbt/small4096TBTHDF5_mergedtaxa_pivot_20120921.h5";
        TagAgainstAnchorHypothesis taah = new TagAgainstAnchorHypothesis(hapMapHDF5, tbtHDF5, topmFileS, "Bowtie2", 10, 0.5, 20, 1);
    }

    public void annotateTOPMHDF5WithAligner() {
        String inputFileS = "M:/pipelineTest/GBSV3test/topm/ini.topm.h5";
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(inputFileS);
        AnnotateTOPM anno = new AnnotateTOPM(topm);
        String bowtie2SamFileS = "M:/pipelineTest/GBSV3test/alignment/small_bowtie2-K5.sam";
        anno.annotateWithBowtie2(bowtie2SamFileS, 5);
        String bwaSamFileS = "M:/pipelineTest/GBSV3test/alignment/small_bwa-N5.sam";
        anno.annotateWithBWA(bwaSamFileS, 5);
        String blastDirS = "M:/pipelineTest/GBSV3test/alignment/blastOut/";
        anno.annotateWithBlastFromDir(blastDirS, 5);
        String bwaMemSamFileS = "M:/pipelineTest/GBSV3test/alignment/small_bwa-mem-a.sam";
        anno.annotateWithBWAMEM(bwaMemSamFileS, 5);
        String PETOPMFileS = "M:/production/pe/ptopm/PE.topm";
        anno.annotateWithPE(PETOPMFileS, 5);
    }

    public void initializeTOPMHDF5() {
        String inputFileS = "M:/pipelineTest/GBSV3test/tagCount/small.cnt";
        String outputFileS = "M:/pipelineTest/GBSV3test/topm/ini.topm.h5";
        TagCounts tc = new TagCounts(inputFileS, TagsByTaxa.FilePacking.Byte);
        TagsOnPhysicalMapV3.createFile(tc, outputFileS);
    }

    public void mkFasta() {
        String inputFileS = "M:/pipelineTest/GBSV3test/tagCount/small.cnt";
        String outputFileS = "M:/pipelineTest/GBSV3test/alignment/small.fa";
        TagCounts tc = new TagCounts(inputFileS, TagsByTaxa.FilePacking.Byte);
        tc.toFASTA(outputFileS);
    }

    public void mkFastq() {
        String inputFileS = "M:/pipelineTest/GBSV3test/tagCount/small.cnt";
        String outputFileS = "M:/pipelineTest/GBSV3test/alignment/small.fq";
        new V3Utils().convertTagCount2Fastq(inputFileS, outputFileS);
    }

    public void mkSmallTagCount() {
        String inputFileS = "M:/pipelineTest/GBSV3test/tagCount/434GFAAXX_s_4.cnt";
        String outputFileS = "M:/pipelineTest/GBSV3test/tagCount/small.cnt";
        new V3Utils().mkSmallTagCountsFile(inputFileS, outputFileS, 10001, 500);
    }

    public void PEPipeline() {
    }

    public void mkPEAlignment() {
        String fFastaFileS = "M:/production/pe/alignment/f.fasta.txt";
        String bFastaFileS = "M:/production/pe/alignment/b.fasta.txt";
        String fSamFileS = "M:/production/pe/alignment/f.k5.sam.gz";
        String bSamFileS = "M:/production/pe/alignment/b.k5.sam.gz";
        Object a = null;
        PETagsOnPhysicalMapV3 ptopm = new PETagsOnPhysicalMapV3(fFastaFileS, bFastaFileS, fSamFileS, bSamFileS);
        String PETOPM = "M:/production/pe/ptopm/PE.topm";
        ptopm.writeBinaryFile(PETOPM);
        ptopm = new PETagsOnPhysicalMapV3(PETOPM);
    }

    public void mkFastaFileFromPE() {
        String infileS = "M:/production/pe/mergePETagCounts/merge.con.pe.cnt";
        PETagCounts ptc = new PETagCounts(infileS, TagsByTaxa.FilePacking.Byte);
        String fFastaFileS = "M:/production/pe/alignment/f.fasta.txt";
        String bFastaFileS = "M:/production/pe/alignment/b.fasta.txt";
        ptc.mkFastaFile(fFastaFileS, bFastaFileS);
    }

    public void contigPETagCounts() {
        String infileS = "M:/production/pe/mergePETagCounts/merge.pe.cnt";
        String outfileS = "M:/production/pe/mergePETagCounts/merge.con.pe.cnt";
        String arguments = "-i " + infileS + " -o " + outfileS;
        String[] args = arguments.split(" ");
        ContigPETagCountPlugin m = new ContigPETagCountPlugin();
        m.setParameters(args);
        m.performFunction(null);
    }

    public void mergePETagCounts() {
        String inputDirS = "M:/production/pe/PETagCounts/";
        String outfileS = "M:/production/pe/mergePETagCounts/merge.pe.cnt";
        String arguments = "-i " + inputDirS + " -o " + outfileS;
        String[] args = arguments.split(" ");
        MergePETagCountPlugin m = new MergePETagCountPlugin();
        m.setParameters(args);
        m.performFunction(null);
    }

    public void parseFastq() {
        String infile1 = "M:/production/pe/Illumina/test/ImputationP15_1_1_fastq.txt";
        String infile2 = "M:/production/pe/Illumina/test/ImputationP15_1_2_fastq.txt";
        String keyfile = "M:/production/pe/key/ImputationP15_key.txt";
        String outputDirS = "M:/production/pe/PETagCounts/";
        String arguments = "-iF " + infile1 + " -iB " + infile2 + " -k " + keyfile + " -e ApekI -l 8 -o " + outputDirS;
        String[] args = arguments.split(" ");
        FastqToPETagCountPlugin q = new FastqToPETagCountPlugin();
        q.setParameters(args);
        q.performFunction(null);
    }

    public void parseQseq() {
        String infile1 = "M:/production/pe/Illumina/81546ABXX_8_1_qseq.txt";
        String infile2 = "M:/production/pe/Illumina/81546ABXX_8_2_qseq.txt";
        String keyfile = "M:/production/pe/key/81546ABXX_key.txt";
        String outputDirS = "M:/production/pe/PETagCounts/";
        String arguments = "-iF " + infile1 + " -iB " + infile2 + " -k " + keyfile + " -e ApekI -o " + outputDirS;
        String[] args = arguments.split(" ");
        QseqToPETagCountPlugin q = new QseqToPETagCountPlugin();
        q.setParameters(args);
        q.performFunction(null);
    }

    public void geneticMappingPipeline() {
        this.geneticMapping();
    }

    public void mkTagGWASMap() {
        String gwasMappingFileS = "M:/pipelineTest/geneticMapping/result/outfile.txt";
        String topmFileS = "M:/production/v3gbs/topm/bowtie2.topm.h5";
        String tagCountFileS = "M:/production/v3gbs/tagCount/AllZeaMasterTags_c10_20120606.cnt";
        String tagGWASMapFileS = "M:/pipelineTest/geneticMapping/tagAttributeMap/tagGwasMap.h5";
        new TagGWASMap(gwasMappingFileS, topmFileS, tagCountFileS, tagGWASMapFileS);
    }

    public void geneticMappingPlugin() {
        TagAgainstAnchorPlugin taa = new TagAgainstAnchorPlugin();
        String hapMapHDF5 = "M:/pipelineTest/geneticMapping/anchor/GBS27.small1024.sBit.h5";
        String tbtHDF5 = "M:/pipelineTest/geneticMapping/tbt/small4096TBTHDF5_mergedtaxa_pivot_20120921.h5";
        String blockFileS = "M:/pipelineTest/geneticMapping/tagBlock/block.tbp";
        String outfileS = "M:/pipelineTest/geneticMapping/result/outfile.txt";
        String arguments = "-g " + hapMapHDF5 + " -t " + tbtHDF5 + " -b " + blockFileS + " -o " + outfileS + " -m 20 -c max -s 32768 -cs 0 -ce 1";
        String[] args = arguments.split(" ");
        taa.setParameters(args);
        taa.performFunction(null);
    }

    public void geneticMapping() {
        String hapMapHDF5 = "M:/pipelineTest/geneticMapping/anchor/GBS27.small1024.sBit.h5";
        String tbtHDF5 = "M:/pipelineTest/geneticMapping/tbt/small4096TBTHDF5_mergedtaxa_pivot_20120921.h5";
        String blockFileS = "M:/pipelineTest/geneticMapping/tagBlock/block.tbp";
        String outfileS = "M:/pipelineTest/geneticMapping/result/outfile.txt";
        TagAgainstAnchor taa = new TagAgainstAnchor(hapMapHDF5, tbtHDF5, blockFileS, outfileS, 1.0E-6, 20, -1, 32768);
    }

    public void mkTBTTagBlock() {
        String tbtHDF5 = "M:/pipelineTest/geneticMapping/tbt/small4096TBTHDF5_mergedtaxa_pivot_20120921.h5";
        String topmFileS = "M:/pipelineTest/GBSV3test/topm/ini.topm.h5";
        String blockFileS = "M:/pipelineTest/geneticMapping/tagBlock/block.tbp";
        TagBlockPosition tbp = new TagBlockPosition(tbtHDF5, topmFileS, "Bowtie2");
        tbp.writeTagBlockPosition(blockFileS);
    }

    public void mkSmallTBTHDF5() {
        String inputTBTS = "M:/production/geneticMapping/tbt/mergeTBTHDF5_mergedtaxa_pivot_20120921.h5";
        String outputTBTS = "M:/pipelineTest/geneticMapping/tbt/small4096TBTHDF5_mergedtaxa_pivot_20120921.h5";
        TagsByTaxaByteHDF5TagGroups tbt = new TagsByTaxaByteHDF5TagGroups(inputTBTS);
        int[] tagIndex = new int[4096];
        for (int i = 0; i < tagIndex.length; ++i) {
            tagIndex[i] = i;
        }
        Arrays.sort(tagIndex);
        tbt.writeDistFile(outputTBTS, tagIndex);
    }

    public void transformAnchorHDF5() {
        String hapMapInputFileS = "M:/pipelineTest/geneticMapping/anchor/GBS27.small1024.T5.imp.hmp.h5";
        String sBitFileS = "M:/pipelineTest/geneticMapping/anchor/GBS27.small1024.sBit.h5";
        new SimpleGenotypeSBit(hapMapInputFileS, sBitFileS);
    }

    public void mkSmallAnchorHDF5() {
        String hapMapInputS = "M:/pipelineTest/geneticMapping/anchor/AllZeaGBSv27i3b.T5.imp.hmp.h5";
        String hapMapOutputS = "M:/pipelineTest/geneticMapping/anchor/GBS27.small1024.T5.imp.hmp.h5";
        GenotypeTable gt = ImportUtils.readGuessFormat(hapMapInputS);
        int[] index = new int[1024];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        FilterGenotypeTable ngt = FilterGenotypeTable.getInstance(gt, index);
        ExportUtils.writeGenotypeHDF5(ngt, hapMapOutputS);
    }

    public void migrateHDF5ToTASSEL5() {
        String hapMapInputS = "M:/production/GBSV3/genotype/GBS27.small1024.imp.hmp.h5";
        String hapMapOutputS = "M:/pipelineTest/geneticMapping/anchor/GBS27.small1024.T5.imp.hmp.h5";
        MigrateHDF5FromT4T5.copyGenotypes(hapMapInputS, hapMapOutputS);
    }

    public static void main(String[] args) {
        new PipelineTest();
    }
}

