/*
 * Decompiled with CFR 0.152.
 */
package format.text;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;

public class Table {
    public String[] header;
    public String[][] content;
    private int sortColumnIndex;
    Swapper swapper = new Swapper(){

        public void swap(int a, int b) {
            String[] temp = Table.this.content[a];
            Table.this.content[a] = Table.this.content[b];
            Table.this.content[b] = temp;
        }
    };
    IntComparator compByColumn = new IntComparator(){

        public int compare(int a, int b) {
            return Table.this.content[a][Table.this.sortColumnIndex].compareTo(Table.this.content[b][Table.this.sortColumnIndex]);
        }
    };

    public Table(String infileS) {
        this.readTable(infileS);
    }

    public Table(String infileS, int rowNum) {
        this.readTable(infileS, rowNum);
    }

    public Table(String[] header, String[][] content) {
        this.header = header;
        this.content = content;
    }

    public Table(String infileS, String splitCha) {
        this.readTable(infileS, splitCha);
    }

    public Table getSubTableByColumn(Table at, int[] index) {
        int i;
        String[] newHeader = new String[index.length];
        String[][] newContent = new String[this.getRowNumber()][index.length];
        for (i = 0; i < newHeader.length; ++i) {
            newHeader[i] = at.header[index[i]];
        }
        for (i = 0; i < this.getRowNumber(); ++i) {
            for (int j = 0; j < index.length; ++j) {
                newContent[i][j] = this.content[i][index[j]];
            }
        }
        return new Table(newHeader, newContent);
    }

    public Table getMergeTableByColumn(Table at) {
        if (this.getRowNumber() != at.getRowNumber()) {
            System.out.println("RowNumbers are not equal. Can't merge tables. Program quit.");
            System.exit(1);
        }
        String[] newHeader = new String[this.getColumnNumber() + at.getColumnNumber()];
        String[][] newContent = new String[this.getRowNumber()][newHeader.length];
        System.arraycopy(this.header, 0, newHeader, 0, this.getColumnNumber());
        System.arraycopy(at.header, 0, newHeader, this.getColumnNumber(), at.getColumnNumber());
        for (int i = 0; i < this.getRowNumber(); ++i) {
            System.arraycopy(this.content[i], 0, newContent[i], 0, this.getColumnNumber());
            System.arraycopy(at.content[i], 0, newContent[i], this.getColumnNumber(), at.getColumnNumber());
        }
        return new Table(newHeader, newContent);
    }

    public int getRowNumber() {
        return this.content.length;
    }

    public int getColumnNumber() {
        return this.header.length;
    }

    public String[] getContentByColumn(int columnIndex) {
        String[] temp = new String[this.getRowNumber()];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.content[i][columnIndex];
        }
        return temp;
    }

    private void readTable(String infileS) {
        int cnt = 0;
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(infileS), 65536);
            this.header = br.readLine().split("\t");
            while ((temp = br.readLine()) != null) {
                ++cnt;
            }
            this.content = new String[cnt][this.header.length];
            br.close();
            br = new BufferedReader(new FileReader(infileS), 65536);
            br.readLine();
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = br.readLine().split("\t");
                if (i % 10000 != 0) continue;
                System.out.println(i + " rows are read in Table");
            }
            System.out.println("Table " + infileS + " is load");
        }
        catch (Exception e) {
            System.out.println("Error occurred while reading Table file " + infileS);
        }
    }

    private void readTable(String infileS, int rowNum) {
        int cnt = 0;
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(infileS), 65536);
            this.header = br.readLine().split("\t");
            while ((temp = br.readLine()) != null) {
                ++cnt;
            }
            if (cnt < rowNum) {
                rowNum = cnt;
            }
            this.content = new String[rowNum][this.header.length];
            br.close();
            br = new BufferedReader(new FileReader(infileS), 65536);
            br.readLine();
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = br.readLine().split("\t");
                if (i % 10000 != 0 || i == 0) continue;
                System.out.println(i + " rows are read in Table");
            }
            System.out.println("Table " + infileS + " is load");
        }
        catch (Exception e) {
            System.out.println("Error occurred while reading Table file " + infileS);
        }
    }

    private void readTable(String infileS, String splitCha) {
        ArrayList<String> recordList = new ArrayList<String>();
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(infileS), 65536);
            this.header = br.readLine().split(splitCha);
            while ((temp = br.readLine()) != null) {
                recordList.add(temp);
            }
            String[] recordArray = recordList.toArray(new String[recordList.size()]);
            this.content = new String[recordArray.length][this.header.length];
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = recordArray[i].split(splitCha);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred while reading Table file " + infileS);
        }
    }

    public void writeTable(String outfileS) {
        try {
            int i;
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            for (i = 0; i < this.header.length; ++i) {
                bw.write(this.header[i] + "\t");
            }
            bw.newLine();
            for (i = 0; i < this.content.length; ++i) {
                for (int j = 0; j < this.header.length; ++j) {
                    bw.write(this.content[i][j] + "\t");
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.out.println("Error occurred while writing table file " + outfileS);
        }
    }

    public void writeTable(String outfileS, boolean[] ifout) {
        try {
            int i;
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            for (i = 0; i < this.header.length; ++i) {
                bw.write(this.header[i] + "\t");
            }
            bw.newLine();
            for (i = 0; i < this.content.length; ++i) {
                if (!ifout[i]) continue;
                for (int j = 0; j < this.header.length; ++j) {
                    bw.write(this.content[i][j] + "\t");
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.out.println("Error occurred while writing table file " + outfileS);
        }
    }

    public void writeTable(String outfileS, int[] indexList) {
        try {
            int i;
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            for (i = 0; i < this.header.length; ++i) {
                bw.write(this.header[i] + "\t");
            }
            bw.newLine();
            for (i = 0; i < indexList.length; ++i) {
                for (int j = 0; j < this.header.length; ++j) {
                    bw.write(this.content[indexList[i]][j] + "\t");
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.out.println("Error occurred while writing table file " + outfileS);
        }
    }

    public void sortByColumn(int columnIndex) {
        System.out.println("Start sorting table");
        this.sortColumnIndex = columnIndex;
        GenericSorting.quickSort((int)0, (int)this.getRowNumber(), (IntComparator)this.compByColumn, (Swapper)this.swapper);
        System.out.println("Finished sorting table");
    }
}

