/*
 * Decompiled with CFR 0.152.
 */
package analysis.panAnchor;

import analysis.panAnchor.Mo17Utils;
import format.text.Fasta;
import format.text.SimpleAlignment;
import net.maizegenetics.dna.map.TagsOnGeneticMap;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class PanGo {
    public void mo17ContigPipe() {
    }

    public void statisticsMo17Contig() {
        String mo17Ref = "M:\\production\\panGenome\\mo17\\genome\\Mo17_scaffolds_201403.fa";
        String mo17LengthFileS = "M:\\production\\panGenome\\mo17\\genome\\statistics\\contigLength.txt";
        Fasta f = new Fasta(mo17Ref);
        f.sortRecordByLengthDescending();
        f.writeLength(mo17LengthFileS);
        System.out.println(f.getSeqNumber() + "\t" + f.getTotalSeqLength());
    }

    public void mo17ScaffoldPipe() {
    }

    public void anchorError() {
        String assemblyQualityFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\quality.txt";
        String goodContigList = "M:\\production\\panGenome\\mo17\\evaluationAnchor\\goodContigList.txt";
        String goodContigError = "M:\\production\\panGenome\\mo17\\evaluationAnchor\\goodContigError.txt";
        new Mo17Utils().mkGoodContigError(assemblyQualityFileS, goodContigList, goodContigError);
    }

    public void statisticsAssembly() {
        String anchorOnContigFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\anchorOnContig.txt";
        String assemblyQualityFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\quality.txt";
        new Mo17Utils().mkStatisticsAssembly(anchorOnContigFileS, assemblyQualityFileS);
        String barPlotFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\bar.txt";
        new Mo17Utils().mkBarQualityAssembly(assemblyQualityFileS, barPlotFileS, 50000, 1000000);
    }

    public void evaluteAnchorByBlast() {
        String assemblyQualityFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\quality.txt";
        String mo17Ref = "M:\\production\\panGenome\\mo17\\genome\\Mo17_scaffolds_201403.fa";
        String fragmentFileS = "M:\\production\\panGenome\\mo17\\evalutetionAnchorByBlast\\goodScaffold_frag.fa";
        String samFileS = "M:\\production\\panGenome\\mo17\\evalutetionAnchorByBlast\\fragOnB73.sam";
        String anchorOnContigFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\anchorOnContig.txt";
        String compareFileS = "M:\\production\\panGenome\\mo17\\evalutetionAnchorByBlast\\goodScaffoldAnchorVsAlign.txt";
        String chrInfoFileS = "E:\\Database\\InfoFile\\ChrLenCentPosi.txt";
        String syntenyDirS = "M:\\production\\panGenome\\mo17\\evalutetionAnchorByBlast\\synteny_blastDisagree\\";
        new Mo17Utils().mkDisagreementBlastSyntenyGraph(samFileS, compareFileS, chrInfoFileS, syntenyDirS);
    }

    public void evaluateAnchor2() {
        String bowtie2FileS = "M:\\production\\panGenome\\mo17\\evaluationAnchor\\scaffoldOnB73.sam";
        String alignFileS = "M:\\production\\panGenome\\mo17\\evaluationAnchor\\scaffoldOnB73.saln.txt";
        SimpleAlignment sa = new SimpleAlignment();
        sa.readFromBowtie2(bowtie2FileS);
        sa.writeSimpleAlignment(alignFileS);
        String chrInfoFileS = "E:\\Database\\InfoFile\\ChrLenCentPosi.txt";
        String fragmentOnChrFileS = "M:\\production\\panGenome\\mo17\\evaluationAnchor\\fragmentOnChr.txt";
        new Mo17Utils().mkFragmentOnChromosome(alignFileS, chrInfoFileS, fragmentOnChrFileS);
        String syntenyDirS = "M:\\production\\panGenome\\mo17\\evaluationAnchor\\synteny\\";
        new Mo17Utils().mkSyntenyGraph(fragmentOnChrFileS, chrInfoFileS, syntenyDirS, 1);
    }

    public void evaluateAnchor1() {
        String mo17Ref = "M:\\production\\panGenome\\mo17\\genome\\Mo17_scaffolds_201403.fa";
        String scaffold = "scaffold162";
        String fragmentFileS = "M:\\production\\panGenome\\mo17\\evaluationAnchor\\" + scaffold + ".fa";
        new Mo17Utils().mkScaffoldFragments(mo17Ref, scaffold, fragmentFileS);
    }

    public void mkSynteny() {
        String anchorOnContigFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\anchorOnContig.txt";
        String chrInfoFileS = "E:\\Database\\InfoFile\\ChrLenCentPosi.txt";
        String syntenyDirS = "M:\\production\\panGenome\\mo17\\synteny\\";
        new Mo17Utils().mkSyntenyGraph(anchorOnContigFileS, chrInfoFileS, syntenyDirS, 5000);
    }

    public void mkAnchorOnContig() {
        String alignFileS = "M:\\production\\panGenome\\mo17\\alignment\\togmOnMo17.saln.txt";
        String contigLengthFileS = "M:\\production\\panGenome\\mo17\\genome\\statistics\\contigLength.txt";
        String anchorFileS = "M:\\pav\\PhyGenMapping\\v1.paper.txt";
        String anchorOnContigFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\anchorOnContig.txt";
        String satisticsFileS = "M:\\production\\panGenome\\mo17\\anchorOnContig\\anchorOnContig_statistics.txt";
        new Mo17Utils().mkAnchorOnContigFile(alignFileS, contigLengthFileS, anchorFileS, anchorOnContigFileS, satisticsFileS);
    }

    public void readInBowtie2() {
        String bowtie2FileS = "M:\\production\\panGenome\\mo17\\alignment\\togmOnMo17.sam";
        String alignFileS = "M:\\production\\panGenome\\mo17\\alignment\\togmOnMo17.saln.txt";
        SimpleAlignment sa = new SimpleAlignment();
        sa.readFromBowtie2(bowtie2FileS);
        sa.writeSimpleAlignment(alignFileS);
    }

    public void convertToFastQ() {
        String togmFileS = "M:\\pav\\PhyGenMapping\\v1.togm.txt";
        String fastqFileS = "M:\\production\\panGenome\\mo17\\alignment\\v1.togm.fq";
        TagsOnGeneticMap togm = new TagsOnGeneticMap(togmFileS, TagsByTaxa.FilePacking.Text);
        togm.writeFastQ(fastqFileS);
    }

    public void statisticsMo17() {
        String mo17Ref = "M:\\production\\panGenome\\mo17\\genome\\Mo17_scaffolds_201403.fa";
        String mo17LengthFileS = "M:\\production\\panGenome\\mo17\\genome\\statistics\\contigLength.txt";
        Fasta f = new Fasta(mo17Ref);
        f.sortRecordByLengthDescending();
        f.writeLength(mo17LengthFileS);
        System.out.println(f.getSeqNumber() + "\t" + f.getTotalSeqLength());
    }

    public static void main(String[] args) {
        new PanGo();
    }
}

