/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.stats.linearmodels.BasicLevel;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.MarkerPhenotype;
import net.maizegenetics.trait.MarkerPhenotypeAdapterUtils;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.Trait;

public class MarkerPhenotypeAdapter {
    protected MarkerPhenotype markerpheno;
    protected Phenotype pheno;
    protected GenotypeTable align;
    protected int numberOfPhenotypes;
    protected int numberOfFactorTraits;
    protected int numberOfCovariates;
    protected int numberOfMarkers;
    protected int numberOfMarkersFromAlignment;
    protected int numberOfMarkersFromPhenotype;
    protected ArrayList<String> phenotypeNames;
    protected ArrayList<String> covariateNames;
    protected ArrayList<String> factorNames;
    protected ArrayList<ArrayList<PhenotypeInfo>> blockList;
    protected HashMap<String, HashMap<BasicLevel, Integer>> covariateTraitMap;
    protected HashMap<String, HashMap<BasicLevel, Integer>> factorTraitMap;
    protected ArrayList<Integer> markerIndex;

    public MarkerPhenotypeAdapter(Phenotype aPhenotype) {
        this.markerpheno = null;
        this.align = null;
        this.pheno = aPhenotype;
        this.init();
    }

    public MarkerPhenotypeAdapter(MarkerPhenotype aMarkerPhenotype) {
        this.markerpheno = aMarkerPhenotype;
        this.align = aMarkerPhenotype.getAlignment();
        this.pheno = aMarkerPhenotype.getPhenotype();
        this.init();
    }

    protected void init() {
        Trait trait;
        int i;
        this.numberOfMarkersFromAlignment = this.align == null ? 0 : this.align.numberOfSites();
        if (!this.areTraitFactorsConsistent()) {
            throw new IllegalArgumentException("Some traits have inconsistent headers. No analysis will be performed");
        }
        TreeSet<String> datanameSet = new TreeSet<String>();
        this.covariateTraitMap = new HashMap();
        this.factorTraitMap = new HashMap();
        this.markerIndex = new ArrayList();
        int nTraits = this.pheno.getNumberOfTraits();
        for (i = 0; i < nTraits; ++i) {
            String name;
            trait = this.pheno.getTrait(i);
            if (trait.getType().equals("data")) {
                datanameSet.add(trait.getName());
            }
            if (trait.getType().equals("covariate")) {
                name = trait.getName();
                HashMap<BasicLevel, Integer> covmap = this.covariateTraitMap.get(name);
                if (covmap == null) {
                    covmap = new HashMap();
                    this.covariateTraitMap.put(name, covmap);
                }
                covmap.put(this.getTraitLevel(trait), i);
            }
            if (trait.getType().equals("factor")) {
                name = trait.getName();
                HashMap<BasicLevel, Integer> facmap = this.factorTraitMap.get(name);
                if (facmap == null) {
                    facmap = new HashMap();
                    this.factorTraitMap.put(name, facmap);
                }
                facmap.put(this.getTraitLevel(trait), i);
            }
            if (!trait.getType().equals("marker")) continue;
            this.markerIndex.add(i);
        }
        this.numberOfPhenotypes = datanameSet.size();
        this.phenotypeNames = new ArrayList(datanameSet);
        this.numberOfCovariates = this.covariateTraitMap.size();
        this.covariateNames = new ArrayList<String>(this.covariateTraitMap.keySet());
        Collections.sort(this.covariateNames);
        this.numberOfFactorTraits = this.factorTraitMap.size();
        this.factorNames = new ArrayList<String>(this.factorTraitMap.keySet());
        Collections.sort(this.factorNames);
        this.numberOfMarkersFromPhenotype = this.markerIndex.size();
        this.numberOfMarkers = this.numberOfMarkersFromAlignment + this.numberOfMarkersFromPhenotype;
        this.blockList = new ArrayList();
        for (int p = 0; p < this.numberOfPhenotypes; ++p) {
            this.blockList.add(new ArrayList());
        }
        for (i = 0; i < nTraits; ++i) {
            trait = this.pheno.getTrait(i);
            if (!trait.getType().equals("data")) continue;
            int ndx = Collections.binarySearch(this.phenotypeNames, trait.getName());
            BasicLevel level = this.getTraitLevel(trait);
            this.blockList.get(ndx).add(new PhenotypeInfo(i, level, trait.getName()));
        }
        String msg = this.checkFactorCovariateEnvironments();
        if (msg.length() > 0) {
            throw new IllegalArgumentException("No analysis will be run:\n" + msg);
        }
    }

    public boolean areTraitFactorsConsistent() {
        if (this.pheno.getNumberOfFactors() == 0) {
            return true;
        }
        String[] factors = this.pheno.getFactorNameCopy();
        for (Trait trait : this.pheno.getTraits()) {
            ArrayList<String> factorlist = trait.getFactorNames();
            if (factorlist == null || factorlist.size() <= 0) continue;
            if (factorlist.size() != factors.length) {
                return false;
            }
            for (int i = 0; i < factors.length; ++i) {
                if (factorlist.contains(factors[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String checkFactorCovariateEnvironments() {
        BasicLevel level;
        StringBuilder msg = new StringBuilder();
        HashSet<BasicLevel> levelSet = new HashSet<BasicLevel>();
        for (ArrayList<PhenotypeInfo> arrayList : this.blockList) {
            for (PhenotypeInfo pi : arrayList) {
                levelSet.add(pi.level);
            }
        }
        for (Map.Entry entry : this.factorTraitMap.entrySet()) {
            boolean consistent = true;
            for (Map.Entry ent : ((HashMap)entry.getValue()).entrySet()) {
                level = (BasicLevel)ent.getKey();
                if (level == null || level.getNumberOfSublevels() <= 0 || levelSet.contains(level)) continue;
                consistent = false;
            }
            if (consistent) continue;
            String factorname = (String)entry.getKey();
            msg.append("The factor " + factorname + " has environments that are inconsistent with the data.\n");
        }
        for (Map.Entry entry : this.covariateTraitMap.entrySet()) {
            boolean consistent = true;
            for (Map.Entry ent : ((HashMap)entry.getValue()).entrySet()) {
                level = (BasicLevel)ent.getKey();
                if (level == null || level.getNumberOfSublevels() <= 0 || levelSet.contains(level)) continue;
                consistent = false;
            }
            if (consistent) continue;
            String covname = (String)entry.getKey();
            msg.append("The covariate " + covname + " has environments that are inconsistent with the data.\n");
        }
        return msg.toString();
    }

    public BasicLevel getTraitLevel(Trait trait) {
        String[] factorName = this.pheno.getFactorNameCopy();
        int nFactors = factorName.length;
        if (trait.getNumberOfFactors() != nFactors) {
            return null;
        }
        String[] level = new String[nFactors];
        for (int i = 0; i < nFactors; ++i) {
            level[i] = trait.getFactorValue(factorName[i]);
        }
        return new BasicLevel((Comparable[])level);
    }

    public int getNumberOfRows(int phenotype) {
        int blocks = this.blockList.get(phenotype).size();
        return this.pheno.getNumberOfTaxa() * blocks;
    }

    public int getNumberOfBlocks(int phenotype) {
        return this.blockList.get(phenotype).size();
    }

    public int getNumberOfPhenotypes() {
        return this.numberOfPhenotypes;
    }

    public double[] getPhenotypeValues(int i) {
        double[] phenotype = new double[this.getNumberOfRows(i)];
        int ntaxa = this.pheno.getNumberOfTaxa();
        int block = 0;
        for (PhenotypeInfo info : this.blockList.get(i)) {
            for (int t = 0; t < ntaxa; ++t) {
                phenotype[block * ntaxa + t] = this.pheno.getData(t, info.index);
            }
            ++block;
        }
        return phenotype;
    }

    public boolean[] getMissingPhenotypes(int phenotype) {
        return MarkerPhenotypeAdapterUtils.whichAreMissing(this.getPhenotypeValues(phenotype));
    }

    public String getPhenotypeName(int i) {
        return this.phenotypeNames.get(i);
    }

    public int getNumberOfFactors() {
        return this.numberOfFactorTraits + this.pheno.getNumberOfFactors();
    }

    public String[] getFactorValues(int phenotype, int factor) {
        int nrows = this.getNumberOfRows(phenotype);
        String[] factorvalue = new String[nrows];
        int ntaxa = this.pheno.getNumberOfTaxa();
        int numberOfPhenoFactors = this.pheno.getNumberOfFactors();
        if (factor < numberOfPhenoFactors) {
            factorvalue = new String[nrows];
            int block = 0;
            for (PhenotypeInfo info : this.blockList.get(phenotype)) {
                for (int t = 0; t < ntaxa; ++t) {
                    factorvalue[block * ntaxa + t] = (String)((Object)info.level.getSublevel(factor));
                }
                ++block;
            }
        } else {
            factor -= numberOfPhenoFactors;
            factorvalue = new String[nrows];
            int block = 0;
            for (PhenotypeInfo info : this.blockList.get(phenotype)) {
                Integer ndx = this.factorTraitMap.get(this.factorNames.get(factor)).get(null);
                if (ndx == null) {
                    ndx = this.factorTraitMap.get(this.factorNames.get(factor)).get(info.level);
                }
                String[] factorlevel = this.pheno.getTrait(ndx).getLevelLabels();
                for (int t = 0; t < ntaxa; ++t) {
                    factorvalue[block * ntaxa + t] = factorlevel[(int)this.pheno.getData(t, ndx)];
                }
                ++block;
            }
        }
        return factorvalue;
    }

    public boolean[] getMissingFactors(int phenotype, int factor) {
        return MarkerPhenotypeAdapterUtils.whichAreMissing(this.getFactorValues(phenotype, factor));
    }

    public String getFactorName(int i) {
        if (i < this.pheno.getNumberOfFactors()) {
            return this.pheno.getFactorName(i);
        }
        return this.factorNames.get(i - this.pheno.getNumberOfFactors());
    }

    public int getNumberOfCovariates() {
        return this.numberOfCovariates;
    }

    public double[] getCovariateValues(int phenotype, int covariate) {
        double[] cov = new double[this.getNumberOfRows(phenotype)];
        int ntaxa = this.pheno.getNumberOfTaxa();
        int block = 0;
        for (PhenotypeInfo info : this.blockList.get(phenotype)) {
            Integer ndx = this.covariateTraitMap.get(this.covariateNames.get(covariate)).get(null);
            if (ndx == null) {
                ndx = this.covariateTraitMap.get(this.covariateNames.get(covariate)).get(info.level);
            }
            for (int t = 0; t < ntaxa; ++t) {
                cov[block * ntaxa + t] = ndx != null ? this.pheno.getData(t, ndx) : Double.NaN;
            }
            ++block;
        }
        return cov;
    }

    public boolean[] getMissingCovariates(int phenotype, int covariate) {
        return MarkerPhenotypeAdapterUtils.whichAreMissing(this.getCovariateValues(phenotype, covariate));
    }

    public String getCovariateName(int i) {
        return this.covariateNames.get(i);
    }

    public int getNumberOfMarkers() {
        return this.numberOfMarkers;
    }

    public boolean isMarkerDiscrete(int i) {
        if (i < this.numberOfMarkersFromAlignment) {
            return true;
        }
        return this.pheno.getTrait(this.markerIndex.get(i -= this.numberOfMarkersFromAlignment)).isDiscrete();
    }

    public String getMarkerName(int i) {
        if (i < this.numberOfMarkersFromAlignment) {
            return this.align.siteName(i);
        }
        int t = this.markerIndex.get(i - this.numberOfMarkersFromAlignment);
        return this.pheno.getTrait(t).getName();
    }

    public String getMarkerChromosome(int marker) {
        if (marker < this.numberOfMarkersFromAlignment) {
            return this.align.chromosome(marker).getName();
        }
        int t = this.markerIndex.get(marker - this.numberOfMarkersFromAlignment);
        Object prop = this.pheno.getTrait(t).getProperty("chromosome");
        if (prop == null) {
            return "";
        }
        return prop.toString();
    }

    public double getMarkerChromosomePosition(int marker) {
        if (marker < this.numberOfMarkersFromAlignment) {
            return this.align.chromosomalPosition(marker);
        }
        int t = this.markerIndex.get(marker - this.numberOfMarkersFromAlignment);
        Object chrpos = this.pheno.getTrait(t).getProperty("position");
        if (chrpos == null) {
            return Double.NaN;
        }
        return (Double)chrpos;
    }

    public String getLocusName(int marker) {
        if (marker < this.numberOfMarkersFromAlignment) {
            return this.align.chromosomeName(marker);
        }
        int t = this.markerIndex.get(marker - this.numberOfMarkersFromAlignment);
        Object locusName = this.pheno.getTrait(t).getProperty("locus");
        if (locusName == null) {
            return "Unknown";
        }
        return locusName.toString();
    }

    public int getLocusPosition(int marker) {
        if (marker < this.numberOfMarkersFromAlignment) {
            return this.align.chromosomalPosition(marker);
        }
        int t = this.markerIndex.get(marker - this.numberOfMarkersFromAlignment);
        Object prop = this.pheno.getTrait(t).getProperty("locusposition");
        if (prop == null || !(prop instanceof Integer)) {
            return marker;
        }
        return (Integer)prop;
    }

    public Object[] getMarkerValue(int phenotype, int marker) {
        int nrows = this.getNumberOfRows(phenotype);
        int nblocks = this.getNumberOfBlocks(phenotype);
        int ntaxa = this.pheno.getNumberOfTaxa();
        if (marker < this.numberOfMarkersFromAlignment) {
            Object[] values = new String[nrows];
            for (int b = 0; b < nblocks; ++b) {
                for (int t = 0; t < ntaxa; ++t) {
                    values[b * ntaxa + t] = this.markerpheno.getAlignment().genotypeAsString(t, marker);
                }
            }
            return values;
        }
        int ndx = this.markerIndex.get(marker - this.numberOfMarkersFromAlignment);
        if (this.isMarkerDiscrete(marker - this.numberOfMarkersFromAlignment)) {
            Object[] values = new String[nrows];
            for (int b = 0; b < nblocks; ++b) {
                String[] labels = this.pheno.getTrait(ndx).getLevelLabels();
                for (int t = 0; t < ntaxa; ++t) {
                    double val = this.pheno.getData(t, ndx);
                    values[b * ntaxa + t] = Double.isNaN(val) ? "?" : labels[(int)val];
                }
            }
            return values;
        }
        Object[] values = new Double[nrows];
        for (int b = 0; b < nblocks; ++b) {
            for (int t = 0; t < ntaxa; ++t) {
                values[b * ntaxa + t] = this.pheno.getData(t, this.markerIndex.get(marker));
            }
        }
        return values;
    }

    public boolean[] getMissingMarkers(int phenotype, int marker) {
        Object[] values = this.getMarkerValue(phenotype, marker);
        return MarkerPhenotypeAdapterUtils.whichAreMissing(values);
    }

    public Taxon[] getTaxa(int phenotype) {
        int nrows = this.getNumberOfRows(phenotype);
        Taxon[] names = new Taxon[nrows];
        int ntaxa = this.pheno.getNumberOfTaxa();
        int nblocks = this.getNumberOfBlocks(phenotype);
        for (int b = 0; b < nblocks; ++b) {
            for (int t = 0; t < ntaxa; ++t) {
                names[b * ntaxa + t] = this.pheno.getTaxon(t);
            }
        }
        return names;
    }

    public boolean hasMarkerNames() {
        if (this.numberOfMarkersFromPhenotype > 0) {
            return true;
        }
        return this.numberOfMarkersFromAlignment > 0 && this.align.siteName(0) != null;
    }

    class PhenotypeInfo {
        int index;
        BasicLevel level;
        String name;

        PhenotypeInfo(int index, BasicLevel level, String name) {
            this.index = index;
            this.level = level;
            this.name = name;
        }
    }
}

