/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.tree.AttributeNode;
import net.maizegenetics.taxa.tree.LabelMapping;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.NodeUtils;

public class SimpleNode
implements AttributeNode {
    private Node parent;
    private int number;
    private byte[] sequence;
    private double length;
    private double lengthSE;
    private double height;
    private Taxon identifier;
    private Hashtable attributes = null;
    private Node[] child;
    static final long serialVersionUID = 3472432765038556717L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(3);
        out.writeObject(this.parent);
        out.writeInt(this.number);
        out.writeObject(this.sequence);
        out.writeDouble(this.length);
        out.writeDouble(this.lengthSE);
        out.writeDouble(this.height);
        out.writeObject(this.identifier);
        out.writeObject(this.child);
        out.writeObject(this.attributes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.parent = (Node)in.readObject();
                this.number = in.readInt();
                this.sequence = (byte[])in.readObject();
                double[][][] partial = (double[][][])in.readObject();
                this.length = in.readDouble();
                this.lengthSE = in.readDouble();
                this.height = in.readDouble();
                in.readDouble();
                this.identifier = (Taxon)in.readObject();
                this.child = (Node[])in.readObject();
                break;
            }
            case 2: {
                this.parent = (Node)in.readObject();
                this.number = in.readInt();
                this.sequence = (byte[])in.readObject();
                this.length = in.readDouble();
                this.lengthSE = in.readDouble();
                this.height = in.readDouble();
                this.identifier = (Taxon)in.readObject();
                this.child = (Node[])in.readObject();
                break;
            }
            default: {
                this.parent = (Node)in.readObject();
                this.number = in.readInt();
                this.sequence = (byte[])in.readObject();
                this.length = in.readDouble();
                this.lengthSE = in.readDouble();
                this.height = in.readDouble();
                this.identifier = (Taxon)in.readObject();
                this.child = (Node[])in.readObject();
                this.attributes = (Hashtable)in.readObject();
            }
        }
    }

    public SimpleNode() {
        this.parent = null;
        this.child = null;
        this.length = 0.0;
        this.lengthSE = 0.0;
        this.height = 0.0;
        this.identifier = Taxon.ANONYMOUS;
        this.number = 0;
        this.sequence = null;
    }

    public SimpleNode(String name, double branchLength) {
        this();
        this.identifier = new Taxon(name);
        this.length = branchLength;
    }

    protected SimpleNode(Node[] children, double branchLength) {
        this();
        this.child = children;
        if (children.length == 1) {
            throw new IllegalArgumentException("Must have more than one child!");
        }
        for (int i = 0; i < this.child.length; ++i) {
            this.child[i].setParent(this);
        }
        this.length = branchLength;
    }

    protected SimpleNode(Node[] children) {
        this(children, 1.0E-9);
    }

    public SimpleNode(Node n) {
        this(n, true);
    }

    public void reset() {
        this.parent = null;
        this.child = null;
        this.length = 0.0;
        this.lengthSE = 0.0;
        this.height = 0.0;
        this.identifier = Taxon.ANONYMOUS;
        this.number = 0;
        this.sequence = null;
    }

    public SimpleNode(Node n, boolean keepIds) {
        this.init(n, keepIds);
        for (int i = 0; i < n.getChildCount(); ++i) {
            this.addChild(new SimpleNode(n.getChild(i), keepIds));
        }
    }

    public SimpleNode(Node n, LabelMapping lm) {
        this.init(n, true, lm);
        for (int i = 0; i < n.getChildCount(); ++i) {
            this.addChild(new SimpleNode(n.getChild(i), lm));
        }
    }

    protected void init(Node n) {
        this.init(n, true);
    }

    protected void init(Node n, boolean keepId) {
        this.init(n, keepId, null);
    }

    protected void init(Node n, boolean keepId, LabelMapping lm) {
        this.parent = null;
        this.length = n.getBranchLength();
        this.lengthSE = n.getBranchLengthSE();
        this.height = n.getNodeHeight();
        this.identifier = keepId ? (lm != null ? lm.getLabelIdentifier(n.getIdentifier()) : n.getIdentifier()) : Taxon.ANONYMOUS;
        this.number = n.getNumber();
        this.sequence = n.getSequence();
        if (n instanceof AttributeNode) {
            AttributeNode attNode = (AttributeNode)n;
            Enumeration e = attNode.getAttributeNames();
            while (e != null && e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.setAttribute(name, attNode.getAttribute(name));
            }
        }
        this.child = null;
    }

    @Override
    public final Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node node) {
        this.parent = node;
    }

    public final void removeParent() {
        this.parent = null;
    }

    public String getSequenceString() {
        return new String(this.sequence);
    }

    @Override
    public byte[] getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(byte[] s) {
        this.sequence = s;
    }

    @Override
    public final double getBranchLength() {
        return this.length;
    }

    @Override
    public final void setBranchLength(double value) {
        this.length = value;
    }

    @Override
    public final double getBranchLengthSE() {
        return this.lengthSE;
    }

    @Override
    public final void setBranchLengthSE(double value) {
        this.lengthSE = value;
    }

    @Override
    public final double getNodeHeight() {
        return this.height;
    }

    @Override
    public final void setNodeHeight(double value) {
        this.height = value < 0.0 ? -value : value;
    }

    @Override
    public final void setNodeHeight(double value, boolean adjustChildBranchLengths) {
        this.height = value < 0.0 ? -value : value;
        if (adjustChildBranchLengths && this.child != null) {
            for (int i = 0; i < this.child.length; ++i) {
                this.child[i].setBranchLength(this.height - this.child[i].getNodeHeight());
            }
        }
    }

    @Override
    public final Taxon getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(Taxon id) {
        this.identifier = id;
    }

    @Override
    public void setNumber(int n) {
        this.number = n;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public Node getChild(int n) {
        return this.child[n];
    }

    @Override
    public void setChild(int n, Node node) {
        this.child[n] = node;
        this.child[n].setParent(this);
    }

    public boolean hasChildren() {
        return !this.isLeaf();
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public void addChild(Node n) {
        this.insertChild(n, this.getChildCount());
    }

    @Override
    public void insertChild(Node n, int pos) {
        int i;
        int numChildren = this.getChildCount();
        Node[] newChild = new Node[numChildren + 1];
        for (i = 0; i < pos; ++i) {
            newChild[i] = this.child[i];
        }
        newChild[pos] = n;
        for (i = pos; i < numChildren; ++i) {
            newChild[i + 1] = this.child[i];
        }
        this.child = newChild;
        n.setParent(this);
    }

    @Override
    public Node removeChild(int n) {
        int i;
        int numChildren = this.getChildCount();
        if (n >= numChildren) {
            throw new IllegalArgumentException("Nonexistent child");
        }
        Node[] newChild = new Node[numChildren - 1];
        for (i = 0; i < n; ++i) {
            newChild[i] = this.child[i];
        }
        for (i = n; i < numChildren - 1; ++i) {
            newChild[i] = this.child[i + 1];
        }
        Node removed = this.child[n];
        removed.setParent(null);
        this.child = newChild;
        return removed;
    }

    public void lengths2HeightsContemp() {
        double largestHeight = 0.0;
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                NodeUtils.lengths2Heights(this.getChild(i));
                double newHeight = this.getChild(i).getNodeHeight() + this.getChild(i).getBranchLength();
                if (!(newHeight > largestHeight)) continue;
                largestHeight = newHeight;
            }
        }
        this.setNodeHeight(largestHeight);
    }

    @Override
    public final void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, value);
    }

    @Override
    public final Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public final Enumeration getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keys();
    }

    @Override
    public final int getChildCount() {
        if (this.child == null) {
            return 0;
        }
        return this.child.length;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        NodeUtils.printNH(new PrintWriter(sw), this, true, false, 0, false);
        return sw.toString();
    }
}

