/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import java.util.ArrayList;
import java.util.TreeSet;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

public class TaxaListUtils {
    private TaxaListUtils() {
    }

    public static TaxaList getCommonTaxa(TaxaList group1, TaxaList group2) {
        return TaxaListUtils.getCommonTaxa(new TaxaList[]{group1, group2});
    }

    public static TaxaList getCommonTaxa(TaxaList[] groups) {
        if (groups == null || groups.length == 0) {
            return null;
        }
        TreeSet<Taxon> intersectIds = new TreeSet<Taxon>();
        for (int x = 0; x < groups[0].numberOfTaxa(); ++x) {
            intersectIds.add((Taxon)groups[0].get(x));
        }
        for (int i = 1; i < groups.length; ++i) {
            ArrayList temp = new ArrayList();
            for (int j = 0; j < groups[i].numberOfTaxa(); ++j) {
                temp.add(groups[i].get(j));
            }
            intersectIds.retainAll(temp);
        }
        TaxaListBuilder builder = new TaxaListBuilder();
        builder.addAll(intersectIds);
        return builder.build();
    }

    public static TaxaList getAllTaxa(TaxaList group1, TaxaList group2) {
        return TaxaListUtils.getAllTaxa(new TaxaList[]{group1, group2});
    }

    public static TaxaList getAllTaxa(TaxaList[] groups) {
        if (groups == null || groups.length == 0) {
            return null;
        }
        TreeSet<Taxon> allIds = new TreeSet<Taxon>();
        for (int i = 0; i < groups.length; ++i) {
            int n = groups[i].numberOfTaxa();
            for (int j = 0; j < n; ++j) {
                allIds.add((Taxon)groups[i].get(j));
            }
        }
        TaxaListBuilder builder = new TaxaListBuilder();
        builder.addAll(allIds);
        return builder.build();
    }
}

