/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.AbstractTableReport;
import net.maizegenetics.util.Report;
import net.maizegenetics.util.TableReport;

public class IdentifierSynonymizer
extends AbstractTableReport
implements Serializable,
Report,
TableReport {
    HashMap<String, Integer> idSynonyms = new HashMap();
    private TaxaList referenceIDGroup;
    private int unmatchCount = 0;

    public IdentifierSynonymizer(TaxaList preferredTaxa, TaxaList[] alternateTaxaSets) {
        this.init(preferredTaxa, alternateTaxaSets);
    }

    public IdentifierSynonymizer(TaxaList preferredTaxa, TaxaList alternateTaxa) {
        TaxaList[] alternateTaxaSets = new TaxaList[]{alternateTaxa};
        this.init(preferredTaxa, alternateTaxaSets);
    }

    private void init(TaxaList preferredTaxa, TaxaList[] alternateTaxaSets) {
        this.referenceIDGroup = preferredTaxa;
        for (int i = 0; i < this.referenceIDGroup.numberOfTaxa(); ++i) {
            this.idSynonyms.put(this.referenceIDGroup.taxaName(i), i);
        }
        for (int a = 0; a < alternateTaxaSets.length; ++a) {
            for (int i = 0; i < alternateTaxaSets[a].numberOfTaxa(); ++i) {
                Taxon currID = (Taxon)alternateTaxaSets[a].get(i);
                if (this.idSynonyms.containsKey(currID.getName())) continue;
                ArrayList<String> theBest = this.findBestMatch(currID.toString());
                if (theBest.size() == 1) {
                    String bs = theBest.get(0);
                    int indexOfBest = this.referenceIDGroup.indexOf(bs);
                    this.idSynonyms.put(currID.toString(), indexOfBest);
                    continue;
                }
                this.idSynonyms.put(currID.toString(), -1);
                ++this.unmatchCount;
            }
        }
    }

    private ArrayList<String> findBestMatch(String unmatchedString) {
        ArrayList<String> bestMatches = new ArrayList<String>();
        double maxScore = -1.0;
        boolean ignoreCase = true;
        boolean ignoreWhite = false;
        boolean ignorePunc = false;
        for (int levelOfRestriction = 0; bestMatches.size() != 1 && levelOfRestriction < 4; ++levelOfRestriction) {
            switch (levelOfRestriction) {
                case 1: {
                    ignoreCase = true;
                    break;
                }
                case 2: {
                    ignoreWhite = true;
                    break;
                }
                case 3: {
                    ignorePunc = true;
                }
            }
            for (int i = 0; i < this.referenceIDGroup.numberOfTaxa(); ++i) {
                double sm = IdentifierSynonymizer.scoreMatch(this.referenceIDGroup.taxaName(i), unmatchedString, ignoreCase, ignoreWhite, ignorePunc);
                if (sm > maxScore) {
                    bestMatches.clear();
                    bestMatches.add(this.referenceIDGroup.taxaName(i));
                    maxScore = sm;
                    continue;
                }
                if (sm != maxScore) continue;
                bestMatches.add(this.referenceIDGroup.taxaName(i));
            }
        }
        return bestMatches;
    }

    public ArrayList<String> findOrderedMatches(String unmatchedString, int levelOfRestriction) {
        TreeMap<Double, String> theSortMap = new TreeMap<Double, String>();
        boolean ignoreCase = false;
        boolean ignoreWhite = false;
        boolean ignorePunc = false;
        if (levelOfRestriction > 0) {
            ignoreCase = true;
        }
        if (levelOfRestriction > 1) {
            ignoreWhite = true;
        }
        if (levelOfRestriction > 2) {
            ignorePunc = true;
        }
        for (int i = 0; i < this.referenceIDGroup.numberOfTaxa(); ++i) {
            double sm = IdentifierSynonymizer.scoreMatch(this.referenceIDGroup.taxaName(i), unmatchedString, ignoreCase, ignoreWhite, ignorePunc);
            theSortMap.put(1.0 - sm - (double)i / 100000.0, this.referenceIDGroup.taxaName(i));
        }
        return new ArrayList<String>(theSortMap.values());
    }

    private double scoreMatch2(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        int score = 0;
        s1 = IdentifierSynonymizer.cleanName(s1, ignoreCase, ignoreWhite, ignorePunc);
        s2 = IdentifierSynonymizer.cleanName(s2, ignoreCase, ignoreWhite, ignorePunc);
        block0: for (int c1 = 0; c1 < s1.length() - 1; ++c1) {
            for (int c2 = 0; c2 < s2.length() - 1; ++c2) {
                if (s1.charAt(c1) != s2.charAt(c2) || s1.charAt(c1 + 1) != s2.charAt(c2 + 1)) continue;
                ++score;
                continue block0;
            }
        }
        double sm = 2.0 * (double)score / (double)(s1.length() + s2.length() - 2);
        return sm;
    }

    public static double scoreMatch(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        s1 = IdentifierSynonymizer.cleanName(s1, ignoreCase, ignoreWhite, ignorePunc);
        s2 = IdentifierSynonymizer.cleanName(s2, ignoreCase, ignoreWhite, ignorePunc);
        ArrayList<String> pairs1 = IdentifierSynonymizer.letterPairs(s1);
        ArrayList<String> pairs2 = IdentifierSynonymizer.letterPairs(s2);
        int intersection = 0;
        int union = pairs1.size() + pairs2.size();
        block0: for (int i = 0; i < pairs1.size(); ++i) {
            String pair1 = pairs1.get(i);
            for (int j = 0; j < pairs2.size(); ++j) {
                String pair2 = pairs2.get(j);
                if (!pair1.equals(pair2)) continue;
                ++intersection;
                pairs2.remove(j);
                continue block0;
            }
        }
        return 2.0 * (double)intersection / (double)union;
    }

    private static ArrayList<String> letterPairs(String str) {
        ArrayList<String> allPairs = new ArrayList<String>();
        for (int i = 0; i < str.length() - 1; ++i) {
            allPairs.add(str.substring(i, i + 2));
        }
        return allPairs;
    }

    private static String cleanName(String s, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        if (ignoreCase) {
            s = s.toUpperCase();
        }
        if (ignoreWhite) {
            s.replaceAll("\\s", "");
        }
        if (ignorePunc) {
            s = s.replaceAll("[^a-zA-Z0-9]", "");
        }
        return s;
    }

    public void changeAlignmentIdentifiers(TaxaList alternateIdGroups) {
        TaxaList[] aidg = new TaxaList[]{alternateIdGroups};
        this.changeAlignmentIdentifiers(aidg[0]);
    }

    public void changeAlignmentIdentifiers(TaxaList[] alternateIdGroups) {
        for (int a = 0; a < alternateIdGroups.length; ++a) {
            TaxaListBuilder tLB = new TaxaListBuilder();
            for (int i = 0; i < alternateIdGroups[a].numberOfTaxa(); ++i) {
                Taxon currID = (Taxon)alternateIdGroups[a].get(i);
                if (this.getPreferredIndex(currID.getName()) > -1) {
                    tLB.add(new Taxon.Builder(this.getPreferredName(currID.getName())).build());
                    continue;
                }
                tLB.add(new Taxon.Builder(currID).build());
            }
        }
    }

    public String toString() {
        String s = "Synonym Table\n" + this.idSynonyms.toString() + "\n\n";
        return s;
    }

    public String getPreferredName(String theID) {
        int index = this.getPreferredIndex(theID);
        if (index > -1) {
            return this.referenceIDGroup.taxaName(index);
        }
        return "";
    }

    public int getPreferredIndex(String theID) {
        Integer index = this.idSynonyms.get(theID);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public Taxon getPreferredIdentifier(Taxon theID) {
        int index = this.getPreferredIndex(theID.getName());
        if (index > -1) {
            return (Taxon)this.referenceIDGroup.get(index);
        }
        return null;
    }

    public void deleteByThreshold(double threshold) {
        Object[] keyArray = this.idSynonyms.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            String realName;
            double score;
            String synName = "" + (String)keyArray[i];
            if (this.getPreferredIndex(synName) <= -1 || !((score = IdentifierSynonymizer.scoreMatch(synName, realName = "" + this.getPreferredName(synName), true, false, false)) < threshold)) continue;
            this.idSynonyms.put(synName, new Integer(-1));
        }
    }

    public boolean setRealName(String synName, String realName) {
        int synID = this.getPreferredIndex(synName);
        int realID = this.referenceIDGroup.indexOf(realName);
        if (synID > -1 && realID > -1) {
            realName = "" + this.getPreferredName(synName);
            this.idSynonyms.put(synName, new Integer(realID));
            return true;
        }
        return false;
    }

    public boolean setRealID(String synName, int realID) {
        if (realID <= this.referenceIDGroup.numberOfTaxa() && realID > -2) {
            this.idSynonyms.put(synName, new Integer(realID));
            return true;
        }
        return false;
    }

    public Object[] getRealNames() {
        Object[] idArray = new Object[this.referenceIDGroup.numberOfTaxa()];
        for (int i = 0; i < this.referenceIDGroup.numberOfTaxa(); ++i) {
            idArray[i] = ((Taxon)this.referenceIDGroup.get(i)).toString();
        }
        return idArray;
    }

    @Override
    public void report(PrintWriter out) {
        out.println("Synonym Table");
        out.println(this.idSynonyms.size() + " unique matches");
        out.println(this.unmatchCount + " unmatched:");
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] cn = new String[]{"TaxaSynonym", "TaxaRealName", "RefIDNum", "MatchScore"};
        return cn;
    }

    @Override
    public Object[] getRow(int row) {
        Object[] data = new Object[4];
        Object[] keyArray = this.idSynonyms.keySet().toArray();
        data[0] = (String)keyArray[row];
        data[1] = this.getPreferredName((String)keyArray[row]);
        data[2] = "" + this.getPreferredIndex((String)keyArray[row]);
        data[3] = "" + IdentifierSynonymizer.scoreMatch("" + data[0], "" + data[1], true, false, false);
        return data;
    }

    public void deleteElements(Object[] key) {
        for (int i = 0; i < key.length; ++i) {
            this.idSynonyms.remove(key[i]);
        }
    }

    @Override
    public String getTableTitle() {
        return "Taxa Synonym Table";
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.idSynonyms.size();
    }

    @Override
    public int getElementCount() {
        return this.getColumnCount() * this.getRowCount();
    }
}

