/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import java.util.ArrayList;
import java.util.TreeSet;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

@Deprecated
public final class IdGroupUtils {
    private IdGroupUtils() {
    }

    public static boolean isContainedWithin(TaxaList sub, TaxaList full) {
        for (int i = 0; i < sub.numberOfTaxa(); ++i) {
            boolean found = false;
            Taxon subID = (Taxon)sub.get(i);
            for (int j = 0; j < full.numberOfTaxa(); ++j) {
                Taxon fullID = (Taxon)full.get(j);
                if (!fullID.equals(subID)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualIgnoringOrder(TaxaList id1, TaxaList id2) {
        return IdGroupUtils.isContainedWithin(id1, id2) && IdGroupUtils.isContainedWithin(id2, id1);
    }

    public static int whichIdNumber(TaxaList group, String s) {
        for (int i = 0; i < group.numberOfTaxa(); ++i) {
            if (!s.equals(((Taxon)group.get(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    public static TaxaList getCommonIds(TaxaList group1, TaxaList group2) {
        return IdGroupUtils.getCommonIds(new TaxaList[]{group1, group2});
    }

    public static TaxaList getCommonIds(TaxaList[] groups) {
        if (groups == null || groups.length == 0) {
            return null;
        }
        TreeSet<Taxon> intersectIds = new TreeSet<Taxon>(groups[0]);
        for (int i = 1; i < groups.length; ++i) {
            intersectIds.retainAll(groups[i]);
        }
        return new TaxaListBuilder().addAll(intersectIds).build();
    }

    public static TaxaList getAllIds(TaxaList group1, TaxaList group2) {
        return IdGroupUtils.getAllIds(new TaxaList[]{group1, group2});
    }

    public static TaxaList getAllIds(TaxaList[] groups) {
        if (groups == null || groups.length == 0) {
            return null;
        }
        TreeSet<Taxon> allIds = new TreeSet<Taxon>();
        for (int i = 0; i < groups.length; ++i) {
            int n = groups[i].numberOfTaxa();
            for (int j = 0; j < n; ++j) {
                allIds.add((Taxon)groups[i].get(j));
            }
        }
        return new TaxaListBuilder().addAll(allIds).build();
    }

    public static TaxaList idGroupSubset(TaxaList original, boolean[] include) {
        int nOld = original.numberOfTaxa();
        if (nOld != include.length) {
            throw new IllegalArgumentException("Size of IdGroup and include array are different.");
        }
        ArrayList<Taxon> newIds = new ArrayList<Taxon>();
        for (int i = 0; i < nOld; ++i) {
            if (!include[i]) continue;
            newIds.add((Taxon)original.get(i));
        }
        return new TaxaListBuilder().addAll(newIds).build();
    }

    public static String[] getNames(Taxon[] ids) {
        String[] names = new String[ids.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ids[i].getName();
        }
        return names;
    }

    public static String[] getNames(Taxon[] ids, int toIgnore) {
        if (toIgnore < 0 || toIgnore >= ids.length) {
            return IdGroupUtils.getNames(ids);
        }
        String[] names = new String[ids.length - 1];
        int index = 0;
        for (int i = 0; i < names.length; ++i) {
            if (i == toIgnore) continue;
            names[index] = ids[i].getName();
            ++index;
        }
        return names;
    }

    public static Taxon[] getIdentifiers(String[] names) {
        Taxon[] ids = new Taxon[names.length];
        for (int i = 0; i < names.length; ++i) {
            ids[i] = new Taxon(names[i]);
        }
        return ids;
    }

    public static Taxon[] getIdentifiers(TaxaList idGroup) {
        Taxon[] ids = new Taxon[idGroup.numberOfTaxa()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (Taxon)idGroup.get(i);
        }
        return ids;
    }

    public static String[] getNames(TaxaList ids) {
        String[] names = new String[ids.numberOfTaxa()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((Taxon)ids.get(i)).getName();
        }
        return names;
    }

    public static String[] getNames(TaxaList ids, int toIgnore) {
        if (toIgnore < 0 || toIgnore >= ids.numberOfTaxa()) {
            return IdGroupUtils.getNames(ids);
        }
        int numberOfIDS = ids.numberOfTaxa();
        String[] names = new String[numberOfIDS - 1];
        int index = 0;
        for (int i = 0; i < numberOfIDS; ++i) {
            if (i == toIgnore) continue;
            names[index] = ((Taxon)ids.get(i)).getName();
            ++index;
        }
        return names;
    }
}

