/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TOPMTableReport;
import net.maizegenetics.gui.TableReportNoPagingTableModel;
import net.maizegenetics.util.DoubleFormat;
import net.maizegenetics.util.TableReport;

public class TableReportPanel
extends JPanel {
    private static final Map<Object, TableReportPanel> INSTANCES = new WeakHashMap<Object, TableReportPanel>();
    private JTable myDataTable;
    private int myTaxaColumnIndex = -1;

    private TableReportPanel(TableReport theTableSource) {
        TableModel theModel = null;
        theModel = theTableSource instanceof TableModel ? (TableModel)((Object)theTableSource) : new TableReportNoPagingTableModel(theTableSource);
        this.myDataTable = new JTable(theModel);
        this.myDataTable.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                this.setText(DoubleFormat.format((Double)value));
            }
        });
        ((DefaultTableCellRenderer)this.myDataTable.getDefaultRenderer(String.class)).setHorizontalAlignment(4);
        ((DefaultTableCellRenderer)this.myDataTable.getDefaultRenderer(Double.class)).setHorizontalAlignment(4);
        ((DefaultTableCellRenderer)this.myDataTable.getDefaultRenderer(Integer.class)).setHorizontalAlignment(4);
        this.myDataTable.setAutoResizeMode(0);
        TableRowSorter<TableModel> theSorter = new TableRowSorter<TableModel>(theModel);
        this.myDataTable.setRowSorter(theSorter);
        JScrollPane jsp = new JScrollPane(this.myDataTable);
        Object[][] rowtable = this.getRowHeadings(theTableSource);
        if (this.myTaxaColumnIndex != -1) {
            JTable rowNameTable = new JTable(rowtable, new String[]{"Taxa"}){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            rowNameTable.setRowSorter(theSorter);
            jsp.setRowHeaderView(rowNameTable);
            int numTaxaToCheck = Math.min(500, rowtable.length);
            int maxChars = 0;
            for (int i = 0; i < numTaxaToCheck; ++i) {
                if (((String)rowtable[i][0]).length() <= maxChars) continue;
                maxChars = ((String)rowtable[i][0]).length();
            }
            int preferedWidth = Math.max(100, maxChars * 9);
            jsp.getRowHeader().setPreferredSize(new Dimension(preferedWidth, this.myDataTable.getHeight()));
            jsp.setCorner("UPPER_LEFT_CORNER", rowNameTable.getTableHeader());
            TableColumn taxaColumn = this.myDataTable.getColumnModel().getColumn(this.myTaxaColumnIndex);
            this.myDataTable.getColumnModel().removeColumn(taxaColumn);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jsp, "Center");
        this.setVisible(true);
    }

    public static TableReportPanel getInstance(TableReport theTableSource) {
        TableReportPanel result = INSTANCES.get(theTableSource);
        if (result == null) {
            result = new TableReportPanel(theTableSource);
            INSTANCES.put(theTableSource, result);
        }
        return result;
    }

    public static TableReportPanel getInstance(TOPMInterface topm) {
        TableReportPanel result = INSTANCES.get(topm);
        if (result == null) {
            result = new TableReportPanel(new TOPMTableReport(topm));
            INSTANCES.put(topm, result);
        }
        return result;
    }

    private String[][] getRowHeadings(TableReport report) {
        Object[] headings = report.getTableColumnNames();
        int n = headings.length;
        for (int i = 0; i < n; ++i) {
            if (!headings[i].toString().equalsIgnoreCase("taxa")) continue;
            this.myTaxaColumnIndex = i;
            break;
        }
        if (this.myTaxaColumnIndex == -1) {
            return null;
        }
        String[][] result = new String[report.getRowCount()][1];
        int n2 = report.getRowCount();
        for (int i = 0; i < n2; ++i) {
            result[i][0] = report.getValueAt(i, this.myTaxaColumnIndex).toString();
        }
        return result;
    }
}

