/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.association.RidgeRegressionEmmaPlugin;
import net.maizegenetics.analysis.chart.ChartDisplayPlugin;
import net.maizegenetics.analysis.chart.Grid2dDisplayPlugin;
import net.maizegenetics.analysis.chart.ManhattanDisplayPlugin;
import net.maizegenetics.analysis.chart.QQDisplayPlugin;
import net.maizegenetics.analysis.chart.TableDisplayPlugin;
import net.maizegenetics.analysis.data.ExportPlugin;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.data.HetsToUnknownPlugin;
import net.maizegenetics.analysis.data.IntersectionAlignmentPlugin;
import net.maizegenetics.analysis.data.MergeGenotypeTablesPlugin;
import net.maizegenetics.analysis.data.PlinkLoadPlugin;
import net.maizegenetics.analysis.data.ProjectionLoadPlugin;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.analysis.data.SynonymizerPlugin;
import net.maizegenetics.analysis.data.UnionAlignmentPlugin;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.analysis.filter.FilterAlignmentPlugin;
import net.maizegenetics.analysis.filter.FilterSiteNamePlugin;
import net.maizegenetics.analysis.filter.FilterTaxaAlignmentPlugin;
import net.maizegenetics.analysis.filter.FilterTaxaPropertiesPlugin;
import net.maizegenetics.analysis.filter.FilterTraitsPlugin;
import net.maizegenetics.analysis.modelfitter.StepwiseOLSModelFitterPlugin;
import net.maizegenetics.analysis.numericaltransform.NumericalTransformPlugin;
import net.maizegenetics.analysis.popgen.LinkageDiseqDisplayPlugin;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumPlugin;
import net.maizegenetics.analysis.popgen.SequenceDiversityPlugin;
import net.maizegenetics.analysis.tree.ArchaeopteryxPlugin;
import net.maizegenetics.analysis.tree.CreateTreePlugin;
import net.maizegenetics.gui.PrintHeapAction;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.progress.ProgressPanel;
import net.maizegenetics.tassel.AboutBox;
import net.maizegenetics.tassel.DataTreePanel;
import net.maizegenetics.tassel.HelpDialog;
import net.maizegenetics.tassel.PreferencesDialog;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class TASSELMainFrame
extends JFrame
implements ActionListener {
    private static final Logger myLogger = Logger.getLogger(TASSELMainFrame.class);
    public static final String version = "5.0.5";
    public static final String versionDate = "April 17, 2014";
    private DataTreePanel myDataTreePanel;
    private String tasselDataFile = "TasselDataFile";
    private JFileChooser filerSave = new JFileChooser();
    private JFileChooser filerOpen = new JFileChooser();
    private JScrollPane reportPanelScrollPane = new JScrollPane();
    private JTextArea reportPanelTextArea = new JTextArea();
    JScrollPane mainPanelScrollPane = new JScrollPane();
    JPanel mainDisplayPanel = new JPanel();
    private JTextArea mainPanelTextArea = new JTextArea();
    private JTextField myStatusTextField = new JTextField();
    private JMenuItem openCompleteDataTreeMenuItem = new JMenuItem();
    private JMenuItem openDataMenuItem = new JMenuItem();
    private JMenuItem saveCompleteDataTreeMenuItem = new JMenuItem();
    private JMenuItem saveDataTreeAsMenuItem = new JMenuItem();
    private PreferencesDialog thePreferencesDialog;
    private final ProgressPanel myProgressPanel = ProgressPanel.getInstance();
    private HashMap<JMenuItem, Plugin> myMenuItemHash = new HashMap();

    public TASSELMainFrame() {
        try {
            this.loadSettings();
            this.myDataTreePanel = new DataTreePanel(this);
            this.myDataTreePanel.setToolTipText("Data Tree Panel");
            this.addMenuBar();
            this.initializeMyFrame();
            this.setTitle("TASSEL (Trait Analysis by aSSociation, Evolution, and Linkage) 5.0.5");
            myLogger.info((Object)"Tassel Version: 5.0.5  Date: April 17, 2014");
            myLogger.info((Object)("Max Available Memory Reported by JVM: " + Utils.getMaxHeapSizeMB() + " MB"));
            myLogger.info((Object)("Java Version: " + System.getProperty("java.version")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeMyFrame() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int xDim = TasselPrefs.getXDim();
        int yDim = TasselPrefs.getYDim();
        if (xDim < 50 || yDim < 50) {
            this.setSize(new Dimension(screenSize.width * 19 / 20, screenSize.height * 19 / 20));
        } else {
            this.setSize(xDim, yDim);
        }
        this.setTitle("TASSEL (Trait Analysis by aSSociation, Evolution, and Linkage)");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TasselPrefs.putXDim(TASSELMainFrame.this.getWidth());
                TasselPrefs.putYDim(TASSELMainFrame.this.getHeight());
                System.exit(0);
            }
        });
        this.filerSave.setDialogType(1);
        JSplitPane dataTreeReportPanelsSplitPanel = new JSplitPane();
        dataTreeReportPanelsSplitPanel.setOrientation(0);
        this.reportPanelTextArea.setEditable(false);
        this.reportPanelTextArea.setToolTipText("Report Panel");
        this.mainPanelTextArea.setDoubleBuffered(true);
        this.mainPanelTextArea.setEditable(false);
        this.mainPanelTextArea.setFont(new Font("Monospaced", 0, 12));
        this.mainPanelTextArea.setToolTipText("Main Panel");
        this.myStatusTextField.setBackground(Color.lightGray);
        this.myStatusTextField.setBorder(null);
        this.saveCompleteDataTreeMenuItem.setText("Save Data Tree");
        this.saveCompleteDataTreeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.saveCompleteDataTreeMenuItem_actionPerformed(e);
            }
        });
        this.saveDataTreeAsMenuItem.setText("Save Data Tree As ...");
        this.saveDataTreeAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.saveDataTreeMenuItem_actionPerformed(e);
            }
        });
        this.openCompleteDataTreeMenuItem.setText("Open Data Tree");
        this.openCompleteDataTreeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.openCompleteDataTreeMenuItem_actionPerformed(e);
            }
        });
        this.openDataMenuItem.setText("Open Data Tree...");
        this.openDataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.openDataMenuItem_actionPerformed(e);
            }
        });
        JSplitPane dataTreeReportMainPanelsSplitPanel = new JSplitPane();
        this.getContentPane().add((Component)dataTreeReportMainPanelsSplitPanel, "Center");
        dataTreeReportMainPanelsSplitPanel.add((Component)dataTreeReportPanelsSplitPanel, "left");
        dataTreeReportPanelsSplitPanel.add((Component)this.myDataTreePanel, "top");
        JSplitPane reportProgressSplitPane = new JSplitPane(0);
        JPanel reportPanel = new JPanel(new BorderLayout());
        reportProgressSplitPane.add((Component)reportPanel, "top");
        reportPanel.add((Component)this.reportPanelScrollPane, "Center");
        this.reportPanelScrollPane.getViewport().add((Component)this.reportPanelTextArea, null);
        reportProgressSplitPane.add((Component)new JScrollPane(this.myProgressPanel), "bottom");
        dataTreeReportPanelsSplitPanel.add((Component)reportProgressSplitPane, "bottom");
        dataTreeReportMainPanelsSplitPanel.add((Component)this.mainDisplayPanel, "right");
        this.mainDisplayPanel.setLayout(new BorderLayout());
        this.mainPanelScrollPane.getViewport().add((Component)this.mainPanelTextArea, null);
        this.mainDisplayPanel.add((Component)this.mainPanelScrollPane, "Center");
        this.mainPanelScrollPane.getViewport().add((Component)this.mainPanelTextArea, null);
        this.getContentPane().add((Component)this.myStatusTextField, "South");
        dataTreeReportMainPanelsSplitPanel.setDividerLocation(this.getSize().width / 4);
        dataTreeReportPanelsSplitPanel.setDividerLocation((int)((double)this.getSize().height / 3.5));
        reportProgressSplitPane.setDividerLocation((int)((double)this.getSize().height / 3.5));
    }

    private void addMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.getFileMenu());
        jMenuBar.add(this.getDataMenu());
        jMenuBar.add(this.getFiltersMenu());
        jMenuBar.add(this.getAnalysisMenu());
        jMenuBar.add(this.getResultsMenu());
        jMenuBar.add(this.getHelpMenu());
        this.setJMenuBar(jMenuBar);
    }

    private void helpAbout_actionPerformed(ActionEvent e) {
        AboutBox dlg = new AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public void sendMessage(String text) {
        this.myStatusTextField.setForeground(Color.BLACK);
        this.myStatusTextField.setText(text);
    }

    public void sendErrorMessage(String text) {
        this.myStatusTextField.setForeground(Color.RED);
        this.myStatusTextField.setText(text);
    }

    public void setMainText(String text) {
        this.mainPanelTextArea.setText(text);
    }

    public void setNoteText(String text) {
        this.reportPanelTextArea.setText(text);
    }

    private void loadSettings() {
        this.filerOpen.setCurrentDirectory(new File(TasselPrefs.getOpenDir()));
        this.filerSave.setCurrentDirectory(new File(TasselPrefs.getSaveDir()));
    }

    private File getSaveFile() {
        File saveFile = null;
        int returnVal = this.filerSave.showSaveDialog(this);
        if (returnVal == 0) {
            saveFile = this.filerSave.getSelectedFile();
            TasselPrefs.putSaveDir(this.filerSave.getCurrentDirectory().getPath());
        }
        return saveFile;
    }

    private File getOpenFile() {
        File openFile = null;
        int returnVal = this.filerOpen.showOpenDialog(this);
        System.out.println("returnVal = " + returnVal);
        System.out.println("JFileChooser.OPEN_DIALOG 0");
        if (returnVal == 0 || returnVal == 0) {
            openFile = this.filerOpen.getSelectedFile();
            System.out.println("openFile = " + openFile);
            TasselPrefs.putOpenDir(this.filerOpen.getCurrentDirectory().getPath());
        }
        return openFile;
    }

    public void addDataSet(DataSet theDataSet, String defaultNode) {
        this.myDataTreePanel.addDataSet(theDataSet, defaultNode);
    }

    private void saveDataTree(String file) {
        LinkedHashMap<Datum, String> dataToSerialize = new LinkedHashMap<Datum, String>();
        Map dataFromTree = this.myDataTreePanel.getDataList();
        StringBuilder builder = new StringBuilder();
        for (Datum currentDatum : dataFromTree.keySet()) {
            String currentNode = (String)dataFromTree.get(currentDatum);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(out);
                oos.writeObject(currentDatum);
                oos.close();
                if (out.toByteArray().length <= 0) continue;
                dataToSerialize.put(currentDatum, currentNode);
            }
            catch (Exception e) {
                myLogger.warn((Object)("saveDataTree: object: " + currentDatum.getName() + " type: " + currentDatum.getData().getClass().getName() + " does not serialize."));
                myLogger.warn((Object)("saveDataTree: message: " + e.getMessage()));
                if (builder.length() == 0) {
                    builder.append("Due to error, these data sets could not\n");
                    builder.append("included in the saved file...");
                }
                builder.append("Data set: ");
                builder.append(currentDatum.getName());
                builder.append(" type: ");
                builder.append(currentDatum.getData().getClass().getName());
                builder.append("\n");
            }
        }
        try {
            File theFile = new File(Utils.addSuffixIfNeeded(file, ".zip"));
            FileOutputStream fos = new FileOutputStream(theFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry thisEntry = new ZipEntry("DATA");
            zos.putNextEntry(thisEntry);
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(dataToSerialize);
            oos.flush();
            zos.closeEntry();
            fos.close();
            this.sendMessage("Data saved to " + theFile.getAbsolutePath());
        }
        catch (Exception ee) {
            this.sendErrorMessage("Data could not be saved: " + ee);
            ee.printStackTrace();
        }
        if (builder.length() != 0) {
            JOptionPane.showMessageDialog(this, builder.toString(), "These data sets not saved...", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readDataTree(String file) {
        String dataTreeLoadFailed = "Unable to open the saved data tree.  The file format of this version is incompatible with other versions.";
        boolean loadedDataTreePanel = false;
        try {
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            if (file.endsWith("zip")) {
                fis = new FileInputStream(file);
                ZipInputStream zis = new ZipInputStream(fis);
                zis.getNextEntry();
                ois = new ObjectInputStream(zis);
            } else {
                fis = new FileInputStream(file);
                ois = new ObjectInputStream(fis);
            }
            try {
                Map data = (Map)ois.readObject();
                for (Datum currentDatum : data.keySet()) {
                    String currentNode = (String)data.get(currentDatum);
                    this.myDataTreePanel.addDatum(currentNode, currentDatum);
                }
                loadedDataTreePanel = true;
            }
            catch (InvalidClassException ice) {
                JOptionPane.showMessageDialog(this, dataTreeLoadFailed, "Incompatible File Format", 1);
            }
            finally {
                fis.close();
            }
            if (loadedDataTreePanel) {
                this.sendMessage("Data loaded.");
            }
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(this, "File not found: " + file, "File not found", 1);
            this.sendErrorMessage("Data tree could not be loaded.");
            return false;
        }
        catch (Exception ee) {
            JOptionPane.showMessageDialog(this, dataTreeLoadFailed + ee, "Incompatible File Format", 1);
            this.sendErrorMessage("Data tree could not be loaded.");
            return false;
        }
        return loadedDataTreePanel;
    }

    private void helpButton_actionPerformed(ActionEvent e) {
        HelpDialog theHelpDialog = new HelpDialog(this);
        theHelpDialog.setLocationRelativeTo(this);
        theHelpDialog.setVisible(true);
    }

    private void openCompleteDataTreeMenuItem_actionPerformed(ActionEvent e) {
        String dataFileName = this.tasselDataFile + ".zip";
        File dataFile = new File(dataFileName);
        if (dataFile.exists()) {
            this.readDataTree(dataFileName);
        } else if (new File("QPGADataFile").exists()) {
            this.readDataTree("QPGADataFile");
        } else {
            JOptionPane.showMessageDialog(this, "File: " + dataFile.getAbsolutePath() + " does not exist.\n" + "Try using File/Open Data Tree...");
        }
    }

    private void openDataMenuItem_actionPerformed(ActionEvent e) {
        File f = this.getOpenFile();
        if (f != null) {
            this.readDataTree(f.getAbsolutePath());
        }
    }

    private void saveDataTreeMenuItem_actionPerformed(ActionEvent e) {
        File f = this.getSaveFile();
        if (f != null) {
            this.saveDataTree(f.getAbsolutePath());
        }
    }

    private void saveCompleteDataTreeMenuItem_actionPerformed(ActionEvent e) {
        this.saveDataTree(this.tasselDataFile + ".zip");
    }

    private void preferencesMenuItem_actionPerformed(ActionEvent e) {
        if (this.thePreferencesDialog == null) {
            this.thePreferencesDialog = new PreferencesDialog();
            this.thePreferencesDialog.pack();
        }
        this.thePreferencesDialog.setLocationRelativeTo(this);
        this.thePreferencesDialog.setVisible(true);
    }

    public void updateMainDisplayPanel(JPanel panel) {
        this.mainDisplayPanel.removeAll();
        this.mainDisplayPanel.add((Component)panel, "Center");
        this.mainDisplayPanel.repaint();
        this.mainDisplayPanel.validate();
    }

    public DataTreePanel getDataTreePanel() {
        return this.myDataTreePanel;
    }

    public ProgressPanel getProgressPanel() {
        return this.myProgressPanel;
    }

    private JMenuItem createMenuItem(Plugin theTP) {
        return this.createMenuItem(theTP, -1);
    }

    private JMenuItem createMenuItem(Plugin theTP, int mnemonic) {
        ImageIcon icon = theTP.getIcon();
        JMenuItem menuItem = new JMenuItem(theTP.getButtonName(), icon);
        if (mnemonic != -1) {
            menuItem.setMnemonic(mnemonic);
        }
        int pixels = 30;
        if (icon != null) {
            pixels -= icon.getIconWidth();
            pixels /= 2;
        }
        menuItem.setIconTextGap(pixels);
        menuItem.setBackground(Color.white);
        menuItem.setMargin(new Insets(2, 2, 2, 2));
        menuItem.setToolTipText(theTP.getToolTipText());
        menuItem.addActionListener(this);
        theTP.addListener(this.myDataTreePanel);
        this.myMenuItemHash.put(menuItem, theTP);
        return menuItem;
    }

    private JMenuItem createMenuItem(Action action, int mnemonic) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        JMenuItem menuItem = new JMenuItem(action.getValue("Name").toString(), icon);
        if (mnemonic != -1) {
            menuItem.setMnemonic(mnemonic);
        }
        int pixels = 30;
        if (icon != null) {
            pixels -= icon.getIconWidth();
            pixels /= 2;
        }
        menuItem.setIconTextGap(pixels);
        menuItem.setBackground(Color.white);
        menuItem.setMargin(new Insets(2, 2, 2, 2));
        menuItem.addActionListener(action);
        return menuItem;
    }

    private JMenu getFiltersMenu() {
        JMenu result = new JMenu("Filter");
        result.setMnemonic(70);
        result.add(this.createMenuItem(new FilterAlignmentPlugin(this, true)));
        result.add(this.createMenuItem(new FilterSiteNamePlugin(this, true)));
        result.add(this.createMenuItem(new FilterTaxaAlignmentPlugin(this, true)));
        result.add(this.createMenuItem(new FilterTaxaPropertiesPlugin(this, true)));
        result.add(this.createMenuItem(new FilterTraitsPlugin(this, true)));
        return result;
    }

    private JMenu getDataMenu() {
        JMenu result = new JMenu("Data");
        result.setMnemonic(68);
        PlinkLoadPlugin plinkLoadPlugin = new PlinkLoadPlugin(this, true);
        plinkLoadPlugin.addListener(this.myDataTreePanel);
        ProjectionLoadPlugin projectionLoadPlugin = new ProjectionLoadPlugin(this, true);
        projectionLoadPlugin.addListener(this.myDataTreePanel);
        result.add(this.createMenuItem(new FileLoadPlugin(this, true, plinkLoadPlugin, projectionLoadPlugin), 76));
        result.add(this.createMenuItem(new ExportPlugin(this, true)));
        result.add(this.createMenuItem(new NumericalTransformPlugin(this, true)));
        result.add(this.createMenuItem(new SynonymizerPlugin(this, true)));
        result.add(this.createMenuItem(new IntersectionAlignmentPlugin(this, true)));
        result.add(this.createMenuItem(new UnionAlignmentPlugin(this, true)));
        result.add(this.createMenuItem(new MergeGenotypeTablesPlugin(this, true)));
        result.add(this.createMenuItem(new SeparatePlugin(this, true)));
        result.add(this.createMenuItem(new HetsToUnknownPlugin(this, true)));
        result.addSeparator();
        JMenuItem delete = new JMenuItem("Delete Dataset");
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.myDataTreePanel.deleteSelectedNodes();
            }
        });
        delete.setToolTipText("Delete Dataset");
        URL imageURL = TASSELMainFrame.class.getResource("images/trash.gif");
        if (imageURL == null) {
            delete.setIconTextGap(30);
        } else {
            delete.setIcon(new ImageIcon(imageURL));
            delete.setIconTextGap(6);
        }
        delete.setIconTextGap(6);
        result.add(delete);
        return result;
    }

    private JMenu getAnalysisMenu() {
        JMenu result = new JMenu("Analysis");
        result.setMnemonic(65);
        result.add(this.createMenuItem(new SequenceDiversityPlugin(this, true)));
        result.add(this.createMenuItem(new LinkageDisequilibriumPlugin(this, true)));
        result.add(this.createMenuItem(new CreateTreePlugin(this, true)));
        result.add(this.createMenuItem(new KinshipPlugin(this, true)));
        result.add(this.createMenuItem(new FixedEffectLMPlugin(this, true)));
        result.add(this.createMenuItem(new MLMPlugin(this, true)));
        result.add(this.createMenuItem(new RidgeRegressionEmmaPlugin(this, true)));
        result.add(this.createMenuItem(new GenotypeSummaryPlugin(this, true)));
        result.add(this.createMenuItem(new StepwiseOLSModelFitterPlugin(this, true)));
        return result;
    }

    private JMenu getResultsMenu() {
        JMenu result = new JMenu("Results");
        result.setMnemonic(82);
        result.add(this.createMenuItem(new TableDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new ArchaeopteryxPlugin(this, true)));
        result.add(this.createMenuItem(new Grid2dDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new LinkageDiseqDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new ChartDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new QQDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new ManhattanDisplayPlugin(this, true)));
        return result;
    }

    private JMenu getFileMenu() {
        JMenu fileMenu = new JMenu();
        fileMenu.setText("File");
        fileMenu.add(this.saveCompleteDataTreeMenuItem);
        fileMenu.add(this.openCompleteDataTreeMenuItem);
        fileMenu.add(this.saveDataTreeAsMenuItem);
        fileMenu.add(this.openDataMenuItem);
        JMenuItem preferencesMenuItem = new JMenuItem();
        preferencesMenuItem.setText("Set Preferences");
        preferencesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.preferencesMenuItem_actionPerformed(e);
            }
        });
        fileMenu.add(preferencesMenuItem);
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasselPrefs.putXDim(TASSELMainFrame.this.getWidth());
                TasselPrefs.putYDim(TASSELMainFrame.this.getHeight());
                System.exit(0);
            }
        });
        fileMenu.add(exitMenuItem);
        return fileMenu;
    }

    private JMenu getHelpMenu() {
        JMenu helpMenu = new JMenu();
        helpMenu.setMnemonic(72);
        helpMenu.setText("Help");
        URL infoImageURL = TASSELMainFrame.class.getResource("images/info.gif");
        ImageIcon infoIcon = null;
        if (infoImageURL != null) {
            infoIcon = new ImageIcon(infoImageURL);
        }
        helpMenu.add(this.createMenuItem(new AbstractAction("Help Manual", infoIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.helpButton_actionPerformed(e);
            }
        }, -1));
        URL aboutImageURL = TASSELMainFrame.class.getResource("images/Tassel_Logo16.png");
        ImageIcon aboutIcon = null;
        if (aboutImageURL != null) {
            aboutIcon = new ImageIcon(aboutImageURL);
        }
        helpMenu.add(this.createMenuItem(new AbstractAction("About", aboutIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.helpAbout_actionPerformed(e);
            }
        }, -1));
        helpMenu.add(this.createMenuItem(PrintHeapAction.getInstance(this), -1));
        return helpMenu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem theMenuItem = (JMenuItem)e.getSource();
        Plugin theTP = this.myMenuItemHash.get(theMenuItem);
        PluginEvent event = new PluginEvent(this.myDataTreePanel.getSelectedTasselDataSet());
        ProgressPanel progressPanel = this.getProgressPanel();
        progressPanel.addPlugin(theTP);
        ThreadedPluginListener thread = new ThreadedPluginListener(theTP, event);
        thread.start();
    }
}

