/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.maizegenetics.prefs.TasselPrefs;

public class PreferencesDialog
extends JDialog {
    private static final Font HEADING_FONT = new Font(null, 1, 14);
    private JCheckBox myRetainRareAlleles = new JCheckBox("Retain Rare Alleles");

    public PreferencesDialog() {
        super((Frame)null, "Preferences...", true);
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setTitle("Preferences...");
        this.setDefaultCloseOperation(1);
        this.setUndecorated(false);
        this.getRootPane().setWindowDecorationStyle(0);
        Container contentPane = this.getContentPane();
        JPanel result = new JPanel();
        BoxLayout layout = new BoxLayout(result, 1);
        result.setLayout(layout);
        result.setAlignmentX(0.0f);
        result.add(Box.createRigidArea(new Dimension(1, 30)));
        result.add(this.getGenotypeStoringPanel());
        result.add(Box.createRigidArea(new Dimension(1, 10)));
        result.add(this.getButtons());
        result.add(Box.createRigidArea(new Dimension(1, 20)));
        contentPane.add(result);
        this.pack();
        this.setResizable(false);
    }

    private JPanel getGenotypeStoringPanel() {
        JPanel result = new JPanel();
        BoxLayout layout = new BoxLayout(result, 1);
        result.setLayout(layout);
        result.setAlignmentX(0.5f);
        JLabel alignPrefsLabel = new JLabel("Alignment Preferences...");
        alignPrefsLabel.setFont(HEADING_FONT);
        result.add(alignPrefsLabel);
        result.add(Box.createRigidArea(new Dimension(1, 10)));
        this.myRetainRareAlleles.setSelected(TasselPrefs.getAlignmentRetainRareAlleles());
        result.add(this.myRetainRareAlleles);
        return result;
    }

    private JPanel getLine(String label, JTextField ref) {
        JPanel result = new JPanel(new FlowLayout(1));
        result.add(new JLabel(label));
        ref.setEditable(true);
        ref.setHorizontalAlignment(2);
        ref.setAlignmentX(0.5f);
        ref.setAlignmentY(0.5f);
        ref.setMaximumSize(ref.getPreferredSize());
        result.add(ref);
        return result;
    }

    private JPanel getButtons() {
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.cancelButton_actionPerformed(e);
            }
        });
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.okButton_actionPerformed(e);
            }
        });
        JPanel result = new JPanel(new FlowLayout(1));
        result.add(okButton);
        result.add(cancelButton);
        return result;
    }

    private void okButton_actionPerformed(ActionEvent e) {
        TasselPrefs.putAlignmentRetainRareAlleles(this.myRetainRareAlleles.isSelected());
        this.setVisible(false);
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.myRetainRareAlleles.setSelected(TasselPrefs.getAlignmentRetainRareAlleles());
        this.setVisible(false);
    }
}

