/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.statistics;

public class FisherExact {
    private static final boolean DEBUG = false;
    private double[] f;
    int maxSize;

    public FisherExact(int maxSize) {
        this.maxSize = maxSize;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        for (int i = 1; i <= this.maxSize; ++i) {
            this.f[i] = this.f[i - 1] + Math.log(i);
        }
    }

    public FisherExact(int maxSize, boolean useLookup) {
        this.maxSize = maxSize;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        for (int i = 1; i <= this.maxSize; ++i) {
            this.f[i] = this.f[i - 1] + Math.log(i);
        }
        int count = 0;
        double minP = 0.05;
        for (int i = 1; i < maxSize; ++i) {
            for (int j = 1; j < maxSize; ++j) {
                for (int k = 1; k < maxSize; ++k) {
                    for (int m = 1; m < maxSize; ++m) {
                        if (!(this.getTwoTailedP(i, j, k, m) < minP)) continue;
                        ++count;
                    }
                }
            }
        }
        System.out.printf("MaxSize %d minP: %g  Count: %d %n", maxSize, minP, count);
    }

    public final double getP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = this.f[a + b] + this.f[c + d] + this.f[a + c] + this.f[b + d] - (this.f[a] + this.f[b] + this.f[c] + this.f[d] + this.f[n]);
        return Math.exp(p);
    }

    public final double getCumlativeP(int a, int b, int c, int d) {
        int i;
        int min;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        if (a * d >= b * c) {
            min = c < b ? c : b;
            for (i = 0; i < min; ++i) {
                p += this.getP(++a, --b, --c, ++d);
            }
        }
        if (a * d < b * c) {
            min = a < d ? a : d;
            for (i = 0; i < min; ++i) {
                double pTemp = this.getP(--a, ++b, ++c, --d);
                p += pTemp;
            }
        }
        return p;
    }

    public final double getRightTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        for (int i = 0; i < min; ++i) {
            p += this.getP(++a, --b, --c, ++d);
        }
        return p;
    }

    public final double getRightTailedPQuick(int a, int b, int c, int d, double maxP) {
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        for (int i = 0; i < min && p < maxP; p += this.getP(++a, --b, --c, ++d), ++i) {
        }
        return p;
    }

    public final double getLeftTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = a < d ? a : d;
        for (int i = 0; i < min; ++i) {
            double pTemp = this.getP(--a, ++b, ++c, --d);
            p += pTemp;
        }
        return p;
    }

    public final double getTwoTailedP(int a, int b, int c, int d) {
        int i;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        double baseP = this.getP(a, b, c, d);
        int initialA = a;
        int initialB = b;
        int initialC = c;
        int initialD = d;
        p += baseP;
        int min = c < b ? c : b;
        for (i = 0; i < min; ++i) {
            double tempP;
            if (!((tempP = this.getP(++a, --b, --c, ++d)) <= baseP)) continue;
            p += tempP;
        }
        a = initialA;
        b = initialB;
        c = initialC;
        d = initialD;
        min = a < d ? a : d;
        for (i = 0; i < min; ++i) {
            double pTemp;
            if (!((pTemp = this.getP(--a, ++b, ++c, --d)) <= baseP)) continue;
            p += pTemp;
        }
        return p;
    }

    public static void main(String[] args) {
        int[][] argInts = new int[15][4];
        argInts[0] = new int[]{2, 3, 6, 4};
        argInts[1] = new int[]{2, 1, 3, 0};
        argInts[2] = new int[]{3, 0, 2, 1};
        argInts[3] = new int[]{1, 2, 0, 3};
        argInts[4] = new int[]{3, 1, 1, 3};
        argInts[5] = new int[]{1, 3, 3, 1};
        argInts[6] = new int[]{0, 1, 1, 0};
        argInts[7] = new int[]{1, 0, 0, 1};
        argInts[8] = new int[]{11, 0, 0, 6};
        argInts[9] = new int[]{10, 1, 1, 5};
        argInts[10] = new int[]{5, 6, 6, 0};
        argInts[11] = new int[]{9, 2, 2, 4};
        argInts[12] = new int[]{6, 5, 5, 1};
        argInts[13] = new int[]{8, 3, 3, 3};
        argInts[14] = new int[]{7, 4, 4, 2};
        FisherExact fe = new FisherExact(100);
        for (int i = 0; i < argInts.length; ++i) {
            System.out.println("\na=" + argInts[i][0] + " b=" + argInts[i][1] + " c=" + argInts[i][2] + " d=" + argInts[i][3]);
            System.out.print("*****Original algorithm: ");
            double cumulativeP = fe.getCumlativeP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("\tcumulativeP = " + cumulativeP);
            System.out.print("*****Left Tailed: ");
            double leftTailedP = fe.getLeftTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("\tleftTailedP = " + leftTailedP);
            System.out.print("*****Right Tailed: ");
            double rightTailedP = fe.getRightTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("\trightTailedP = " + rightTailedP);
            System.out.print("*****Two Tailed: ");
            double twoTailedP = fe.getTwoTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("\ttwoTailedP = " + twoTailedP);
        }
    }
}

