/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.math;

import net.maizegenetics.stats.math.MersenneTwisterFast;

public interface OrderEnumerator {
    public boolean hasMore();

    public int getNext();

    public void reset();

    public static class Utils {
        private static final Constant ZERO = new Constant(0);

        public static final OrderEnumerator getConstant(int index) {
            return new Constant(index);
        }

        public static final OrderEnumerator getOrdered(int size) {
            return new Ordered(size);
        }

        public static final OrderEnumerator getShuffled(int size) {
            return new Shuffled(size);
        }

        public static final OrderEnumerator getBiasAlternating(OrderEnumerator primary, OrderEnumerator secondary) {
            return new BiasAlternate(primary, secondary);
        }

        public static final OrderEnumerator getAlternating(OrderEnumerator primary, OrderEnumerator secondary) {
            return new Alternate(primary, secondary);
        }

        public static final OrderEnumerator getZero() {
            return ZERO;
        }

        public static final OrderEnumerator getRestricted(OrderEnumerator toRestrict, int minimum, int range) {
            return new Restricted(toRestrict, minimum, range);
        }

        public static final OrderEnumerator getAdjusted(OrderEnumerator toAdjust, int adjustmentFactor) {
            return new Adjust(toAdjust, adjustmentFactor);
        }

        public static final OEFactory getZeroFactory() {
            return ZERO;
        }

        public static final OEFactory getConstantFactory(int index) {
            return new Constant(index);
        }

        public static final OEFactory getOrderedFactory() {
            return Ordered.Factory.INSTANCE;
        }

        public static final OEFactory getShuffledFactory() {
            return Shuffled.Factory.INSTANCE;
        }

        public static final OEFactory getAdjustedFactory(OEFactory toAdjust, int adjustmentFactor) {
            return new Adjust.Factory(toAdjust, adjustmentFactor);
        }

        public static final OEFactory getRestrictedFactory(OEFactory toRestrict, int minimum, int range) {
            return new Restricted.Factory(toRestrict, minimum, range);
        }

        public static final OEFactory getAlternatingFactory(OEFactory primary, OEFactory secondary) {
            return new Alternate.Factory(primary, secondary);
        }

        public static final OEFactory getBiasAlternatingFactory(OEFactory primary, OEFactory secondary) {
            return new BiasAlternate.Factory(primary, secondary);
        }

        private static class BiasAlternate
        implements OrderEnumerator {
            OrderEnumerator primary_;
            OrderEnumerator secondary_;
            boolean onSecondary_;

            public BiasAlternate(OrderEnumerator primary, OrderEnumerator secondary) {
                this.primary_ = primary;
                this.secondary_ = secondary;
                this.reset();
            }

            @Override
            public boolean hasMore() {
                return this.primary_.hasMore() || this.onSecondary_ && this.secondary_.hasMore();
            }

            @Override
            public int getNext() {
                if (this.onSecondary_) {
                    int toReturn = this.secondary_.getNext();
                    this.onSecondary_ = this.secondary_.hasMore();
                    return toReturn;
                }
                this.secondary_.reset();
                this.onSecondary_ = this.secondary_.hasMore();
                return this.primary_.getNext();
            }

            @Override
            public void reset() {
                this.primary_.reset();
                this.onSecondary_ = false;
            }

            static class Factory
            implements OEFactory {
                OEFactory primary_;
                OEFactory secondary_;

                public Factory(OEFactory primary, OEFactory secondary) {
                    this.primary_ = primary;
                    this.secondary_ = secondary;
                }

                @Override
                public OrderEnumerator createOrderEnumerator(int size) {
                    return new BiasAlternate(this.primary_.createOrderEnumerator(size), this.secondary_.createOrderEnumerator(size));
                }
            }
        }

        private static class Alternate
        implements OrderEnumerator {
            OrderEnumerator primary_;
            OrderEnumerator secondary_;
            boolean onSecondary_;

            public Alternate(OrderEnumerator primary, OrderEnumerator secondary) {
                this.primary_ = primary;
                this.secondary_ = secondary;
                this.reset();
            }

            @Override
            public boolean hasMore() {
                return this.primary_.hasMore() || this.secondary_.hasMore();
            }

            @Override
            public int getNext() {
                if (!this.onSecondary_ || !this.secondary_.hasMore()) {
                    int toReturn = this.primary_.getNext();
                    this.onSecondary_ = this.secondary_.hasMore();
                    return toReturn;
                }
                int toReturn = this.secondary_.getNext();
                this.onSecondary_ = !this.primary_.hasMore();
                return toReturn;
            }

            @Override
            public void reset() {
                this.primary_.reset();
                this.secondary_.reset();
                this.onSecondary_ = false;
            }

            static class Factory
            implements OEFactory {
                OEFactory primary_;
                OEFactory secondary_;

                public Factory(OEFactory primary, OEFactory secondary) {
                    this.primary_ = primary;
                    this.secondary_ = secondary;
                }

                @Override
                public OrderEnumerator createOrderEnumerator(int size) {
                    return new Alternate(this.primary_.createOrderEnumerator(size), this.secondary_.createOrderEnumerator(size));
                }
            }
        }

        private static class Adjust
        implements OrderEnumerator {
            OrderEnumerator toAdjust_;
            int adjustmentAmount_;

            public Adjust(OrderEnumerator toAdjust, int adjustmentAmount) {
                this.toAdjust_ = toAdjust;
                this.adjustmentAmount_ = adjustmentAmount;
                this.reset();
            }

            @Override
            public boolean hasMore() {
                return this.toAdjust_.hasMore();
            }

            @Override
            public int getNext() {
                return this.toAdjust_.getNext() + this.adjustmentAmount_;
            }

            @Override
            public void reset() {
                this.toAdjust_.reset();
            }

            static class Factory
            implements OEFactory {
                OEFactory toAdjustFactory_;
                int adjustmentAmount_;

                public Factory(OEFactory toAdjustFactory, int adjustmentAmount) {
                    this.toAdjustFactory_ = toAdjustFactory;
                    this.adjustmentAmount_ = adjustmentAmount;
                }

                @Override
                public OrderEnumerator createOrderEnumerator(int size) {
                    return new Adjust(this.toAdjustFactory_.createOrderEnumerator(size - this.adjustmentAmount_), this.adjustmentAmount_);
                }
            }
        }

        private static class Restricted
        implements OrderEnumerator {
            OrderEnumerator toAdjust_;
            int minimum_;
            int top_;
            int next_;
            boolean hasMore_;

            public Restricted(OrderEnumerator toAdjust, int minimum, int range) {
                this.toAdjust_ = toAdjust;
                this.minimum_ = minimum;
                this.top_ = minimum + range;
                this.reset();
            }

            @Override
            public boolean hasMore() {
                return this.hasMore_;
            }

            private void updateNext() {
                this.hasMore_ = false;
                while (this.toAdjust_.hasMore()) {
                    int i = this.toAdjust_.getNext();
                    if (i < this.minimum_ || i >= this.top_) continue;
                    this.next_ = i;
                    this.hasMore_ = true;
                    break;
                }
            }

            @Override
            public int getNext() {
                int myNext = this.next_;
                this.updateNext();
                return myNext;
            }

            @Override
            public void reset() {
                this.toAdjust_.reset();
                this.updateNext();
            }

            static class Factory
            implements OEFactory {
                OEFactory toAdjustFactory_;
                int minimum_;
                int range_;

                public Factory(OEFactory toAdjustFactory, int minimum, int range) {
                    this.toAdjustFactory_ = toAdjustFactory;
                    this.minimum_ = minimum;
                    this.range_ = range;
                }

                @Override
                public OrderEnumerator createOrderEnumerator(int size) {
                    return new Restricted(this.toAdjustFactory_.createOrderEnumerator(size), this.minimum_, this.range_);
                }
            }
        }

        private static class Shuffled
        implements OrderEnumerator {
            int currentIndex_;
            int[] indexes_;
            int size_;
            MersenneTwisterFast random_ = new MersenneTwisterFast();

            public Shuffled(int size) {
                this.size_ = size;
                this.indexes_ = new int[size];
                for (int i = 0; i < size; ++i) {
                    this.indexes_[i] = i;
                }
                this.reset();
            }

            @Override
            public boolean hasMore() {
                return this.currentIndex_ < this.size_;
            }

            @Override
            public int getNext() {
                return this.indexes_[this.currentIndex_++];
            }

            @Override
            public void reset() {
                this.currentIndex_ = 0;
                this.random_.shuffle(this.indexes_);
            }

            static class Factory
            implements OEFactory {
                static final Factory INSTANCE = new Factory();

                Factory() {
                }

                @Override
                public OrderEnumerator createOrderEnumerator(int size) {
                    return new Shuffled(size);
                }
            }
        }

        private static class Ordered
        implements OrderEnumerator {
            int index_;
            int size_;

            public Ordered(int size) {
                this.size_ = size;
                this.reset();
            }

            @Override
            public boolean hasMore() {
                return this.index_ < this.size_;
            }

            @Override
            public int getNext() {
                return this.index_++;
            }

            @Override
            public void reset() {
                this.index_ = 0;
            }

            static class Factory
            implements OEFactory {
                static final Factory INSTANCE = new Factory();

                Factory() {
                }

                @Override
                public OrderEnumerator createOrderEnumerator(int size) {
                    return new Ordered(size);
                }
            }
        }

        private static class Constant
        implements OrderEnumerator,
        OEFactory {
            int index_;
            boolean hasMore_;

            public Constant(int index) {
                this.index_ = index;
            }

            @Override
            public boolean hasMore() {
                return this.hasMore_;
            }

            @Override
            public int getNext() {
                this.hasMore_ = false;
                return this.index_;
            }

            @Override
            public void reset() {
                this.hasMore_ = true;
            }

            @Override
            public OrderEnumerator createOrderEnumerator(int size) {
                return this;
            }
        }
    }

    public static interface OEFactory {
        public OrderEnumerator createOrderEnumerator(int var1);
    }
}

