/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.util.TableReport;

public class Phenotype
implements TableReport {
    private ArrayListMultimap<ATTRIBUTE_TYPE, PhenotypeAttribute> attributeMultimap;
    private ArrayList<PhenotypeAttribute> attributeList;
    private TaxaList myTaxaList;
    private int numberOfAttributes;
    private int numberOfObservations;
    private String tableName;

    public Object getValue(int obs, int attrnum) {
        return this.attributeList.get(attrnum).getValue(obs);
    }

    public PhenotypeAttribute getAttribute(int attrnum) {
        return this.attributeList.get(attrnum);
    }

    public PhenotypeAttribute getAttributeOfType(ATTRIBUTE_TYPE type, int attrnum) {
        return (PhenotypeAttribute)this.attributeMultimap.get((Object)type).get(attrnum);
    }

    public List<PhenotypeAttribute> getAttributeListOfType(ATTRIBUTE_TYPE type) {
        return new ArrayList<PhenotypeAttribute>(this.attributeMultimap.get((Object)type));
    }

    public TaxaList getTaxaList() {
        return this.myTaxaList;
    }

    public int getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public int getNumberOfAttributesOfType(ATTRIBUTE_TYPE type) {
        return this.attributeMultimap.get((Object)type).size();
    }

    public int getNumberOfObservations() {
        return this.numberOfObservations;
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] columnNames = new String[this.numberOfAttributes];
        int count = 0;
        for (PhenotypeAttribute attr : this.attributeList) {
            columnNames[count++] = attr.getName();
        }
        return columnNames;
    }

    @Override
    public Object[][] getTableData() {
        return this.getTableData(0, this.numberOfObservations - 1);
    }

    @Override
    public String getTableTitle() {
        return this.tableName;
    }

    @Override
    public int getColumnCount() {
        return this.numberOfAttributes + 1;
    }

    @Override
    public int getRowCount() {
        return this.numberOfObservations;
    }

    @Override
    public int getElementCount() {
        return this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(int row) {
        int n = this.numberOfAttributes + 1;
        Object[] rowValues = new Object[this.numberOfAttributes + 1];
        for (int i = 0; i < n; ++i) {
            rowValues[i] = this.getValueAt(row, i);
        }
        return rowValues;
    }

    @Override
    public Object[][] getTableData(int start, int end) {
        int n = end - start + 1;
        Object[][] data = new Object[n][];
        for (int i = 0; i < n; ++i) {
            data[i] = this.getRow(start + i);
        }
        return data;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.myTaxaList.get(row);
        }
        return this.attributeList.get(col - 1).getValue(row);
    }

    public static enum ATTRIBUTE_TYPE {
        data,
        covariate,
        factor;

    }
}

