/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.util.Sizeof;
import net.maizegenetics.util.Utils;

public class PrintHeapAction
extends AbstractAction
implements Runnable {
    private static final Map myInstances = new HashMap(1);
    public static final String TEXT = "Show Memory";
    private final Frame myParentFrame;
    private long myLastRecordedHeap = 0L;
    private static final NumberFormat myFormat = NumberFormat.getInstance();

    private PrintHeapAction(Frame parentFrame) {
        super(TEXT, PrintHeapAction.getIcon());
        this.myParentFrame = parentFrame;
    }

    public static PrintHeapAction getInstance(Frame parentFrame) {
        PrintHeapAction result = (PrintHeapAction)myInstances.get(parentFrame);
        if (result == null) {
            result = new PrintHeapAction(parentFrame);
            myInstances.put(parentFrame, result);
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("Current Heap Size: ");
            long current = Sizeof.getMemoryUse();
            String currentStr = myFormat.format(current / 0x100000L);
            buffer.append(currentStr);
            buffer.append(" MB");
            buffer.append("\nMax Available Heap: ");
            buffer.append(Utils.getMaxHeapSizeMB());
            buffer.append(" MB");
            buffer.append("\nDelta Since Last Record: ");
            String delta = myFormat.format((current - this.myLastRecordedHeap) / 0x100000L);
            buffer.append(delta);
            buffer.append(" MB\n");
            this.myLastRecordedHeap = current;
        }
        catch (Exception ex) {
            buffer.append("\n");
            buffer.append(ex.getMessage());
        }
        String str = buffer.toString();
        JOptionPane dialog = new JOptionPane(str, 1);
        JOptionPane.showMessageDialog(this.myParentFrame, str, "Heap Used", 1);
    }

    private static ImageIcon getIcon() {
        URL imageURL = PrintHeapAction.class.getResource("MemoryUse16.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    static {
        myFormat.setMaximumFractionDigits(2);
    }
}

