/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import net.maizegenetics.dna.tag.AbstractTags;
import net.maizegenetics.dna.tag.TagsHDF5;
import net.maizegenetics.util.Tassel5HDF5Constants;

public abstract class AbstractTagsHDF5
extends AbstractTags
implements TagsHDF5 {
    protected IHDF5Writer h5 = null;
    protected int currentBlockIndex = -1;
    protected int currentIndex = -1;

    @Override
    public int getBlockSize() {
        return 65536;
    }

    @Override
    public int getBlockNum() {
        int num = super.getTagCount() / this.getBlockSize();
        if (super.getTagCount() % this.getBlockSize() == 0) {
            return num;
        }
        return num + 1;
    }

    @Override
    public int getBlockIndex(int currentIndex) {
        return currentIndex / this.getBlockSize();
    }

    @Override
    public int getCurrentBlockIndex() {
        return this.currentBlockIndex;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public int getCurrentIndexWithinBlock() {
        return this.getCurrentIndex() % this.getBlockSize();
    }

    protected void initializeMatrix(int tagCount, int tagLengthInLong) {
        this.tagLengthInLong = tagLengthInLong;
        this.tags = new long[tagLengthInLong][tagCount];
        this.tagLength = new byte[tagCount];
    }

    @Override
    public boolean isInCurrentBlock(int queryIndex) {
        int queryBlockIndex = queryIndex / this.getBlockSize();
        return queryBlockIndex == this.currentBlockIndex;
    }

    @Override
    public HDF5IntStorageFeatures getIntStorageFeatures() {
        return Tassel5HDF5Constants.intDeflation;
    }

    @Override
    public HDF5GenericStorageFeatures getGenericStorageFeatures() {
        return Tassel5HDF5Constants.genDeflation;
    }

    @Override
    public HDF5FloatStorageFeatures getFloatStorageFeatures() {
        return Tassel5HDF5Constants.floatDeflation;
    }

    @Override
    public void sort() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void swap(int index1, int index2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

