/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;

class ProcessHapMapBlock
implements Runnable {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private static final int NUM_HAPMAP_NON_TAXA_HEADERS = 11;
    private static final int GENOIDX = 11;
    private static final int SNPID_INDEX = 0;
    private static final int VARIANT_INDEX = 1;
    private static final int CHROMOSOME_INDEX = 2;
    private static final int POSITION_INDEX = 3;
    private final int taxaN;
    private final int siteN;
    private ArrayList<String> txtL;
    private SuperByteMatrix gTS;
    private final ArrayList<Position> blkPosList;
    private final boolean isOneLetter;

    private ProcessHapMapBlock(int taxaN, ArrayList<String> txtL) {
        this.taxaN = taxaN;
        this.siteN = txtL.size();
        this.txtL = txtL;
        this.blkPosList = new ArrayList(this.siteN);
        String[] tokens = WHITESPACE_PATTERN.split(txtL.get(0), 12);
        double avg = (double)(tokens[11].length() + 1) / (double)taxaN;
        if (avg > 1.99 && avg < 2.01) {
            this.isOneLetter = true;
        } else if (avg > 2.99 && avg < 3.01) {
            this.isOneLetter = false;
        } else {
            throw new IllegalStateException("ProcessHapMapBlock: Genotype coded wrong use 1 or 2 letters per genotype");
        }
    }

    public static ProcessHapMapBlock getInstance(int taxaN, ArrayList<String> txtL) {
        return new ProcessHapMapBlock(taxaN, txtL);
    }

    @Override
    public void run() {
        HashMap<String, Chromosome> chromosomeLookup = new HashMap<String, Chromosome>();
        this.gTS = SuperByteMatrixBuilder.getInstance(this.taxaN, this.siteN);
        for (int s = 0; s < this.siteN; ++s) {
            int i;
            String input = this.txtL.get(s);
            int[] tabPos = new int[11];
            int tabIndex = 0;
            int len = input.length();
            for (int i2 = 0; tabIndex < 11 && i2 < len; ++i2) {
                if (input.charAt(i2) != '\t') continue;
                tabPos[tabIndex++] = i2;
            }
            String chrName = input.substring(tabPos[1] + 1, tabPos[2]);
            Chromosome currChr = (Chromosome)chromosomeLookup.get(chrName);
            if (currChr == null) {
                currChr = new Chromosome(new String(chrName));
                chromosomeLookup.put(chrName, currChr);
            }
            String variants = input.substring(tabPos[0] + 1, tabPos[1]);
            GeneralPosition.Builder apb = new GeneralPosition.Builder(currChr, Integer.parseInt(input.substring(tabPos[2] + 1, tabPos[3]))).snpName(input.substring(0, tabPos[0])).knownVariants(variants);
            try {
                byte glbMajor = NucleotideAlignmentConstants.getNucleotideDiploidByte(variants.charAt(0));
                apb.allele(Position.Allele.GLBMAJ, glbMajor);
                if (variants.length() == 3) {
                    byte glbMinor = NucleotideAlignmentConstants.getNucleotideDiploidByte(variants.charAt(2));
                    apb.allele(Position.Allele.GLBMIN, glbMinor);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.blkPosList.add(apb.build());
            int offset = tabPos[10] + 1;
            if (this.isOneLetter) {
                for (i = offset; i < len; i += 2) {
                    this.gTS.set((i - offset) / 2, s, NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i)));
                }
                continue;
            }
            for (i = offset; i < len; i += 3) {
                this.gTS.set((i - offset) / 3, s, GenotypeTableUtils.getDiploidValue(NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i + 1)), NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i))));
            }
        }
        this.txtL = null;
    }

    int getSiteNumber() {
        return this.siteN;
    }

    SuperByteMatrix getGenoTS() {
        return this.gTS;
    }

    ArrayList<Position> getBlkPosList() {
        return this.blkPosList;
    }
}

