/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.depth;

import net.maizegenetics.dna.snp.depth.AlleleDepth;
import net.maizegenetics.dna.snp.depth.AlleleDepthUtil;

public abstract class AbstractAlleleDepth
implements AlleleDepth {
    private final int myNumAlleles;
    private final int myNumTaxa;
    private final int myNumSites;

    AbstractAlleleDepth(int numAlleles, int numTaxa, int numSites) {
        this.myNumAlleles = numAlleles;
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
    }

    @Override
    public int[] depthForAlleles(int taxon, int site) {
        int[] result = new int[this.myNumAlleles];
        for (int a = 0; a < this.myNumAlleles; ++a) {
            result[a] = this.depthForAllele(taxon, site, a);
        }
        return result;
    }

    @Override
    public int depthForAllele(int taxon, int site, int allele) {
        return AlleleDepthUtil.depthByteToInt(this.depthForAlleleByte(taxon, site, allele));
    }

    @Override
    public int depth(int taxon, int site) {
        int result = 0;
        for (int a = 0; a < this.myNumAlleles; ++a) {
            result += this.depthForAllele(taxon, site, a);
        }
        return result;
    }

    @Override
    public int depthForTaxon(int taxon) {
        int result = 0;
        for (int site = 0; site < this.myNumSites; ++site) {
            result += this.depth(taxon, site);
        }
        return result;
    }

    @Override
    public int depthForSite(int site) {
        int result = 0;
        for (int taxon = 0; taxon < this.myNumTaxa; ++taxon) {
            result += this.depth(taxon, site);
        }
        return result;
    }

    @Override
    public byte[][] depthAllSitesByte(int taxon) {
        byte[][] result = new byte[this.myNumAlleles][this.myNumSites];
        for (int allele = 0; allele < this.myNumAlleles; ++allele) {
            for (int site = 0; site < this.myNumSites; ++site) {
                byte[] byArray = result[allele];
                int n = site;
                byArray[n] = (byte)(byArray[n] + this.depthForAllele(taxon, site, allele));
            }
        }
        return result;
    }
}

