/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.bit;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.bit.BitStorage;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.util.BitSet;

public class DynamicBitStorage
implements BitStorage {
    private GenotypeCallTable myGenotype;
    private final GenotypeTable.WHICH_ALLELE myWhichAllele;
    private byte[] myPrefAllele;
    private final int myTaxaCount;
    private final int mySiteCount;
    private static final int SBoff = 58;
    Weigher<Long, BitSet> weighByLength = new Weigher<Long, BitSet>(){

        public int weigh(Long key, BitSet value) {
            return value.getNumWords() * 8;
        }
    };
    private LoadingCache<Long, BitSet> bitCache;
    private CacheLoader<Long, BitSet> bitLoader = new CacheLoader<Long, BitSet>(){

        public BitSet load(Long key) {
            if (DynamicBitStorage.this.getDirectionFromKey(key) == SB.TAXA) {
                byte[] a1 = DynamicBitStorage.this.myPrefAllele;
                int taxon = DynamicBitStorage.this.getSiteOrTaxonFromKey(key);
                BitSet bs = GenotypeTableUtils.calcBitPresenceFromGenotype(DynamicBitStorage.this.myGenotype.genotypeAllSites(taxon), a1);
                return bs;
            }
            ArrayList<Long> toFill = new ArrayList<Long>();
            toFill.add(key);
            try {
                DynamicBitStorage.this.bitCache.putAll(this.loadAll(toFill));
                return (BitSet)DynamicBitStorage.this.bitCache.get((Object)key);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Map<Long, BitSet> loadAll(Iterable<? extends Long> keys) throws Exception {
            long key = keys.iterator().next();
            HashMap<Long, BitSet> result = new HashMap<Long, BitSet>(64);
            int site = DynamicBitStorage.this.getSiteOrTaxonFromKey(key);
            int length = DynamicBitStorage.this.mySiteCount - site < 64 ? DynamicBitStorage.this.mySiteCount - site : 64;
            byte[][] genotypeTBlock = new byte[length][DynamicBitStorage.this.myTaxaCount];
            for (int t = 0; t < DynamicBitStorage.this.myTaxaCount; ++t) {
                for (int s = 0; s < genotypeTBlock.length; ++s) {
                    genotypeTBlock[s][t] = DynamicBitStorage.this.myGenotype.genotype(t, site + s);
                }
            }
            for (int i = 0; i < length; ++i) {
                byte a1 = DynamicBitStorage.this.myPrefAllele[site + i];
                BitSet bs = GenotypeTableUtils.calcBitPresenceFromGenotype(genotypeTBlock[i], a1);
                result.put(DynamicBitStorage.this.getKey(SB.SITE, site + i), bs);
            }
            return result;
        }
    };

    private long getKey(SB direction, int siteOrTaxon) {
        return (long)direction.index << 58 | (long)siteOrTaxon;
    }

    private int getSiteOrTaxonFromKey(long key) {
        return (int)(key << 32 >>> 32);
    }

    private SB getDirectionFromKey(long key) {
        if (key >>> 58 == (long)SB.TAXA.index) {
            return SB.TAXA;
        }
        return SB.SITE;
    }

    @Override
    public BitSet allelePresenceForAllSites(int taxon) {
        try {
            return (BitSet)this.bitCache.get((Object)this.getKey(SB.TAXA, taxon));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public BitSet allelePresenceForAllTaxa(int site) {
        try {
            return (BitSet)this.bitCache.get((Object)this.getKey(SB.SITE, site));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long[] allelePresenceForSitesBlock(int taxon, int startBlock, int endBlock) {
        BitSet result = this.allelePresenceForAllSites(taxon);
        if (result == null) {
            return new long[0];
        }
        return result.getBits(startBlock, endBlock - 1);
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllSites(int taxon, boolean firstParent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllTaxa(int site, boolean firstParent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] haplotypeAllelePresenceForSitesBlock(int taxon, boolean firstParent, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DynamicBitStorage(GenotypeCallTable genotype, GenotypeTable.WHICH_ALLELE allele, byte[] prefAllele) {
        this.myGenotype = genotype;
        this.myWhichAllele = allele;
        this.mySiteCount = this.myGenotype.numberOfSites();
        this.myTaxaCount = this.myGenotype.numberOfTaxa();
        this.myPrefAllele = Arrays.copyOf(prefAllele, prefAllele.length);
        this.bitCache = CacheBuilder.newBuilder().maximumWeight(300000000L).weigher(this.weighByLength).build(this.bitLoader);
    }

    private static enum SB {
        TAXA(0),
        SITE(1);

        public final int index;

        private SB(int index) {
            this.index = index;
        }
    }
}

