/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.maizegenetics.dna.map.DonorHaplotypes;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.ProjectionGenotypeCallTable;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

public class ProjectionBuilder {
    private final GenotypeTable myBaseAlignment;
    private ImmutableMap.Builder<Taxon, NavigableSet<DonorHaplotypes>> allBreakPoints;

    public static GenotypeTable getInstance(GenotypeTable baseAlignment, ImmutableMap<Taxon, NavigableSet<DonorHaplotypes>> allBreakPoints) {
        TaxaList tl = new TaxaListBuilder().addAll((Collection<Taxon>)allBreakPoints.keySet()).build();
        ImmutableList breakList = ImmutableList.builder().addAll((Iterable)allBreakPoints.values()).build();
        return GenotypeTableBuilder.getInstance(new ProjectionGenotypeCallTable(baseAlignment, (ImmutableList<NavigableSet<DonorHaplotypes>>)breakList), baseAlignment.positions(), tl);
    }

    public ProjectionBuilder(GenotypeTable myBaseAlignment) {
        this.myBaseAlignment = myBaseAlignment;
        this.allBreakPoints = new ImmutableMap.Builder();
    }

    public synchronized ProjectionBuilder addTaxon(Taxon taxon, Map<Position, Taxon[]> breakPoints) {
        NavigableSet<DonorHaplotypes> intBreak = this.convertToIndexBreakPoints(breakPoints);
        this.allBreakPoints.put((Object)taxon, intBreak);
        return this;
    }

    public synchronized ProjectionBuilder addTaxon(Taxon taxon, NavigableSet<DonorHaplotypes> breakPoints) {
        this.allBreakPoints.put((Object)taxon, breakPoints);
        return this;
    }

    public synchronized ProjectionBuilder addTaxon(Taxon taxon, Collection<DonorHaplotypes> breakPoints) {
        TreeSet<DonorHaplotypes> tBreak = new TreeSet<DonorHaplotypes>();
        for (DonorHaplotypes breakPoint : breakPoints) {
            tBreak.add(breakPoint);
        }
        return this.addTaxon(taxon, (NavigableSet<DonorHaplotypes>)tBreak);
    }

    public GenotypeTable build() {
        ImmutableMap immBreak = this.allBreakPoints.build();
        System.out.println(immBreak.size());
        return ProjectionBuilder.getInstance(this.myBaseAlignment, (ImmutableMap<Taxon, NavigableSet<DonorHaplotypes>>)immBreak);
    }

    private NavigableSet<DonorHaplotypes> convertToIndexBreakPoints(Map<Position, Taxon[]> breakPoints) {
        DonorHaplotypes lastP = new DonorHaplotypes(null, -1, -1, -1, -1);
        TreeSet<DonorHaplotypes> intBreak = new TreeSet<DonorHaplotypes>();
        TaxaList tl = this.myBaseAlignment.taxa();
        for (Map.Entry<Position, Taxon[]> bp : breakPoints.entrySet()) {
            Taxon[] ts = bp.getValue();
            if (ts.length != 2) {
                throw new IllegalArgumentException("Two parents required for DonorHaplotypes");
            }
            int[] iT = new int[ts.length];
            for (int i = 0; i < iT.length; ++i) {
                int r = tl.indexOf(ts[i]);
                if (r < 0) {
                    throw new IllegalArgumentException("Taxa not found or duplicated:" + ts[i].getName());
                }
                iT[i] = r;
            }
            DonorHaplotypes dh = new DonorHaplotypes(bp.getKey().getChromosome(), bp.getKey().getPosition(), Integer.MAX_VALUE, iT[0], iT[1]);
            if (lastP == dh) continue;
            intBreak.add(dh);
            lastP = dh;
        }
        return intBreak;
    }
}

