/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.bit.BitStorage;
import net.maizegenetics.dna.snp.depth.AlleleDepth;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;

public class CombineGenotypeTable
implements GenotypeTable {
    private static final long serialVersionUID = -5197800047652332969L;
    private final GenotypeTable[] myAlignments;
    private final int[] mySiteOffsets;
    private final Map<Chromosome, GenotypeTable> myChromosomes = new HashMap<Chromosome, GenotypeTable>();
    private Chromosome[] myChromosomesList;
    private int[] myChromosomesOffsets;
    private final TaxaList myTaxaList;
    private String[][] myAlleleStates;

    private CombineGenotypeTable(TaxaList taxaList, GenotypeTable[] genoTables) {
        this.myTaxaList = taxaList;
        this.myAlignments = genoTables;
        this.mySiteOffsets = new int[genoTables.length + 1];
        this.mySiteOffsets[0] = 0;
        int count = 0;
        for (int i = 0; i < genoTables.length; ++i) {
            this.mySiteOffsets[i + 1] = count = genoTables[i].numberOfSites() + count;
            Chromosome[] chromosomes = genoTables[i].chromosomes();
            for (int j = 0; j < chromosomes.length; ++j) {
                this.myChromosomes.put(chromosomes[j], genoTables[i]);
            }
        }
        this.initChromosomes();
    }

    public static GenotypeTable getInstance(GenotypeTable[] genoTables) {
        if (genoTables == null || genoTables.length == 0) {
            throw new IllegalArgumentException("CombineAlignment: getInstance: must provide genoTables.");
        }
        if (genoTables.length == 1) {
            return genoTables[0];
        }
        TaxaList firstGroup = genoTables[0].taxa();
        for (int i = 1; i < genoTables.length; ++i) {
            if (CombineGenotypeTable.areTaxaListsEqual(firstGroup, genoTables[i].taxa())) continue;
            throw new IllegalArgumentException("CombineAlignment: getInstance: TaxaLists do not match.");
        }
        return new CombineGenotypeTable(firstGroup, genoTables);
    }

    public static GenotypeTable getInstance(GenotypeTable[] genoTables, boolean isUnion) {
        if (genoTables == null || genoTables.length == 0) {
            throw new IllegalArgumentException("CombineAlignment: getInstance: must provide genoTables.");
        }
        if (genoTables.length == 1) {
            return genoTables[0];
        }
        TaxaList[] groups = new TaxaList[genoTables.length];
        for (int i = 0; i < genoTables.length; ++i) {
            groups[i] = genoTables[i].taxa();
        }
        TaxaList newTaxa = null;
        newTaxa = isUnion ? TaxaListUtils.getAllTaxa(groups) : TaxaListUtils.getCommonTaxa(groups);
        GenotypeTable[] newAlignmentNews = new GenotypeTable[genoTables.length];
        for (int i = 0; i < genoTables.length; ++i) {
            newAlignmentNews[i] = FilterGenotypeTable.getInstance(genoTables[i], newTaxa);
        }
        return new CombineGenotypeTable(newTaxa, newAlignmentNews);
    }

    private static boolean areTaxaListsEqual(TaxaList first, TaxaList second) {
        if (first.numberOfTaxa() != second.numberOfTaxa()) {
            return false;
        }
        int n = first.numberOfTaxa();
        for (int i = 0; i < n; ++i) {
            if (((Taxon)first.get(i)).equals(second.get(i))) continue;
            return false;
        }
        return true;
    }

    private void initChromosomes() {
        int i;
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
        for (i = 0; i < this.myAlignments.length; ++i) {
            chromosomes.addAll(Arrays.asList(this.myAlignments[i].chromosomes()));
            int[] tempOffsets = this.myAlignments[i].chromosomesOffsets();
            for (int j = 0; j < tempOffsets.length; ++j) {
                offsets.add(tempOffsets[j] + this.mySiteOffsets[i]);
            }
        }
        this.myChromosomesList = new Chromosome[chromosomes.size()];
        this.myChromosomesList = chromosomes.toArray(this.myChromosomesList);
        this.myChromosomesOffsets = new int[offsets.size()];
        for (i = 0; i < offsets.size(); ++i) {
            this.myChromosomesOffsets[i] = (Integer)offsets.get(i);
        }
        if (this.myChromosomesOffsets.length != this.myChromosomesList.length) {
            throw new IllegalStateException("CombineAlignment: initChromosomes: number chromosomes offsets should equal number of chromosomes.");
        }
    }

    @Override
    public byte genotype(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].genotype(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] genotypeRange(int taxon, int startSite, int endSite) {
        byte[] result = new byte[endSite - startSite];
        int count = 0;
        int firstAlign = this.translateSite(startSite);
        int secondAlign = this.translateSite(endSite);
        for (int i = firstAlign; i <= secondAlign; ++i) {
            int firstSite = 0;
            if (i == firstAlign) {
                firstSite = startSite - this.mySiteOffsets[firstAlign];
            }
            int secondSite = 0;
            secondSite = firstAlign == secondAlign ? endSite - this.mySiteOffsets[firstAlign] : (i != secondAlign ? this.myAlignments[i].numberOfSites() : endSite - this.mySiteOffsets[secondAlign]);
            for (int s = firstSite; s < secondSite; ++s) {
                result[count++] = this.myAlignments[i].genotype(taxon, s);
            }
        }
        return result;
    }

    @Override
    public byte genotype(int taxon, Chromosome locus, int physicalPosition) {
        int site = this.siteOfPhysicalPosition(physicalPosition, locus);
        int translate = this.translateSite(site);
        return this.myAlignments[translate].genotype(taxon, site - this.mySiteOffsets[translate]);
    }

    public int translateSite(int site) {
        for (int i = 1; i < this.mySiteOffsets.length; ++i) {
            if (this.mySiteOffsets[i] <= site) continue;
            return i - 1;
        }
        throw new IndexOutOfBoundsException("CombineAlignment: translateSite: index out of range: " + site);
    }

    @Override
    public boolean hasReference() {
        for (int i = 0; i < this.myAlignments.length; ++i) {
            if (this.myAlignments[i].hasReference()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String siteName(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].siteName(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int numberOfSites() {
        return this.mySiteOffsets[this.mySiteOffsets.length - 1];
    }

    @Override
    public int chromosomeSiteCount(Chromosome locus) {
        return this.myChromosomes.get(locus).chromosomeSiteCount(locus);
    }

    @Override
    public int chromosomalPosition(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].chromosomalPosition(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome locus) {
        GenotypeTable align = this.myChromosomes.get(locus);
        int i = -1;
        for (int j = 0; j < this.myAlignments.length; ++j) {
            if (this.myAlignments[j] != align) continue;
            i = j;
            break;
        }
        if (i == -1) {
            return -1;
        }
        return this.mySiteOffsets[i] + align.siteOfPhysicalPosition(physicalPosition, locus);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome locus, String snpName) {
        GenotypeTable align = this.myChromosomes.get(locus);
        int i = -1;
        for (int j = 0; j < this.myAlignments.length; ++j) {
            if (this.myAlignments[j] != align) continue;
            i = j;
            break;
        }
        if (i == -1) {
            return -1;
        }
        return this.mySiteOffsets[i] + align.siteOfPhysicalPosition(physicalPosition, locus, snpName);
    }

    @Override
    public Chromosome chromosome(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].chromosome(site - this.mySiteOffsets[translate]);
    }

    @Override
    public Chromosome[] chromosomes() {
        return this.myChromosomesList;
    }

    @Override
    public int numChromosomes() {
        if (this.myChromosomesList == null) {
            return 0;
        }
        return this.myChromosomesList.length;
    }

    @Override
    public float[][] siteScores() {
        if (!this.hasSiteScores()) {
            return null;
        }
        int numSeqs = this.numberOfTaxa();
        float[][] result = new float[numSeqs][this.numberOfSites()];
        int n = this.myAlignments.length;
        for (int a = 0; a < n; ++a) {
            if (!this.myAlignments[a].hasSiteScores()) continue;
            int m = this.myAlignments[a].numberOfSites();
            for (int s = 0; s < m; ++s) {
                for (int t = 0; t < numSeqs; ++t) {
                    result[t][this.mySiteOffsets[a] + s] = this.myAlignments[a].siteScore(t, s);
                }
            }
        }
        return result;
    }

    @Override
    public float siteScore(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].siteScore(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public boolean hasSiteScores() {
        for (GenotypeTable align : this.myAlignments) {
            if (!align.hasSiteScores()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indelSize(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].indelSize(site - this.mySiteOffsets[translate]);
    }

    @Override
    public boolean isIndel(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].isIndel(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte referenceAllele(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].referenceAllele(site - this.mySiteOffsets[translate]);
    }

    @Override
    public GenotypeTable[] compositeAlignments() {
        return this.myAlignments;
    }

    @Override
    public byte majorAllele(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].majorAllele(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte minorAllele(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].minorAllele(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] minorAlleles(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].minorAlleles(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] alleles(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].alleles(site - this.mySiteOffsets[translate]);
    }

    @Override
    public double minorAlleleFrequency(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].minorAlleleFrequency(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].allelesSortedByFrequency(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] genotypeArray(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].genotypeArray(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] genotypeAllTaxa(int site) {
        byte[] result = new byte[this.numberOfTaxa()];
        int offset = 0;
        for (int i = 0; i < this.myAlignments.length; ++i) {
            byte[] current = this.myAlignments[i].genotypeAllTaxa(site);
            System.arraycopy(current, 0, result, offset, current.length);
            offset += current.length;
        }
        return result;
    }

    @Override
    public byte[] genotypeAllSites(int taxon) {
        byte[] result = new byte[this.numberOfSites()];
        for (int i = 0; i < this.myAlignments.length; ++i) {
            byte[] current = this.myAlignments[i].genotypeAllSites(taxon);
            System.arraycopy(current, 0, result, this.myChromosomesOffsets[i], current.length);
        }
        return result;
    }

    @Override
    public BitSet allelePresenceForAllSites(int taxon, GenotypeTable.WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("CombineAlignment: getAllelePresenceForAllSites: This operation isn't possible as it spans multiple GenotypeTables.");
    }

    @Override
    public long[] allelePresenceForSitesBlock(int taxon, GenotypeTable.WHICH_ALLELE allele, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("CombineAlignment: getAllelePresenceForSitesBlock: This operation isn't possible as it spans multiple GenotypeTables.");
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].genotypeAsString(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public String[] genotypeAsStringArray(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].genotypeAsStringArray(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] referenceAlleles(int startSite, int endSite) {
        int numSites = endSite - startSite;
        byte[] result = new byte[numSites];
        for (int i = 0; i < numSites; ++i) {
            result[i] = this.referenceAllele(startSite + i);
        }
        return result;
    }

    @Override
    public byte[] referenceAlleleForAllSites() {
        for (int i = 0; i < this.myAlignments.length; ++i) {
            if (this.myAlignments[i].hasReference()) continue;
            return null;
        }
        byte[] result = new byte[this.numberOfSites()];
        int count = 0;
        for (int i = 0; i < this.myAlignments.length; ++i) {
            byte[] current = this.myAlignments[i].referenceAlleleForAllSites();
            for (int j = 0; j < current.length; ++j) {
                result[count++] = current[j];
            }
        }
        return result;
    }

    @Override
    public boolean isHeterozygous(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].isHeterozygous(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public int[] physicalPositions() {
        boolean allNull = true;
        for (int i = 0; i < this.myAlignments.length; ++i) {
            int[] current = this.myAlignments[0].physicalPositions();
            if (current == null || current.length == 0) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            return null;
        }
        int[] result = new int[this.numberOfSites()];
        int count = 0;
        for (int i = 0; i < this.myAlignments.length; ++i) {
            int[] current = this.myAlignments[i].physicalPositions();
            for (int j = 0; j < current.length; ++j) {
                result[count++] = current[j];
            }
        }
        return result;
    }

    @Override
    public String chromosomeName(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].chromosomeName(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int[] chromosomesOffsets() {
        return this.myChromosomesOffsets;
    }

    @Override
    public GenotypeTable.SITE_SCORE_TYPE siteScoreType() {
        GenotypeTable.SITE_SCORE_TYPE first = this.myAlignments[0].siteScoreType();
        for (int i = 1; i < this.myAlignments.length; ++i) {
            if (first == this.myAlignments[i].siteScoreType()) continue;
            return GenotypeTable.SITE_SCORE_TYPE.MixedScoreTypes;
        }
        return first;
    }

    @Override
    public boolean isAllPolymorphic() {
        for (int i = 0; i < this.myAlignments.length; ++i) {
            if (this.myAlignments[i].isAllPolymorphic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPolymorphic(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].isPolymorphic(site - this.mySiteOffsets[translate]);
    }

    @Override
    public double majorAlleleFrequency(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].majorAlleleFrequency(site - this.mySiteOffsets[translate]);
    }

    @Override
    public String genomeVersion() {
        String first = this.myAlignments[0].genomeVersion();
        if (first == null) {
            return null;
        }
        for (int i = 1; i < this.myAlignments.length; ++i) {
            String current = this.myAlignments[i].genomeVersion();
            if (current == null || first.equals(current)) continue;
            return null;
        }
        return first;
    }

    @Override
    public boolean isPositiveStrand(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].isPositiveStrand(site - this.mySiteOffsets[translate]);
    }

    @Override
    public boolean isPhased() {
        for (int i = 0; i < this.myAlignments.length; ++i) {
            if (this.myAlignments[i].isPhased()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainsRareAlleles() {
        for (int i = 0; i < this.myAlignments.length; ++i) {
            if (this.myAlignments[i].retainsRareAlleles()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[][] alleleDefinitions() {
        if (this.myAlleleStates != null) {
            return this.myAlleleStates;
        }
        boolean allTheSame = true;
        String[][] encodings = this.myAlignments[0].alleleDefinitions();
        if (encodings.length == 1) {
            for (int i = 1; i < this.myAlignments.length; ++i) {
                String[][] current = this.myAlignments[i].alleleDefinitions();
                if (current.length != 1 || encodings[0].length != current[0].length) {
                    allTheSame = false;
                    break;
                }
                for (int j = 0; j < encodings[0].length; ++j) {
                    if (current[0][j].equals(encodings[0][j])) continue;
                    allTheSame = false;
                    break;
                }
                if (allTheSame) {
                    continue;
                }
                break;
            }
        } else {
            allTheSame = false;
        }
        if (allTheSame) {
            this.myAlleleStates = encodings;
        } else {
            String[][] result = new String[this.numberOfSites()][];
            int count = 0;
            for (int i = 0; i < this.myAlignments.length; ++i) {
                int n = this.myAlignments[i].numberOfSites();
                for (int j = 0; j < n; ++j) {
                    result[count++] = this.myAlignments[i].alleleDefinitions(j);
                }
            }
            this.myAlleleStates = result;
        }
        return this.myAlleleStates;
    }

    @Override
    public String[] alleleDefinitions(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].alleleDefinitions(site - this.mySiteOffsets[translate]);
    }

    @Override
    public String genotypeAsString(int site, byte value) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].genotypeAsString(site - this.mySiteOffsets[translate], value);
    }

    @Override
    public int maxNumAlleles() {
        int result = 999999;
        for (int i = 0; i < this.myAlignments.length; ++i) {
            if (this.myAlignments[i].maxNumAlleles() >= result) continue;
            result = this.myAlignments[i].maxNumAlleles();
        }
        return result;
    }

    @Override
    public int totalGametesNonMissingForSite(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].totalGametesNonMissingForSite(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int heterozygousCount(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].heterozygousCount(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int minorAlleleCount(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].minorAlleleCount(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int majorAlleleCount(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].majorAlleleCount(site - this.mySiteOffsets[translate]);
    }

    @Override
    public Object[][] genosSortedByFrequency(int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].genosSortedByFrequency(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] allelesBySortType(GenotypeTable.ALLELE_SORT_TYPE scope, int site) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].allelesBySortType(scope, site - this.mySiteOffsets[translate]);
    }

    @Override
    public BitSet allelePresenceForAllTaxa(int site, GenotypeTable.WHICH_ALLELE allele) {
        int translate = this.translateSite(site);
        return this.myAlignments[translate].allelePresenceForAllTaxa(site - this.mySiteOffsets[translate], allele);
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllSites(int taxon, boolean firstParent, GenotypeTable.WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllTaxa(int site, boolean firstParent, GenotypeTable.WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] haplotypeAllelePresenceForSitesBlock(int taxon, boolean firstParent, GenotypeTable.WHICH_ALLELE allele, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String genotypeAsStringRow(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] firstLastSiteOfChromosome(Chromosome chromosome) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int numberOfTaxa() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Chromosome chromosome(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String majorAlleleAsString(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String minorAlleleAsString(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TaxaList taxa() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String taxaName(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String diploidAsString(int site, byte value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int totalNonMissingForSite(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[][] genoCounts() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[][] majorMinorCounts() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int totalGametesNonMissingForTaxon(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int heterozygousCountForTaxon(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int totalNonMissingForTaxon(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasDepth() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AlleleDepth depth() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] depthForAlleles(int taxon, int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitStorage bitStorage(GenotypeTable.WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PositionList positions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GenotypeCallTable genotypeMatrix() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

