/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.collect.ArrayListMultimap;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;

final class PositionArrayList
implements PositionList {
    private final List<Position> mySiteList;
    private final int numPositions;
    private final byte[][] alleles;
    private final Map<Chromosome, ChrOffPos> myChrOffPosTree;
    private final Map<String, Chromosome> myChrNameHash;
    private final Chromosome firstChromosome;
    private final String genomeVersion;

    PositionArrayList(ArrayList<Position> builderList, String genomeVersion) {
        this.genomeVersion = genomeVersion;
        this.numPositions = builderList.size();
        this.alleles = new byte[Position.Allele.COUNT][this.numPositions];
        ArrayListMultimap pTS = ArrayListMultimap.create();
        this.mySiteList = new ArrayList<Position>(builderList.size());
        this.myChrOffPosTree = new TreeMap<Chromosome, ChrOffPos>();
        this.myChrNameHash = new HashMap<String, Chromosome>();
        int currStart = 0;
        if (builderList.isEmpty()) {
            this.firstChromosome = null;
            return;
        }
        Chromosome currChr = builderList.get(0).getChromosome();
        for (int i = 0; i < builderList.size(); ++i) {
            Position ap = builderList.get(i);
            for (Position.Allele allele : Position.Allele.values()) {
                this.alleles[allele.index()][i] = ap.getAllele(allele);
            }
            this.mySiteList.add(ap);
            if (!ap.getChromosome().equals(currChr)) {
                this.myChrOffPosTree.put(currChr, new ChrOffPos(currStart, i - 1, null));
                currChr = ap.getChromosome();
                currStart = i;
            }
            if (i == builderList.size() - 1) {
                this.myChrOffPosTree.put(currChr, new ChrOffPos(currStart, i, null));
                currChr = null;
            }
            pTS.put((Object)ap.getChromosome(), (Object)ap.getPosition());
        }
        for (Chromosome chr : pTS.keySet()) {
            List p = pTS.get((Object)chr);
            int[] intP = new int[p.size()];
            for (int i = 0; i < intP.length; ++i) {
                intP[i] = (Integer)p.get(i);
            }
            ChrOffPos currOff = this.myChrOffPosTree.get(chr);
            this.myChrOffPosTree.put(chr, new ChrOffPos(currOff.startSiteOff, currOff.endSiteOff, intP));
            this.myChrNameHash.put(chr.getName(), chr);
        }
        this.firstChromosome = (Chromosome)((TreeMap)this.myChrOffPosTree).firstKey();
        pTS = null;
    }

    @Override
    public byte referenceAllele(int site) {
        return this.mySiteList.get(site).getAllele(Position.Allele.REF);
    }

    @Override
    public byte[] referenceAlleles(int startSite, int endSite) {
        byte[] result = new byte[endSite - startSite];
        System.arraycopy(this.alleles[Position.Allele.REF.index()], startSite, result, 0, result.length);
        return result;
    }

    @Override
    public byte[] referenceAlleleForAllSites() {
        return Arrays.copyOf(this.alleles[Position.Allele.REF.index()], this.alleles[Position.Allele.REF.index()].length);
    }

    @Override
    public boolean hasReference() {
        return this.genomeVersion != null;
    }

    @Override
    public String siteName(int site) {
        return this.mySiteList.get(site).getSNPID();
    }

    @Override
    public int numberOfSites() {
        return this.numPositions;
    }

    @Override
    public int chromosomeSiteCount(Chromosome chromosome) {
        return this.myChrOffPosTree.get((Object)chromosome).position.length;
    }

    @Override
    public int[] startAndEndOfChromosome(Chromosome chromosome) {
        ChrOffPos cop;
        if (chromosome == null) {
            chromosome = this.firstChromosome;
        }
        if ((cop = this.myChrOffPosTree.get(chromosome)) == null) {
            return null;
        }
        return new int[]{cop.startSiteOff, cop.endSiteOff};
    }

    @Override
    public int chromosomalPosition(int site) {
        return this.mySiteList.get(site).getPosition();
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome) {
        int i;
        ChrOffPos cop;
        if (chromosome == null) {
            chromosome = this.firstChromosome;
        }
        if ((cop = this.myChrOffPosTree.get(chromosome)) == null) {
            return Integer.MIN_VALUE;
        }
        for (i = Arrays.binarySearch(cop.position, physicalPosition); i > 0 && physicalPosition == cop.position[i - 1]; --i) {
        }
        return i += i < 0 ? -cop.startSiteOff : cop.startSiteOff;
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome, String snpName) {
        int result = this.siteOfPhysicalPosition(physicalPosition, chromosome);
        if (result < 0) {
            return result;
        }
        if (snpName.equals(this.siteName(result))) {
            return result;
        }
        int index = result;
        while (index < this.numPositions && this.chromosomalPosition(index) == physicalPosition) {
            if (snpName.equals(this.siteName(index))) {
                return index;
            }
            ++result;
        }
        return -result - 1;
    }

    @Override
    public int[] physicalPositions() {
        int[] result = new int[this.numPositions];
        IntBuffer ib = IntBuffer.wrap(result);
        for (ChrOffPos cop : this.myChrOffPosTree.values()) {
            ib.put(cop.position);
        }
        return result;
    }

    @Override
    public String chromosomeName(int site) {
        return this.mySiteList.get(site).getChromosome().getName();
    }

    @Override
    public Chromosome chromosome(int site) {
        return this.mySiteList.get(site).getChromosome();
    }

    @Override
    public Chromosome chromosome(String name) {
        return this.myChrNameHash.get(name);
    }

    @Override
    public Chromosome[] chromosomes() {
        return this.myChrOffPosTree.keySet().toArray(new Chromosome[0]);
    }

    @Override
    public int numChromosomes() {
        return this.myChrOffPosTree.size();
    }

    @Override
    public int[] chromosomesOffsets() {
        int[] result = new int[this.myChrOffPosTree.size()];
        int index = 0;
        for (ChrOffPos cop : this.myChrOffPosTree.values()) {
            result[index++] = cop.startSiteOff;
        }
        return result;
    }

    @Override
    public int indelSize(int site) {
        return this.mySiteList.get(site).getKnownVariants()[1].length();
    }

    @Override
    public boolean isIndel(int site) {
        return this.mySiteList.get(site).isIndel();
    }

    @Override
    public String genomeVersion() {
        return this.genomeVersion;
    }

    @Override
    public boolean isPositiveStrand(int site) {
        return 1 == this.mySiteList.get(site).getStrand();
    }

    @Override
    public int size() {
        return this.mySiteList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mySiteList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.mySiteList.contains(o);
    }

    @Override
    public Iterator<Position> iterator() {
        return this.mySiteList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.mySiteList.toArray();
    }

    @Override
    public <AnnotatedSite> AnnotatedSite[] toArray(AnnotatedSite[] a) {
        return this.mySiteList.toArray(a);
    }

    @Override
    @Deprecated
    public boolean add(Position e) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mySiteList.containsAll(c);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends Position> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends Position> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public Position get(int index) {
        return this.mySiteList.get(index);
    }

    @Override
    @Deprecated
    public Position set(int index, Position element) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public void add(int index, Position element) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public Position remove(int index) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public int indexOf(Object o) {
        return Collections.binarySearch(this.mySiteList, (Position)o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.mySiteList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Position> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Position> listIterator(final int index) {
        return new ListIterator<Position>(){
            private final ListIterator<Position> i;
            {
                this.i = PositionArrayList.this.mySiteList.listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Position next() {
                return this.i.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            @Override
            public Position previous() {
                return this.i.previous();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Position e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Position e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<Position> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.mySiteList.subList(fromIndex, toIndex));
    }

    private static class ChrOffPos {
        final int startSiteOff;
        final int endSiteOff;
        final int[] position;

        private ChrOffPos(int startSiteOff, int endSiteOff, int[] position) {
            this.startSiteOff = startSiteOff;
            this.endSiteOff = endSiteOff;
            this.position = position;
        }
    }
}

