/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import net.maizegenetics.analysis.numericaltransform.Conversion;
import net.maizegenetics.analysis.numericaltransform.ImputePanel;
import net.maizegenetics.analysis.numericaltransform.NumericalGenotypePanel;
import net.maizegenetics.analysis.numericaltransform.NumericalGenotypePlugin;
import net.maizegenetics.analysis.numericaltransform.PCAPanel;
import net.maizegenetics.analysis.numericaltransform.TransformationPanel;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;

class NumTransformDialog
extends JDialog {
    private Datum myInput;
    private List<Datum> myResults = new ArrayList<Datum>();
    private Phenotype myCharacterAlignment;
    private GenotypeTable myGenotype;
    private JTabbedPane myTabbedPane = new JTabbedPane();
    private int myTransformTabIndex = -1;
    private int myImputationTabIndex = -1;
    private int myPcaTabIndex = -1;
    private int myNgTabIndex = -1;
    private ImputePanel myPnlImputation;
    private TransformationPanel myPnlTranformation;
    private PCAPanel myPnlPCA;
    private NumericalGenotypePanel myPnlNumericalGenotype;
    private JTable myTblTraits;
    private Frame myParentFrame = null;

    public NumTransformDialog(Frame frame, Datum theDatum) throws Exception {
        super(frame, true);
        this.myInput = theDatum;
        this.myParentFrame = frame;
        if (theDatum.getData() instanceof Phenotype) {
            this.myCharacterAlignment = (Phenotype)theDatum.getData();
        } else if (theDatum.getData() instanceof GenotypeTable) {
            this.myGenotype = (GenotypeTable)theDatum.getData();
        } else {
            throw new Exception("Must be Phenotype or Genotype");
        }
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            System.out.println("Error in NumTransform Dialog");
        }
    }

    private void jbInit() throws Exception {
        if (this.myCharacterAlignment != null) {
            this.myTblTraits = this.createTraitTable(this.myCharacterAlignment);
            this.myTblTraits.selectAll();
        }
        this.myTabbedPane.setDebugGraphicsOptions(0);
        JButton btnCreateAlignment = new JButton();
        btnCreateAlignment.setActionCommand("Create Dataset");
        btnCreateAlignment.setText("Create Dataset");
        btnCreateAlignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumTransformDialog.this.btnCreateAlignment_actionPerformed(e);
            }
        });
        JButton btnClose = new JButton();
        btnClose.setText("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumTransformDialog.this.btnClose_actionPerformed(e);
            }
        });
        if (this.myCharacterAlignment != null) {
            this.myPnlTranformation = new TransformationPanel(this.myInput, this.myParentFrame);
            this.myPnlImputation = new ImputePanel(this.myInput);
            this.myPnlPCA = new PCAPanel(this.myInput, this.myParentFrame);
            this.myTabbedPane.add((Component)this.myPnlTranformation, "Trans");
            this.myTransformTabIndex = this.myTabbedPane.getTabCount() - 1;
            this.myTabbedPane.add((Component)this.myPnlImputation, "Impute");
            this.myImputationTabIndex = this.myTabbedPane.getTabCount() - 1;
            this.myTabbedPane.add((Component)this.myPnlPCA, "PCA");
            this.myPcaTabIndex = this.myTabbedPane.getTabCount() - 1;
        } else if (this.myGenotype != null) {
            this.myPnlNumericalGenotype = new NumericalGenotypePanel(this.myInput);
            this.myTabbedPane.add((Component)this.myPnlNumericalGenotype, "Numerical Genotype");
            this.myNgTabIndex = this.myTabbedPane.getTabCount() - 1;
        }
        JScrollPane scpTraits = new JScrollPane(this.myTblTraits);
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout());
        pnlButtons.add(btnCreateAlignment);
        pnlButtons.add(btnClose);
        this.getContentPane().add((Component)scpTraits, "Center");
        this.getContentPane().add((Component)this.myTabbedPane, "East");
        this.getContentPane().add((Component)pnlButtons, "South");
    }

    private JTable createTraitTable(Phenotype ca) {
        Object[] tableColumnNames = new String[]{"Column", "Percent Missing Data"};
        Object[] missingData = Conversion.getPercentMissingData(ca, 2);
        Object[][] tableData = new Object[ca.getNumberOfTraits()][2];
        for (int i = 0; i < ca.getNumberOfTraits(); ++i) {
            tableData[i][0] = ca.getTrait(i).getName() + "." + ca.getTrait(i).getProperty("env");
            tableData[i][1] = missingData[i];
        }
        JTable tblAvailableColumns = new JTable(tableData, tableColumnNames);
        tblAvailableColumns.setEnabled(true);
        tblAvailableColumns.setRowSelectionAllowed(true);
        tblAvailableColumns.setSelectionMode(2);
        return tblAvailableColumns;
    }

    private void btnCreateAlignment_actionPerformed(ActionEvent e) {
        Datum result = null;
        int selectedTab = this.myTabbedPane.getSelectedIndex();
        if (selectedTab == this.myTransformTabIndex) {
            result = this.myPnlTranformation.createNormalizedData(this.myTblTraits);
        } else if (selectedTab == this.myImputationTabIndex) {
            result = this.myPnlImputation.createImputedData(this.myTblTraits);
        } else if (selectedTab == this.myPcaTabIndex) {
            List<Datum> resultL = this.myPnlPCA.createPCAData(this.myTblTraits);
            if (resultL != null) {
                this.myResults.addAll(resultL);
            }
        } else if (selectedTab == this.myNgTabIndex) {
            if (this.myPnlNumericalGenotype.isCollapseSelected()) {
                SimplePhenotype temp = NumericalGenotypePlugin.collapseTransform(this.myGenotype);
                result = new Datum(this.myInput.getName() + "_Collasped", temp, null);
            } else if (this.myPnlNumericalGenotype.isSeparateSelected()) {
                SimplePhenotype temp = NumericalGenotypePlugin.separatedTransform(this.myGenotype);
                result = new Datum(this.myInput.getName() + "_Separated", temp, null);
            }
        }
        if (result != null) {
            this.myResults.add(result);
        }
        this.setVisible(false);
    }

    List<Datum> getResults() {
        return this.myResults;
    }

    private void btnClose_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

