/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

public class TransitionProbability {
    protected double[][] probabilityOfATransition;
    protected double[][] adjustedProbability;
    protected int[] positions;
    double avgSegmentLength = Double.NaN;

    public void setTransitionProbability(double[][] probabilityMatrix) {
        this.probabilityOfATransition = probabilityMatrix;
    }

    public double getTransitionProbability(int state1, int state2) {
        return this.adjustedProbability[state1][state2];
    }

    public double getLnTransitionProbability(int state1, int state2) {
        return Math.log(this.getTransitionProbability(state1, state2));
    }

    public int getNumberOfStates() {
        return this.probabilityOfATransition.length;
    }

    public void setTransitionCounts(int[][] transitionCounts, int chromosomeLength, int numberOfTaxa) {
        int n = transitionCounts.length;
        int totalTransitions = 0;
        int[] rowSums = new int[n];
        int rowCount = 0;
        int[][] arr$ = transitionCounts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] row;
            for (int cell : row = arr$[i$]) {
                totalTransitions += cell;
                int n2 = rowCount;
                rowSums[n2] = rowSums[n2] + cell;
            }
            ++rowCount;
        }
        this.avgSegmentLength = (double)chromosomeLength * (double)numberOfTaxa / (double)totalTransitions;
        this.probabilityOfATransition = new double[n][n];
        for (int row = 0; row < n; ++row) {
            for (int col = 0; col < n; ++col) {
                this.probabilityOfATransition[row][col] = (double)transitionCounts[row][col] / (double)rowSums[row];
            }
        }
    }

    public void setNode(int node) {
        if (node <= 0) {
            return;
        }
        int n = this.probabilityOfATransition.length;
        this.adjustedProbability = new double[n][n];
        int segmentLength = Math.abs(this.positions[node] - this.positions[node - 1]);
        for (int row = 0; row < n; ++row) {
            double offdiagsum = 0.0;
            for (int col = 0; col < n; ++col) {
                if (col == row) continue;
                double m = -Math.log(1.0 - 2.0 * this.probabilityOfATransition[row][col]) * (double)segmentLength / this.avgSegmentLength / 2.0;
                this.adjustedProbability[row][col] = (1.0 - Math.exp(-2.0 * m)) / 2.0;
                offdiagsum += this.adjustedProbability[row][col];
            }
            this.adjustedProbability[row][row] = 1.0 - offdiagsum;
        }
    }

    public void setAverageSegmentLength(double length) {
        this.avgSegmentLength = length;
    }

    public void setPositions(int[] positions) {
        this.positions = positions;
    }
}

