/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.maizegenetics.analysis.clustering.Haplotype;
import net.maizegenetics.analysis.clustering.HaplotypeCluster;
import net.maizegenetics.analysis.clustering.HaplotypeClusterer;
import net.maizegenetics.analysis.imputation.EmissionProbability;
import net.maizegenetics.analysis.imputation.ImputationUtils;
import net.maizegenetics.analysis.imputation.PopulationData;
import net.maizegenetics.analysis.imputation.SubpopulationFinder;
import net.maizegenetics.analysis.imputation.TransitionProbability;
import net.maizegenetics.analysis.imputation.TransitionProbabilityWithVariableRecombination;
import net.maizegenetics.analysis.imputation.ViterbiAlgorithm;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.stats.math.GammaFunction;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.TaxaListUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.BitUtil;
import net.maizegenetics.util.OpenBitSet;
import org.apache.commons.math.MathException;
import org.apache.commons.math.stat.inference.TestUtils;
import org.apache.log4j.Logger;

public class NucleotideImputationUtils {
    private static final Logger myLogger = Logger.getLogger(NucleotideImputationUtils.class);
    static final byte AA = NucleotideAlignmentConstants.getNucleotideDiploidByte("AA");
    static final byte CC = NucleotideAlignmentConstants.getNucleotideDiploidByte("CC");
    static final byte GG = NucleotideAlignmentConstants.getNucleotideDiploidByte("GG");
    static final byte TT = NucleotideAlignmentConstants.getNucleotideDiploidByte("TT");
    static final byte AC = NucleotideAlignmentConstants.getNucleotideDiploidByte("AC");
    static final byte AG = NucleotideAlignmentConstants.getNucleotideDiploidByte("AG");
    static final byte AT = NucleotideAlignmentConstants.getNucleotideDiploidByte("AT");
    static final byte CG = NucleotideAlignmentConstants.getNucleotideDiploidByte("CG");
    static final byte CT = NucleotideAlignmentConstants.getNucleotideDiploidByte("CT");
    static final byte GT = NucleotideAlignmentConstants.getNucleotideDiploidByte("GT");
    static final byte NN = NucleotideAlignmentConstants.getNucleotideDiploidByte("NN");
    static final byte CA = NucleotideAlignmentConstants.getNucleotideDiploidByte("CA");
    static final byte[] byteval = new byte[]{AA, CC, GG, TT, AC};
    static final HashMap<Byte, Integer> genotypeMap = new HashMap();
    static final byte[][] genoval;

    private NucleotideImputationUtils() {
    }

    public static void callParentAllelesByWindow(PopulationData popdata, double maxMissing, double minMaf, int windowSize, double minR) {
        int[] snpIndex;
        BitSet ldFilteredBits;
        BitSet polybits;
        int N = 15;
        double segratio = popdata.contribution1;
        if (minMaf < 0.0 && (segratio == 0.5 || segratio == 0.25 || segratio == 0.75)) {
            polybits = NucleotideImputationUtils.whichSitesSegregateCorrectly(popdata.original, maxMissing, segratio);
        } else {
            if (minMaf < 0.0) {
                minMaf = 0.0;
            }
            polybits = NucleotideImputationUtils.whichSitesArePolymorphic(popdata.original, maxMissing, minMaf);
        }
        myLogger.info((Object)("polybits cardinality = " + polybits.cardinality()));
        OpenBitSet filteredBits = NucleotideImputationUtils.whichSnpsAreFromSameTag(popdata.original, polybits);
        myLogger.info((Object)("filteredBits.cardinality = " + filteredBits.cardinality()));
        if (minR > 0.0) {
            int halfWindow = windowSize / 2;
            ldFilteredBits = NucleotideImputationUtils.ldfilter(popdata.original, halfWindow, minR, filteredBits);
        } else {
            ldFilteredBits = filteredBits;
        }
        myLogger.info((Object)("ldFilteredBits.cardinality = " + ldFilteredBits.cardinality()));
        int nsites = popdata.original.numberOfSites();
        int ntaxa = popdata.original.numberOfTaxa();
        popdata.alleleA = new byte[nsites];
        popdata.alleleC = new byte[nsites];
        popdata.snpIndex = new OpenBitSet(nsites);
        for (int s = 0; s < nsites; ++s) {
            popdata.alleleA[s] = N;
            popdata.alleleC[s] = N;
        }
        int[] parentIndex = new int[]{popdata.original.taxa().indexOf(popdata.parent1), popdata.original.taxa().indexOf(popdata.parent2)};
        GenotypeTable[] prevAlignment = null;
        int[][] snpIndices = NucleotideImputationUtils.getWindows(ldFilteredBits, windowSize);
        boolean append = false;
        int nWindows = snpIndices.length;
        for (int w = 0; w < nWindows; ++w) {
            if (append) {
                int n1 = snpIndices[w - 1].length;
                int n2 = snpIndices[w].length;
                snpIndex = new int[n1 + n2];
                System.arraycopy(snpIndices[w - 1], 0, snpIndex, 0, n1);
                System.arraycopy(snpIndices[w], 0, snpIndex, n1, n2);
                append = false;
            } else {
                snpIndex = snpIndices[w];
            }
            FilterGenotypeTable windowAlignment = FilterGenotypeTable.getInstance(popdata.original, snpIndex);
            LinkedList<Integer> snpList = new LinkedList<Integer>();
            for (int s : snpIndex) {
                snpList.add(s);
            }
            GenotypeTable[] taxaAlignments = NucleotideImputationUtils.getTaxaGroupAlignments(windowAlignment, parentIndex, snpList);
            if (taxaAlignments == null) {
                append = true;
                continue;
            }
            double r = 0.0;
            if (prevAlignment != null) {
                r = NucleotideImputationUtils.getIdCorrelation(new TaxaList[][]{{prevAlignment[0].taxa(), prevAlignment[1].taxa()}, {taxaAlignments[0].taxa(), taxaAlignments[1].taxa()}});
                myLogger.info((Object)("For " + popdata.name + " the window starting at " + popdata.original.siteName(snpIndex[0]) + ", r = " + r + " , # of snps in alignment = " + snpList.size()));
            } else {
                myLogger.info((Object)("For " + popdata.name + " the window starting at " + popdata.original.siteName(snpIndex[0]) + ", # of snps in alignment = " + snpList.size()));
            }
            NucleotideImputationUtils.checkAlignmentOrderIgnoringParents(taxaAlignments, popdata, r);
            prevAlignment = taxaAlignments;
            NucleotideImputationUtils.callParentAllelesUsingTaxaGroups(popdata, taxaAlignments, snpList);
        }
        myLogger.info((Object)("number of called snps = " + popdata.snpIndex.cardinality()));
        int nsnps = (int)popdata.snpIndex.cardinality();
        ntaxa = popdata.original.numberOfTaxa();
        nsites = popdata.original.numberOfSites();
        snpIndex = new int[nsnps];
        int snpcount = 0;
        PositionListBuilder posBuilder = new PositionListBuilder();
        for (int s = 0; s < nsites; ++s) {
            if (!popdata.snpIndex.fastGet(s)) continue;
            snpIndex[snpcount++] = s;
            posBuilder.add((Position)popdata.original.positions().get(s));
        }
        snpIndex = Arrays.copyOf(snpIndex, snpcount);
        GenotypeTableBuilder builder = GenotypeTableBuilder.getTaxaIncremental(posBuilder.build());
        nsnps = snpIndex.length;
        for (int t = 0; t < ntaxa; ++t) {
            byte[] taxonGeno = new byte[nsnps];
            for (int s = 0; s < nsnps; ++s) {
                byte Aallele = popdata.alleleA[snpIndex[s]];
                byte Callele = popdata.alleleC[snpIndex[s]];
                byte[] val = GenotypeTableUtils.getDiploidValues(popdata.original.genotype(t, snpIndex[s]));
                taxonGeno[s] = val[0] == Aallele && val[1] == Aallele ? AA : (val[0] == Callele && val[1] == Callele ? CC : (val[0] == Aallele && val[1] == Callele || val[0] == Callele && val[1] == Aallele ? AC : NN));
            }
            builder.addTaxon((Taxon)popdata.original.taxa().get(t), taxonGeno);
        }
        popdata.imputed = builder.build();
    }

    public static void callParentAllelesUsingClusters(PopulationData popdata, double maxMissing, double minMaf, int windowSize, boolean checkSubpops) {
        int[] origSites;
        HaplotypeCluster.ReturnHaplotype = HaplotypeCluster.TYPE.majority;
        int ntaxa = popdata.original.numberOfTaxa();
        int nOriginalSites = popdata.original.numberOfSites();
        popdata.alleleA = new byte[nOriginalSites];
        popdata.alleleC = new byte[nOriginalSites];
        popdata.snpIndex = new OpenBitSet(nOriginalSites);
        double maxHet = 0.06;
        if (minMaf < 0.0) {
            minMaf = 0.05;
        }
        GenotypeTable a = NucleotideImputationUtils.filterSnpsByTag(popdata.original, minMaf, maxMissing, maxHet);
        int nFilteredSites = a.numberOfSites();
        int[] siteTranslationArray = new int[nFilteredSites];
        FilterGenotypeTable fa = (FilterGenotypeTable)a;
        for (int s = 0; s < nFilteredSites; ++s) {
            siteTranslationArray[s] = fa.translateSite(s);
        }
        int maxdist = 100;
        ArrayList<HaplotypeCluster> clusters = null;
        int start = 0;
        while (maxdist > 10) {
            clusters = NucleotideImputationUtils.clusterWindow(a, start, windowSize, 4);
            int mindist2 = 0;
            int mindist3 = 0;
            if (clusters.size() > 2) {
                mindist2 = Math.min(HaplotypeClusterer.clusterDistanceMaxPairDiff(clusters.get(0), clusters.get(2)), HaplotypeClusterer.clusterDistanceMaxPairDiff(clusters.get(1), clusters.get(2)));
            }
            if (clusters.size() > 3) {
                mindist3 = Math.min(HaplotypeClusterer.clusterDistanceMaxPairDiff(clusters.get(0), clusters.get(3)), HaplotypeClusterer.clusterDistanceMaxPairDiff(clusters.get(1), clusters.get(3)));
            }
            maxdist = Math.max(mindist2, mindist3);
            start += windowSize;
        }
        HaplotypeCluster.ReturnHaplotype = HaplotypeCluster.TYPE.majority;
        for (int i = 0; i < 4; ++i) {
            if (clusters.size() <= i) continue;
            System.out.println(clusters.get(i));
        }
        int[] sites = new int[windowSize];
        int currentSite = start - windowSize;
        for (int i = 0; i < windowSize; ++i) {
            sites[i] = currentSite++;
        }
        ArrayList<HaplotypeCluster> seedClusters = new ArrayList<HaplotypeCluster>(clusters);
        int[] siteNumber = new int[]{windowSize};
        int[] firstWindowSites = null;
        while (siteNumber[0] == windowSize && sites[windowSize - 1] < nFilteredSites - 1) {
            seedClusters = NucleotideImputationUtils.extendClusters(a, seedClusters, sites, siteNumber, true);
            if (firstWindowSites == null) {
                firstWindowSites = Arrays.copyOf(sites, sites.length);
            }
            if (siteNumber[0] <= 0) continue;
            if (siteNumber[0] < windowSize) {
                sites = Arrays.copyOf(sites, siteNumber[0]);
            }
            origSites = NucleotideImputationUtils.translateSitesBackToOriginal(sites, siteTranslationArray);
            NucleotideImputationUtils.updateAlleleCalls(seedClusters.get(0), origSites, popdata.alleleA);
            NucleotideImputationUtils.updateAlleleCalls(seedClusters.get(1), origSites, popdata.alleleC);
            for (int site : origSites) {
                popdata.snpIndex.fastSet(site);
            }
        }
        seedClusters = new ArrayList<HaplotypeCluster>(clusters);
        siteNumber = new int[]{windowSize};
        sites = firstWindowSites;
        while (siteNumber[0] == windowSize && sites[0] > 0) {
            seedClusters = NucleotideImputationUtils.extendClusters(a, seedClusters, sites, siteNumber, false);
            if (siteNumber[0] <= 0) continue;
            if (siteNumber[0] < windowSize) {
                sites = Arrays.copyOfRange(sites, windowSize - siteNumber[0], windowSize);
            }
            origSites = NucleotideImputationUtils.translateSitesBackToOriginal(sites, siteTranslationArray);
            NucleotideImputationUtils.updateAlleleCalls(seedClusters.get(0), origSites, popdata.alleleA);
            NucleotideImputationUtils.updateAlleleCalls(seedClusters.get(1), origSites, popdata.alleleC);
            for (int site : origSites) {
                popdata.snpIndex.fastSet(site);
            }
        }
        NucleotideImputationUtils.checkParentage(popdata);
        int nsnps = (int)popdata.snpIndex.cardinality();
        ntaxa = popdata.original.numberOfTaxa();
        int nsites = popdata.original.numberOfSites();
        int[] snpIndex = new int[nsnps];
        int snpcount = 0;
        for (int s = 0; s < nsites; ++s) {
            if (!popdata.snpIndex.fastGet(s)) continue;
            snpIndex[snpcount++] = s;
        }
        snpIndex = Arrays.copyOf(snpIndex, snpcount);
        nsnps = snpIndex.length;
        GenotypeTable target = FilterGenotypeTable.getInstance(popdata.original, snpIndex);
        NucleotideImputationUtils.createSubPops(popdata, checkSubpops);
        NucleotideImputationUtils.checksubpops(popdata, 20);
        int npops = popdata.subpopulationGroups.size();
        TaxaList[] taxaLists = new TaxaList[popdata.subpopulationGroups.size()];
        popdata.subpopulationGroups.toArray(taxaLists);
        TaxaList allTaxa = TaxaListUtils.getAllTaxa(taxaLists);
        target = FilterGenotypeTable.getInstance(target, allTaxa);
        GenotypeTableBuilder builder = GenotypeTableBuilder.getTaxaIncremental(target.positions());
        for (int p = 0; p < npops; ++p) {
            TaxaList popTaxaList = popdata.subpopulationGroups.get(p);
            ntaxa = popTaxaList.numberOfTaxa();
            int[] taxaIndex = new int[ntaxa];
            for (int t = 0; t < ntaxa; ++t) {
                taxaIndex[t] = target.taxa().indexOf((Taxon)popTaxaList.get(t));
            }
            BitSet subpopSnpUse = popdata.subpoplationSiteIndex.get(p);
            nsnps = target.numberOfSites();
            for (int t = 0; t < ntaxa; ++t) {
                byte[] taxonGeno = new byte[nsnps];
                String gstr = target.genotypeAsStringRow(t);
                for (int s = 0; s < nsnps; ++s) {
                    byte Aallele = popdata.alleleA[snpIndex[s]];
                    byte Callele = popdata.alleleC[snpIndex[s]];
                    byte val = target.genotype(taxaIndex[t], s);
                    taxonGeno[s] = val == Aallele ? AA : (val == Callele ? CC : (GenotypeTableUtils.isHeterozygous(val) ? AC : NN));
                }
                builder.addTaxon((Taxon)popTaxaList.get(t), taxonGeno);
            }
        }
        popdata.imputed = builder.build();
    }

    public static void callParentAllelesUsingClustersOnly(PopulationData popdata, double maxMissing, double minMaf, int windowSize, boolean checkSubpops) {
        double mindiff = 0.7;
        int overlap = 10;
        HaplotypeCluster.ReturnHaplotype = HaplotypeCluster.TYPE.majority;
        int ntaxa = popdata.original.numberOfTaxa();
        int nOriginalSites = popdata.original.numberOfSites();
        popdata.alleleA = new byte[nOriginalSites];
        popdata.alleleC = new byte[nOriginalSites];
        popdata.snpIndex = new OpenBitSet(nOriginalSites);
        double maxHet = 0.06;
        GenotypeTable a = NucleotideImputationUtils.filterSnpsByTag(popdata.original, minMaf, maxMissing, maxHet);
        int nFilteredSites = a.numberOfSites();
        int[] siteTranslationArray = new int[nFilteredSites];
        FilterGenotypeTable fa = (FilterGenotypeTable)a;
        for (int s = 0; s < nFilteredSites; ++s) {
            siteTranslationArray[s] = fa.translateSite(s);
        }
        int maxsite = nFilteredSites - windowSize - overlap;
        ArrayList<HaplotypeCluster> clusters = null;
        HaplotypeCluster.ReturnHaplotype = HaplotypeCluster.TYPE.unanimous;
        byte[] prevA = null;
        byte[] prevC = null;
        for (int start = 0; start <= maxsite; start += windowSize - overlap) {
            int origSite;
            int prevSite;
            boolean overlapMatchingSite;
            int s;
            byte[] hap1;
            clusters = start + windowSize > maxsite ? NucleotideImputationUtils.clusterWindow(a, start, nFilteredSites - start, 2) : NucleotideImputationUtils.clusterWindow(a, start, windowSize, 2);
            double diff1 = HaplotypeClusterer.clusterDistanceClusterDiffProportion(clusters.get(0), clusters.get(1));
            double diff2 = HaplotypeClusterer.clusterDistanceClusterDiffProportion(clusters.get(0), clusters.get(2));
            double diff3 = HaplotypeClusterer.clusterDistanceClusterDiffProportion(clusters.get(0), clusters.get(3));
            double diff4 = HaplotypeClusterer.clusterDistanceClusterDiffProportion(clusters.get(0), clusters.get(4));
            byte[] hap0 = clusters.get(0).getHaplotype();
            if (diff1 >= mindiff) {
                hap1 = clusters.get(1).getHaplotype();
            } else if (diff2 >= mindiff) {
                hap1 = clusters.get(2).getHaplotype();
            } else if (diff3 >= mindiff) {
                hap1 = clusters.get(3).getHaplotype();
            } else if (diff4 >= mindiff) {
                hap1 = clusters.get(4).getHaplotype();
            } else {
                throw new IllegalArgumentException(String.format("No second haplotype at site %d, position %d.", start, a.chromosomalPosition(start)));
            }
            if (start == 0) {
                for (int s2 = 0; s2 < windowSize; ++s2) {
                    if (hap0[s2] == NN || hap1[s2] == NN || hap0[s2] == hap1[s2]) continue;
                    int origSite2 = siteTranslationArray[s2];
                    popdata.snpIndex.fastSet(origSite2);
                    popdata.alleleA[origSite2] = hap0[s2];
                    popdata.alleleC[origSite2] = hap1[s2];
                }
                prevA = hap0;
                prevC = hap1;
                continue;
            }
            int seqlength = hap0.length;
            if (NucleotideImputationUtils.haplotypeOverlapSimilarity(prevA, hap0, overlap, windowSize) > 0.8 && NucleotideImputationUtils.haplotypeOverlapSimilarity(prevC, hap1, overlap, windowSize) > 0.8) {
                for (s = 0; s < seqlength; ++s) {
                    overlapMatchingSite = true;
                    if (s < overlap && prevA[prevSite = s + windowSize - overlap] != NN && hap0[s] != NN && (prevA[prevSite] != hap0[s] || prevC[prevSite] != hap1[s])) {
                        overlapMatchingSite = false;
                    }
                    if (hap0[s] == NN || hap1[s] == NN || hap0[s] == hap1[s] || !overlapMatchingSite) continue;
                    origSite = siteTranslationArray[start + s];
                    popdata.snpIndex.fastSet(origSite);
                    popdata.alleleA[origSite] = hap0[s];
                    popdata.alleleC[origSite] = hap1[s];
                }
                prevA = hap0;
                prevC = hap1;
                continue;
            }
            if (NucleotideImputationUtils.haplotypeOverlapSimilarity(prevA, hap1, overlap, windowSize) > 0.8 && NucleotideImputationUtils.haplotypeOverlapSimilarity(prevC, hap0, overlap, windowSize) > 0.8) {
                for (s = 0; s < seqlength; ++s) {
                    overlapMatchingSite = true;
                    if (s < overlap && prevA[prevSite = s + windowSize - overlap] != NN && hap1[s] != NN && (prevA[prevSite] != hap1[s] || prevC[prevSite] != hap0[s])) {
                        overlapMatchingSite = false;
                    }
                    if (hap0[s] == NN || hap1[s] == NN || hap0[s] == hap1[s] || !overlapMatchingSite) continue;
                    origSite = siteTranslationArray[start + s];
                    popdata.snpIndex.fastSet(origSite);
                    popdata.alleleA[origSite] = hap1[s];
                    popdata.alleleC[origSite] = hap0[s];
                }
                prevA = hap1;
                prevC = hap0;
                continue;
            }
            throw new IllegalArgumentException(String.format("Haplotypes fail to approximately match previous haplotypes at site %d, position %d.", start, a.chromosomalPosition(start)));
        }
        NucleotideImputationUtils.createSubPops(popdata, checkSubpops);
        NucleotideImputationUtils.checksubpops(popdata, 20);
        int nsnps = (int)popdata.snpIndex.cardinality();
        int nsites = popdata.original.numberOfSites();
        int[] snpIndex = new int[nsnps];
        int snpcount = 0;
        for (int s = 0; s < nsites; ++s) {
            if (!popdata.snpIndex.fastGet(s)) continue;
            snpIndex[snpcount++] = s;
        }
        snpIndex = Arrays.copyOf(snpIndex, snpcount);
        nsnps = snpIndex.length;
        FilterGenotypeTable target = FilterGenotypeTable.getInstance(popdata.original, snpIndex);
        GenotypeTableBuilder builder = GenotypeTableBuilder.getTaxaIncremental(target.positions());
        int nsubpops = popdata.subpopulationGroups.size();
        for (int sp = 0; sp < nsubpops; ++sp) {
            BitSet SI = popdata.subpoplationSiteIndex.get(sp);
            TaxaList subpopTaxa = popdata.subpopulationGroups.get(sp);
            ntaxa = subpopTaxa.numberOfTaxa();
            for (int t = 0; t < ntaxa; ++t) {
                int taxaTargetIndex = target.taxa().indexOf((Taxon)subpopTaxa.get(t));
                byte[] taxonGeno = new byte[nsnps];
                for (int s = 0; s < nsnps; ++s) {
                    if (!SI.fastGet(snpIndex[s])) continue;
                    byte Aallele = popdata.alleleA[snpIndex[s]];
                    byte Callele = popdata.alleleC[snpIndex[s]];
                    byte[] val = GenotypeTableUtils.getDiploidValues(target.genotype(taxaTargetIndex, s));
                    taxonGeno[s] = val[0] == Aallele && val[1] == Aallele ? AA : (val[0] == Callele && val[1] == Callele ? CC : (val[0] == Aallele && val[1] == Callele || val[0] == Callele && val[1] == Aallele ? AC : NN));
                }
                builder.addTaxon((Taxon)subpopTaxa.get(t), taxonGeno);
            }
        }
        popdata.imputed = builder.build();
    }

    public static boolean compareHaplotypes(byte[] h0, byte[] h1, int overlap, int haplength) {
        boolean same = true;
        int start = haplength - overlap;
        for (int ptr = 0; same && ptr < overlap; ++ptr) {
            if (h0[start + ptr] == h1[ptr] || h0[start + ptr] == NN || h1[ptr] == NN) continue;
            same = false;
        }
        return same;
    }

    public static double haplotypeOverlapSimilarity(byte[] h0, byte[] h1, int overlap, int haplength) {
        int start = haplength - overlap;
        int matchCount = 0;
        int nonmissingCount = 0;
        for (int ptr = 0; ptr < overlap; ++ptr) {
            if (h0[start + ptr] == NN || h1[ptr] == NN) continue;
            ++nonmissingCount;
            if (h0[start + ptr] != h1[ptr]) continue;
            ++matchCount;
        }
        return (double)matchCount / (double)nonmissingCount;
    }

    public static void createSubPops(PopulationData popdata, boolean isNAM) {
        popdata.subpopulationGroups = new ArrayList();
        if (isNAM) {
            TaxaListBuilder[] sublists = new TaxaListBuilder[3];
            for (int i = 0; i < 3; ++i) {
                sublists[i] = new TaxaListBuilder();
            }
            for (Taxon taxon : popdata.original.taxa()) {
                int pop = SubpopulationFinder.getNamSubPopulation(taxon);
                if (pop <= 0) continue;
                sublists[pop].add(taxon);
            }
            for (int i = 0; i < 3; ++i) {
                TaxaList poplist = sublists[i].build();
                if (poplist.size() <= 0) continue;
                popdata.subpopulationGroups.add(poplist);
            }
        } else {
            popdata.subpopulationGroups.add(popdata.original.taxa());
        }
    }

    public static void checksubpops(PopulationData popdata, int halfWindowSize) {
        double minMatchScore = 0.9;
        int nsubpops = popdata.subpopulationGroups.size();
        int totalsites = popdata.original.numberOfSites();
        popdata.subpoplationSiteIndex = new ArrayList();
        for (int i = 0; i < nsubpops; ++i) {
            double[] cuts;
            GenotypeTable a = FilterGenotypeTable.getInstance(popdata.original, popdata.subpopulationGroups.get(i));
            OpenBitSet snpUseIndex = new OpenBitSet(totalsites);
            popdata.subpoplationSiteIndex.add(snpUseIndex);
            int nsites = (int)popdata.snpIndex.cardinality();
            int[] goodsites = new int[nsites];
            int ptr = 0;
            for (int ts = 0; ts < totalsites; ++ts) {
                if (!popdata.snpIndex.fastGet(ts) || !(a.minorAlleleFrequency(ts) > 0.0)) continue;
                goodsites[ptr++] = ts;
            }
            nsites = ptr;
            goodsites = Arrays.copyOf(goodsites, ptr);
            int ntaxa = a.numberOfTaxa();
            double[] score = new double[nsites];
            for (int s = 0; s < nsites; ++s) {
                int firstSite = s - halfWindowSize;
                int lastSite = s + halfWindowSize;
                if (firstSite < 0) {
                    lastSite -= firstSite;
                    firstSite = 0;
                } else if (lastSite > nsites - 1) {
                    firstSite -= lastSite - nsites + 1;
                    lastSite = nsites - 1;
                }
                byte Aallele = popdata.alleleA[goodsites[s]];
                byte Callele = popdata.alleleC[goodsites[s]];
                int matchCount = 0;
                int totalCount = 0;
                for (int t = 0; t < ntaxa; ++t) {
                    byte tgeno = a.genotype(t, goodsites[s]);
                    if (tgeno != Aallele && tgeno != Callele) continue;
                    byte[] matchAllele = tgeno == Aallele ? popdata.alleleA : popdata.alleleC;
                    for (int s2 = firstSite; s2 <= lastSite; ++s2) {
                        byte tgeno2;
                        if (s2 == s || (tgeno2 = a.genotype(t, goodsites[s2])) == NN) continue;
                        ++totalCount;
                        if (tgeno2 != matchAllele[goodsites[s2]]) continue;
                        ++matchCount;
                    }
                }
                score[s] = (double)matchCount / (double)totalCount;
            }
            boolean iter = true;
            for (double cutoff : cuts = new double[]{0.7, 0.8, 0.9}) {
                int[] bestsites = new int[nsites];
                ptr = 0;
                for (int s = 0; s < nsites; ++s) {
                    if (!(score[s] > cutoff)) continue;
                    bestsites[ptr++] = goodsites[s];
                }
                bestsites = Arrays.copyOf(bestsites, ptr);
                int nbest = ptr;
                for (int s = 0; s < nsites; ++s) {
                    double matchScore;
                    int closeSite = Arrays.binarySearch(bestsites, goodsites[s]);
                    if (closeSite < 0) {
                        closeSite = -closeSite - 1;
                    }
                    int firstSite = closeSite - halfWindowSize;
                    int lastSite = closeSite + halfWindowSize;
                    if (firstSite < 0) {
                        lastSite -= firstSite;
                        firstSite = 0;
                    } else if (lastSite > nbest - 1) {
                        firstSite -= lastSite - nbest + 1;
                        lastSite = nbest - 1;
                    }
                    byte Aallele = popdata.alleleA[goodsites[s]];
                    byte Callele = popdata.alleleC[goodsites[s]];
                    int matchCount = 0;
                    int totalCount = 0;
                    for (int t = 0; t < ntaxa; ++t) {
                        byte tgeno = a.genotype(t, goodsites[s]);
                        if (tgeno != Aallele && tgeno != Callele) continue;
                        byte[] matchAllele = tgeno == Aallele ? popdata.alleleA : popdata.alleleC;
                        for (int s2 = firstSite; s2 <= lastSite; ++s2) {
                            byte tgeno2;
                            if (bestsites[s2] == goodsites[s] || (tgeno2 = a.genotype(t, bestsites[s2])) == NN) continue;
                            ++totalCount;
                            if (tgeno2 != matchAllele[bestsites[s2]]) continue;
                            ++matchCount;
                        }
                    }
                    score[s] = matchScore = (double)matchCount / (double)totalCount;
                }
            }
            for (int s = 0; s < nsites; ++s) {
                if (!(score[s] >= minMatchScore)) continue;
                snpUseIndex.fastSet(goodsites[s]);
            }
        }
    }

    public static int[] translateSitesBackToOriginal(int[] sites, int[] translation) {
        int n = sites.length;
        int[] orig = new int[n];
        for (int i = 0; i < n; ++i) {
            orig[i] = translation[sites[i]];
        }
        return orig;
    }

    public static ArrayList<HaplotypeCluster> extendClusters(GenotypeTable a, ArrayList<HaplotypeCluster> clusters, int[] sites, int[] windowSize, boolean forward) {
        int s;
        int nextSite;
        int direction;
        int maxDiff = 4;
        int totalSites = a.numberOfSites();
        int targetSize = windowSize[0];
        int nSelected = 0;
        if (forward) {
            direction = 1;
            nextSite = sites[sites.length - 1] + 1;
        } else {
            direction = -1;
            nextSite = sites[0] - 1;
        }
        String[] hap0 = new String[targetSize];
        String[] hap1 = new String[targetSize];
        while (nSelected < targetSize && nextSite < totalSites && nextSite > -1) {
            String mj1;
            byte allele;
            int taxon;
            Haplotype hap;
            HashMultiset snpset0 = HashMultiset.create();
            HashMultiset snpset1 = HashMultiset.create();
            HaplotypeCluster hc = clusters.get(0);
            Iterator<Haplotype> iterator = hc.getIterator();
            while (iterator.hasNext()) {
                hap = iterator.next();
                taxon = hap.taxonIndex;
                allele = a.genotype(taxon, nextSite);
                if (allele == Haplotype.N) continue;
                snpset0.add((Object)NucleotideAlignmentConstants.getNucleotideIUPAC(allele));
            }
            hc = clusters.get(1);
            iterator = hc.getIterator();
            while (iterator.hasNext()) {
                hap = iterator.next();
                taxon = hap.taxonIndex;
                allele = a.genotype(taxon, nextSite);
                if (allele == Haplotype.N) continue;
                snpset1.add((Object)NucleotideAlignmentConstants.getNucleotideIUPAC(allele));
            }
            String mj0 = NucleotideImputationUtils.getMajorAlleleFromSnpset((Multiset<String>)snpset0);
            if (mj0 != null && (mj1 = NucleotideImputationUtils.getMajorAlleleFromSnpset((Multiset<String>)snpset1)) != null && !mj0.equals(mj1)) {
                if (forward) {
                    hap0[nSelected] = mj0;
                    hap1[nSelected] = mj1;
                    sites[nSelected] = nextSite;
                } else {
                    int ptr = targetSize - 1 - nSelected;
                    hap0[ptr] = mj0;
                    hap1[ptr] = mj1;
                    sites[ptr] = nextSite;
                }
                ++nSelected;
            }
            nextSite += direction;
        }
        windowSize[0] = nSelected;
        int[] selectedSites = forward ? Arrays.copyOf(sites, nSelected) : Arrays.copyOfRange(sites, targetSize - nSelected, targetSize);
        int numberOfSites = selectedSites.length;
        byte[] seq = new byte[numberOfSites];
        if (forward) {
            for (s = 0; s < numberOfSites; ++s) {
                seq[s] = NucleotideAlignmentConstants.getNucleotideDiploidByte(hap0[s]);
            }
        } else {
            for (s = 0; s < numberOfSites; ++s) {
                seq[s] = NucleotideAlignmentConstants.getNucleotideDiploidByte(hap0[s + targetSize - numberOfSites]);
            }
        }
        Haplotype haplotype0 = new Haplotype(seq);
        seq = new byte[numberOfSites];
        if (forward || numberOfSites == targetSize) {
            for (int s2 = 0; s2 < numberOfSites; ++s2) {
                seq[s2] = NucleotideAlignmentConstants.getNucleotideDiploidByte(hap1[s2]);
            }
        } else {
            int dif = targetSize - numberOfSites;
            for (int s3 = 0; s3 < numberOfSites; ++s3) {
                seq[s3] = NucleotideAlignmentConstants.getNucleotideDiploidByte(hap1[s3 + dif]);
            }
        }
        Haplotype haplotype1 = new Haplotype(seq);
        ArrayList<Haplotype> cluster0 = new ArrayList<Haplotype>();
        ArrayList<Haplotype> cluster1 = new ArrayList<Haplotype>();
        int ntaxa = a.numberOfTaxa();
        FilterGenotypeTable b = FilterGenotypeTable.getInstance(a, selectedSites);
        for (int t = 0; t < ntaxa; ++t) {
            seq = b.genotypeAllSites(t);
            Haplotype hap = new Haplotype(seq, t);
            int dist0 = hap.distanceFrom(haplotype0);
            int dist1 = hap.distanceFrom(haplotype1);
            if (dist0 <= maxDiff && dist1 > maxDiff) {
                cluster0.add(hap);
                continue;
            }
            if (dist0 > maxDiff && dist1 <= maxDiff) {
                cluster1.add(hap);
                continue;
            }
            if (numberOfSites >= maxDiff) continue;
            if (dist0 == 0 && dist1 > 1) {
                cluster0.add(hap);
                continue;
            }
            if (dist0 <= 1 || dist1 != 0) continue;
            cluster1.add(hap);
        }
        ArrayList<HaplotypeCluster> newClusters = new ArrayList<HaplotypeCluster>();
        newClusters.add(new HaplotypeCluster(cluster0));
        newClusters.add(new HaplotypeCluster(cluster1));
        return newClusters;
    }

    public static String getMajorAlleleFromSnpset(Multiset<String> snpset, double alpha) {
        ArrayList snplist = new ArrayList(snpset.entrySet());
        if (snplist.size() == 0) {
            return null;
        }
        if (snplist.size() == 1) {
            return (String)((Multiset.Entry)snplist.get(0)).getElement();
        }
        Collections.sort(snplist, new Comparator<Multiset.Entry<String>>(){

            @Override
            public int compare(Multiset.Entry<String> entry1, Multiset.Entry<String> entry2) {
                if (entry1.getCount() > entry2.getCount()) {
                    return -1;
                }
                if (entry1.getCount() < entry2.getCount()) {
                    return 1;
                }
                return 0;
            }
        });
        long[] observed = new long[]{((Multiset.Entry)snplist.get(0)).getCount(), ((Multiset.Entry)snplist.get(1)).getCount()};
        double total = observed[0] + observed[1];
        double[] expected = new double[]{total / 2.0, total / 2.0};
        boolean different = false;
        try {
            different = TestUtils.chiSquareTest((double[])expected, (long[])observed, (double)alpha);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Illegal Argument to NucleotideImputationUtils.testClassSize(): ");
            e.printStackTrace();
        }
        catch (MathException e) {
            System.out.println("Exception calculating chi-square in NucleotideImputationUtils.testClassSize(): ");
            e.printStackTrace();
        }
        if (different) {
            return (String)((Multiset.Entry)snplist.get(0)).getElement();
        }
        return null;
    }

    public static String getMajorAlleleFromSnpset(Multiset<String> snpset) {
        return NucleotideImputationUtils.getMajorAlleleFromSnpset(snpset, 0.05);
    }

    public static void updateAlleleCalls(HaplotypeCluster cluster2, int[] sites, byte[] alleleCalls) {
        for (byte alleleCalls[sites[i]] : cluster2.getHaplotype()) {
        }
    }

    public static void callParentAllelesByWindowForBackcrosses(PopulationData popdata, double maxMissing, double minMaf, int windowSize, double minR) {
        BitSet ldFilteredBits;
        BitSet polybits = NucleotideImputationUtils.whichSitesSegregateCorrectly(popdata.original, maxMissing, 0.25);
        myLogger.info((Object)("polybits cardinality = " + polybits.cardinality()));
        OpenBitSet filteredBits = NucleotideImputationUtils.whichSnpsAreFromSameTag(popdata.original, 0.8);
        filteredBits.and(polybits);
        System.out.println("filteredBits.cardinality = " + filteredBits.cardinality());
        if (minR > 0.0) {
            int halfWindow = windowSize / 2;
            ldFilteredBits = NucleotideImputationUtils.ldfilter(popdata.original, halfWindow, minR, filteredBits);
        } else {
            ldFilteredBits = filteredBits;
        }
        myLogger.info((Object)("ldFilteredBits.cardinality = " + ldFilteredBits.cardinality()));
        int nsites = popdata.original.numberOfSites();
        int ntaxa = popdata.original.numberOfTaxa();
        popdata.alleleA = new byte[nsites];
        popdata.alleleC = new byte[nsites];
        popdata.snpIndex = new OpenBitSet(nsites);
        for (int s = 0; s < nsites; ++s) {
            if (!ldFilteredBits.fastGet(s)) continue;
            popdata.alleleA[s] = popdata.original.majorAllele(s);
            popdata.alleleC[s] = popdata.original.minorAllele(s);
            popdata.snpIndex.fastSet(s);
        }
        myLogger.info((Object)("number of called snps = " + popdata.snpIndex.cardinality()));
        int nsnps = (int)popdata.snpIndex.cardinality();
        ntaxa = popdata.original.numberOfTaxa();
        nsites = popdata.original.numberOfSites();
        int[] snpIndex = new int[nsnps];
        int snpcount = 0;
        for (int s = 0; s < nsites; ++s) {
            if (!popdata.snpIndex.fastGet(s)) continue;
            snpIndex[snpcount++] = s;
        }
        snpIndex = Arrays.copyOf(snpIndex, snpcount);
        FilterGenotypeTable target = FilterGenotypeTable.getInstance(popdata.original, snpIndex);
        myLogger.info((Object)"filtered on snps");
        TaxaListBuilder taxaBuilder = new TaxaListBuilder();
        int minGametes = 200;
        for (int t = 0; t < ntaxa; ++t) {
            if (target.totalGametesNonMissingForTaxon(t) <= minGametes) continue;
            taxaBuilder.add((Taxon)target.taxa().get(t));
        }
        GenotypeTable target2 = FilterGenotypeTable.getInstance((GenotypeTable)target, taxaBuilder.build());
        myLogger.info((Object)"identified low coverage taxa");
        nsnps = snpIndex.length;
        ntaxa = target2.numberOfTaxa();
        GenotypeTableBuilder builder = GenotypeTableBuilder.getSiteIncremental(target2.taxa());
        for (int s = 0; s < nsnps; ++s) {
            byte Aallele = popdata.alleleA[snpIndex[s]];
            byte Callele = popdata.alleleC[snpIndex[s]];
            byte[] siteGeno = new byte[ntaxa];
            for (int t = 0; t < ntaxa; ++t) {
                byte[] val = GenotypeTableUtils.getDiploidValues(target2.genotype(t, s));
                siteGeno[t] = val[0] == Aallele && val[1] == Aallele ? AA : (val[0] == Callele && val[1] == Callele ? CC : (val[0] == Aallele && val[1] == Callele || val[0] == Callele && val[1] == Aallele ? AC : NN));
            }
            builder.addSite((Position)target2.positions().get(s), siteGeno);
        }
        myLogger.info((Object)"called alleles");
        popdata.imputed = builder.build();
    }

    public static void callParentAllelesByWindowForMultipleBC(PopulationData popdata, double maxMissing, int minMinorAlleleCount, int windowSize) {
        BitSet polybits = NucleotideImputationUtils.whichSitesArePolymorphic(popdata.original, maxMissing, minMinorAlleleCount);
        myLogger.info((Object)("polybits cardinality = " + polybits.cardinality()));
        OpenBitSet filteredBits = NucleotideImputationUtils.whichSnpsAreFromSameTag(popdata.original, 0.8);
        filteredBits.and(polybits);
        System.out.println("filteredBits.cardinality = " + filteredBits.cardinality());
        int nsites = popdata.original.numberOfSites();
        int ntaxa = popdata.original.numberOfTaxa();
        popdata.alleleA = new byte[nsites];
        popdata.alleleC = new byte[nsites];
        popdata.snpIndex = new OpenBitSet(nsites);
        for (int s = 0; s < nsites; ++s) {
            if (!filteredBits.fastGet(s)) continue;
            popdata.alleleA[s] = popdata.original.majorAllele(s);
            popdata.alleleC[s] = popdata.original.minorAllele(s);
            popdata.snpIndex.fastSet(s);
        }
        myLogger.info((Object)("number of called snps = " + popdata.snpIndex.cardinality()));
        int nsnps = (int)popdata.snpIndex.cardinality();
        ntaxa = popdata.original.numberOfTaxa();
        nsites = popdata.original.numberOfSites();
        int[] snpIndex = new int[nsnps];
        int snpcount = 0;
        for (int s = 0; s < nsites; ++s) {
            if (!popdata.snpIndex.fastGet(s)) continue;
            snpIndex[snpcount++] = s;
        }
        snpIndex = Arrays.copyOf(snpIndex, snpcount);
        FilterGenotypeTable target = FilterGenotypeTable.getInstance(popdata.original, snpIndex);
        nsnps = snpIndex.length;
        GenotypeTableBuilder builder = GenotypeTableBuilder.getSiteIncremental(target.taxa());
        for (int s = 0; s < nsnps; ++s) {
            byte Aallele = popdata.alleleA[snpIndex[s]];
            byte Callele = popdata.alleleC[snpIndex[s]];
            byte[] siteGeno = new byte[ntaxa];
            for (int t = 0; t < ntaxa; ++t) {
                byte[] val = GenotypeTableUtils.getDiploidValues(target.genotype(t, s));
                siteGeno[t] = val[0] == Aallele && val[1] == Aallele ? AA : (val[0] == Callele && val[1] == Callele ? CC : (val[0] == Aallele && val[1] == Callele || val[0] == Callele && val[1] == Aallele ? AC : NN));
            }
            builder.addSite((Position)target.positions().get(s), siteGeno);
        }
        myLogger.info((Object)"called alleles");
        popdata.imputed = builder.build();
    }

    public static void checkAlignmentOrderIgnoringParents(GenotypeTable[] alignments, PopulationData family, double r) {
        boolean swapAlignments = false;
        double minR = -0.05;
        if (r < minR) {
            swapAlignments = true;
        }
        if (swapAlignments) {
            GenotypeTable temp = alignments[0];
            alignments[0] = alignments[1];
            alignments[1] = temp;
        }
    }

    public static int[][] getWindows(BitSet ispoly, int windowSize) {
        int npoly = (int)ispoly.cardinality();
        int nsnps = (int)ispoly.size();
        int nwindows = npoly / windowSize;
        int remainder = npoly % windowSize;
        if (remainder > windowSize / 2) {
            ++nwindows;
        }
        int[][] windows = new int[nwindows][];
        int setsize = npoly / nwindows;
        int windowCount = 0;
        int snpCount = 0;
        int polyCount = 0;
        while (snpCount < nsnps && windowCount < nwindows) {
            int numberLeft = npoly - polyCount;
            if (numberLeft < setsize * 2) {
                setsize = numberLeft;
            }
            int[] set = new int[setsize];
            int setcount = 0;
            while (setcount < setsize && snpCount < nsnps) {
                if (ispoly.fastGet(snpCount)) {
                    set[setcount++] = snpCount;
                    ++polyCount;
                }
                ++snpCount;
            }
            windows[windowCount++] = set;
        }
        return windows;
    }

    public static void callParentAllelesUsingTaxaGroups(PopulationData family, GenotypeTable[] taxaGroups, LinkedList<Integer> snpList) {
        int nsnps = taxaGroups[0].numberOfSites();
        Iterator snpit = snpList.iterator();
        for (int s = 0; s < nsnps; ++s) {
            byte[] major = new byte[]{taxaGroups[0].majorAllele(s), taxaGroups[1].majorAllele(s)};
            Integer snpIndex = (Integer)snpit.next();
            if (major[0] == 15 || major[1] == 15 || major[0] == major[1]) continue;
            family.alleleA[snpIndex.intValue()] = major[0];
            family.alleleC[snpIndex.intValue()] = major[1];
            family.snpIndex.fastSet(snpIndex);
        }
    }

    public static double getIdCorrelation(TaxaList[][] id) {
        double[][] counts = new double[2][2];
        counts[0][0] = TaxaListUtils.getCommonTaxa(id[0][0], id[1][0]).numberOfTaxa();
        counts[0][1] = TaxaListUtils.getCommonTaxa(id[0][0], id[1][1]).numberOfTaxa();
        counts[1][0] = TaxaListUtils.getCommonTaxa(id[0][1], id[1][0]).numberOfTaxa();
        counts[1][1] = TaxaListUtils.getCommonTaxa(id[0][1], id[1][1]).numberOfTaxa();
        double num = counts[0][0] * counts[1][1] - counts[0][1] * counts[1][0];
        double p1 = counts[0][0] + counts[0][1];
        double q1 = counts[1][0] + counts[1][1];
        double p2 = counts[0][0] + counts[1][0];
        double q2 = counts[0][1] + counts[1][1];
        return num / Math.sqrt(p1 * q1 * p2 * q2);
    }

    public static BitSet whichSitesArePolymorphic(GenotypeTable a, double maxMissing, int minMinorAlleleCount) {
        int ntaxa = a.numberOfTaxa();
        double minMaf = (double)minMinorAlleleCount / (double)(2 * ntaxa);
        return NucleotideImputationUtils.whichSitesArePolymorphic(a, maxMissing, minMaf);
    }

    public static BitSet whichSitesArePolymorphic(GenotypeTable a, double maxMissing, double minMaf) {
        int nsites = a.numberOfSites();
        int ntaxa = a.numberOfTaxa();
        OpenBitSet polybits = new OpenBitSet(nsites);
        for (int s = 0; s < nsites; ++s) {
            int notMissingCount = a.totalNonMissingForSite(s);
            int minorAlleleCount = a.minorAlleleCount(s);
            double maf = a.minorAlleleFrequency(s);
            double pMissing = (double)(ntaxa - notMissingCount) / (double)ntaxa;
            if (!(pMissing <= maxMissing) || !(maf >= minMaf)) continue;
            polybits.fastSet(s);
        }
        return polybits;
    }

    public static BitSet whichSitesSegregateCorrectly(GenotypeTable a, double maxMissing, double ratio) {
        int nsites = a.numberOfSites();
        int ntaxa = a.numberOfTaxa();
        OpenBitSet polybits = new OpenBitSet(nsites);
        for (int s = 0; s < nsites; ++s) {
            int[][] freq = a.allelesSortedByFrequency(s);
            int nMissing = ntaxa - a.totalNonMissingForSite(s);
            double pMissing = (double)nMissing / (double)ntaxa;
            if (freq[1].length <= 1 || !(pMissing <= maxMissing)) continue;
            int Mj = freq[1][0];
            int Mn = freq[1][1];
            double pmono = NucleotideImputationUtils.binomialProbability(Mj + Mn, Mn, 0.002);
            double pquarter = NucleotideImputationUtils.binomialProbability(Mj + Mn, Mn, 0.25);
            double phalf = NucleotideImputationUtils.binomialProbability(Mj + Mn, Mn, 0.5);
            if (ratio == 0.25 || ratio == 0.75) {
                if (!(pquarter > phalf) || !(pquarter > pmono)) continue;
                polybits.fastSet(s);
                continue;
            }
            if (!(phalf / (pmono + pquarter) > 2.0)) continue;
            polybits.fastSet(s);
        }
        return polybits;
    }

    private static double binomialProbability(int trials, int successes, double pSuccess) {
        double n = trials;
        double k = successes;
        double logprob = GammaFunction.lnGamma(n + 1.0) - GammaFunction.lnGamma(k + 1.0) - GammaFunction.lnGamma(n - k + 1.0) + k * Math.log(pSuccess) + (n - k) * Math.log(1.0 - pSuccess);
        return Math.exp(logprob);
    }

    public static GenotypeTable[] getTaxaGroupAlignments(GenotypeTable a, int[] parentIndex, LinkedList<Integer> snpIndices) {
        GenotypeTable[] taxaClusters = ImputationUtils.getTwoClusters(a, 20);
        LinkedList<Integer> originalList = new LinkedList<Integer>(snpIndices);
        int nsites = a.numberOfSites();
        boolean[] include = new boolean[nsites];
        int[] includedSnps = new int[nsites];
        int snpcount = 0;
        for (int s = 0; s < nsites; ++s) {
            Integer snpIndex = snpIndices.remove();
            if (taxaClusters[0].majorAllele(s) != taxaClusters[1].majorAllele(s)) {
                include[s] = true;
                includedSnps[snpcount++] = s;
                snpIndices.add(snpIndex);
                continue;
            }
            include[s] = false;
        }
        if (snpcount > 5) {
            includedSnps = Arrays.copyOf(includedSnps, snpcount);
            if (snpcount == nsites) {
                return taxaClusters;
            }
            return ImputationUtils.getTwoClusters((GenotypeTable)FilterGenotypeTable.getInstance(a, includedSnps), 20);
        }
        snpIndices.clear();
        snpIndices.addAll(originalList);
        return taxaClusters;
    }

    public static void estimateMissingDistances(DistanceMatrix dm) {
        int nsize = dm.getSize();
        double totalDistance = 0.0;
        int count = 0;
        for (int i = 0; i < nsize; ++i) {
            for (int j = i + 1; j < nsize; ++j) {
                double distance = dm.getDistance(i, j);
                if (Double.isNaN(distance)) continue;
                totalDistance += dm.getDistance(i, j);
                ++count;
            }
        }
        double avgDist = totalDistance / (double)count;
        for (int i = 0; i < nsize; ++i) {
            if (Double.isNaN(dm.getDistance(i, i))) {
                dm.setDistance(i, i, 0.0);
            }
            for (int j = i + 1; j < nsize; ++j) {
                if (!Double.isNaN(dm.getDistance(i, j))) continue;
                dm.setDistance(i, j, avgDist);
            }
        }
    }

    public static double computeRForAlleles(int site1, int site2, GenotypeTable a) {
        int s1Count = 0;
        int s2Count = 0;
        int prodCount = 0;
        int totalCount = 0;
        long[] m11 = a.allelePresenceForAllTaxa(site1, GenotypeTable.WHICH_ALLELE.Major).getBits();
        long[] m12 = a.allelePresenceForAllTaxa(site1, GenotypeTable.WHICH_ALLELE.Minor).getBits();
        long[] m21 = a.allelePresenceForAllTaxa(site2, GenotypeTable.WHICH_ALLELE.Major).getBits();
        long[] m22 = a.allelePresenceForAllTaxa(site2, GenotypeTable.WHICH_ALLELE.Minor).getBits();
        int n = m11.length;
        for (int i = 0; i < n; ++i) {
            long valid = (m11[i] ^ m12[i]) & (m21[i] ^ m22[i]);
            long s1major = m11[i] & valid;
            long s2major = m21[i] & valid;
            long s1s2major = s1major & s2major & valid;
            s1Count += BitUtil.pop(s1major);
            s2Count += BitUtil.pop(s2major);
            prodCount += BitUtil.pop(s1s2major);
            totalCount += BitUtil.pop(valid);
        }
        if (totalCount < 2) {
            return Double.NaN;
        }
        double num = (double)prodCount - (double)s1Count * (double)s2Count / (double)totalCount;
        double denom = (double)(s1Count * (totalCount - s1Count)) / (double)totalCount;
        if ((denom *= (double)(s2Count * (totalCount - s2Count)) / (double)totalCount) == 0.0) {
            return Double.NaN;
        }
        return num / Math.sqrt(denom);
    }

    public static double computeRForMissingness(int site1, int site2, GenotypeTable a) {
        int totalCount = a.numberOfTaxa();
        BitSet m11 = a.allelePresenceForAllTaxa(site1, GenotypeTable.WHICH_ALLELE.Major);
        BitSet m12 = a.allelePresenceForAllTaxa(site1, GenotypeTable.WHICH_ALLELE.Minor);
        BitSet m21 = a.allelePresenceForAllTaxa(site2, GenotypeTable.WHICH_ALLELE.Major);
        BitSet m22 = a.allelePresenceForAllTaxa(site2, GenotypeTable.WHICH_ALLELE.Minor);
        OpenBitSet s1present = new OpenBitSet(m11.getBits(), m11.getNumWords());
        s1present.union(m12);
        OpenBitSet s2present = new OpenBitSet(m21.getBits(), m21.getNumWords());
        s2present.union(m22);
        long s1Count = s1present.cardinality();
        long s2Count = s2present.cardinality();
        long prodCount = OpenBitSet.intersectionCount(s1present, s2present);
        double num = (double)prodCount - (double)s1Count * (double)s2Count / (double)totalCount;
        double denom = (double)(s1Count * ((long)totalCount - s1Count)) / (double)totalCount;
        if ((denom *= (double)(s2Count * ((long)totalCount - s2Count)) / (double)totalCount) == 0.0) {
            return Double.NaN;
        }
        return num / Math.sqrt(denom);
    }

    public static double computeGenotypeR(int site1, int site2, GenotypeTable a) throws IllegalStateException {
        BitSet s1mj = a.allelePresenceForAllTaxa(site1, GenotypeTable.WHICH_ALLELE.Major);
        BitSet s1mn = a.allelePresenceForAllTaxa(site1, GenotypeTable.WHICH_ALLELE.Minor);
        BitSet s2mj = a.allelePresenceForAllTaxa(site2, GenotypeTable.WHICH_ALLELE.Major);
        BitSet s2mn = a.allelePresenceForAllTaxa(site2, GenotypeTable.WHICH_ALLELE.Minor);
        OpenBitSet bothpresent = new OpenBitSet(s1mj);
        bothpresent.union(s1mn);
        OpenBitSet s2present = new OpenBitSet(s2mj);
        s2present.union(s2mn);
        bothpresent.intersect(s2present);
        long nsites = a.numberOfTaxa();
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sumsq1 = 0.0;
        double sumsq2 = 0.0;
        double sumprod = 0.0;
        double count = 0.0;
        for (long i = 0L; i < nsites; ++i) {
            if (!bothpresent.fastGet(i)) continue;
            double val1 = 0.0;
            double val2 = 0.0;
            if (s1mj.fastGet(i)) {
                val1 = s1mn.fastGet(i) ? (val1 += 1.0) : (val1 += 2.0);
            }
            if (s2mj.fastGet(i)) {
                val2 = s2mn.fastGet(i) ? (val2 += 1.0) : (val2 += 2.0);
            }
            sum1 += val1;
            sumsq1 += val1 * val1;
            sum2 += val2;
            sumsq2 += val2 * val2;
            sumprod += val1 * val2;
            count += 1.0;
        }
        double num = sumprod - sum1 / count * sum2;
        double denom = Math.sqrt((sumsq1 - sum1 / count * sum1) * (sumsq2 - sum2 / count * sum2));
        if (denom == 0.0) {
            return Double.NaN;
        }
        return num / denom;
    }

    public static GenotypeTable imputeUsingViterbiFiveState(GenotypeTable a, double probHeterozygous, String familyName) {
        return NucleotideImputationUtils.imputeUsingViterbiFiveState(a, probHeterozygous, familyName, false);
    }

    public static GenotypeTable imputeUsingViterbiFiveState(GenotypeTable a, double probHeterozygous, String familyName, boolean useVariableRecombitionRates) {
        byte[] states;
        int t;
        int maxIterations = 50;
        HashMap<Byte, Byte> obsMap = new HashMap<Byte, Byte>();
        obsMap.put(AA, (byte)0);
        obsMap.put(AC, (byte)1);
        obsMap.put(CA, (byte)1);
        obsMap.put(CC, (byte)2);
        int ntaxa = a.numberOfTaxa();
        int nsites = a.numberOfSites();
        double[][] transition = new double[][]{{0.999, 1.0E-4, 3.0E-4, 1.0E-4, 5.0E-4}, {2.0E-4, 0.999, 5.0E-5, 5.0E-5, 2.0E-4}, {2.0E-4, 5.0E-5, 0.999, 5.0E-5, 2.0E-4}, {2.0E-4, 5.0E-5, 5.0E-5, 0.999, 2.0E-4}, {5.0E-4, 1.0E-4, 3.0E-4, 1.0E-4, 0.999}};
        TransitionProbability tp = useVariableRecombitionRates ? new TransitionProbabilityWithVariableRecombination(a.chromosomeName(0)) : new TransitionProbability();
        tp.setTransitionProbability(transition);
        int chrlength = a.chromosomalPosition(nsites - 1) - a.chromosomalPosition(0);
        tp.setAverageSegmentLength(chrlength / nsites);
        double[][] emission = new double[][]{{0.998, 0.001, 0.001}, {0.6, 0.2, 0.2}, {0.4, 0.2, 0.4}, {0.2, 0.2, 0.6}, {0.001, 0.001, 0.998}};
        EmissionProbability ep = new EmissionProbability();
        ep.setEmissionProbability(emission);
        ArrayList<OpenBitSet> notMissingIndex = new ArrayList<OpenBitSet>();
        int[] notMissingCount = new int[ntaxa];
        ArrayList<byte[]> nonMissingObs = new ArrayList<byte[]>();
        ArrayList<int[]> snpPositions = new ArrayList<int[]>();
        for (t = 0; t < ntaxa; ++t) {
            long[] bits = a.allelePresenceForAllSites(t, GenotypeTable.WHICH_ALLELE.Major).getBits();
            OpenBitSet notMiss = new OpenBitSet(bits, bits.length);
            notMiss.or(a.allelePresenceForAllSites(t, GenotypeTable.WHICH_ALLELE.Minor));
            notMissingIndex.add(notMiss);
            notMissingCount[t] = (int)notMiss.cardinality();
        }
        for (t = 0; t < ntaxa; ++t) {
            byte[] obs = new byte[notMissingCount[t]];
            int[] pos = new int[notMissingCount[t]];
            nonMissingObs.add(obs);
            snpPositions.add(pos);
            BitSet isNotMissing = (BitSet)notMissingIndex.get(t);
            int nmcount = 0;
            for (int s = 0; s < nsites; ++s) {
                byte base = a.genotype(t, s);
                if (isNotMissing.fastGet(s) && obsMap.get(a.genotype(t, s)) == null) {
                    myLogger.info((Object)("null from " + Byte.toString(base)));
                }
                if (!isNotMissing.fastGet(s)) continue;
                obs[nmcount] = (Byte)obsMap.get(a.genotype(t, s));
                pos[nmcount++] = a.chromosomalPosition(s);
            }
        }
        double phom = (1.0 - probHeterozygous) / 2.0;
        double[] pTrue = new double[]{phom, 0.25 * probHeterozygous, 0.5 * probHeterozygous, 0.25 * probHeterozygous, phom};
        ArrayList<byte[]> bestStates = new ArrayList<byte[]>();
        int[][] previousStateCount = new int[5][3];
        int iter = 0;
        boolean hasNotConverged = true;
        while (iter < maxIterations && hasNotConverged) {
            int[] row;
            int i$;
            myLogger.info((Object)("Iteration " + iter++ + " for " + familyName));
            bestStates.clear();
            for (int t2 = 0; t2 < ntaxa; ++t2) {
                tp.setPositions((int[])snpPositions.get(t2));
                int nobs = notMissingCount[t2];
                if (nobs >= 20) {
                    ViterbiAlgorithm va = new ViterbiAlgorithm((byte[])nonMissingObs.get(t2), tp, ep, pTrue);
                    va.calculate();
                    bestStates.add(va.getMostProbableStateSequence());
                    continue;
                }
                myLogger.info((Object)("Fewer then 20 observations for " + a.taxa().taxaName(t2)));
                byte[] states2 = new byte[nobs];
                byte[] obs = (byte[])nonMissingObs.get(t2);
                for (int i = 0; i < nobs; ++i) {
                    states2[i] = obs[i] == AA ? 0 : (obs[i] == CC ? 4 : 2);
                }
                bestStates.add(states2);
            }
            int[][] transitionCounts = new int[5][5];
            double[][] transitionProb = new double[5][5];
            for (int t3 = 0; t3 < ntaxa; ++t3) {
                states = (byte[])bestStates.get(t3);
                for (int s = 1; s < notMissingCount[t3]; ++s) {
                    int[] nArray = transitionCounts[states[s - 1]];
                    byte by = states[s];
                    nArray[by] = nArray[by] + 1;
                }
            }
            for (int row2 = 0; row2 < 5; ++row2) {
                int col;
                double rowsum = 0.0;
                for (col = 0; col < 5; ++col) {
                    rowsum += (double)transitionCounts[row2][col];
                }
                for (col = 0; col < 5; ++col) {
                    transitionProb[row2][col] = (double)transitionCounts[row2][col] / rowsum;
                }
            }
            tp.setTransitionCounts(transitionCounts, chrlength, ntaxa);
            int[][] emissionCounts = new int[5][3];
            double[][] emissionProb = new double[5][3];
            for (int t4 = 0; t4 < ntaxa; ++t4) {
                byte[] obs = (byte[])nonMissingObs.get(t4);
                byte[] states3 = (byte[])bestStates.get(t4);
                for (int s = 0; s < notMissingCount[t4]; ++s) {
                    int[] nArray = emissionCounts[states3[s]];
                    byte by = obs[s];
                    nArray[by] = nArray[by] + 1;
                }
            }
            hasNotConverged = false;
            for (int r = 0; r < 5; ++r) {
                for (int c = 0; c < 3; ++c) {
                    if (previousStateCount[r][c] == emissionCounts[r][c]) continue;
                    hasNotConverged = true;
                    previousStateCount[r][c] = emissionCounts[r][c];
                }
            }
            double[] rowSums = new double[5];
            double total = 0.0;
            for (int row3 = 0; row3 < 5; ++row3) {
                int col;
                double rowsum = 0.0;
                for (col = 0; col < 3; ++col) {
                    rowsum += (double)emissionCounts[row3][col];
                }
                for (col = 0; col < 3; ++col) {
                    emissionProb[row3][col] = (double)emissionCounts[row3][col] / rowsum;
                }
                rowSums[row3] = rowsum;
                total += rowsum;
            }
            ep.setEmissionProbability(emissionProb);
            for (int i = 0; i < 5; ++i) {
                pTrue[i] = rowSums[i] / total;
            }
            if (hasNotConverged && iter != maxIterations) continue;
            StringBuilder sb = new StringBuilder("Family ");
            sb.append(familyName).append(", chromosome ").append(a.chromosomeName(0));
            if (iter < maxIterations) {
                sb.append(": EM algorithm converged at iteration ").append(iter).append(".\n");
            } else {
                sb.append(": EM algorithm failed to converge after ").append(iter).append(" iterations.\n");
            }
            sb = new StringBuilder("Transition counts from row to column:\n");
            Object arr$ = transitionCounts;
            int len$ = ((int[][])arr$).length;
            for (i$ = 0; i$ < len$; ++i$) {
                for (int cell : row = arr$[i$]) {
                    sb.append(cell).append("\t");
                }
                sb.append("\n");
            }
            sb.append("\n");
            myLogger.info((Object)sb.toString());
            sb = new StringBuilder("Transition probabilities:\n");
            arr$ = transitionProb;
            len$ = ((int[][])arr$).length;
            for (i$ = 0; i$ < len$; ++i$) {
                for (int cell : row = arr$[i$]) {
                    sb.append((double)cell).append("\t");
                }
                sb.append("\n");
            }
            sb.append("\n");
            myLogger.info((Object)sb.toString());
            sb = new StringBuilder("Imputation counts, rows=states, columns=observations:\n");
            arr$ = emissionCounts;
            len$ = ((int[][])arr$).length;
            for (i$ = 0; i$ < len$; ++i$) {
                for (int cell : row = arr$[i$]) {
                    sb.append(cell).append("\t");
                }
                sb.append("\n");
            }
            sb.append("\n");
            myLogger.info((Object)sb.toString());
            sb = new StringBuilder("Emission probabilities:\n");
            arr$ = emissionProb;
            len$ = ((int[][])arr$).length;
            for (i$ = 0; i$ < len$; ++i$) {
                for (int cell : row = arr$[i$]) {
                    sb.append((double)cell).append("\t");
                }
                sb.append("\n");
            }
            sb.append("\n");
            myLogger.info((Object)sb.toString());
        }
        GenotypeTableBuilder builder = GenotypeTableBuilder.getTaxaIncremental(a.positions());
        nsites = a.numberOfSites();
        for (int t5 = 0; t5 < ntaxa; ++t5) {
            BitSet hasData = (BitSet)notMissingIndex.get(t5);
            states = (byte[])bestStates.get(t5);
            int stateCount = 0;
            byte[] taxonGeno = new byte[nsites];
            Arrays.fill(taxonGeno, NN);
            for (int s = 0; s < nsites; ++s) {
                if (!hasData.fastGet(s)) continue;
                if (states[stateCount] == 0) {
                    taxonGeno[s] = AA;
                } else if (states[stateCount] < 4) {
                    taxonGeno[s] = AC;
                } else if (states[stateCount] == 4) {
                    taxonGeno[s] = CC;
                }
                ++stateCount;
            }
            builder.addTaxon((Taxon)a.taxa().get(t5), taxonGeno);
        }
        return builder.build();
    }

    public static void fillGapsInAlignment(PopulationData popdata) {
        int ntaxa = popdata.imputed.numberOfTaxa();
        int nsites = popdata.imputed.numberOfSites();
        GenotypeTableBuilder builder = GenotypeTableBuilder.getTaxaIncremental(popdata.imputed.positions());
        for (int t = 0; t < ntaxa; ++t) {
            int prevsite = -1;
            byte prevValue = -1;
            byte[] taxonGeno = new byte[nsites];
            Arrays.fill(taxonGeno, NN);
            for (int s = 0; s < nsites; ++s) {
                byte val = popdata.imputed.genotype(t, s);
                if (val == NN) continue;
                if (prevsite == -1) {
                    prevsite = s;
                    prevValue = val;
                    continue;
                }
                if (val == prevValue) {
                    for (int site = prevsite + 1; site < s; ++site) {
                        taxonGeno[site] = prevValue;
                    }
                    prevsite = s;
                    continue;
                }
                prevsite = s;
                prevValue = val;
            }
            builder.addTaxon((Taxon)popdata.imputed.taxa().get(t), taxonGeno);
        }
        popdata.imputed = builder.build();
    }

    public static GenotypeTable convertParentCallsToNucleotides(PopulationData popdata) {
        GenotypeTableBuilder builder = GenotypeTableBuilder.getSiteIncremental(popdata.imputed.taxa());
        BitSet isPopSnp = popdata.snpIndex;
        int nsites = (int)isPopSnp.capacity();
        int ntaxa = popdata.imputed.taxa().numberOfTaxa();
        int imputedSnpCount = 0;
        for (int s = 0; s < nsites; ++s) {
            if (!isPopSnp.fastGet(s)) continue;
            byte Acall = popdata.alleleA[s];
            byte Ccall = popdata.alleleC[s];
            byte AAcall = (byte)(Acall << 4 | Acall);
            byte CCcall = (byte)(Ccall << 4 | Ccall);
            byte ACcall = (byte)(Acall << 4 | Ccall);
            byte[] geno = new byte[ntaxa];
            for (int t = 0; t < ntaxa; ++t) {
                byte parentCall = popdata.imputed.genotype(t, imputedSnpCount);
                geno[t] = parentCall == AA ? AAcall : (parentCall == CC ? CCcall : (parentCall == AC || parentCall == CA ? ACcall : NN));
            }
            builder.addSite((Position)popdata.imputed.positions().get(imputedSnpCount), geno);
            ++imputedSnpCount;
        }
        myLogger.info((Object)("Original alignment updated for family " + popdata.name + " chromosome " + popdata.original.chromosomeName(0) + ".\n"));
        return builder.build();
    }

    public static OpenBitSet whichSnpsAreFromSameTag(GenotypeTable geno, double minRsq) {
        int nsites = geno.numberOfSites();
        int firstSite = 0;
        OpenBitSet isSelected = new OpenBitSet(nsites);
        isSelected.fastSet(0);
        Chromosome firstSnpChr = geno.chromosome(0);
        int firstSnpPos = geno.chromosomalPosition(0);
        while (firstSite < nsites - 1) {
            int nextSite = firstSite + 1;
            int nextSnpPos = geno.chromosomalPosition(nextSite);
            Chromosome nextSnpChr = geno.chromosome(nextSite);
            while (firstSnpChr.equals(nextSnpChr) && nextSnpPos - firstSnpPos < 64) {
                BitSet rMj = geno.allelePresenceForAllTaxa(firstSite, GenotypeTable.WHICH_ALLELE.Major);
                BitSet rMn = geno.allelePresenceForAllTaxa(firstSite, GenotypeTable.WHICH_ALLELE.Minor);
                BitSet cMj = geno.allelePresenceForAllTaxa(nextSite, GenotypeTable.WHICH_ALLELE.Major);
                BitSet cMn = geno.allelePresenceForAllTaxa(nextSite, GenotypeTable.WHICH_ALLELE.Minor);
                int[][] contig = new int[2][2];
                contig[0][0] = (int)OpenBitSet.intersectionCount(rMj, cMj);
                contig[1][0] = (int)OpenBitSet.intersectionCount(rMn, cMj);
                contig[0][1] = (int)OpenBitSet.intersectionCount(rMj, cMn);
                contig[1][1] = (int)OpenBitSet.intersectionCount(rMn, cMn);
                double rsq = NucleotideImputationUtils.calculateRSqr(contig[0][0], contig[0][1], contig[1][0], contig[1][1], 2);
                if (Double.isNaN(rsq) || rsq < minRsq) {
                    isSelected.fastSet(nextSite);
                    break;
                }
                if (++nextSite >= nsites) break;
                nextSnpPos = geno.chromosomalPosition(nextSite);
                nextSnpChr = geno.chromosome(nextSite);
            }
            if ((firstSite = nextSite) >= nsites) continue;
            firstSnpChr = nextSnpChr;
            firstSnpPos = nextSnpPos;
            isSelected.fastSet(firstSite);
        }
        return isSelected;
    }

    public static OpenBitSet whichSnpsAreFromSameTag(GenotypeTable geno, BitSet polybits) {
        if (polybits.cardinality() == 0L) {
            if (polybits instanceof OpenBitSet) {
                return (OpenBitSet)polybits;
            }
            return new OpenBitSet(polybits.getBits(), polybits.getNumWords());
        }
        int nsites = geno.numberOfSites();
        int firstSite = 0;
        while (!polybits.fastGet(firstSite)) {
            ++firstSite;
        }
        OpenBitSet isSelected = new OpenBitSet(nsites);
        isSelected.fastSet(firstSite);
        int firstSnpPos = geno.chromosomalPosition(firstSite);
        Chromosome firstChr = geno.chromosome(firstSite);
        while (firstSite < nsites - 1) {
            boolean skip;
            int nextSite = firstSite + 1;
            int nextSnpPos = geno.chromosomalPosition(nextSite);
            Chromosome nextChr = geno.chromosome(nextSite);
            boolean bl = skip = !polybits.fastGet(nextSite) || firstChr.equals(nextChr) && nextSnpPos - firstSnpPos < 64 && NucleotideImputationUtils.computeRForMissingness(firstSite, nextSite, geno) > 0.8;
            while (skip) {
                boolean validSite;
                boolean bl2 = validSite = nextSite < nsites;
                while (validSite && !polybits.fastGet(nextSite)) {
                    validSite = ++nextSite < nsites;
                }
                if (validSite) {
                    boolean correlatedSite;
                    nextSnpPos = geno.chromosomalPosition(nextSite);
                    nextChr = geno.chromosome(nextSite);
                    int dist = nextSnpPos - firstSnpPos;
                    boolean nearbySite = firstChr.equals(nextChr) && dist < 64;
                    double r = NucleotideImputationUtils.computeRForMissingness(firstSite, nextSite, geno);
                    boolean bl3 = correlatedSite = r > 0.7;
                    if (nearbySite && correlatedSite) {
                        skip = true;
                        validSite = ++nextSite < nsites;
                        continue;
                    }
                    skip = false;
                    continue;
                }
                skip = false;
            }
            firstSite = nextSite;
            if (firstSite >= nsites) continue;
            firstChr = nextChr;
            firstSnpPos = nextSnpPos;
            isSelected.fastSet(firstSite);
        }
        return isSelected;
    }

    public static GenotypeTable filterSnpsByTag(GenotypeTable a, double minMaf, double maxMissing, double maxHet) {
        int nOriginalSites = a.numberOfSites();
        int[] selectedSites = new int[nOriginalSites];
        int ntaxa = a.numberOfTaxa();
        selectedSites[0] = 0;
        int selectedCount = 1;
        int headSite = 0;
        for (int s = 1; s < nOriginalSites; ++s) {
            int dist = a.chromosomalPosition(s) - a.chromosomalPosition(headSite);
            double maf = a.minorAlleleFrequency(s);
            int npresent = a.totalNonMissingForSite(s);
            int nhet = a.heterozygousCount(s);
            double pmissing = (double)(ntaxa - npresent) / (double)ntaxa;
            double phet = (double)nhet / (double)npresent;
            if (dist < 64 && !(NucleotideImputationUtils.computeRForMissingness(headSite, s, a) < 0.7) || !(maf >= minMaf) || !(pmissing <= maxMissing) || !(phet <= maxHet)) continue;
            selectedSites[selectedCount++] = s;
            headSite = s;
        }
        selectedSites = Arrays.copyOf(selectedSites, selectedCount);
        return FilterGenotypeTable.getInstance(a, selectedSites);
    }

    static double calculateRSqr(int countAB, int countAb, int countaB, int countab, int minTaxaForEstimate) {
        double nonmissingSampleSize = countAB + countAb + countaB + countab;
        if (nonmissingSampleSize < (double)minTaxaForEstimate) {
            return Double.NaN;
        }
        double freqA = (double)(countAB + countAb) / nonmissingSampleSize;
        double freqB = (double)(countAB + countaB) / nonmissingSampleSize;
        if (freqA == 0.0 || freqB == 0.0 || freqA == 1.0 || freqB == 1.0) {
            return Double.NaN;
        }
        double rsqr = (double)countAB / nonmissingSampleSize * ((double)countab / nonmissingSampleSize);
        rsqr -= (double)countaB / nonmissingSampleSize * ((double)countAb / nonmissingSampleSize);
        rsqr *= rsqr;
        return rsqr /= freqA * (1.0 - freqA) * freqB * (1.0 - freqB);
    }

    public static BitSet ldfilter(GenotypeTable a, int window, double minR, BitSet filterBits) {
        int nsites = a.numberOfSites();
        OpenBitSet ldbits = new OpenBitSet(nsites);
        for (int s = 0; s < nsites; ++s) {
            double avgr;
            if (!filterBits.fastGet(s) || !((avgr = NucleotideImputationUtils.neighborLD(a, s, window, filterBits)) >= minR)) continue;
            ldbits.fastSet(s);
        }
        return ldbits;
    }

    public static double neighborLD(GenotypeTable a, int snp, int window, BitSet filterBits) {
        int site;
        double sumr = 0.0;
        int nsites = a.numberOfSites();
        int siteCount = 0;
        int sitesTestedCount = 0;
        for (site = snp + 10; siteCount < window && site < nsites; ++site) {
            double r;
            if (!filterBits.fastGet(site) || Double.isNaN(r = NucleotideImputationUtils.computeGenotypeR(snp, site, a))) continue;
            sumr += Math.abs(NucleotideImputationUtils.computeGenotypeR(snp, site, a));
            ++siteCount;
            ++sitesTestedCount;
        }
        siteCount = 0;
        for (site = snp - 10; siteCount < window && site >= 0; --site) {
            if (!filterBits.fastGet(site)) continue;
            sumr += Math.abs(NucleotideImputationUtils.computeGenotypeR(snp, site, a));
            ++siteCount;
            ++sitesTestedCount;
        }
        return sumr / (double)sitesTestedCount;
    }

    public static ArrayList<HaplotypeCluster> clusterWindow(GenotypeTable a, int start, int length, int maxdif) {
        int ntaxa = a.numberOfTaxa();
        int end = start + length;
        ArrayList<Haplotype> haps = new ArrayList<Haplotype>();
        for (int t = 0; t < ntaxa; ++t) {
            haps.add(new Haplotype(a.genotypeRange(t, start, end), t));
        }
        HaplotypeClusterer hc = new HaplotypeClusterer(haps);
        hc.makeClusters();
        ArrayList<HaplotypeCluster> mergedClusters = HaplotypeClusterer.getMergedClusters(hc.getClusterList(), maxdif);
        return mergedClusters;
    }

    public static void checkParentage(PopulationData popdata) {
        byte thisAllele;
        int s;
        int other;
        int cmatches;
        int amatches;
        int total;
        myLogger.info((Object)String.format("Checking parents of %s", popdata.name));
        TaxaList myTaxaList = popdata.original.taxa();
        LinkedList<Integer> p1list = new LinkedList<Integer>();
        LinkedList<Integer> p2list = new LinkedList<Integer>();
        int nsites = popdata.original.numberOfSites();
        int ntaxa = popdata.original.numberOfTaxa();
        for (int t = 0; t < ntaxa; ++t) {
            String tname = myTaxaList.taxaName(t);
            if (tname.toUpperCase().contains(popdata.parent1.toUpperCase())) {
                p1list.add(t);
            }
            if (!tname.toUpperCase().contains(popdata.parent2.toUpperCase())) continue;
            p2list.add(t);
        }
        int consistent = 0;
        int notConsistent = 0;
        for (Integer tndx : p1list) {
            total = 0;
            amatches = 0;
            cmatches = 0;
            other = 0;
            for (s = 0; s < nsites; ++s) {
                if (!popdata.snpIndex.fastGet(s) || (thisAllele = popdata.original.genotype(tndx, s)) == NN) continue;
                ++total;
                if (thisAllele == popdata.alleleA[s]) {
                    ++amatches;
                    continue;
                }
                if (thisAllele == popdata.alleleC[s]) {
                    ++cmatches;
                    continue;
                }
                ++other;
            }
            consistent += amatches;
            notConsistent += cmatches;
            myLogger.info((Object)String.format("%s: total = %d, amatches = %d, cmatches = %d, other = %d", myTaxaList.taxaName(tndx), total, amatches, cmatches, other));
        }
        for (Integer tndx : p2list) {
            total = 0;
            amatches = 0;
            cmatches = 0;
            other = 0;
            for (s = 0; s < nsites; ++s) {
                if (!popdata.snpIndex.fastGet(s) || (thisAllele = popdata.original.genotype(tndx, s)) == NN) continue;
                ++total;
                if (thisAllele == popdata.alleleA[s]) {
                    ++amatches;
                    continue;
                }
                if (thisAllele == popdata.alleleC[s]) {
                    ++cmatches;
                    continue;
                }
                ++other;
            }
            consistent += cmatches;
            notConsistent += amatches;
            myLogger.info((Object)String.format("%s: total = %d, amatches = %d, cmatches = %d, other = %d", myTaxaList.taxaName(tndx), total, amatches, cmatches, other));
        }
        double probNotConsistent = 0.0;
        if (notConsistent > 0 && (probNotConsistent = (double)notConsistent / (double)(notConsistent + consistent)) > 0.75) {
            byte[] temp = popdata.alleleA;
            popdata.alleleA = popdata.alleleC;
            popdata.alleleC = temp;
        }
        myLogger.info((Object)String.format("Finished checking parents. probNotConsistent = " + probNotConsistent, new Object[0]));
    }

    static {
        genotypeMap.put(AA, 0);
        genotypeMap.put(CC, 1);
        genotypeMap.put(GG, 2);
        genotypeMap.put(TT, 3);
        genotypeMap.put(AC, 4);
        genotypeMap.put(CA, 4);
        genoval = new byte[][]{{AA, AC, AG, AT}, {AC, CC, CG, CT}, {AG, CG, GG, GT}, {AT, CT, GT, TT}};
    }
}

