/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.list.IntArrayList;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TaxaGroups;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class ModifyTBTHDF5Plugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ModifyTBTHDF5Plugin.class);
    private ArgsEngine myArgsEngine = null;
    private String myAdditionalTBTHDF5 = null;
    private String myTargetTBTHDF5 = null;
    private String myOutputTransposeTagTBTHDF5 = null;
    private boolean combineTaxa = false;
    private Tags myMasterTags = null;
    private static int maxGoodReads = 500000000;
    IntArrayList[] taxaReads;
    int[] readsPerSample;
    int[] mappedReadsPerSample;
    int goodBarcodedReads = 0;
    int allReads = 0;
    int goodMatched = 0;
    HashMap<String, Integer> taxaNameToIndices;
    TagsByTaxaByteHDF5TaxaGroups targetTBT = null;

    public ModifyTBTHDF5Plugin() {
        super(null, false);
    }

    public ModifyTBTHDF5Plugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        this.targetTBT = this.myMasterTags != null ? new TagsByTaxaByteHDF5TaxaGroups(this.myMasterTags, this.myTargetTBTHDF5) : new TagsByTaxaByteHDF5TaxaGroups(this.myTargetTBTHDF5);
        if (this.myAdditionalTBTHDF5 != null) {
            this.addAllTaxaToNewHDF5(this.myAdditionalTBTHDF5);
        }
        if (this.combineTaxa) {
            this.combineTaxaHDF5();
        }
        if (this.myOutputTransposeTagTBTHDF5 != null) {
            TagsByTaxaByteHDF5TagGroups tagsByTaxaByteHDF5TagGroups = new TagsByTaxaByteHDF5TagGroups(this.targetTBT, this.myOutputTransposeTagTBTHDF5);
        }
        this.targetTBT.getFileReadyForClosing();
        this.targetTBT = null;
        System.gc();
        return null;
    }

    private void printUsage() {
        myLogger.info((Object)"\n\n\nThe ModifyTBTHDF5Plugin accepts the following arguments:\n-o  Target TBT HDF5 (*tbt.h5) file to be modified\nDepending on the modification that you wish to make, one of either:\n    -i  TBT HDF5 (*tbt.h5) file containing additional taxa to be added to the target TBT HDF5 file\n    -c  Merge taxa in the target TBT HDF5 file with same LibraryPrepID\n    -p  Pivot (transpose) the target TBT HDF5 file into a tag-optimized orientation\n\n\n\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--addition-file", true);
            this.myArgsEngine.add("-o", "--target-HDF5", true);
            this.myArgsEngine.add("-c", "--combine-taxa", false);
            this.myArgsEngine.add("-p", "--taghdf-file", true);
        }
        this.myArgsEngine.parse(args);
        if (!this.myArgsEngine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an target file (option -o).");
        }
        this.myTargetTBTHDF5 = this.myArgsEngine.getString("-o");
        if (this.myArgsEngine.getBoolean("-i")) {
            this.myAdditionalTBTHDF5 = this.myArgsEngine.getString("-i");
        }
        if (this.myArgsEngine.getBoolean("-p")) {
            this.myOutputTransposeTagTBTHDF5 = this.myArgsEngine.getString("-p");
        }
        if (this.myArgsEngine.getBoolean("-c")) {
            this.combineTaxa = true;
        }
    }

    private boolean addAllTaxaToNewHDF5(String addTBTName) {
        int i;
        TagsByTaxaByteHDF5TaxaGroups addTBT = new TagsByTaxaByteHDF5TaxaGroups(addTBTName);
        for (i = 0; i < addTBT.getTagCount(); ++i) {
            if (Arrays.equals(this.targetTBT.getTag(i), addTBT.getTag(i))) continue;
            System.err.println("Tags are not the same for the two TBT file.  They cannot be combined.");
            System.exit(0);
        }
        for (i = 0; i < addTBT.getTaxaCount(); ++i) {
            String name = addTBT.getTaxaName(i);
            byte[] states = addTBT.getReadCountDistributionForTaxon(i);
            this.targetTBT.addTaxon(name, states);
        }
        addTBT.getFileReadyForClosing();
        return true;
    }

    private boolean combineTaxaHDF5() {
        TreeMap<String, ArrayList<String>> combineTaxa = new TreeMap<String, ArrayList<String>>();
        for (String tn : this.targetTBT.getTaxaNames()) {
            String ptn = this.parseTaxaName(tn, "#");
            ArrayList<String> taxaList = (ArrayList<String>)combineTaxa.get(ptn);
            if (taxaList == null) {
                taxaList = new ArrayList<String>();
                combineTaxa.put(ptn, taxaList);
            }
            taxaList.add(tn);
        }
        for (ArrayList taxaList : combineTaxa.values()) {
            if (taxaList.size() < 2) continue;
            byte[] di = new byte[this.targetTBT.getTagCount()];
            String ptn = this.parseTaxaName((String)taxaList.get(0), "" + taxaList.size());
            for (int i = 0; i < taxaList.size(); ++i) {
                int j = this.targetTBT.getIndexOfTaxaName((String)taxaList.get(i));
                byte[] dj = this.targetTBT.getReadCountDistributionForTaxon(j);
                for (int k = 0; k < dj.length; ++k) {
                    int ts = di[k] + dj[k];
                    di[k] = ts > 127 ? 127 : (byte)ts;
                }
            }
            this.targetTBT.addTaxon(ptn, di);
            for (String tn : taxaList) {
                this.targetTBT.deleteTaxon(tn);
            }
        }
        return true;
    }

    private String parseTaxaName(String tn, String cnt) {
        String[] s = tn.split(":");
        return s[0] + ":MRG:" + cnt + ":" + s[3];
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        String inTBTFile = "/Users/edbuckler/SolexaAnal/GBS/build20120110/tbt/434GFAAXX_s_3.tbt.byte";
        TagsByTaxaByte inTBT = new TagsByTaxaByte(inTBTFile, TagsByTaxa.FilePacking.Byte);
        TagsByTaxaByteHDF5TagGroups transHDF5 = new TagsByTaxaByteHDF5TagGroups("/Users/edbuckler/SolexaAnal/GBS/test/t433s3.h5");
        int same = 0;
        int diff = 0;
        int count = 0;
        long time = System.currentTimeMillis();
        int tags = 9;
        for (int i = 0; i < 1000000; i += 11) {
            int taxon = i % inTBT.getTaxaCount();
            if (i % 550 == 0) {
                tags = i % inTBT.getTagCount();
            }
            int newTaxonIndex = transHDF5.getIndexOfTaxaName(inTBT.getTaxaName(taxon));
            if (inTBT.getReadCountForTagTaxon(tags, taxon) == transHDF5.getReadCountForTagTaxon(tags, newTaxonIndex)) {
                ++same;
            } else {
                ++diff;
            }
            ++count;
        }
        System.out.printf("Same %d Diff %d %n", same, diff);
        long duration = System.currentTimeMillis() - time;
        double rate = (double)duration / (double)count;
        System.out.printf("Rate %g %n", rate);
    }
}

