/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.Trait;

class TraitTableModel
extends AbstractTableModel {
    ArrayList<Trait> traitList;
    Phenotype myPhenotype;
    Boolean[] include;
    String[] colName;
    int numberOfTraits;
    int numberOfFactors;
    int numberOfColumns;
    int typeColumnNumber;

    TraitTableModel(Phenotype aPhenotype) {
        this.myPhenotype = aPhenotype;
        this.traitList = new ArrayList();
        List<Trait> oldList = this.myPhenotype.getTraits();
        for (Trait trait : oldList) {
            this.traitList.add(Trait.getInstance(trait));
        }
        this.numberOfTraits = this.traitList.size();
        this.numberOfFactors = this.myPhenotype.getNumberOfFactors();
        this.numberOfColumns = 4 + this.numberOfFactors;
        this.setColumnNames();
        this.include = new Boolean[this.numberOfTraits];
        for (int i = 0; i < this.numberOfTraits; ++i) {
            this.include[i] = true;
        }
    }

    private void setColumnNames() {
        this.colName = new String[this.numberOfColumns];
        int col = 0;
        this.colName[col++] = "Trait";
        for (String factorname : this.myPhenotype.getFactorNameCopy()) {
            this.colName[col++] = factorname;
        }
        this.typeColumnNumber = col;
        this.colName[col++] = "Type";
        this.colName[col++] = "Discrete";
        this.colName[col++] = "Include";
    }

    @Override
    public int getColumnCount() {
        return this.colName.length;
    }

    @Override
    public int getRowCount() {
        return this.include.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 3 + this.numberOfFactors) {
            return this.include[row];
        }
        if (col == 0) {
            return this.traitList.get(row).getName();
        }
        if (col == 1 + this.numberOfFactors) {
            return this.traitList.get(row).getType();
        }
        if (col == 2 + this.numberOfFactors) {
            return this.traitList.get(row).isDiscrete();
        }
        String factorName = this.myPhenotype.getFactorName(col - 1);
        Object factorValue = this.myPhenotype.getTrait(row).getProperty(factorName);
        if (factorValue == null) {
            return "";
        }
        return factorValue;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 2 + this.numberOfFactors) {
            return String.class;
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.colName[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == this.typeColumnNumber || columnIndex == this.typeColumnNumber + 2;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 3 + this.numberOfFactors) {
            this.include[rowIndex] = (Boolean)value;
        }
        if (columnIndex == 1 + this.numberOfFactors) {
            this.traitList.get(rowIndex).setType(value.toString());
        }
    }

    public void excludeAll() {
        for (int i = 0; i < this.numberOfTraits; ++i) {
            this.include[i] = Boolean.FALSE;
        }
        this.fireTableDataChanged();
    }

    public void includeAll() {
        for (int i = 0; i < this.numberOfTraits; ++i) {
            this.include[i] = Boolean.TRUE;
        }
        this.fireTableDataChanged();
    }

    public void excludeSome(int[] index) {
        for (int i : index) {
            this.include[i] = Boolean.FALSE;
        }
        this.fireTableDataChanged();
    }

    public void includeSome(int[] index) {
        for (int i : index) {
            this.include[i] = Boolean.TRUE;
        }
        this.fireTableDataChanged();
    }

    public int getTypeColumnNumber() {
        return this.typeColumnNumber;
    }
}

