/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.AbstractAvailableListModel;
import net.maizegenetics.gui.SelectFromAvailableDialog;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import org.apache.log4j.Logger;

public class FilterSiteNamePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterSiteNamePlugin.class);
    private int[] mySitesToKeep = null;
    private String[] mySiteNamesToKeep = null;
    private String[] mySiteNamesToRemove = null;

    public FilterSiteNamePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> inputData = input.getDataOfType(GenotypeTable.class);
            if (inputData.size() != 1) {
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection. Please select a single alignment.");
                } else {
                    myLogger.error((Object)"performFunction: Please input a single alignment.");
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Datum td = this.processDatum(inputData.get(0), this.isInteractive());
            if (td == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet output = new DataSet(td, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, FilterSiteNamePlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private Datum processDatum(Datum inDatum, boolean isInteractive) {
        final GenotypeTable alignment = (GenotypeTable)inDatum.getData();
        if (isInteractive) {
            AbstractAvailableListModel listModel = new AbstractAvailableListModel(){

                @Override
                public int getRealSize() {
                    return alignment.numberOfSites();
                }

                @Override
                public String getRealElementAt(int index) {
                    return alignment.siteName(index);
                }
            };
            SelectFromAvailableDialog dialog = new SelectFromAvailableDialog(this.getParentFrame(), "Site Name Filter", listModel);
            dialog.setLocationRelativeTo(this.getParentFrame());
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return null;
            }
            this.mySitesToKeep = dialog.getDesiredIndices();
            dialog.dispose();
        }
        FilterGenotypeTable result = null;
        if (this.mySitesToKeep != null && this.mySitesToKeep.length != 0) {
            result = FilterGenotypeTable.getInstance(alignment, this.mySitesToKeep);
        } else if (this.mySiteNamesToKeep != null && this.mySiteNamesToKeep.length != 0) {
            result = FilterGenotypeTable.getInstance(alignment, this.mySiteNamesToKeep);
        } else if (this.mySiteNamesToRemove != null && this.mySiteNamesToRemove.length != 0) {
            result = FilterGenotypeTable.getInstanceRemoveSiteNames(alignment, this.mySiteNamesToRemove);
        } else {
            return null;
        }
        String theName = inDatum.getName() + "_" + result.numberOfSites() + "_Sites";
        String theComment = "Subset of " + result.numberOfSites() + " from " + alignment.numberOfSites() + " Sites\n" + inDatum.getComment();
        return new Datum(theName, result, theComment);
    }

    public int[] getSitesToKeep() {
        return this.mySitesToKeep;
    }

    public void setSitesToKeep(int[] sitesToKeep) {
        this.mySitesToKeep = sitesToKeep;
        this.validItemsSet();
    }

    public String[] getSiteNamesToKeep() {
        return this.mySiteNamesToKeep;
    }

    public void setSiteNamesToKeep(String[] sitesToKeep) {
        this.mySiteNamesToKeep = sitesToKeep;
        this.validItemsSet();
    }

    public String[] getSiteNamesToRemove() {
        return this.mySiteNamesToRemove;
    }

    public void setSiteNamesToRemove(String[] sitesToRemove) {
        this.mySiteNamesToRemove = sitesToRemove;
        this.validItemsSet();
    }

    private void validItemsSet() {
        int count = 0;
        if (this.mySitesToKeep != null && this.mySitesToKeep.length != 0) {
            ++count;
        }
        if (this.mySiteNamesToKeep != null && this.mySiteNamesToKeep.length != 0) {
            ++count;
        }
        if (this.mySiteNamesToRemove != null && this.mySiteNamesToRemove.length != 0) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalStateException("FilterSiteNamePlugin: validItemsSet: Can only set one of the following: sites to keep, site names to keep, or site names to remove.");
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterSiteNamePlugin.class.getResource("/net/maizegenetics/analysis/images/Filter.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Site Names";
    }

    @Override
    public String getToolTipText() {
        return "Select Site Names Within Dataset";
    }
}

