/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.distance.Kinship;
import net.maizegenetics.analysis.distance.KinshipMethodDialog;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.trait.SimplePhenotype;

public class KinshipPlugin
extends AbstractPlugin {
    Kinship.KINSHIP_TYPE kinshipType = Kinship.KINSHIP_TYPE.Endelman;

    public KinshipPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List alignInList = input.getDataSet();
            if (alignInList.isEmpty()) {
                String message = "Nothing selected. Please select pedigree data.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    System.out.println(message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            if (this.isInteractive()) {
                KinshipMethodDialog kmd = new KinshipMethodDialog(this.getParentFrame());
                kmd.setLocationRelativeTo(this.getParentFrame());
                kmd.setVisible(true);
                if (kmd.isCancelled) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                this.kinshipType = kmd.isEndelmanSelected() ? Kinship.KINSHIP_TYPE.Endelman : Kinship.KINSHIP_TYPE.IBS;
                kmd.dispose();
            }
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            for (Datum current : alignInList) {
                String datasetName = current.getName();
                Kinship kin = null;
                try {
                    if (current.getData() instanceof GenotypeTable) {
                        GenotypeTable theAlignment = (GenotypeTable)current.getData();
                        kin = new Kinship(theAlignment, this.kinshipType);
                    } else if (current.getData() instanceof SimplePhenotype) {
                        SimplePhenotype ped = (SimplePhenotype)current.getData();
                        kin = new Kinship(ped);
                    } else {
                        String message = "Invalid selection. Can't create kinship matrix from: " + datasetName;
                        if (this.isInteractive()) {
                            JOptionPane.showMessageDialog(this.getParentFrame(), message);
                        } else {
                            System.out.println(message);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = "Problem creating kinship matrix from: " + datasetName + "\n" + e.getClass().getName() + ": " + e.getMessage();
                    if (this.isInteractive()) {
                        JOptionPane.showMessageDialog(this.getParentFrame(), message);
                    }
                    System.out.println(message);
                    e.printStackTrace();
                }
                if (kin == null) continue;
                DataSet ds = new DataSet(new Datum("kin_" + datasetName, kin.getDm(), "kinship matrix created from " + datasetName), (Plugin)this);
                result.add(ds);
                this.fireDataSetReturned(new PluginEvent(ds, KinshipPlugin.class));
            }
            DataSet dataSet = DataSet.getDataSet(result, this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = KinshipPlugin.class.getResource("/net/maizegenetics/analysis/images/Kin.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Kinship";
    }

    @Override
    public String getToolTipText() {
        return "Calculate kinship from marker data";
    }

    public void setKinshipType(Kinship.KINSHIP_TYPE kinshipType) {
        this.kinshipType = kinshipType;
    }
}

