/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.maizegenetics.analysis.data.FileLoadPlugin;

class ReportOptionDialog
extends JDialog {
    private boolean myIsCancel = true;
    private ButtonGroup myButtonGroup = new ButtonGroup();
    private JRadioButton myReportRadioButton = new JRadioButton("Write As Report");
    private JRadioButton myTextRadioButton = new JRadioButton("Write As Text");

    public ReportOptionDialog() {
        super((Frame)null, "Export Report...", true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("Export Report...");
        this.setDefaultCloseOperation(1);
        this.setUndecorated(false);
        this.getRootPane().setWindowDecorationStyle(0);
        Container contentPane = this.getContentPane();
        BoxLayout layout = new BoxLayout(contentPane, 1);
        contentPane.setLayout(layout);
        JPanel main = this.getMain();
        contentPane.add(main);
        this.pack();
        this.setResizable(false);
        this.myButtonGroup.add(this.myReportRadioButton);
        this.myButtonGroup.add(this.myTextRadioButton);
        this.myReportRadioButton.setSelected(true);
    }

    private JPanel getMain() {
        JPanel inputs = new JPanel();
        BoxLayout layout = new BoxLayout(inputs, 1);
        inputs.setLayout(layout);
        inputs.setAlignmentX(0.5f);
        inputs.add(Box.createRigidArea(new Dimension(1, 10)));
        inputs.add(this.getLabel());
        inputs.add(Box.createRigidArea(new Dimension(1, 10)));
        inputs.add(this.getOptionPanel());
        inputs.add(Box.createRigidArea(new Dimension(1, 10)));
        inputs.add(this.getButtons());
        inputs.add(Box.createRigidArea(new Dimension(1, 10)));
        return inputs;
    }

    private JPanel getLabel() {
        JPanel result = new JPanel();
        BoxLayout layout = new BoxLayout(result, 1);
        result.setLayout(layout);
        result.setAlignmentX(0.5f);
        JLabel jLabel1 = new JLabel("Choose File Type to Export.");
        jLabel1.setFont(new Font("Dialog", 1, 18));
        result.add(jLabel1);
        return result;
    }

    private JPanel getOptionPanel() {
        JPanel result = new JPanel();
        BoxLayout layout = new BoxLayout(result, 1);
        result.setLayout(layout);
        result.setAlignmentX(0.5f);
        result.setBorder(BorderFactory.createEtchedBorder());
        result.add(this.myReportRadioButton);
        result.add(this.myTextRadioButton);
        result.add(Box.createRigidArea(new Dimension(1, 20)));
        return result;
    }

    private JPanel getButtons() {
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportOptionDialog.this.cancelButton_actionPerformed(e);
            }
        });
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportOptionDialog.this.okButton_actionPerformed(e);
            }
        });
        JPanel result = new JPanel(new FlowLayout(1));
        result.add(okButton);
        result.add(cancelButton);
        return result;
    }

    public FileLoadPlugin.TasselFileType getTasselFileType() {
        if (this.myTextRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.Text;
        }
        return null;
    }

    private void okButton_actionPerformed(ActionEvent e) {
        this.myIsCancel = false;
        this.setVisible(false);
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.myIsCancel = true;
        this.setVisible(false);
    }

    public boolean isCancel() {
        return this.myIsCancel;
    }
}

